/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.armnn;

import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.ITrack;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.JobEnd;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.JobStart;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.LayerJob;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.misc.TaskId;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.eclipse.jdt.annotation.NonNull;

public class ArmNNCamViewBuilder {
    private final int viewId;
    private final @NonNull IExternalProtocolEventStream output;
    private boolean notCreatedCamViewYet;

    public ArmNNCamViewBuilder(@NonNull IExternalProtocolEventStream output, int viewId) {
        this.output = output;
        this.viewId = viewId;
        this.notCreatedCamViewYet = true;
    }

    public void drawView(long timestamp, @NonNull TaskId taskId) {
        try {
            if (this.notCreatedCamViewYet) {
                this.output.camView(ClockSource.MONOTONIC_RAW, timestamp, taskId, this.viewId, "Arm NN timeline");
                this.notCreatedCamViewYet = false;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void drawLayerJob(@NonNull LayerJob job, int @NonNull [] dependencies) {
        try {
            this.output.camJobStart(job.getTaskID(), this.viewId, ClockSource.MONOTONIC_RAW, job.getStartTimestamp(), job.getTrackID(), job.getJobID(), job.getName(), new AnnotationColour());
            this.output.camJobStop(job.getTaskID(), this.viewId, ClockSource.MONOTONIC_RAW, job.getEndTimestamp(), job.getJobID());
            this.output.camJobDependencies(job.getTaskID(), this.viewId, ClockSource.MONOTONIC_RAW, job.getStartTimestamp(), job.getJobID(), -1, dependencies);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void drawTrack(@NonNull ITrack track) {
        try {
            this.output.camTrack(ClockSource.MONOTONIC_RAW, track.getTimestamp(), track.getTaskID(), this.viewId, track.getParentTrackID(), track.getTrackId(), track.getName());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void drawJobStart(@NonNull JobStart jobStart) {
        try {
            this.output.camJobStart(jobStart.getTaskID(), this.viewId, ClockSource.MONOTONIC_RAW, jobStart.getTimestamp(), jobStart.getTrackID(), jobStart.getJobID(), jobStart.getName(), new AnnotationColour());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void drawJobStop(@NonNull JobEnd jobEnd) {
        try {
            this.output.camJobStop(jobEnd.getTaskID(), this.viewId, ClockSource.MONOTONIC_RAW, jobEnd.getTimestamp(), jobEnd.getJobID());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void drawJobDependencies(@NonNull TaskId taskId, long jobStartTimestamp, int jobID, int @NonNull [] dependencies) {
        try {
            this.output.camJobDependencies(taskId, this.viewId, ClockSource.MONOTONIC_RAW, jobStartTimestamp, jobID, -1, dependencies);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

