/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import com.arm.streamline.analysis.model.DynamicCounterSeriesKey;
import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.KernelAnnotationSeriesKey;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.jni.common.WarningItem;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.capture.apc.time.Timestamp;
import com.arm.streamline.protocol.misc.TaskId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class TimestampTrackingExternalProtocolEventStream
implements IExternalProtocolEventStream {
    private @Nullable Timestamp earliestTimestamp = null;
    private @NonNull List<@NonNull Entry> entries = new ArrayList<Entry>();
    private @Nullable Timestamp latestTimestamp = null;
    private int startOffset = 0;

    @Override
    public void activityStop(@NonNull ICounterSeriesKey counterKey, @NonNull ClockSource clockSource, long rawTimestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, int activity) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void activitySwitch(@NonNull ICounterSeriesKey counterKey, @NonNull ClockSource clockSource, long rawTimestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, int activity, int reason) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void annotationMarker(@NonNull ClockSource clockSource, long rawTimestamp, @Nullable TaskId taskId, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void annotationText(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, int channel, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void annotationTextAsync(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, @NonNull String title, int id, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void annotationTextAsyncEnd(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, @NonNull String title, int id) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void annotationTextNameChannel(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, int channel, int group, @NonNull String text) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void annotationTextNameGroup(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, int group, @NonNull String text) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void annotationTextPop(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, @NonNull String title) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void annotationTextPush(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, @NonNull String title, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void annotationVisual(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, @NonNull String text, byte @NonNull [] image) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void atraceCounter(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull String name, @NonNull TaskId taskId, long value) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void attributes(long vmUID, Map<@NonNull String, @NonNull String> attributes) throws IOException {
    }

    @Override
    public void camJob(int viewUID, @NonNull ClockSource clockSource, long startTime, long duration, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        this.track(clockSource, startTime);
    }

    @Override
    public void camJob(@NonNull TaskId taskId, int viewUID, @NonNull ClockSource clockSource, long startTime, long duration, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        this.track(clockSource, startTime);
    }

    @Override
    public void camJobDependencies(@NonNull TaskId taskId, int viewUID, @NonNull ClockSource clockSource, long rawTimestamp, int jobUID, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void camJobStart(@NonNull TaskId taskId, int viewUID, @NonNull ClockSource clockSource, long rawTimestamp, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void camJobStop(@NonNull TaskId taskId, int viewUID, @NonNull ClockSource clockSource, long rawTimestamp, int jobUID) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void camTrack(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, int viewUID, int parentTrack, int trackUID, @NonNull String name) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void camTrack(int viewUID, int parentTrack, int trackUID, @NonNull String name) throws IOException {
    }

    @Override
    public void camView(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, int viewUID, @NonNull String name) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void camView(int viewUID, @NonNull String name) throws IOException {
    }

    @Override
    public void chopExternalFrame(int offset) {
        assert (offset > 0);
        assert (offset >= this.startOffset);
        this.entries.add(new Entry(this.startOffset, offset - this.startOffset, this.earliestTimestamp, this.latestTimestamp));
        this.startOffset = offset;
        this.reset();
    }

    @Override
    public void chopExternalHeaderFrame(int offset) {
        assert (offset > 0);
        assert (offset >= this.startOffset);
        this.track(ClockSource.BEFORE_START, 0L);
        this.entries.add(new Entry(this.startOffset, offset - this.startOffset, this.earliestTimestamp, this.latestTimestamp));
        this.startOffset = offset;
        this.reset();
    }

    @Override
    public void counter(@NonNull ICounterSeriesKey counterKey, @NonNull ClockSource clockSource, long rawTimestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, long value) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void createDynamicCounterSeries(@NonNull DynamicCounterSeriesKey counterKey, @NonNull String title, @NonNull String name, @NonNull String units, @NonNull String description, @NonNull CounterClass counterClass, @NonNull CounterDisplay display, @NonNull SeriesComposition seriesComposition, @NonNull GraphRenderingType renderingType, boolean averageSelection, boolean percentage, @NonNull AnnotationColour colour, double multiplier, @NonNull List<@NonNull String> activities, @NonNull List<@NonNull AnnotationColour> activityColors) throws IOException {
    }

    @Override
    public void createKernelAnnotationsCounterSeries(@NonNull KernelAnnotationSeriesKey counterKey, @NonNull String title, @NonNull String name, @NonNull String units, @NonNull String description, @NonNull CounterClass counterClass, @NonNull CounterDisplay display, @NonNull SeriesComposition seriesComposition, @NonNull GraphRenderingType renderingType, boolean averageSelection, boolean percentage, @NonNull AnnotationColour colour, double multiplier, @NonNull List<@NonNull String> activities, @NonNull List<@NonNull AnnotationColour> activityColors) throws IOException {
    }

    @Override
    public void idle(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull ProcessingElementReference peReference, boolean online) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    public @NonNull List<@NonNull Entry> takeEntries(int frameLength) {
        assert (this.startOffset <= frameLength);
        if (this.startOffset < frameLength) {
            if (this.startOffset != 0 && (this.earliestTimestamp != null || this.latestTimestamp != null)) {
                throw new IllegalStateException();
            }
            this.chopExternalFrame(frameLength);
        }
        @NonNull List<@NonNull Entry> result = this.entries;
        this.entries = new ArrayList<Entry>();
        this.startOffset = 0;
        this.reset();
        return result;
    }

    @Override
    public void tracepointEvent(@NonNull ClockSource clockSource, long rawTimestamp, @Nullable TaskId taskId, @NonNull TracepointFormat tracepointFormat, byte @NonNull [] raw) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void warning(@NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId thread, @NonNull WarningItem warning) throws IOException {
        this.track(clockSource, rawTimestamp);
    }

    @Override
    public void warning(@NonNull WarningItem warning) throws IOException {
    }

    private void reset() {
        this.earliestTimestamp = null;
        this.latestTimestamp = null;
    }

    private void track(@NonNull ClockSource clockSource, long rawTimestamp) {
        Timestamp timestamp = new Timestamp(clockSource, rawTimestamp);
        if (this.earliestTimestamp == null || timestamp.compareTo(this.earliestTimestamp) < 0) {
            this.earliestTimestamp = timestamp;
        }
        if (this.latestTimestamp == null || timestamp.compareTo(this.latestTimestamp) > 0) {
            this.latestTimestamp = timestamp;
        }
    }

    public static final class Entry {
        public final @NonNull Timestamp earliestTimestamp;
        public final @Nullable Timestamp latestTimestamp;
        public final int length;
        public final int offset;

        public Entry(int offset, int length, @Nullable Timestamp earliestTimestamp, @Nullable Timestamp latestTimestamp) {
            this.offset = offset;
            this.length = length;
            this.earliestTimestamp = earliestTimestamp != null ? earliestTimestamp : Timestamp.BEFORE_START;
            this.latestTimestamp = latestTimestamp;
        }
    }
}

