/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import org.eclipse.jdt.annotation.NonNull;

public final class ExternalProtocolChannel
implements Comparable<ExternalProtocolChannel> {
    public final @NonNull String channelName;
    public final boolean compact;
    public final int fd;
    public final long uid;
    public final long vmUID;

    public ExternalProtocolChannel(long vmUID, boolean compact, long uid, int fd, @NonNull String channelName) {
        this.vmUID = vmUID;
        this.compact = compact;
        this.uid = uid;
        this.fd = fd;
        this.channelName = channelName;
    }

    @Override
    public int compareTo(ExternalProtocolChannel o) {
        int vmResult = Long.compare(this.vmUID, o.vmUID);
        if (vmResult != 0) {
            return vmResult;
        }
        int compactResult = Boolean.compare(this.compact, o.compact);
        if (compactResult != 0) {
            return compactResult;
        }
        int uidResult = Long.compare(this.uid, o.uid);
        if (uidResult != 0) {
            return uidResult;
        }
        int fdResult = Long.compare(this.fd, o.fd);
        if (fdResult != 0) {
            return fdResult;
        }
        return this.channelName.compareTo(o.channelName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExternalProtocolChannel) {
            ExternalProtocolChannel that = (ExternalProtocolChannel)obj;
            return this.uid == that.uid && this.fd == that.fd && this.vmUID == that.vmUID && this.compact == that.compact && this.channelName.equals(that.channelName);
        }
        return false;
    }

    public int hashCode() {
        return ((Long.hashCode(this.uid) * 31 + Long.hashCode(this.vmUID)) * 31 + this.channelName.hashCode()) * 31 + Boolean.hashCode(this.compact);
    }

    public String toString() {
        return String.format("ExternalProtocolChannel [vmUID=%s, channelName=%s, fd=%s, uid=%s, compact=%s]", this.vmUID, this.channelName, this.fd, this.uid, this.compact);
    }
}

