/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.StaticCounterSeriesKey;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.io.BufferUtils;
import com.arm.streamline.ftrace.TracepointField;
import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.protocol.capture.apc.pass_two.warnings.WarningsFactory;
import com.arm.streamline.protocol.capture.apc.protocol.external.AtraceParser;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolChannel;
import com.arm.streamline.protocol.capture.apc.protocol.external.FTraceCommon;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolDecoder;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.misc.TaskId;
import com.arm.utils.NullChecking;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EStateFtraceV2
implements IExternalProtocolDecoder {
    public static final @NonNull String PROTOCOL = "FTRACE 2";
    private static final @NonNull String COMMON_PID = "common_pid";
    private static final @NonNull String FIELD_BUF_OLD_KERNEL = "buf";
    private static final @NonNull String FIELD_BUF = "buf[]";
    private static final @NonNull String FIELD_COMMIT = "commit";
    private static final @NonNull String FIELD_DATA = "data";
    private static final @NonNull String FIELD_TIMESTAMP = "timestamp";
    private static final @NonNull String FORMAT_PRINT = "print";
    private static final int RINGBUF_TYPE_PADDING = 29;
    private static final int RINGBUF_TYPE_TIME_EXTEND = 30;
    private static final int RINGBUF_TYPE_TIME_STAMP = 31;
    private static final int TIME_EXTEND_SHIFT = 27;
    private final boolean enableAtrace;
    private final @NonNull AtraceParser atraceParser;
    private final @NonNull ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final @NonNull FTraceCommon commonProcessing;
    private final @NonNull TracepointFormat mHeaderPage;
    private final int mPageSize;
    private final @NonNull IExternalProtocolEventStream outputStream;
    private final @NonNull IExternalProtocolPassTwoState passTwoState;
    private final @NonNull ProcessingElementReference systemWidePeReference;
    private final @NonNull Map<@NonNull String, @NonNull FtraceCounter> tracepointCounterSeries = new HashMap<String, FtraceCounter>();

    private static long headerToDelta(int header) {
        return header >>> 5;
    }

    private static int headerToLen(int header) {
        return header & 0x1F;
    }

    public EStateFtraceV2(@NonNull ExternalProtocolChannel channel, @NonNull IExternalProtocolPassTwoState passTwoState, @NonNull IExternalProtocolEventStream outputStream, boolean enableAtrace) throws IOException {
        this.passTwoState = passTwoState;
        this.outputStream = outputStream;
        this.systemWidePeReference = passTwoState.getSystemWideProcessingElementReference();
        this.enableAtrace = enableAtrace;
        this.atraceParser = new AtraceParser(channel, passTwoState, outputStream);
        for (Map.Entry<String, StaticCounterSeriesKey> entry : passTwoState.getStaticCounterSeries().getTracepointCountersByName().entrySet()) {
            this.tracepointCounterSeries.put(entry.getKey(), new FtraceCounter(entry.getValue()));
        }
        @Nullable TracepointFormat headerPageFormat = passTwoState.getTracepointFormat(-2147483647);
        if (headerPageFormat == null) {
            throw new IOException("Missing header page tracepoint format");
        }
        @NonNull TracepointField data = (TracepointField)NullChecking.neverNull((Object)headerPageFormat.getField(FIELD_DATA));
        this.mHeaderPage = headerPageFormat;
        this.mPageSize = data.getOffset() + data.getSize();
        if (this.mPageSize <= 0) {
            throw new IOException("Invalid header page size");
        }
        this.commonProcessing = new FTraceCommon(passTwoState, outputStream);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void process(byte @NonNull [] data) throws IOException {
        if (data.length <= 0) {
            return;
        }
        int pos = 0;
        while (pos < data.length) {
            int baosSize = this.baos.size();
            if (baosSize > 0) {
                if (baosSize + data.length - pos < this.mPageSize) {
                    this.baos.write(data, pos, data.length - pos);
                    return;
                }
                byte[] page = new byte[this.mPageSize];
                System.arraycopy(this.baos.toByteArray(), 0, page, 0, baosSize);
                System.arraycopy(data, pos, page, baosSize, this.mPageSize - baosSize);
                this.baos.reset();
                this.processPage(page, 0);
                pos += this.mPageSize - baosSize;
                continue;
            }
            if (data.length - pos < this.mPageSize) {
                this.baos.write(data, pos, data.length - pos);
                return;
            }
            this.processPage(data, pos);
            pos += this.mPageSize;
        }
    }

    @Override
    public boolean reorderable() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void processPage(byte @NonNull [] buf, int bufPos) throws IOException {
        timestamp = this.mHeaderPage.getInt("timestamp", buf, bufPos);
        commit = this.mHeaderPage.getInt("commit", buf, bufPos);
        pos = this.mHeaderPage.getField("data").getOffset();
        while ((long)pos < commit) {
            block27: {
                block28: {
                    header = BufferUtils.readLEInt((byte[])buf, (int)(bufPos + pos));
                    pos += 4;
                    typeLen = EStateFtraceV2.headerToLen(header);
                    delta = EStateFtraceV2.headerToDelta(header);
                    length = 0;
                    switch (typeLen) {
                        case 29: {
                            pLength = BufferUtils.readLEInt((byte[])buf, (int)(bufPos + pos));
                            pos += pLength;
                            break;
                        }
                        case 30: {
                            extend = BufferUtils.readLEInt((byte[])buf, (int)(bufPos + pos));
                            pos += 4;
                            delta = (long)(extend << 27) + delta;
                            break;
                        }
                        case 31: {
                            pos += 12;
                            break;
                        }
                        case 0: {
                            length = BufferUtils.readLEInt((byte[])buf, (int)(bufPos + pos)) - 1 & -4;
                            pos += 4;
                            break;
                        }
                        default: {
                            length = 4 * typeLen;
                        }
                    }
                    if (length <= 0) break block27;
                    commonType = (int)BufferUtils.readLEIntSize((byte[])buf, (int)(bufPos + pos + 0), (int)2, (boolean)false);
                    format = this.passTwoState.getTracepointFormat(commonType);
                    time = timestamp + delta;
                    if (format == null) break block28;
                    if (!EStateFtraceV2.$assertionsDisabled && buf.length - (bufPos + pos) < length) {
                        throw new AssertionError((Object)String.format("bp=%d, p=%d, b.l=%d, l=%d", new Object[]{bufPos, pos, buf.length, length}));
                    }
                    rawBytes = new byte[length];
                    System.arraycopy(buf, bufPos + pos, rawBytes, 0, length);
                    tid = (int)format.getInt("common_pid", rawBytes);
                    taskId = new TaskId(tid);
                    if (time == -1L) break block27;
                    var20_16 = format.getName();
                    tmp = -1;
                    switch (var20_16.hashCode()) {
                        case 106934957: {
                            if (var20_16.equals("print")) {
                                tmp = 1;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            bufField = format.getField("buf[]");
                            if (bufField == null) {
                                bufField = format.getField("buf");
                            }
                            if (bufField == null) {
                                throw new IOException("Bad format for ftrace 'print' event.");
                            }
                            data = bufField.getString(rawBytes, 0);
                            if (!data.isEmpty() && data.charAt(data.length() - 1) == '\n') {
                                data = data.substring(0, data.length() - 1);
                            }
                            if (this.enableAtrace) {
                                this.atraceParser.parseAtrace(ClockSource.MONOTONIC_RAW, time, taskId, data);
                                break;
                            }
                            break block27;
                        }
                        default: {
                            counterSeriesDescriptor = this.tracepointCounterSeries.get(format.getName());
                            if (counterSeriesDescriptor == null) ** GOTO lbl90
                            var22_18 = format.getName();
                            tmp = -1;
                            switch (var22_18.hashCode()) {
                                case 1241386885: {
                                    if (var22_18.equals("cpu_frequency")) {
                                        tmp = 1;
                                    }
                                    break;
                                }
                            }
                            switch (tmp) {
                                case 1: {
                                    cpuId = (int)format.getInt("cpu_id", rawBytes);
                                    state = (int)format.getInt("state", rawBytes);
                                    this.commonProcessing.onCpuFrequency((ICounterSeriesKey)counterSeriesDescriptor.counterSeriesKey, time, cpuId, state);
                                    break;
                                }
                                default: {
                                    arg = counterSeriesDescriptor.arg;
                                    if (arg == null) {
                                        this.outputStream.counter((ICounterSeriesKey)counterSeriesDescriptor.counterSeriesKey, ClockSource.MONOTONIC_RAW, time, this.systemWidePeReference, taskId, 1L);
                                        break;
                                    }
                                    value = format.getInt(arg, rawBytes);
                                    this.outputStream.counter((ICounterSeriesKey)counterSeriesDescriptor.counterSeriesKey, ClockSource.MONOTONIC_RAW, time, this.systemWidePeReference, taskId, value);
                                }
                            }
lbl90:
                            // 4 sources

                            this.outputStream.tracepointEvent(ClockSource.MONOTONIC_RAW, time, taskId, format, rawBytes);
                            break;
                        }
                    }
                    break block27;
                }
                this.outputStream.warning(WarningsFactory.missingTracepointFormat(commonType));
            }
            pos += length;
        }
    }

    private static class FtraceCounter {
        public final @Nullable String arg;
        public final @NonNull StaticCounterSeriesKey counterSeriesKey;

        public FtraceCounter(@NonNull StaticCounterSeriesKey counterSeriesKey) {
            this.counterSeriesKey = counterSeriesKey;
            CounterRecord cr = counterSeriesKey.getCounterRecord();
            this.arg = cr.getArg();
        }
    }
}

