/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import com.arm.streamline.analysis.model.DynamicCounterSeriesKey;
import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolChannel;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolDecoder;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.gator.io.ByteBufferAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.misc.TaskId;
import com.arm.utils.NullChecking;
import com.arm.utils.numbers.UnsignedLong;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;

public final class EStateAnnotateV1
implements IExternalProtocolDecoder {
    public static final int HEADER_ACTIVITY_SWITCH = 10;
    public static final int HEADER_CAM_JOB = 12;
    public static final int HEADER_CAM_JOB_SET_DEPS = 15;
    public static final int HEADER_CAM_JOB_START = 14;
    public static final int HEADER_CAM_JOB_STOP = 16;
    public static final int HEADER_CAM_TRACK = 11;
    public static final int HEADER_CAM_VIEW_NAME = 13;
    public static final int HEADER_CHANNEL_NAME = 3;
    public static final int HEADER_COUNTER = 8;
    public static final int HEADER_COUNTER_VALUE = 9;
    public static final int HEADER_GROUP_NAME = 4;
    public static final int HEADER_MARKER = 6;
    public static final int HEADER_MARKER_COLOR = 7;
    public static final int HEADER_MAX = 17;
    public static final int HEADER_UNDEFINED = 0;
    public static final int HEADER_UTF8 = 1;
    public static final int HEADER_UTF8_COLOR = 2;
    public static final int HEADER_VISUAL = 5;
    public static final String PROTOCOL1 = "ANNOTATE 1";
    public static final String PROTOCOL2 = "ANNOTATE 2";
    public static final String PROTOCOL3 = "ANNOTATE 3";
    public static final String PROTOCOL4 = "ANNOTATE 4";
    public static final String PROTOCOL5 = "ANNOTATE 5";
    private @NonNull ClockSource lastSeenClockSource = ClockSource.BEFORE_START;
    private long lastSeenTimestamp = 0L;
    private byte[] mData;
    private int mMarkerCode;
    private int mPid;
    private int mSize;
    private @NonNull State mState;
    private int mTid;
    private final int mVersion;
    private final @NonNull IExternalProtocolEventStream outputStream;
    private final @NonNull ProcessingElementReference systemWidePeReference;

    private static @NonNull CounterClass getCounterClass(int counterClass) {
        switch (counterClass) {
            case 1: {
                return CounterClass.DELTA;
            }
            case 2: {
                return CounterClass.ABSOLUTE;
            }
            case 3: {
                return CounterClass.ACTIVITY;
            }
            case 4: {
                return CounterClass.INCIDENT;
            }
        }
        assert (false);
        return CounterClass.getDefault();
    }

    private static @NonNull CounterDisplay getCounterDisplay(int counterDisplay) {
        switch (counterDisplay) {
            case 1: {
                return CounterDisplay.AVERAGE;
            }
            case 2: {
                return CounterDisplay.ACCUMULATE;
            }
            case 3: {
                return CounterDisplay.HERTZ;
            }
            case 4: {
                return CounterDisplay.MAXIMUM;
            }
            case 5: {
                return CounterDisplay.MINIMUM;
            }
        }
        assert (false);
        return CounterDisplay.getDefault();
    }

    private static @NonNull GraphRenderingType getRenderingType(int renderingType) {
        switch (renderingType) {
            case 1: {
                return GraphRenderingType.FILLED;
            }
            case 2: {
                return GraphRenderingType.LINE;
            }
            case 3: {
                return GraphRenderingType.BAR;
            }
        }
        assert (false);
        return GraphRenderingType.DEFAULT;
    }

    private static @NonNull SeriesComposition getSeriesComposition(int seriesComposition) {
        switch (seriesComposition) {
            case 1: {
                return SeriesComposition.STACKED;
            }
            case 2: {
                return SeriesComposition.OVERLAY;
            }
            case 3: {
                return SeriesComposition.LOG10;
            }
        }
        assert (false);
        return SeriesComposition.DEFAULT;
    }

    private static int getVersion(String protocol) {
        switch (protocol) {
            case "ANNOTATE 1": {
                return 1;
            }
            case "ANNOTATE 2": {
                return 2;
            }
            case "ANNOTATE 3": {
                return 3;
            }
            case "ANNOTATE 4": {
                return 4;
            }
            case "ANNOTATE 5": {
                return 5;
            }
        }
        throw new RuntimeException();
    }

    private static int readColor(IAPCByteReader in) throws IOException {
        int color = 0;
        color |= in.getUnsignedByte() << 16;
        color |= in.getUnsignedByte() << 8;
        color |= in.getUnsignedByte() << 0;
        return color |= in.getUnsignedByte() << 24;
    }

    public EStateAnnotateV1(@NonNull ExternalProtocolChannel channel, @NonNull IExternalProtocolPassTwoState passTwoState, @NonNull IExternalProtocolEventStream outputStream) {
        this.outputStream = outputStream;
        this.systemWidePeReference = passTwoState.getSystemWideProcessingElementReference();
        this.mVersion = EStateAnnotateV1.getVersion(channel.channelName);
        this.reset();
        this.mState = State.TID;
    }

    @Override
    public void process(byte @NonNull [] data) throws IOException {
        ByteBufferAPCByteReader in = new ByteBufferAPCByteReader(data);
        int size = in.remaining();
        int origPos = in.position();
        block17: while (in.position() < origPos + size) {
            switch (this.mState) {
                case TID: {
                    this.mTid = in.getUnsignedByte();
                    this.mState = State.TID_1;
                    break;
                }
                case TID_1: {
                    this.mTid |= in.getUnsignedByte() << 8;
                    this.mState = State.TID_2;
                    break;
                }
                case TID_2: {
                    this.mTid |= in.getUnsignedByte() << 16;
                    this.mState = State.TID_3;
                    break;
                }
                case TID_3: {
                    this.mTid |= in.getUnsignedByte() << 24;
                    this.mState = State.PID;
                    break;
                }
                case PID: {
                    this.mPid = in.getUnsignedByte();
                    this.mState = State.PID_1;
                    break;
                }
                case PID_1: {
                    this.mPid |= in.getUnsignedByte() << 8;
                    this.mState = State.PID_2;
                    break;
                }
                case PID_2: {
                    this.mPid |= in.getUnsignedByte() << 16;
                    this.mState = State.PID_3;
                    break;
                }
                case PID_3: {
                    this.mPid |= in.getUnsignedByte() << 24;
                    if (this.mVersion >= 3) {
                        this.mState = State.MANGLE;
                        break;
                    }
                    this.mState = State.MARKER_CODE;
                    this.outputStream.chopExternalHeaderFrame(in.position());
                    break;
                }
                case MANGLE: {
                    in.getUnsignedByte();
                    this.mState = State.MARKER_CODE;
                    this.outputStream.chopExternalHeaderFrame(in.position());
                    break;
                }
                case MARKER_CODE: {
                    this.mMarkerCode = in.getUnsignedByte();
                    if (this.mMarkerCode <= 0 || this.mMarkerCode >= 17) {
                        this.writeError(String.format("Unknown Annotate protocol \"%d\"", this.mMarkerCode));
                        this.mState = State.ERRORED;
                        break;
                    }
                    this.mState = State.SIZE;
                    break;
                }
                case SIZE: {
                    this.mSize = in.getUnsignedByte();
                    this.mState = State.SIZE_1;
                    break;
                }
                case SIZE_1: {
                    this.mSize |= in.getUnsignedByte() << 8;
                    this.mState = State.SIZE_2;
                    break;
                }
                case SIZE_2: {
                    this.mSize |= in.getUnsignedByte() << 16;
                    this.mState = State.SIZE_3;
                    break;
                }
                case SIZE_3: {
                    this.mSize |= in.getUnsignedByte() << 24;
                    if (this.mSize <= 0) {
                        this.emitChop(in.position());
                        break;
                    }
                    this.mData = new byte[this.mSize];
                    this.mState = State.DATA;
                    break;
                }
                case DATA: {
                    int read = size - in.position() + origPos;
                    if (read > this.mSize) {
                        read = this.mSize;
                    }
                    in.get((byte[])NullChecking.neverNull((Object)this.mData), this.mData.length - this.mSize, read);
                    this.mSize -= read;
                    if (this.mSize > 0) continue block17;
                    this.emitChop(in.position());
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void emitChop(int endPosition) throws IOException {
        boolean definitionEvent = this.emitData();
        this.reset();
        if (definitionEvent) {
            this.outputStream.chopExternalHeaderFrame(endPosition);
        } else {
            this.outputStream.chopExternalFrame(endPosition);
        }
    }

    private boolean emitData() throws IOException {
        ByteBufferAPCByteReader in = new ByteBufferAPCByteReader((byte[])NullChecking.neverNull((Object)this.mData));
        TaskId taskId = new TaskId(this.mPid, this.mTid);
        switch (this.mMarkerCode) {
            case 1: {
                long timestamp = in.getPackedLong();
                if (timestamp >= 0L) {
                    this.lastSeenClockSource = ClockSource.MONOTONIC_RAW;
                    this.lastSeenTimestamp = UnsignedLong.max((long)timestamp, (long)this.lastSeenTimestamp);
                    int channel = in.getPackedInt();
                    String text = in.readRemainingAsUTF8String();
                    this.outputStream.annotationText(ClockSource.MONOTONIC_RAW, timestamp, taskId, channel, text);
                }
                return false;
            }
            case 2: {
                long timestamp = in.getPackedLong();
                if (timestamp >= 0L) {
                    this.lastSeenClockSource = ClockSource.MONOTONIC_RAW;
                    this.lastSeenTimestamp = UnsignedLong.max((long)timestamp, (long)this.lastSeenTimestamp);
                    int channel = in.getPackedInt();
                    int color = EStateAnnotateV1.readColor(in);
                    String text = in.readRemainingAsUTF8String();
                    this.outputStream.annotationText(ClockSource.MONOTONIC_RAW, timestamp, taskId, channel, new AnnotationColour(color), text);
                }
                return false;
            }
            case 3: {
                long timestamp = in.getPackedLong();
                if (timestamp >= 0L) {
                    this.lastSeenClockSource = ClockSource.MONOTONIC_RAW;
                    this.lastSeenTimestamp = UnsignedLong.max((long)timestamp, (long)this.lastSeenTimestamp);
                    int channel = in.getPackedInt();
                    int group = in.getPackedInt();
                    String text = in.readRemainingAsUTF8String();
                    this.outputStream.annotationTextNameChannel(ClockSource.MONOTONIC_RAW, timestamp, taskId, channel, group, text);
                }
                return false;
            }
            case 4: {
                long timestamp = in.getPackedLong();
                if (timestamp >= 0L) {
                    this.lastSeenClockSource = ClockSource.MONOTONIC_RAW;
                    this.lastSeenTimestamp = UnsignedLong.max((long)timestamp, (long)this.lastSeenTimestamp);
                    int group = in.getPackedInt();
                    String text = in.readRemainingAsUTF8String();
                    this.outputStream.annotationTextNameGroup(ClockSource.MONOTONIC_RAW, timestamp, taskId, group, text);
                }
                return false;
            }
            case 5: {
                long timestamp = in.getPackedLong();
                if (timestamp >= 0L) {
                    this.lastSeenClockSource = ClockSource.MONOTONIC_RAW;
                    this.lastSeenTimestamp = UnsignedLong.max((long)timestamp, (long)this.lastSeenTimestamp);
                    String text = in.readNullTerminatedUTF8String();
                    byte[] image = new byte[in.remaining()];
                    in.get(image, 0, in.remaining());
                    this.outputStream.annotationVisual(ClockSource.MONOTONIC_RAW, timestamp, taskId, text, image);
                }
                return false;
            }
            case 6: {
                long timestamp = in.getPackedLong();
                if (timestamp >= 0L) {
                    this.lastSeenClockSource = ClockSource.MONOTONIC_RAW;
                    this.lastSeenTimestamp = UnsignedLong.max((long)timestamp, (long)this.lastSeenTimestamp);
                    String text = in.readRemainingAsUTF8String();
                    this.outputStream.annotationMarker(ClockSource.MONOTONIC_RAW, timestamp, taskId, text);
                }
                return false;
            }
            case 7: {
                long timestamp = in.getPackedLong();
                if (timestamp >= 0L) {
                    this.lastSeenClockSource = ClockSource.MONOTONIC_RAW;
                    this.lastSeenTimestamp = UnsignedLong.max((long)timestamp, (long)this.lastSeenTimestamp);
                    int color = EStateAnnotateV1.readColor(in);
                    String text = in.readRemainingAsUTF8String();
                    this.outputStream.annotationMarker(ClockSource.MONOTONIC_RAW, timestamp, taskId, new AnnotationColour(color), text);
                }
                return false;
            }
            case 8: {
                int id = in.getPackedInt();
                boolean perCpu = in.getPackedInt() != 0;
                @NonNull CounterClass counterClass = EStateAnnotateV1.getCounterClass(in.getPackedInt());
                @NonNull CounterDisplay display = EStateAnnotateV1.getCounterDisplay(in.getPackedInt());
                int modifier = in.getPackedInt();
                @NonNull SeriesComposition seriesComposition = EStateAnnotateV1.getSeriesComposition(in.getPackedInt());
                @NonNull GraphRenderingType renderingType = EStateAnnotateV1.getRenderingType(in.getPackedInt());
                boolean averageSelection = in.getPackedInt() != 0;
                boolean averageCores = in.getPackedInt() != 0;
                boolean percentage = in.getPackedInt() != 0;
                int activityCount = in.getPackedInt();
                int cores = in.getPackedInt();
                int color = EStateAnnotateV1.readColor(in);
                @NonNull ArrayList<@NonNull String> activities = new ArrayList<String>();
                @NonNull ArrayList<@NonNull AnnotationColour> activityColors = new ArrayList<AnnotationColour>();
                int i = 0;
                while (i < activityCount) {
                    activities.add(in.readNullTerminatedUTF8String());
                    int activityColor = EStateAnnotateV1.readColor(in);
                    activityColors.add(new AnnotationColour(activityColor));
                    ++i;
                }
                @NonNull String title = in.readNullTerminatedUTF8String();
                @NonNull String name = in.readNullTerminatedUTF8String();
                @NonNull String units = in.readNullTerminatedUTF8String();
                @NonNull String description = in.readRemainingAsUTF8String();
                double multiplier = 1.0 / (double)modifier;
                this.outputStream.createDynamicCounterSeries(new DynamicCounterSeriesKey(id), title, name, units, description, counterClass, display, seriesComposition, renderingType, averageSelection, percentage, new AnnotationColour(color), multiplier, activities, activityColors);
                return true;
            }
            case 9: {
                long timestamp = in.getPackedLong();
                if (timestamp >= 0L) {
                    int core = in.getPackedInt();
                    int id = in.getPackedInt();
                    long value = in.getPackedLong();
                    this.outputStream.counter((ICounterSeriesKey)new DynamicCounterSeriesKey(id), ClockSource.MONOTONIC_RAW, timestamp, this.systemWidePeReference, taskId, value);
                }
                return false;
            }
            case 10: {
                long timestamp = in.getPackedLong();
                if (timestamp >= 0L) {
                    int core = in.getPackedInt();
                    int id = in.getPackedInt();
                    int activity = in.getPackedInt();
                    int tid = in.getPackedInt();
                    @NonNull TaskId tidId = new TaskId(tid);
                    if (activity != 0) {
                        this.outputStream.activitySwitch((ICounterSeriesKey)new DynamicCounterSeriesKey(id), ClockSource.MONOTONIC_RAW, timestamp, this.systemWidePeReference, tidId, activity, 0);
                    } else {
                        this.outputStream.activityStop((ICounterSeriesKey)new DynamicCounterSeriesKey(id), ClockSource.MONOTONIC_RAW, timestamp, this.systemWidePeReference, tidId, 0);
                    }
                }
                return false;
            }
            case 11: {
                int viewUID = in.getPackedInt();
                int trackUID = in.getPackedInt();
                int parentTrack = in.getPackedInt();
                String name = in.readRemainingAsUTF8String();
                this.outputStream.camTrack(this.lastSeenClockSource, this.lastSeenTimestamp, taskId, viewUID, parentTrack, trackUID, name);
                return true;
            }
            case 12: {
                int viewUID = in.getPackedInt();
                int jobUID = in.getPackedInt();
                int track = in.getPackedInt();
                long startTime = in.getPackedLong();
                if (startTime >= 0L) {
                    this.lastSeenClockSource = ClockSource.MONOTONIC_RAW;
                    this.lastSeenTimestamp = UnsignedLong.max((long)startTime, (long)this.lastSeenTimestamp);
                    long duration = in.getPackedLong();
                    int color = EStateAnnotateV1.readColor(in);
                    int primaryDependency = in.getPackedInt();
                    int numberOfDependencies = in.getPackedInt();
                    int[] dependencies = new int[numberOfDependencies];
                    int count = 0;
                    while (count < numberOfDependencies) {
                        dependencies[count] = in.getPackedInt();
                        ++count;
                    }
                    String name = in.readRemainingAsUTF8String();
                    this.outputStream.camJob(taskId, viewUID, ClockSource.MONOTONIC_RAW, startTime, duration, track, jobUID, name, new AnnotationColour(color), primaryDependency, dependencies);
                }
                return false;
            }
            case 13: {
                int viewUID = in.getPackedInt();
                String name = in.readRemainingAsUTF8String();
                this.outputStream.camView(this.lastSeenClockSource, this.lastSeenTimestamp, taskId, viewUID, name);
                return true;
            }
            case 14: {
                int viewUID = in.getPackedInt();
                int jobUID = in.getPackedInt();
                int track = in.getPackedInt();
                long timestamp = in.getPackedLong();
                if (timestamp >= 0L) {
                    this.lastSeenClockSource = ClockSource.MONOTONIC_RAW;
                    this.lastSeenTimestamp = UnsignedLong.max((long)timestamp, (long)this.lastSeenTimestamp);
                    int color = EStateAnnotateV1.readColor(in);
                    String name = in.readRemainingAsUTF8String();
                    this.outputStream.camJobStart(taskId, viewUID, ClockSource.MONOTONIC_RAW, timestamp, track, jobUID, name, new AnnotationColour(color));
                }
                return false;
            }
            case 15: {
                int viewUID = in.getPackedInt();
                int jobUID = in.getPackedInt();
                long timestamp = in.getPackedLong();
                if (timestamp >= 0L) {
                    this.lastSeenClockSource = ClockSource.MONOTONIC_RAW;
                    this.lastSeenTimestamp = UnsignedLong.max((long)timestamp, (long)this.lastSeenTimestamp);
                    int primaryDependency = in.getPackedInt();
                    int numberOfDependencies = in.getPackedInt();
                    int[] dependencies = new int[numberOfDependencies];
                    int count = 0;
                    while (count < numberOfDependencies) {
                        dependencies[count] = in.getPackedInt();
                        ++count;
                    }
                    this.outputStream.camJobDependencies(taskId, viewUID, ClockSource.MONOTONIC_RAW, timestamp, jobUID, primaryDependency, dependencies);
                }
                return false;
            }
            case 16: {
                int viewUID = in.getPackedInt();
                int jobUID = in.getPackedInt();
                long timestamp = in.getPackedLong();
                if (timestamp >= 0L) {
                    this.lastSeenClockSource = ClockSource.MONOTONIC_RAW;
                    this.lastSeenTimestamp = UnsignedLong.max((long)timestamp, (long)this.lastSeenTimestamp);
                    this.outputStream.camJobStop(taskId, viewUID, ClockSource.MONOTONIC_RAW, timestamp, jobUID);
                }
                return false;
            }
        }
        return false;
    }

    private void reset() {
        this.mState = State.MARKER_CODE;
        this.mMarkerCode = 0;
        this.mSize = 0;
        this.mData = null;
    }

    private void writeError(@NonNull String format) throws IOException {
        this.outputStream.annotationMarker(this.lastSeenClockSource, this.lastSeenTimestamp, new TaskId(this.mPid, this.mTid), AnnotationColour.WARNING_COLOUR, format);
    }

    @Override
    public boolean reorderable() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }

    private static enum State {
        DATA,
        ERRORED,
        MANGLE,
        MARKER_CODE,
        PID,
        PID_1,
        PID_2,
        PID_3,
        SIZE,
        SIZE_1,
        SIZE_2,
        SIZE_3,
        TID,
        TID_1,
        TID_2,
        TID_3;

    }
}

