/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.annotations;

import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.protocol.capture.apc.protocol.annotations.IGatorAnnotationProtocolPassTwoEventStream;
import com.arm.streamline.protocol.gator.io.ByteBufferAPCByteReader;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNull;

public class GatorAnnotate {
    private static final byte @NonNull [] EMPTY = new byte[0];
    private static final int HEADER_ASCII = -1;
    private static final int HEADER_CHANNEL_NAME = 7;
    private static final int HEADER_GROUP_NAME = 8;
    private static final int HEADER_MARKER1 = 2;
    private static final int HEADER_MARKER2 = 5;
    private static final int HEADER_MAX = 10;
    private static final int HEADER_OPENCL = 9;
    private static final int HEADER_UNDEFINED = 0;
    private static final int HEADER_UTF8_2 = 6;
    private static final int HEADER_VISUAL1 = 1;
    private static final int HEADER_VISUAL2 = 4;
    private static final int MARKER_COLOR = 27;
    private static final int MARKER_EXTENDED = 28;
    private static final int MARKER_NEWLINE = 10;
    private static final int MARKER_TERMINATE = 0;
    private int mChannel;
    private int mColor;
    private int mGroup;
    private byte[] mImage;
    private int mImageLength;
    private int mMarkerCode;
    private AState mState;
    private byte[] mString;
    private int mStringLength;
    private StringBuilder mStringText = new StringBuilder();
    private final @NonNull IGatorAnnotationProtocolPassTwoEventStream outputStream;

    public GatorAnnotate(@NonNull IGatorAnnotationProtocolPassTwoEventStream outputStream) {
        this.outputStream = outputStream;
        this.reset();
    }

    public void process(long timestamp, byte @NonNull [] data) throws IOException {
        ByteBufferAPCByteReader in = new ByteBufferAPCByteReader(data);
        int size = in.remaining();
        int origPos = in.position();
        block29: while (in.position() < origPos + size) {
            switch (this.mState) {
                case ESCAPE_CODE: {
                    if (in.peekUnsignedByte() == 28) {
                        this.mState = AState.MARKER_CODE;
                        in.skipBytes(1);
                        break;
                    }
                    this.mState = AState.ASCII_COLOR;
                    this.mMarkerCode = -1;
                    break;
                }
                case MARKER_CODE: {
                    this.mMarkerCode = in.getUnsignedByte();
                    if (this.mMarkerCode <= 0 || this.mMarkerCode >= 10) {
                        this.mState = AState.ERROR;
                        this.writeError(timestamp, String.format("Unknown Annotate protocol \"%d\"", this.mMarkerCode));
                        return;
                    }
                    if (this.mMarkerCode == 2) {
                        this.mState = AState.ASCII_COLOR;
                        break;
                    }
                    if (this.mMarkerCode == 6 || this.mMarkerCode == 7) {
                        this.mState = AState.CHANNEL;
                        break;
                    }
                    if (this.mMarkerCode == 8) {
                        this.mState = AState.GROUP;
                        break;
                    }
                    this.mState = AState.STRING_LENGTH;
                    break;
                }
                case CHANNEL: {
                    this.mChannel = in.getUnsignedByte();
                    this.mState = AState.CHANNEL_1;
                    break;
                }
                case CHANNEL_1: {
                    this.mChannel |= in.getUnsignedByte() << 8;
                    this.mState = AState.CHANNEL_2;
                    break;
                }
                case CHANNEL_2: {
                    this.mChannel |= in.getUnsignedByte() << 16;
                    this.mState = AState.CHANNEL_3;
                    break;
                }
                case CHANNEL_3: {
                    this.mChannel += in.getUnsignedByte() << 24;
                    if (this.mMarkerCode == 7) {
                        this.mState = AState.GROUP;
                        break;
                    }
                    this.mState = AState.STRING_LENGTH;
                    break;
                }
                case GROUP: {
                    this.mGroup = in.getUnsignedByte();
                    this.mState = AState.GROUP_1;
                    break;
                }
                case GROUP_1: {
                    this.mGroup |= in.getUnsignedByte() << 8;
                    this.mState = AState.GROUP_2;
                    break;
                }
                case GROUP_2: {
                    this.mGroup += in.getUnsignedByte() << 16;
                    this.mState = AState.GROUP_3;
                    break;
                }
                case GROUP_3: {
                    this.mGroup += in.getUnsignedByte() << 24;
                    this.mState = AState.STRING_LENGTH;
                    break;
                }
                case STRING_LENGTH: {
                    this.mStringLength = in.getUnsignedByte();
                    this.mState = AState.STRING_LENGTH_1;
                    break;
                }
                case STRING_LENGTH_1: {
                    this.mStringLength |= in.getUnsignedByte() << 8;
                    if (this.mMarkerCode == 1) {
                        this.mState = AState.IMAGE_LENGTH;
                        break;
                    }
                    if (this.mStringLength > 0 || this.mMarkerCode == 4) {
                        this.mState = AState.COLOR;
                        break;
                    }
                    if (timestamp >= 0L) {
                        if (this.mMarkerCode == 5) {
                            this.outputStream.annotationMarker(timestamp, new AnnotationColour(this.mColor), "");
                        } else {
                            this.outputStream.annotationText(timestamp, this.mChannel, new AnnotationColour(this.mColor), "");
                        }
                    }
                    this.reset();
                    break;
                }
                case COLOR: {
                    if (in.peekUnsignedByte() == 27 && this.mStringLength >= 4) {
                        in.skipBytes(1);
                        this.mStringLength -= 4;
                        this.mString = new byte[this.mStringLength];
                        this.mColor = 0x1B000000;
                        this.mState = AState.COLOR_1;
                        break;
                    }
                    this.mString = new byte[this.mStringLength];
                    this.mState = AState.STRING_DATA;
                    break;
                }
                case COLOR_1: {
                    this.mColor |= in.getUnsignedByte() << 16;
                    this.mState = AState.COLOR_2;
                    break;
                }
                case COLOR_2: {
                    this.mColor |= in.getUnsignedByte() << 8;
                    this.mState = AState.COLOR_3;
                    break;
                }
                case COLOR_3: {
                    this.mColor |= in.getUnsignedByte();
                    if (this.mStringLength <= 0) {
                        if (timestamp >= 0L) {
                            String text = this.mMarkerCode != 5 ? " " : new String(this.mString, StandardCharsets.UTF_8);
                            if (this.mMarkerCode == 5) {
                                this.outputStream.annotationMarker(timestamp, new AnnotationColour(this.mColor), text);
                            } else {
                                this.outputStream.annotationText(timestamp, this.mChannel, new AnnotationColour(this.mColor), text);
                            }
                        }
                        this.reset();
                        break;
                    }
                    this.mState = AState.STRING_DATA;
                    break;
                }
                case STRING_DATA: {
                    int remove = size - in.position() + origPos;
                    if (remove > this.mStringLength) {
                        remove = this.mStringLength;
                    }
                    in.get((byte[])NullChecking.neverNull((Object)this.mString), this.mString.length - this.mStringLength, remove);
                    this.mStringLength -= remove;
                    if (this.mStringLength > 0) continue block29;
                    if (this.mMarkerCode == 1) {
                        this.mState = AState.IMAGE_DATA;
                        break;
                    }
                    if (this.mMarkerCode == 4) {
                        this.mState = AState.IMAGE_LENGTH;
                        break;
                    }
                    String text = new String(this.mString, StandardCharsets.UTF_8);
                    if (this.mMarkerCode == 7 || this.mMarkerCode == 8) {
                        if (timestamp >= 0L) {
                            if (this.mMarkerCode == 7) {
                                this.outputStream.annotationTextNameChannel(timestamp, this.mChannel, this.mGroup, text);
                            } else {
                                this.outputStream.annotationTextNameGroup(timestamp, this.mGroup, text);
                            }
                        }
                    } else if (this.mMarkerCode == 9) {
                        this.outputStream.annotationOpenCLUnsupported(timestamp);
                    } else if (timestamp >= 0L) {
                        if (this.mMarkerCode == 5) {
                            this.outputStream.annotationMarker(timestamp, new AnnotationColour(this.mColor), text);
                        } else {
                            this.outputStream.annotationText(timestamp, this.mChannel, new AnnotationColour(this.mColor), text);
                        }
                    }
                    this.reset();
                    break;
                }
                case IMAGE_LENGTH: {
                    this.mImageLength = in.getUnsignedByte();
                    this.mState = AState.IMAGE_LENGTH_1;
                    break;
                }
                case IMAGE_LENGTH_1: {
                    this.mImageLength += in.getUnsignedByte() << 8;
                    this.mState = AState.IMAGE_LENGTH_2;
                    break;
                }
                case IMAGE_LENGTH_2: {
                    this.mImageLength += in.getUnsignedByte() << 16;
                    this.mState = AState.IMAGE_LENGTH_3;
                    break;
                }
                case IMAGE_LENGTH_3: {
                    this.mImageLength += in.getUnsignedByte() << 24;
                    this.mImage = new byte[this.mImageLength];
                    if (this.mMarkerCode == 1) {
                        this.mState = AState.COLOR;
                        break;
                    }
                    if (this.mImageLength > 0) {
                        this.mState = AState.IMAGE_DATA;
                        break;
                    }
                    if (timestamp >= 0L) {
                        String text = new String(this.mString, StandardCharsets.UTF_8);
                        this.outputStream.annotationVisual(timestamp, text, (byte[])NullChecking.neverNullOr((Object)this.mImage, (Object)EMPTY));
                    }
                    this.reset();
                    break;
                }
                case IMAGE_DATA: {
                    int read = size - in.position() + origPos;
                    if (read > this.mImageLength) {
                        read = this.mImageLength;
                    }
                    in.get((byte[])NullChecking.neverNull((Object)this.mImage), this.mImage.length - this.mImageLength, read);
                    this.mImageLength -= read;
                    if (this.mImageLength > 0) continue block29;
                    if (timestamp >= 0L) {
                        String text = new String(this.mString, StandardCharsets.UTF_8);
                        this.outputStream.annotationVisual(timestamp, text, (byte[])NullChecking.neverNullOr((Object)this.mImage, (Object)EMPTY));
                    }
                    this.reset();
                    break;
                }
                case ASCII_COLOR: {
                    if (in.peekUnsignedByte() == 27) {
                        in.skipBytes(1);
                        this.mColor = -16777216;
                        this.mState = AState.ASCII_COLOR_1;
                        break;
                    }
                    this.mState = AState.ASCII_STRING_DATA;
                    break;
                }
                case ASCII_COLOR_1: {
                    this.mColor |= in.getUnsignedByte() << 16;
                    this.mState = AState.ASCII_COLOR_2;
                    break;
                }
                case ASCII_COLOR_2: {
                    this.mColor |= in.getUnsignedByte() << 8;
                    this.mState = AState.ASCII_COLOR_3;
                    break;
                }
                case ASCII_COLOR_3: {
                    this.mColor |= in.getUnsignedByte();
                    this.mState = AState.ASCII_STRING_DATA;
                    break;
                }
                case ASCII_STRING_DATA: {
                    int value = in.getUnsignedByte();
                    if (value == 0 || value == 10) {
                        if (timestamp >= 0L) {
                            if (this.mMarkerCode == 2) {
                                this.outputStream.annotationMarker(timestamp, AnnotationColour.DEFAULT_COLOUR_OBJ, this.mStringText.toString());
                            } else {
                                this.outputStream.annotationText(timestamp, 0, AnnotationColour.DEFAULT_COLOUR_OBJ, this.mStringText.toString());
                            }
                        }
                        this.reset();
                        break;
                    }
                    this.mStringText.append((char)value);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void reset() {
        this.mState = AState.ESCAPE_CODE;
        this.mMarkerCode = 0;
        this.mStringLength = 0;
        this.mImageLength = 0;
        this.mChannel = 0;
        this.mColor = -3092272;
        this.mString = null;
        this.mImage = null;
        this.mStringText.setLength(0);
    }

    private void writeError(long timestamp, @NonNull String format) throws IOException {
        this.outputStream.annotationMarker(timestamp, AnnotationColour.WARNING_COLOUR, format);
    }

    private static enum AState {
        ASCII_COLOR,
        ASCII_COLOR_1,
        ASCII_COLOR_2,
        ASCII_COLOR_3,
        ASCII_STRING_DATA,
        CHANNEL,
        CHANNEL_1,
        CHANNEL_2,
        CHANNEL_3,
        COLOR,
        COLOR_1,
        COLOR_2,
        COLOR_3,
        ERROR,
        ESCAPE_CODE,
        GROUP,
        GROUP_1,
        GROUP_2,
        GROUP_3,
        IMAGE_DATA,
        IMAGE_LENGTH,
        IMAGE_LENGTH_1,
        IMAGE_LENGTH_2,
        IMAGE_LENGTH_3,
        MARKER_CODE,
        STRING_DATA,
        STRING_LENGTH,
        STRING_LENGTH_1;

    }
}

