/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two;

import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.KernelAnnotationSeriesKey;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.protocol.capture.apc.pass_two.IExternalProtocolPassTwoEventStream;
import com.arm.streamline.protocol.capture.apc.pass_two.IKernelTracepointProcessor;
import com.arm.streamline.protocol.misc.TaskId;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.NonNull;

public class KernelTracepointProcessor
implements IKernelTracepointProcessor {
    private static final @NonNull String GATOR_PREFIX = "gator_";
    private static final @NonNull String TRACEPOINT_GATOR_BOOKMARK = "gator_bookmark";
    private static final @NonNull String TRACEPOINT_GATOR_TEXT = "gator_text";
    private static final @NonNull String TRACEPOINT_GATOR_COUNTER = "gator_counter";
    private static final @NonNull String FIELD_TID = "tid";
    private static final @NonNull String FIELD_LABEL = "label";
    private static final @NonNull String FIELD_COLOR = "color";
    private static final @NonNull String FIELD_CHANNEL = "channel";
    private static final @NonNull String FIELD_VALUE = "value";
    private static final @NonNull String FIELD_IS_DELTA = "isdelta";
    private static final @NonNull String FIELD_TITLE = "title";
    private static final @NonNull String FIELD_NAME = "name";
    private static final @NonNull String FIELD_UNITS = "units";
    private static final @NonNull String KERNEL_COUNTER_DESC = "A custom user-generated kernel counter";
    private static final AtomicInteger CHANNEL_ID_GENERATOR = new AtomicInteger(0);
    private final long vmUID;
    private final @NonNull IExternalProtocolPassTwoEventStream output;
    private final @NonNull ProcessingElementReferenceSet peReferenceSet;
    private final @NonNull TObjectIntHashMap<@NonNull String> channelStringToID;
    private final @NonNull Map<@NonNull String, @NonNull KernelAnnotationSeriesKey> counterNameToKey;

    public KernelTracepointProcessor(long vmUID, @NonNull IExternalProtocolPassTwoEventStream output, @NonNull ProcessingElementReferenceSet peReferenceSet) {
        this.vmUID = vmUID;
        this.output = output;
        this.peReferenceSet = peReferenceSet;
        this.channelStringToID = new TObjectIntHashMap();
        this.counterNameToKey = new HashMap<String, KernelAnnotationSeriesKey>();
    }

    @Override
    public boolean isKernelTracepoint(@NonNull TracepointFormat tracepointFormat) {
        return tracepointFormat.getName().startsWith(GATOR_PREFIX);
    }

    @Override
    public boolean processTracepointData(long mappedTimestamp, @NonNull TracepointFormat tracepointFormat, byte @NonNull [] raw) throws IOException {
        switch (tracepointFormat.getName()) {
            case "gator_bookmark": {
                int tid = (int)tracepointFormat.getInt(FIELD_TID, raw);
                TaskId taskId = tid < 0 ? null : new TaskId(tid);
                AnnotationColour colour = new AnnotationColour((int)tracepointFormat.getInt(FIELD_COLOR, raw));
                this.output.annotationMarker(mappedTimestamp, taskId, colour, tracepointFormat.getDynamicString(FIELD_LABEL, raw));
                break;
            }
            case "gator_text": {
                int tid = (int)tracepointFormat.getInt(FIELD_TID, raw);
                assert (tid >= 0);
                TaskId taskId = new TaskId(Math.max(0, tid));
                String channelString = tracepointFormat.getDynamicString(FIELD_CHANNEL, raw);
                int channelID = this.channelStringToID.get((Object)channelString);
                if (!this.channelStringToID.contains((Object)channelString)) {
                    channelID = CHANNEL_ID_GENERATOR.getAndIncrement();
                    this.channelStringToID.put((Object)channelString, channelID);
                    this.output.annotationTextNameChannel(mappedTimestamp, taskId, channelID, 0, channelString);
                }
                AnnotationColour colour = new AnnotationColour((int)tracepointFormat.getInt(FIELD_COLOR, raw));
                this.output.annotationText(mappedTimestamp, taskId, channelID, colour, tracepointFormat.getDynamicString(FIELD_LABEL, raw));
                break;
            }
            case "gator_counter": {
                int tid = (int)tracepointFormat.getInt(FIELD_TID, raw);
                TaskId taskId = tid < 0 ? null : new TaskId(tid);
                String title = tracepointFormat.getDynamicString(FIELD_TITLE, raw);
                String name = tracepointFormat.getDynamicString(FIELD_NAME, raw);
                String titleNameConcat = String.format("%s_%s", title, name);
                KernelAnnotationSeriesKey counterKey = this.counterNameToKey.get(titleNameConcat);
                if (counterKey == null) {
                    counterKey = new KernelAnnotationSeriesKey(title, name);
                    this.counterNameToKey.put(titleNameConcat, counterKey);
                    boolean isDelta = tracepointFormat.getBool(FIELD_IS_DELTA, raw);
                    CounterClass counterClass = isDelta ? CounterClass.DELTA : CounterClass.ABSOLUTE;
                    CounterDisplay display = isDelta ? CounterDisplay.ACCUMULATE : CounterDisplay.AVERAGE;
                    this.output.createKernelAnnotationsCounterSeries(counterKey, title, name, tracepointFormat.getDynamicString(FIELD_UNITS, raw), KERNEL_COUNTER_DESC, counterClass, display, SeriesComposition.DEFAULT, GraphRenderingType.DEFAULT, isDelta, false, AnnotationColour.DEFAULT_COLOUR_OBJ, 1.0, Collections.emptyList(), Collections.emptyList());
                }
                long value = tracepointFormat.getInt(FIELD_VALUE, raw);
                this.output.counter((ICounterSeriesKey)counterKey, mappedTimestamp, this.peReferenceSet.get(DeviceType.SYSTEM_WIDE, this.vmUID, 0), taskId, value);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

