/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_one;

import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.perf.records.EventAttribute;
import com.arm.streamline.perf.records.EventHeader;
import com.arm.streamline.perf.records.ReadFormat;
import com.arm.streamline.perf.records.RecordBlob;
import com.arm.streamline.perf.records.RegisterValues;
import com.arm.streamline.protocol.capture.apc.io.APCFrameAddress;
import com.arm.streamline.protocol.capture.apc.pass_one.IGatorPassOneTimestampTracker;
import com.arm.streamline.protocol.capture.apc.pass_two.PerfDataBufferPassTwoEventConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfDataBufferEventConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfProtocolStateTracker;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.misc.TaskId;
import com.arm.utils.collections.ObjIntPair;
import com.arm.utils.collections.ObjLongPair;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class PerfDataBufferPassOneEventConsumer
implements IPerfDataBufferEventConsumer<APCFrameAddress> {
    protected static final String TRACEPOINT_FIELD_SCHED_SWITCH_NEXT_PID = "next_pid";
    protected static final String TRACEPOINT_NAME_SCHED_SWITCH = "sched_switch";
    private final @NonNull IPerfProtocolStateTracker perfAttributesTracker;
    private final @NonNull IGatorPassOneTimestampTracker timestampTracker;
    private final @NonNull Map<@NonNull ObjIntPair<@Nullable Long>, @NonNull ObjLongPair<@NonNull ClockSource>> itraceTimes = new HashMap<ObjIntPair<Long>, ObjLongPair<ClockSource>>();

    public PerfDataBufferPassOneEventConsumer(@NonNull IPerfProtocolStateTracker perfAttributesTracker, @NonNull IGatorPassOneTimestampTracker timestampTracker) {
        this.perfAttributesTracker = perfAttributesTracker;
        this.timestampTracker = timestampTracker;
    }

    @Override
    public void aux(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @Nullable Long attributeId, @Nullable TaskId taskId, long offset, long size, long flags) throws IOException {
        ObjLongPair<ClockSource> itraceEntry = this.itraceTimes.get(new ObjIntPair((Object)attributeId, deviceNumber));
        if (itraceEntry != null) {
            this.timestampTracker.trackPerfTimestamp(address, (ClockSource)((Object)itraceEntry.first), itraceEntry.second, deviceNumber);
        }
        this.timestampTracker.trackPerfTimestamp(address, clockSource, timestamp, deviceNumber);
        this.itraceTimes.put((ObjIntPair<Long>)new ObjIntPair((Object)attributeId, deviceNumber), (ObjLongPair<ClockSource>)new ObjLongPair((Object)clockSource, timestamp));
    }

    @Override
    public void comm(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @NonNull TaskId taskId, @NonNull String comm, boolean exec, @Nullable Long sampleTimestampLocalClock) throws IOException {
        this.timestampTracker.trackPossibleSyncThreadComm(taskId.tid, comm, sampleTimestampLocalClock);
        this.timestampTracker.trackPerfTimestamp(address, clockSource, timestamp, deviceNumber);
    }

    @Override
    public void exit(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @NonNull TaskId taskId) throws IOException {
        this.timestampTracker.trackPerfTimestamp(address, clockSource, timestamp, deviceNumber);
    }

    @Override
    public void fork(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @NonNull TaskId parentTaskId, @NonNull TaskId taskId) throws IOException {
        this.timestampTracker.trackPerfTimestamp(address, clockSource, timestamp, deviceNumber);
    }

    @Override
    public void itraceStart(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @Nullable Long attributeId, @NonNull TaskId taskId) throws IOException {
        this.timestampTracker.trackPerfTimestamp(address, clockSource, timestamp, deviceNumber);
        this.itraceTimes.put((ObjIntPair<Long>)new ObjIntPair((Object)attributeId, deviceNumber), (ObjLongPair<ClockSource>)new ObjLongPair((Object)clockSource, timestamp));
    }

    @Override
    public void lost(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, long id, long lost) throws IOException {
        this.timestampTracker.trackPerfTimestamp(address, clockSource, timestamp, deviceNumber);
    }

    @Override
    public void lostSamples(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, long lost) throws IOException {
        this.timestampTracker.trackPerfTimestamp(address, clockSource, timestamp, deviceNumber);
    }

    @Override
    public void mmap(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @NonNull TaskId taskId, long addr, long len, long pgOff, @NonNull String filename, boolean data) throws IOException {
        if (!filename.equals("[kernel.kallsyms]_text")) {
            this.timestampTracker.trackPerfTimestamp(address, clockSource, timestamp, deviceNumber);
        } else {
            this.timestampTracker.trackPerfTimestamp(address, ClockSource.BEFORE_START, 0L, deviceNumber);
        }
    }

    @Override
    public void other(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, @NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, int deviceNumber, @NonNull ByteBuffer buffer) throws IOException {
        this.timestampTracker.trackPerfTimestamp(address, clockSource, timestamp, deviceNumber);
    }

    @Override
    public void read(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @NonNull TaskId taskId, @NonNull ReadFormat readFormat) throws IOException {
        this.timestampTracker.trackPerfTimestamp(address, clockSource, timestamp, deviceNumber);
    }

    @Override
    public void sample(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, @NonNull EventHeader header, @NonNull RecordBlob.SampleRecord sampleRecord, int deviceNumber, @Nullable ReadFormat readFormat, long @Nullable [] callchain, byte @Nullable [] raw, boolean registersHostIs64bit, RecordBlob.IRecordBlobVisitor.Abi registersAbi, RegisterValues registers) throws IOException {
        TracepointFormat tracepointFormat;
        @Nullable EventAttribute attribute = sampleRecord.attribute;
        @Nullable Long time = sampleRecord.time;
        @Nullable Integer tid = sampleRecord.tid;
        if (time != null && tid != null) {
            @NonNull PerfDataBufferPassTwoEventConsumer.GenerateFakeContextSwitchResult fakeContextSwitch = PerfDataBufferPassTwoEventConsumer.shouldGenerateFakeContextSwitch(this.perfAttributesTracker, attribute);
            switch (fakeContextSwitch) {
                case DO_NOT_GENERATE: 
                case GENERATE_EXIT: {
                    break;
                }
                case GENERATE_ENTRY: {
                    this.timestampTracker.trackPossibleSyncThreadTaskSwitch(time, tid);
                    break;
                }
                default: {
                    throw new AssertionError((Object)fakeContextSwitch);
                }
            }
        }
        if (time != null && raw != null && attribute != null && !attribute.isFlagSet(EventAttribute.Flags.USE_CLOCKID) && attribute.getType() == 2 && (tracepointFormat = this.perfAttributesTracker.getTracepointFormat(attribute.getConfig())) != null && TRACEPOINT_NAME_SCHED_SWITCH.equals(tracepointFormat.getName())) {
            int nextTid = (int)tracepointFormat.getInt(TRACEPOINT_FIELD_SCHED_SWITCH_NEXT_PID, raw);
            this.timestampTracker.trackPossibleSyncThreadTaskSwitch(time, nextTid);
        }
        this.timestampTracker.trackPerfTimestamp(address, clockSource, timestamp, deviceNumber);
    }

    @Override
    public void simplePerfCallchain(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @NonNull TaskId taskId, long chainType, long time, long[] ips, long[] sps) throws IOException {
        this.timestampTracker.trackPerfTimestamp(address, clockSource, timestamp, deviceNumber);
    }

    @Override
    public void simplePerfKAllSyms(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @NonNull String kallsyms) throws IOException {
        this.timestampTracker.trackPerfTimestamp(address, clockSource, timestamp, deviceNumber);
    }

    @Override
    public void swtch(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @Nullable Long attributeId, @Nullable TaskId taskId, boolean out) throws IOException {
        this.timestampTracker.trackPerfTimestamp(address, clockSource, timestamp, deviceNumber);
    }

    @Override
    public void swtchCpuWide(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @Nullable Long attributeId, @Nullable TaskId sampleTaskId, boolean out, @NonNull TaskId prevNextTaskId) throws IOException {
        this.timestampTracker.trackPerfTimestamp(address, clockSource, timestamp, deviceNumber);
    }

    @Override
    public void throttle(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, long time, long id, long streamId) throws IOException {
        this.timestampTracker.trackPerfTimestamp(address, clockSource, timestamp, deviceNumber);
    }

    @Override
    public void unthrottle(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, long time, long id, long streamId) throws IOException {
        this.timestampTracker.trackPerfTimestamp(address, clockSource, timestamp, deviceNumber);
    }
}

