/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_one;

import com.arm.streamline.protocol.ProtocolException;
import com.arm.streamline.protocol.capture.apc.index.IAPCFrameAddressIndexTracker;
import com.arm.streamline.protocol.capture.apc.io.APCFrameAddress;
import com.arm.streamline.protocol.capture.apc.pass_one.IGatorPassOneTimestampTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.IGatordSyncThreadTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.ISpeSyncEventTracker;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolMessageProperties;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.capture.apc.time.Timestamp;
import com.arm.streamline.protocol.capture.apc.time.TimesyncInformation;
import com.arm.utils.numbers.UnsignedLong;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GatorPassOneTimestampTracker
implements IGatorPassOneTimestampTracker {
    public static final long LOCAL_CLOCK_MONOTONIC_BASE_ALIGNMENT_FACTOR = 1000000000L;
    private @Nullable Long earliestLocalClockOrMonotonicRawTimestamp;
    private @Nullable Long earliestLocalClockTimestamp;
    private @Nullable Long earliestMonotonicDeltaTimestamp;
    private @Nullable Long earliestMonotonicRawTimestamp;
    private @Nullable TimesyncEvent earliestTimesyncEvent;
    private final @NonNull IAPCFrameAddressIndexTracker frameIndex;
    private @Nullable Long latestLocalClockOrMonotonicRawTimestamp;
    private @Nullable Long latestLocalClockTimestamp;
    private @Nullable Long latestMonotonicDeltaTimestamp;
    private @Nullable Long latestMonotonicRawTimestamp;
    private final @NonNull ISpeSyncEventTracker speSyncEventTracker;
    private @Nullable SummaryInformation summaryInformation;
    private final @NonNull IGatordSyncThreadTracker syncThreadTracker;
    private final long vmUID;

    private static @NonNull Long updateEarliestTimestamp(@Nullable Long earliestTimestamp, long newTimestamp) {
        if (earliestTimestamp == null || UnsignedLong.compare((long)newTimestamp, (long)earliestTimestamp) < 0) {
            return newTimestamp;
        }
        return earliestTimestamp;
    }

    private static @NonNull Long updateLatestTimestamp(@Nullable Long latestTimestamp, long newTimestamp) {
        if (latestTimestamp == null || UnsignedLong.compare((long)newTimestamp, (long)latestTimestamp) > 0) {
            return newTimestamp;
        }
        return latestTimestamp;
    }

    public GatorPassOneTimestampTracker(long vmUID, @NonNull IAPCFrameAddressIndexTracker frameIndex, @NonNull IGatordSyncThreadTracker syncThreadTracker, @NonNull ISpeSyncEventTracker speSyncEventTracker) {
        this.vmUID = vmUID;
        this.frameIndex = frameIndex;
        this.speSyncEventTracker = speSyncEventTracker;
        this.syncThreadTracker = syncThreadTracker;
    }

    @Override
    public void addTimesyncEvent(long monotonicDelta, long localClock) {
        @Nullable TimesyncEvent currentEvent = this.earliestTimesyncEvent;
        if (currentEvent == null || monotonicDelta < currentEvent.monotonicDelta) {
            this.earliestTimesyncEvent = new TimesyncEvent(monotonicDelta, localClock);
        }
    }

    @Override
    public void deferFrame(@NonNull APCFrameAddress address) {
        this.frameIndex.removeDeferredFrame(this.vmUID, address);
    }

    public @NonNull TimesyncInformation getTimesyncInformation() throws ProtocolException {
        @Nullable SummaryInformation summaryInformation = this.summaryInformation;
        if (summaryInformation == null) {
            throw new ProtocolException(ProtocolException.Reason.MISSING_SUMMARY_INFORMATION);
        }
        long earliestLocalClock = this.findEarliestLocalClock(summaryInformation.nosync, summaryInformation.monotonicTime);
        long delta = earliestLocalClock - summaryInformation.monotonicTime;
        boolean useMonotonicRawAsLocalClockBase = delta >= -1000000000L && delta <= 1000000000L;
        long earliestMonotonicDelta = this.findEarliestMonotonicDelta(summaryInformation.nosync, useMonotonicRawAsLocalClockBase, summaryInformation.monotonicTime, earliestLocalClock);
        long latestMonotonicDelta = this.findLatestMonotonicDelta(summaryInformation.nosync, useMonotonicRawAsLocalClockBase, summaryInformation.monotonicTime, earliestLocalClock);
        long duration = latestMonotonicDelta - earliestMonotonicDelta;
        return new TimesyncInformation(summaryInformation.nosync, useMonotonicRawAsLocalClockBase, summaryInformation.monotonicTime, earliestLocalClock, earliestMonotonicDelta, duration, this.speSyncEventTracker.getTimestampMapper());
    }

    @Override
    public void setSummaryInformation(long monotonicTime, boolean nosync) {
        assert (this.summaryInformation == null);
        this.summaryInformation = new SummaryInformation(monotonicTime, nosync);
    }

    @Override
    public void trackExternalFrame(@NonNull APCFrameAddress address, @NonNull ExternalProtocolMessageProperties properties) {
        assert (properties.channel.vmUID == this.vmUID);
        this.frameIndex.frameExternal(address, properties);
    }

    @Override
    public @NonNull Timestamp trackNonPerfTimestamp(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp) {
        @NonNull Timestamp timestampObject = this.createTimestamp(clockSource, timestamp);
        this.frameIndex.frameTimestamp(address, this.vmUID, timestampObject);
        return timestampObject;
    }

    @Override
    public @NonNull Timestamp trackPerfTimestamp(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber) {
        @NonNull Timestamp timestampObject = this.createTimestamp(clockSource, timestamp);
        this.frameIndex.perfFrameTimestamp(address, this.vmUID, timestampObject, deviceNumber);
        return timestampObject;
    }

    @Override
    public void trackPossibleSyncThreadComm(int tid, @NonNull String comm, @Nullable Long localClock) {
        this.syncThreadTracker.trackComm(tid, comm, localClock);
    }

    @Override
    public void trackPossibleSyncThreadTaskSwitch(long localClock, int nextTid) {
        this.syncThreadTracker.trackSwitch(localClock, nextTid);
    }

    @Override
    public void trackSpeSyncEvent(int deviceNumber, long monotonicRaw, long archClockCount, long archClockFreq) {
        this.speSyncEventTracker.track(deviceNumber, monotonicRaw, archClockCount, archClockFreq);
    }

    @Override
    public void updateTimeRange(@NonNull ClockSource clockSource, long timestamp) {
        this.createTimestamp(clockSource, timestamp);
    }

    private @NonNull Timestamp createLocalClock(long value) {
        this.earliestLocalClockTimestamp = GatorPassOneTimestampTracker.updateEarliestTimestamp(this.earliestLocalClockTimestamp, value);
        this.latestLocalClockTimestamp = GatorPassOneTimestampTracker.updateLatestTimestamp(this.latestLocalClockTimestamp, value);
        return new Timestamp(ClockSource.LOCAL_CLOCK, value);
    }

    private @NonNull Timestamp createLocalClockOrMonotonicRaw(long value) {
        @Nullable SummaryInformation summaryInformation = this.summaryInformation;
        if (summaryInformation != null && summaryInformation.nosync) {
            if (UnsignedLong.compare((long)summaryInformation.monotonicTime, (long)value) > 0) {
                return Timestamp.BEFORE_START;
            }
            long delta = value - summaryInformation.monotonicTime;
            this.earliestMonotonicDeltaTimestamp = GatorPassOneTimestampTracker.updateEarliestTimestamp(this.earliestMonotonicDeltaTimestamp, delta);
            this.latestMonotonicDeltaTimestamp = GatorPassOneTimestampTracker.updateLatestTimestamp(this.latestMonotonicDeltaTimestamp, delta);
            return new Timestamp(ClockSource.MONOTONIC_DELTA, delta);
        }
        this.earliestLocalClockOrMonotonicRawTimestamp = GatorPassOneTimestampTracker.updateEarliestTimestamp(this.earliestLocalClockOrMonotonicRawTimestamp, value);
        this.latestLocalClockOrMonotonicRawTimestamp = GatorPassOneTimestampTracker.updateLatestTimestamp(this.latestLocalClockOrMonotonicRawTimestamp, value);
        return new Timestamp(ClockSource.LOCAL_CLOCK_OR_MONOTONIC_RAW, value);
    }

    private @NonNull Timestamp createMonotonicDelta(long value) {
        if (value < 0L) {
            return Timestamp.BEFORE_START;
        }
        this.earliestMonotonicDeltaTimestamp = GatorPassOneTimestampTracker.updateEarliestTimestamp(this.earliestMonotonicDeltaTimestamp, value);
        this.latestMonotonicDeltaTimestamp = GatorPassOneTimestampTracker.updateLatestTimestamp(this.latestMonotonicDeltaTimestamp, value);
        return new Timestamp(ClockSource.MONOTONIC_DELTA, value);
    }

    private @NonNull Timestamp createMonotonicRaw(long value) {
        @Nullable SummaryInformation summaryInformation = this.summaryInformation;
        if (summaryInformation != null) {
            if (UnsignedLong.compare((long)summaryInformation.monotonicTime, (long)value) > 0) {
                return Timestamp.BEFORE_START;
            }
            long delta = value - summaryInformation.monotonicTime;
            this.earliestMonotonicDeltaTimestamp = GatorPassOneTimestampTracker.updateEarliestTimestamp(this.earliestMonotonicDeltaTimestamp, delta);
            this.latestMonotonicDeltaTimestamp = GatorPassOneTimestampTracker.updateLatestTimestamp(this.latestMonotonicDeltaTimestamp, delta);
            return new Timestamp(ClockSource.MONOTONIC_DELTA, delta);
        }
        this.earliestMonotonicRawTimestamp = GatorPassOneTimestampTracker.updateEarliestTimestamp(this.earliestMonotonicRawTimestamp, value);
        this.latestMonotonicRawTimestamp = GatorPassOneTimestampTracker.updateLatestTimestamp(this.latestMonotonicRawTimestamp, value);
        return new Timestamp(ClockSource.MONOTONIC_RAW, value);
    }

    private @NonNull Timestamp createTimestamp(@NonNull ClockSource clockSource, long timestamp) {
        switch (clockSource) {
            case BEFORE_START: {
                return Timestamp.BEFORE_START;
            }
            case LOCAL_CLOCK: {
                return this.createLocalClock(timestamp);
            }
            case LOCAL_CLOCK_OR_MONOTONIC_RAW: {
                return this.createLocalClockOrMonotonicRaw(timestamp);
            }
            case MONOTONIC_DELTA: {
                return this.createMonotonicDelta(timestamp);
            }
            case MONOTONIC_RAW: {
                return this.createMonotonicRaw(timestamp);
            }
        }
        throw new AssertionError();
    }

    private long findEarliestLocalClock(boolean nosync, long monotonicTime) {
        @Nullable TimesyncEvent timesyncEvent = this.earliestTimesyncEvent;
        if (timesyncEvent != null) {
            return timesyncEvent.localClock - timesyncEvent.monotonicDelta;
        }
        @Nullable Long syncThreadTimeBase = this.syncThreadTracker.getLocalClockBase(monotonicTime);
        @Nullable Long localClock = this.earliestLocalClockTimestamp;
        @Nullable Long localClockOrMonontonicRaw = this.earliestLocalClockOrMonotonicRawTimestamp;
        if (syncThreadTimeBase != null) {
            return syncThreadTimeBase;
        }
        if (!nosync && localClockOrMonontonicRaw != null) {
            if (localClock != null) {
                return UnsignedLong.min((long)localClock, (long)localClockOrMonontonicRaw);
            }
            return localClockOrMonontonicRaw;
        }
        if (localClock != null) {
            return localClock;
        }
        return 0L;
    }

    private long findEarliestMonotonicDelta(boolean nosync, boolean useMonotonicRawAsLocalClockBase, long monotonicTime, long earliestLocalClock) {
        @Nullable Long earliestLocalClockOrMonotonicRawTimestamp = this.earliestLocalClockOrMonotonicRawTimestamp;
        @Nullable Long earliestLocalClockTimestamp = this.earliestLocalClockTimestamp;
        @Nullable Long earliestMonotonicDeltaTimestamp = this.earliestMonotonicDeltaTimestamp;
        @Nullable Long earliestMonotonicRawTimestamp = this.earliestMonotonicRawTimestamp;
        Long result = null;
        if (earliestLocalClockOrMonotonicRawTimestamp != null) {
            result = nosync || useMonotonicRawAsLocalClockBase ? GatorPassOneTimestampTracker.updateEarliestTimestamp(result, Math.max(earliestLocalClockOrMonotonicRawTimestamp - monotonicTime, 0L)) : GatorPassOneTimestampTracker.updateEarliestTimestamp(result, Math.max(earliestLocalClockOrMonotonicRawTimestamp - earliestLocalClock, 0L));
        }
        if (earliestLocalClockTimestamp != null) {
            result = useMonotonicRawAsLocalClockBase ? GatorPassOneTimestampTracker.updateEarliestTimestamp(result, Math.max(earliestLocalClockTimestamp - monotonicTime, 0L)) : GatorPassOneTimestampTracker.updateEarliestTimestamp(result, Math.max(earliestLocalClockTimestamp - earliestLocalClock, 0L));
        }
        if (earliestMonotonicRawTimestamp != null) {
            result = GatorPassOneTimestampTracker.updateEarliestTimestamp(result, Math.max(earliestMonotonicRawTimestamp - monotonicTime, 0L));
        }
        if (earliestMonotonicDeltaTimestamp != null) {
            result = GatorPassOneTimestampTracker.updateEarliestTimestamp(result, Math.max(earliestMonotonicDeltaTimestamp, 0L));
        }
        if (result == null) {
            return 0L;
        }
        return result;
    }

    private long findLatestMonotonicDelta(boolean nosync, boolean useMonotonicRawAsLocalClockBase, long monotonicTime, long latestLocalClock) {
        @Nullable Long latestLocalClockOrMonotonicRawTimestamp = this.latestLocalClockOrMonotonicRawTimestamp;
        @Nullable Long latestLocalClockTimestamp = this.latestLocalClockTimestamp;
        @Nullable Long latestMonotonicDeltaTimestamp = this.latestMonotonicDeltaTimestamp;
        @Nullable Long latestMonotonicRawTimestamp = this.latestMonotonicRawTimestamp;
        Long result = null;
        if (latestLocalClockOrMonotonicRawTimestamp != null) {
            result = nosync || useMonotonicRawAsLocalClockBase ? GatorPassOneTimestampTracker.updateLatestTimestamp(result, Math.max(latestLocalClockOrMonotonicRawTimestamp - monotonicTime, 0L)) : GatorPassOneTimestampTracker.updateLatestTimestamp(result, Math.max(latestLocalClockOrMonotonicRawTimestamp - latestLocalClock, 0L));
        }
        if (latestLocalClockTimestamp != null) {
            result = useMonotonicRawAsLocalClockBase ? GatorPassOneTimestampTracker.updateLatestTimestamp(result, Math.max(latestLocalClockTimestamp - monotonicTime, 0L)) : GatorPassOneTimestampTracker.updateLatestTimestamp(result, Math.max(latestLocalClockTimestamp - latestLocalClock, 0L));
        }
        if (latestMonotonicRawTimestamp != null) {
            result = GatorPassOneTimestampTracker.updateLatestTimestamp(result, Math.max(latestMonotonicRawTimestamp - monotonicTime, 0L));
        }
        if (latestMonotonicDeltaTimestamp != null) {
            result = GatorPassOneTimestampTracker.updateLatestTimestamp(result, Math.max(latestMonotonicDeltaTimestamp, 0L));
        }
        if (result == null) {
            return 0L;
        }
        return result;
    }

    private static class SummaryInformation {
        public final long monotonicTime;
        public final boolean nosync;

        public SummaryInformation(long monotonicTime, boolean nosync) {
            this.monotonicTime = monotonicTime;
            this.nosync = nosync;
        }
    }

    private static final class TimesyncEvent {
        public final long localClock;
        public final long monotonicDelta;

        public TimesyncEvent(long monotonicDelta, long localClock) {
            this.monotonicDelta = monotonicDelta;
            this.localClock = localClock;
        }
    }
}

