/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_one;

import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.perf.InvalidPerfDataException;
import com.arm.streamline.perf.records.EventAttribute;
import com.arm.streamline.protocol.capture.apc.io.APCFrameAddress;
import com.arm.streamline.protocol.capture.apc.pass_one.ExternalProtocolChannelPassOneTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.ICookieTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.IExternalProtocolChannelPassOneTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.IGatorPassOneGlobalStateTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.IGatorPassOnePerVirtualMachineStateTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.IGatorPassOneTimestampTracker;
import com.arm.streamline.protocol.capture.apc.pass_one.PerfDataBufferPassOneEventConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.DelayProcessingException;
import com.arm.streamline.protocol.capture.apc.protocol.IGatorPerVirtualMachineProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolChannel;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolMessageProperties;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfAuxDataBufferWriter;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfDataBufferEventConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfDataBufferPassProcessor;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfProtocolStateTracker;
import com.arm.streamline.protocol.capture.apc.protocol.perf.PerfDataBufferPassProcessor;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.misc.ILinuxKAllSymsSymbolParser;
import com.arm.streamline.protocol.misc.TaskId;
import com.arm.streamline.report.model.pe.ProcessingElementTopology;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GatorPassOnePerVirtualMachineProtocolEventConsumer
implements IGatorPerVirtualMachineProtocolEventConsumer {
    private final @NonNull ICookieTracker cookieTracker;
    private final @NonNull IExternalProtocolChannelPassOneTracker externalProtocolPassOneTracker;
    private final @NonNull IGatorPassOneGlobalStateTracker globalStateTracker;
    private final @NonNull ILinuxKAllSymsSymbolParser kallsymsTracker;
    private final @NonNull IPerfProtocolStateTracker perfAttributesTracker;
    private final @NonNull IPerfDataBufferEventConsumer<@NonNull APCFrameAddress> perfDataBufferPassOneEventConsumer;
    private final @NonNull IPerfDataBufferPassProcessor perfDataBufferPassProcessor;
    private final @NonNull IGatorPassOneTimestampTracker timestampTracker;
    private final @NonNull IGatorPassOnePerVirtualMachineStateTracker vmStateTracker;
    private final long vmUID;

    public GatorPassOnePerVirtualMachineProtocolEventConsumer(long vmUID, @NonNull ByteOrder byteOrder, @NonNull IGatorPassOneGlobalStateTracker globalStateTracker, @NonNull IGatorPassOnePerVirtualMachineStateTracker vmStateTracker, @NonNull IGatorPassOneTimestampTracker timestampTracker, @NonNull IPerfProtocolStateTracker perfAttributesTracker, @NonNull ICookieTracker cookieTracker, @NonNull ILinuxKAllSymsSymbolParser kallsymsTracker) {
        this.vmUID = vmUID;
        this.globalStateTracker = globalStateTracker;
        this.vmStateTracker = vmStateTracker;
        this.timestampTracker = timestampTracker;
        this.perfAttributesTracker = perfAttributesTracker;
        this.cookieTracker = cookieTracker;
        this.kallsymsTracker = kallsymsTracker;
        this.perfDataBufferPassProcessor = new PerfDataBufferPassProcessor(byteOrder, perfAttributesTracker);
        this.perfDataBufferPassOneEventConsumer = new PerfDataBufferPassOneEventConsumer(perfAttributesTracker, timestampTracker);
        this.externalProtocolPassOneTracker = new ExternalProtocolChannelPassOneTracker(vmUID);
    }

    public GatorPassOnePerVirtualMachineProtocolEventConsumer(long vmUID, @NonNull IGatorPassOneGlobalStateTracker globalStateTracker, @NonNull IGatorPassOnePerVirtualMachineStateTracker vmStateTracker, @NonNull IGatorPassOneTimestampTracker timestampTracker, @NonNull IPerfProtocolStateTracker perfAttributesTracker, @NonNull ICookieTracker cookieTracker, @NonNull ILinuxKAllSymsSymbolParser kallsymsTracker, @NonNull IPerfDataBufferPassProcessor perfDataBufferPassProcessor, @NonNull IPerfDataBufferEventConsumer<@NonNull APCFrameAddress> perfDataBufferPassOneEventConsumer, @NonNull IExternalProtocolChannelPassOneTracker externalProtocolPassOneTracker) {
        this.vmUID = vmUID;
        this.globalStateTracker = globalStateTracker;
        this.vmStateTracker = vmStateTracker;
        this.timestampTracker = timestampTracker;
        this.perfAttributesTracker = perfAttributesTracker;
        this.cookieTracker = cookieTracker;
        this.kallsymsTracker = kallsymsTracker;
        this.perfDataBufferPassProcessor = perfDataBufferPassProcessor;
        this.perfDataBufferPassOneEventConsumer = perfDataBufferPassOneEventConsumer;
        this.externalProtocolPassOneTracker = externalProtocolPassOneTracker;
    }

    @Override
    public void absoluteBacktrace(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, IBacktraceSource backtraceSource, int deviceNumber, @NonNull TaskId taskId, long @NonNull [] addresses) throws IOException {
        this.timestampTracker.trackNonPerfTimestamp(address, clockSource, timestamp);
    }

    @Override
    public void activityStop(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, int key, @Nullable TaskId taskId, int activity) throws IOException {
        this.timestampTracker.trackNonPerfTimestamp(address, clockSource, timestamp);
    }

    @Override
    public void activitySwitch(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, int key, @Nullable TaskId taskId, int activity, int userStateValue) throws IOException {
        this.timestampTracker.trackNonPerfTimestamp(address, clockSource, timestamp);
    }

    @Override
    public void addPerfEventAttributeByKey(int key, @NonNull EventAttribute attribute) throws IOException {
        this.perfAttributesTracker.addPerfEventAttributeByKey(key, attribute);
    }

    @Override
    public void addPerfEventAttributeIdToKeyMapping(long id, int key) throws IOException {
        this.perfAttributesTracker.addPerfEventAttributeIdToKeyMapping(id, key);
    }

    @Override
    public void captureProperties(long wallClockTime, long bootTime, long monotonicTime, boolean nosync, @NonNull Map<@NonNull String, @NonNull String> attributes) throws IOException {
        this.timestampTracker.setSummaryInformation(monotonicTime, nosync);
        boolean applicationTracingMode = attributes.getOrDefault("perf.is_system_wide", "1").equals("0");
        boolean perfCanAccessTracepoints = !attributes.getOrDefault("perf.can_access_tracepoints", "1").equals("0");
        boolean perfHasContextSwitchRecords = !attributes.getOrDefault("perf.has_attr_context_switch", "0").equals("0");
        boolean supportsSchedulerTrace = !applicationTracingMode || perfCanAccessTracepoints || perfHasContextSwitchRecords;
        this.vmStateTracker.setApplicationTracingMode(applicationTracingMode);
        this.perfAttributesTracker.setSupportsSchedulerTrace(supportsSchedulerTrace);
        this.globalStateTracker.captureSummary(this.vmUID, wallClockTime, bootTime, monotonicTime, attributes, applicationTracingMode);
    }

    @Override
    public void cookie(@NonNull APCFrameAddress address, int cookieUID, @NonNull String value) throws IOException {
        this.cookieTracker.set(cookieUID, value);
    }

    @Override
    public void counter(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, @Nullable Integer deviceNumber, @Nullable TaskId taskId, int key, long value) throws IOException {
        this.timestampTracker.trackNonPerfTimestamp(address, clockSource, timestamp);
    }

    @Override
    public void externalClosed(int fd) throws IOException {
        this.externalProtocolPassOneTracker.close(fd);
    }

    @Override
    public void externalData(@NonNull APCFrameAddress address, int fd, int loadOffset, byte @NonNull [] data) throws IOException {
        @Nullable ExternalProtocolMessageProperties properties = this.externalProtocolPassOneTracker.data(fd, loadOffset, data);
        if (properties != null) {
            this.timestampTracker.trackExternalFrame(address, properties);
        }
    }

    @Override
    public void externalFrame(@NonNull APCFrameAddress address, long uid, int fd, @NonNull String channelName, int offset, byte @NonNull [] data) throws IOException {
        @NonNull ExternalProtocolChannel channel = this.externalProtocolPassOneTracker.getCompactChannel(uid, fd, channelName);
        @NonNull ExternalProtocolMessageProperties properties = new ExternalProtocolMessageProperties(channel, offset, data.length);
        this.timestampTracker.trackExternalFrame(address, properties);
    }

    @Override
    public @Nullable EventAttribute getPerfEventAttributeByKey(int key) {
        return this.perfAttributesTracker.getPerfEventAttributeByKey(key);
    }

    @Override
    public void idle(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, boolean online) throws IOException {
        this.timestampTracker.trackNonPerfTimestamp(address, clockSource, timestamp);
    }

    @Override
    public void metadata(@NonNull APCFrameAddress address, int key, @NonNull String value) throws IOException {
        this.globalStateTracker.metadata(this.vmUID, key, value);
    }

    @Override
    public void kAllSyms(@NonNull String kallsyms) throws IOException {
        this.kallsymsTracker.append(kallsyms);
    }

    @Override
    public void perfAuxBuffer(@NonNull APCFrameAddress address, int cpu, long offset, byte @NonNull [] data) throws IOException {
        @NonNull IPerfAuxDataBufferWriter auxBufferWriter = this.perfAttributesTracker.getPerfAuxBufferWriter(cpu);
        auxBufferWriter.append(offset, data);
    }

    @Override
    public void perfDataBuffer(@NonNull APCFrameAddress address, int protocolDeviceNumber, byte @NonNull [] data) throws IOException {
        try {
            this.perfDataBufferPassProcessor.processRecords(address, protocolDeviceNumber, data, this.perfDataBufferPassOneEventConsumer);
        }
        catch (InvalidPerfDataException e) {
            if (e.getReason() != InvalidPerfDataException.Reason.MISSING_ID) {
                throw e;
            }
            this.timestampTracker.deferFrame(address);
            throw new DelayProcessingException(e);
        }
    }

    @Override
    public void perfSpeSyncEvent(int deviceNumber, long monotonicRaw, long archClockCount, long archClockFreq) throws IOException {
        this.timestampTracker.trackSpeSyncEvent(deviceNumber, monotonicRaw, archClockCount, archClockFreq);
    }

    @Override
    public void processingElementProperties(int deviceNumber, int identifierCode, @NonNull String name, @Nullable ProcessingElementTopology processingElementTopology) throws IOException {
        this.globalStateTracker.processingElementProperties(this.vmUID, deviceNumber, identifierCode, name, processingElementTopology);
    }

    @Override
    public void schedSwitch(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, int deviceNumber, @NonNull TaskId nextTaskId, @NonNull IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason reason) throws IOException {
        this.timestampTracker.trackNonPerfTimestamp(address, clockSource, timestamp);
    }

    @Override
    public void threadExec(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, @Nullable TaskId oldTaskId, @NonNull TaskId taskId, int cookieUID) throws IOException {
        this.timestampTracker.trackNonPerfTimestamp(address, clockSource, timestamp);
    }

    @Override
    public void threadExit(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, @NonNull TaskId taskId) throws IOException {
        this.timestampTracker.trackNonPerfTimestamp(address, clockSource, timestamp);
    }

    @Override
    public void threadFork(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, @Nullable TaskId parentTaskId, @NonNull TaskId taskId) throws IOException {
        this.timestampTracker.trackNonPerfTimestamp(address, clockSource, timestamp);
    }

    @Override
    public void threadLinkCookie(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, @NonNull TaskId taskId, int cookieUID) throws IOException {
        this.timestampTracker.trackNonPerfTimestamp(address, clockSource, timestamp);
    }

    @Override
    public void threadMaps(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, @NonNull TaskId taskId, @NonNull String maps) throws IOException {
        this.timestampTracker.trackNonPerfTimestamp(address, clockSource, timestamp);
    }

    @Override
    public void threadMMap(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, @NonNull TaskId taskId, long fileOffset, long mapAddress, long length, @NonNull String filename) throws IOException {
        this.timestampTracker.trackNonPerfTimestamp(address, clockSource, timestamp);
    }

    @Override
    public void threadProperties(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, @Nullable TaskId parentTaskId, @NonNull TaskId taskId, @NonNull String name, @NonNull String exePath, @Nullable String linuxProcMapsContents) throws IOException {
        this.timestampTracker.trackNonPerfTimestamp(address, clockSource, timestamp);
    }

    @Override
    public void threadRename(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long timestamp, @NonNull TaskId taskId, @NonNull String name, boolean exec) throws IOException {
        this.timestampTracker.trackPossibleSyncThreadComm(taskId.tid, name, null);
        this.timestampTracker.trackNonPerfTimestamp(address, clockSource, timestamp);
    }

    @Override
    public void timesyncEvent(long monotonicDelta, long localClock) throws IOException {
        this.timestampTracker.addTimesyncEvent(monotonicDelta, localClock);
    }

    @Override
    public void tracepointFormat(@NonNull TracepointFormat tracepointFormat) throws IOException {
        this.perfAttributesTracker.addTracepointFormat(tracepointFormat);
    }

    @Override
    public void warning(long timestamp, @NonNull TaskId taskId, @NonNull String textMessage) throws IOException {
    }
}

