/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.index;

import com.arm.streamline.protocol.capture.apc.index.APCFrameAddressWithVmUIDAndTimestamp;
import com.arm.streamline.protocol.capture.apc.index.IAPCFrameAddressIndex;
import com.arm.streamline.protocol.capture.apc.index.IAPCFrameAddressIndexTracker;
import com.arm.streamline.protocol.capture.apc.io.APCFrameAddress;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolChannel;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolMessageProperties;
import com.arm.streamline.protocol.capture.apc.time.ITimestampMapper;
import com.arm.streamline.protocol.capture.apc.time.Timestamp;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingLongFunction;
import gnu.trove.map.hash.TIntLongHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class APCFrameAddressIndexTracker
implements IAPCFrameAddressIndexTracker,
IAPCFrameAddressIndex {
    private final @NonNull Map<@NonNull ExternalProtocolChannel, @NonNull List<@NonNull APCFrameAddress>> externalMessages = new HashMap<ExternalProtocolChannel, List<APCFrameAddress>>();
    private final boolean perfFramesMayContainManyCores;
    private final @NonNull Map<@NonNull Long, @NonNull List<@NonNull AddressIndexEntry>> timestamps = new HashMap<Long, List<AddressIndexEntry>>();
    private final @NonNull IThrowingLongFunction<@NonNull ITimestampMapper, IOException> timesyncInformationProvider;

    public APCFrameAddressIndexTracker(boolean perfFramesMayContainManyCores, @NonNull IThrowingLongFunction<@NonNull ITimestampMapper, IOException> timesyncInformationProvider) {
        this.perfFramesMayContainManyCores = perfFramesMayContainManyCores;
        this.timesyncInformationProvider = timesyncInformationProvider;
    }

    @Override
    public @NonNull SortedMap<@NonNull ExternalProtocolChannel, @NonNull List<@NonNull APCFrameAddress>> createExternalMessages() {
        for (List<APCFrameAddress> list : this.externalMessages.values()) {
            list.sort(Comparator.naturalOrder());
        }
        return Collections.unmodifiableSortedMap(new TreeMap<ExternalProtocolChannel, List<APCFrameAddress>>(this.externalMessages));
    }

    @Override
    public @NonNull List<@NonNull APCFrameAddressWithVmUIDAndTimestamp> createIndex() throws IOException {
        @NonNull ArrayList<@NonNull APCFrameAddressWithVmUIDAndTimestamp> result = new ArrayList<APCFrameAddressWithVmUIDAndTimestamp>(this.timestamps.size());
        for (Map.Entry<Long, List<AddressIndexEntry>> mEntry : this.timestamps.entrySet()) {
            @NonNull Long vmUID = mEntry.getKey();
            @NonNull List<@NonNull AddressIndexEntry> timestamps = mEntry.getValue();
            @NonNull ITimestampMapper timesyncInformation = (ITimestampMapper)this.timesyncInformationProvider.apply(vmUID.longValue());
            @NonNull ArrayList<@NonNull AddressIndexEntry> perfAddresses = new ArrayList<AddressIndexEntry>();
            int count = timestamps.size();
            int i = 0;
            while (i < count) {
                @NonNull AddressIndexEntry entry = timestamps.get(i);
                if (!entry.perfFrame) {
                    @NonNull Timestamp timestamp = entry.timestamp;
                    long mappedTimestamp = ITimestampMapper.mapTimestamp(timesyncInformation, timestamp);
                    @NonNull APCFrameAddressWithVmUIDAndTimestamp mappedEntry = new APCFrameAddressWithVmUIDAndTimestamp(entry.address, vmUID, mappedTimestamp);
                    result.add(mappedEntry);
                } else {
                    perfAddresses.add(entry);
                }
                Object nullEntry = null;
                timestamps.set(i, (AddressIndexEntry)nullEntry);
                ++i;
            }
            timestamps.clear();
            if (perfAddresses.isEmpty()) continue;
            Collections.reverse(perfAddresses);
            Collections.sort(perfAddresses, (a, b) -> -a.address.compareTo(b.address));
            TIntLongHashMap lastTimestamps = new TIntLongHashMap(10, 0.5f, 0, Long.MAX_VALUE);
            for (@NonNull AddressIndexEntry entry : perfAddresses) {
                int deviceNumber = entry.perfDeviceNumber;
                long lastTimestamp = lastTimestamps.get(deviceNumber);
                @NonNull Timestamp timestamp = entry.timestamp;
                long mappedTimestamp = ITimestampMapper.mapTimestamp(timesyncInformation, timestamp);
                long timestampToUse = ITimestampMapper.min(mappedTimestamp, lastTimestamp);
                @NonNull APCFrameAddressWithVmUIDAndTimestamp mappedEntry = new APCFrameAddressWithVmUIDAndTimestamp(entry.address, vmUID, timestampToUse);
                result.add(mappedEntry);
                lastTimestamps.put(deviceNumber, timestampToUse);
            }
        }
        this.timestamps.clear();
        result.sort(Comparator.naturalOrder());
        return Collections.unmodifiableList(result);
    }

    @Override
    public void frameExternal(@NonNull APCFrameAddress address, @NonNull ExternalProtocolMessageProperties message) {
        @NonNull List resultList = this.externalMessages.computeIfAbsent(message.channel, c -> new ArrayList());
        if (message.length > 0) {
            resultList.add(address.subMessage(message.offsetInFrame, message.length));
        }
    }

    @Override
    public void frameTimestamp(@NonNull APCFrameAddress address, long vmUID, @NonNull Timestamp timestamp) {
        this.frameTimestamp(address, vmUID, timestamp, false, 0);
    }

    @Override
    public void perfFrameTimestamp(@NonNull APCFrameAddress address, long vmUID, @NonNull Timestamp timestamp, int deviceNumber) {
        this.frameTimestamp(address, vmUID, timestamp, true, deviceNumber);
    }

    @Override
    public void removeDeferredFrame(long vmUID, @NonNull APCFrameAddress address) {
        @Nullable List<@NonNull AddressIndexEntry> list = this.timestamps.get(vmUID);
        if (list == null) {
            return;
        }
        list.removeIf(entry -> entry.address.equals(address));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void frameTimestamp(@NonNull APCFrameAddress address, long vmUID, @NonNull Timestamp timestamp, boolean perfFrame, int perfDeviceNumber) {
        int perfDeviceNumberToUse = this.perfFramesMayContainManyCores ? 0 : perfDeviceNumber;
        @NonNull @NonNull List list = this.timestamps.computeIfAbsent(vmUID, k -> new ArrayList());
        int size = list.size();
        if (size > 0) {
            @NonNull AddressIndexEntry last = (AddressIndexEntry)list.get(size - 1);
            if (last.address.equals(address)) {
                if (perfFrame != last.perfFrame || perfDeviceNumberToUse != last.perfDeviceNumber) {
                    throw new AssertionError();
                }
                @NonNull Timestamp lowestTimestamp = (Timestamp)NullChecking.neverNull((Object)Timestamp.min(last.timestamp, timestamp));
                if (!lowestTimestamp.equals(last.timestamp)) {
                    list.set(size - 1, new AddressIndexEntry(last.address, lowestTimestamp, perfFrame, perfDeviceNumberToUse));
                }
                return;
            }
        }
        list.add(new AddressIndexEntry(address, timestamp, perfFrame, perfDeviceNumberToUse));
    }

    private static final class AddressIndexEntry
    implements Comparable<AddressIndexEntry> {
        public final @NonNull APCFrameAddress address;
        public final int perfDeviceNumber;
        public final boolean perfFrame;
        public final @NonNull Timestamp timestamp;

        public AddressIndexEntry(@NonNull APCFrameAddress address, @NonNull Timestamp timestamp, boolean perfFrame, int perfDeviceNumber) {
            this.address = address;
            this.timestamp = timestamp;
            this.perfFrame = perfFrame;
            this.perfDeviceNumber = perfDeviceNumber;
        }

        @Override
        public int compareTo(AddressIndexEntry o) {
            int timestampResult = this.timestamp.compareTo(o.timestamp);
            if (timestampResult != 0) {
                return timestampResult;
            }
            return this.address.compareTo(o.address);
        }

        public String toString() {
            return String.format("%s: %s%s", this.timestamp, this.address, this.perfFrame ? " (perf)" : "");
        }
    }
}

