/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processing.idle;

import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.utility.ClusterNameUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AnalysisCounterIdleStateModificationDetector {
    private static final @NonNull String @NonNull [] LINUX_COUNTERS = new String[]{"_softirq", "_irq", "_switch", "_freq", "_system", "_user"};

    public static boolean isCpuPmuCounter(@NonNull CounterRecord counterRecord) {
        @NonNull DeviceType deviceType = counterRecord.getDeviceTypeOrDefault();
        if (!deviceType.isCPU()) {
            return false;
        }
        @Nullable String counterName = counterRecord.getCounter();
        if (counterName == null) {
            return false;
        }
        return AnalysisCounterIdleStateModificationDetector.isCpuPmuCounter(counterName);
    }

    public static boolean isCpuPmuCounter(@NonNull String counterName) {
        if (AnalysisCounterIdleStateModificationDetector.isLinuxCounter(counterName)) {
            return false;
        }
        return ClusterNameUtils.getArchName((String)counterName) != null;
    }

    public static boolean isLinuxCounter(@NonNull String counterName) {
        String[] stringArray = LINUX_COUNTERS;
        int n = LINUX_COUNTERS.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            if (counterName.endsWith(suffix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

