/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.CounterMode;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.utility.Ternary;
import gnu.trove.list.array.TIntArrayList;
import java.util.Collections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AtraceCounterSeriesKey
implements ICounterSeriesKey {
    private final @NonNull String name;

    public static @NonNull CounterRecord makeCounterRecord(@NonNull String name) {
        @NonNull CounterRecord result = new CounterRecord("atrace_dynamic_counter_" + name.replaceAll("[^0-9a-zA-Z]+", "_"), "atrace", name, name, null, null, 0, CounterClass.ABSOLUTE, CounterDisplay.MAXIMUM, false, CounterMode.SYSTEM_WIDE, 1.0, SeriesComposition.STACKED, GraphRenderingType.FILLED, false, false, Collections.emptyList(), new TIntArrayList(), 0, true, true, Ternary.TRUE, null);
        result.setDeviceType(DeviceType.SYSTEM_WIDE);
        return result;
    }

    public AtraceCounterSeriesKey(@NonNull String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AtraceCounterSeriesKey) {
            AtraceCounterSeriesKey that = (AtraceCounterSeriesKey)obj;
            return this.name.equals(that.name);
        }
        return false;
    }

    @Override
    public @Nullable String getArbitraryBacktraceSourceName() {
        return null;
    }

    @Override
    public @Nullable String getBacktraceSourceNameIfEbsCounter() {
        return null;
    }

    public @NonNull CounterRecord getCounterRecord() {
        return AtraceCounterSeriesKey.makeCounterRecord(this.name);
    }

    @Override
    public @NonNull DeviceType getDeviceTypeOrDefault() {
        return DeviceType.SYSTEM_WIDE;
    }

    @Override
    public @Nullable Integer getKeyIfHas() {
        return null;
    }

    @Override
    public @Nullable String getTracepointArg() {
        return null;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean isCpuPmuCounter() {
        return false;
    }

    @Override
    public boolean isDeltaCounter() {
        return false;
    }

    @Override
    public boolean isSourceFilterable() {
        return true;
    }

    @Override
    public boolean isStaticCounter() {
        return false;
    }

    @Override
    public boolean isThreadCounter() {
        return true;
    }

    public String toString() {
        return String.format("AtraceCounterSeriesKey [name=%s]", this.name);
    }
}

