/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.stream.parser;

import com.arm.streamline.analysis.dbnative.decoder.PackedValueUnpacker;
import com.arm.streamline.analysis.dbnative.stream.parser.IPrintable;
import com.arm.streamline.analysis.dbnative.stream.parser.IStreamParser;
import com.arm.streamline.analysis.dbnative.types.IndexTimestampSeqno;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class IdleStreamParser
implements IStreamParser<StreamValue> {
    @Override
    public StreamValue parseDataPayload(@NonNull IndexTimestampSeqno index, @NonNull PackedValueUnpacker unpacker) {
        int deviceNo = unpacker.unpackOneInt();
        boolean isOnline = unpacker.takeOneBoolean();
        return new StreamValue(index, deviceNo, isOnline);
    }

    public static final class StreamValue
    implements IPrintable {
        public final @NonNull IndexTimestampSeqno index;
        public final int deviceNo;
        public final boolean isOnline;

        public StreamValue(@NonNull IndexTimestampSeqno index, int deviceNo, boolean isOnline) {
            this.index = index;
            this.deviceNo = deviceNo;
            this.isOnline = isOnline;
        }

        @Override
        public void printToStream(@NonNull Appendable a) throws IOException {
            a.append("        " + String.valueOf(this.index) + " :: " + String.format("%1$2s", this.deviceNo) + (this.isOnline ? " :: online :: " : " :: offline :: "));
            a.append(System.lineSeparator());
        }
    }
}

