/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.stream.parser;

import com.arm.streamline.analysis.dbnative.decoder.PackedValueUnpacker;
import com.arm.streamline.analysis.dbnative.stream.parser.DbConstants;
import com.arm.streamline.analysis.dbnative.stream.parser.IPrintable;
import com.arm.streamline.analysis.dbnative.stream.parser.IStreamParser;
import com.arm.streamline.analysis.dbnative.types.IndexTimestampSeqno;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CounterStreamParser
implements IStreamParser<StreamValue> {
    @Override
    public StreamValue parseDataPayload(@NonNull IndexTimestampSeqno index, @NonNull PackedValueUnpacker unpacker) {
        int deviceNo = unpacker.unpackOneInt();
        long utid = unpacker.unpackOneLong();
        long duration = unpacker.unpackOneLong();
        long value = unpacker.unpackOneLong();
        return new StreamValue(index, deviceNo, utid, duration, value);
    }

    public static final class StreamValue
    implements IPrintable {
        public final @NonNull IndexTimestampSeqno index;
        public final int deviceNo;
        public final @Nullable Integer utid;
        public final long duration;
        public final long value;

        public StreamValue(@NonNull IndexTimestampSeqno index, int deviceNo, long utid, long duration, long value) {
            this.index = index;
            this.deviceNo = deviceNo;
            this.utid = DbConstants.toUtid(utid);
            this.duration = duration;
            this.value = value;
        }

        @Override
        public void printToStream(@NonNull Appendable a) throws IOException {
            a.append(" " + String.valueOf(this.index) + " :: " + String.format("%1$2s", this.deviceNo) + " :: " + String.format("%1$4s", this.utid) + " :: " + String.format("%1$9s", this.duration) + " :: " + this.value);
            a.append(System.lineSeparator());
        }
    }
}

