/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.factory;

import com.arm.streamline.analysis.database.ApplicationsReader;
import com.arm.streamline.analysis.database.CoresReaderWriter;
import com.arm.streamline.analysis.database.DBPropertiesReaderWriter;
import com.arm.streamline.analysis.database.EventsChart;
import com.arm.streamline.analysis.database.KernelSymbolsReaderWriter;
import com.arm.streamline.analysis.database.ProcessingElementReferenceSetReaderWriter;
import com.arm.streamline.analysis.database.VirtualMachinePropertiesReaderWriter;
import com.arm.streamline.analysis.database.api.IAnalysisReaderFactoryV2;
import com.arm.streamline.analysis.database.api.activity.IAnalysisActivityReader;
import com.arm.streamline.analysis.database.api.annotations.IAnalysisAnnotationsReader;
import com.arm.streamline.analysis.database.api.cam.IAnalysisCAMReader;
import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterReader;
import com.arm.streamline.analysis.database.api.counters.IAnalysisSpeMultiCounterReader;
import com.arm.streamline.analysis.database.stream.factory.CAMTrack;
import com.arm.streamline.analysis.database.stream.factory.CAMView;
import com.arm.streamline.analysis.database.v3.DatabaseActivityReader;
import com.arm.streamline.analysis.database.v3.DatabaseAnnotationEventReader;
import com.arm.streamline.analysis.database.v3.DatabaseCamStreamL0Entries;
import com.arm.streamline.analysis.database.v3.DatabaseCamStreamReader;
import com.arm.streamline.analysis.database.v3.DatabaseCounterReader;
import com.arm.streamline.analysis.database.v3.DatabaseSpeCounterReader;
import com.arm.streamline.analysis.database.v3.SchedulerTraceActivityStream;
import com.arm.streamline.analysis.database.v3.SchedulerTraceActivityStreamReader;
import com.arm.streamline.analysis.database.v3.metadata.CountersXmlReader;
import com.arm.streamline.analysis.database.v3.metadata.DevicesXmlReader;
import com.arm.streamline.analysis.database.v3.metadata.ExecutablePathsXmlReader;
import com.arm.streamline.analysis.database.v3.metadata.IDbCountersMap;
import com.arm.streamline.analysis.database.v3.metadata.IExecutablePathsMap;
import com.arm.streamline.analysis.dbnative.index.L1IndexIterator;
import com.arm.streamline.analysis.dbnative.io.IFileDataView;
import com.arm.streamline.analysis.dbnative.io.MMappedFileDataView;
import com.arm.streamline.analysis.dbnative.metadata.IMetadata;
import com.arm.streamline.analysis.dbnative.metadata.Metadata;
import com.arm.streamline.analysis.dbnative.root.DBRootTypeKey;
import com.arm.streamline.analysis.dbnative.stream.StreamValueIterator;
import com.arm.streamline.analysis.dbnative.stream.parser.CamStreamParser;
import com.arm.streamline.analysis.dbnative.stream.parser.SchedulerStreamParser;
import com.arm.streamline.analysis.dbnative.stream.parser.SpeStreamParser;
import com.arm.streamline.analysis.dbnative.types.IndexId;
import com.arm.streamline.analysis.dbnative.types.L0IndexEntry;
import com.arm.streamline.analysis.model.CounterMap;
import com.arm.streamline.analysis.model.DBProperties;
import com.arm.streamline.analysis.model.DeviceTypeCalculator;
import com.arm.streamline.analysis.model.KernelSymbol;
import com.arm.streamline.analysis.model.VirtualMachineProperties;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.xml.counters.BadXmlException;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.report.model.topology.ICores;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.LongIntBiFunction;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AnalysisDatabaseReaderFactoryV3
implements IAnalysisReaderFactoryV2 {
    public static final @NonNull String APPLICATIONS_FILE = "applications.xml";
    public static final @NonNull String COUNTERS_FILE = "counters.xml";
    public static final @NonNull String DEVICES_FILE = "devices.xml";
    public static final @NonNull String EXECUTABLE_PATHS_FILE = "executable_paths.xml";
    public static final @NonNull String KALLSYMS_FILE = "kernel-symbols.xml";
    public static final @NonNull String STATE_FILE = "state.xml";
    public static final @NonNull String VM_STATE_FILE = "virtual-machines.xml";
    private static final int PALE_GREEN = -2143625405;
    private static final int PINK = -2132850878;
    private static final int @NonNull [] DEFAULT_EVENT_CHART_COLORS = new int[]{-2143625405, -2132850878};
    private static final boolean DEFAULT_EVENT_CHART_PER_CORE = true;
    private static final boolean DEFAULT_EVENT_CHART_SOURCE_FILTERABLE = true;
    private static final boolean DEFAULT_EVENT_CHART_PROC = true;
    private static final @NonNull String @NonNull [] DEFAULT_EVENT_CHART_SERIES_DESCRIPTIONS = new String[]{"User activity", "System activity"};
    private static final @NonNull String @NonNull [] DEFAULT_EVENT_CHART_SERIES_NAMES = new String[]{"User", "System"};
    private static final @NonNull String DEFAULT_EVENT_CHART_TITLE = "CPU Activity";
    private final @NonNull Map<@NonNull DBRootTypeKey, @NonNull Map<@NonNull CounterRecord, @NonNull TLongObjectMap<IndexId>>> allActivities;
    private final @NonNull Map<@NonNull DBRootTypeKey, @NonNull Map<@NonNull CounterRecord, @NonNull TLongObjectMap<IndexId>>> allCounters;
    private final @NonNull IUniqueIds applications;
    private final @NonNull IDbCountersMap counters;
    private final @NonNull File dataFile;
    private final @NonNull IFileDataView dataFileView;
    private final @NonNull File dbDirectory;
    private final @NonNull DBProperties dbProperties;
    private final @NonNull DevicesXmlReader devicesXml;
    private final @NonNull IExecutablePathsMap executablePaths;
    private final @NonNull File indexFile;
    private final @NonNull TLongObjectMap<List<@NonNull KernelSymbol>> kernelSymbols;
    private final @NonNull IMetadata metadata;
    private final @NonNull ProcessingElementReferenceSet processingElementsReferenceSet = new ProcessingElementReferenceSet();
    private final @NonNull TLongObjectMap<VirtualMachineProperties> vmStateMap;

    public static @Nullable CAMView composeCamView(long vmuid, int overrideId, @NonNull StreamValueIterator<CamStreamParser.IStreamValue> definitionsStream) throws IOException {
        CamDefinitionsVisitor visitor = new CamDefinitionsVisitor();
        while (definitionsStream.hasNext()) {
            CamStreamParser.IStreamValue val = definitionsStream.next();
            val.accept(visitor);
        }
        Integer viewUID = visitor.viewUID;
        if (viewUID == null || visitor.tracks.isEmpty()) {
            return null;
        }
        return new CAMView(vmuid, overrideId, (String)NullChecking.neverNullOr((Object)visitor.name, (Object)""), visitor.tracks, visitor.utid);
    }

    public static @NonNull IAnalysisAnnotationsReader createAnnotationsReader(@NonNull IMetadata metadata, @NonNull IFileDataView dataFileView) throws IOException {
        @NonNull Map<@NonNull Long, @NonNull List<@NonNull L0IndexEntry>> vmuidsToL0 = AnalysisDatabaseReaderFactoryV3.findL0EntriesForRootKey(metadata, DBRootTypeKey.annotation);
        return new DatabaseAnnotationEventReader(vmuidsToL0, dataFileView);
    }

    public static @NonNull IAnalysisReaderFactoryV2.IAnalysisReaderActivityStream createSchedulerTraceReaderStream(@NonNull IMetadata metadata, @NonNull IFileDataView dataFile, @NonNull ProcessingElementReferenceSet processingElements, @NonNull IUniqueIds applications) throws IOException {
        List peList = processingElements.getList(DeviceType.CPU).stream().sorted().collect(Collectors.toList());
        @NonNull ProcessingElementReference @NonNull [] peArray = (ProcessingElementReference[])peList.toArray(ProcessingElementReference[]::new);
        EventsChart chart = AnalysisDatabaseReaderFactoryV3.createSchedulerEventsChart(peArray);
        TLongObjectHashMap streamsByVmuid = new TLongObjectHashMap();
        streamsByVmuid.putAll(AnalysisDatabaseReaderFactoryV3.findStreamsForRootKey(metadata, DBRootTypeKey.scheduler));
        List<SchedulerTraceActivityStreamReader.VmStream> vmStreams = AnalysisDatabaseReaderFactoryV3.mapStreamChannels((TLongObjectMap<IndexId>)streamsByVmuid, peArray, (vm, channelBase, deviceNoCount, index) -> {
            List<L0IndexEntry> l0Entries = metadata.getL0Index(index);
            L1IndexIterator l1Iterator = L1IndexIterator.createFromL0Index(dataFile, l0Entries);
            StreamValueIterator<SchedulerStreamParser.StreamValue> streamValueIter = new StreamValueIterator<SchedulerStreamParser.StreamValue>(dataFile, l1Iterator, new SchedulerStreamParser());
            return new SchedulerTraceActivityStreamReader.VmStream(vm, channelBase, deviceNoCount, applications, streamValueIter);
        });
        return new SchedulerTraceActivityStream(chart, vmStreams);
    }

    public static @NonNull Set<? extends @NonNull IAnalysisReaderFactoryV2.IAnalysisCAMDataStream> enumerateAllCamStreams(@NonNull IMetadata metadata, final @NonNull IFileDataView dataView) throws IOException {
        List<DatabaseCamStreamL0Entries> l0Entries = AnalysisDatabaseReaderFactoryV3.findL0EntriesForCamData(metadata);
        @NonNull HashSet<@NonNull 1> camStreams = new HashSet<1>();
        for (final DatabaseCamStreamL0Entries streamPair : l0Entries) {
            L1IndexIterator l1OfDefinitions = L1IndexIterator.createFromL0Index(dataView, streamPair.getDefinitionL0Entries());
            StreamValueIterator<CamStreamParser.IStreamValue> definitionsStream = new StreamValueIterator<CamStreamParser.IStreamValue>(dataView, l1OfDefinitions, new CamStreamParser());
            int overrideId = Math.toIntExact(streamPair.getInstanceId());
            final CAMView camView = AnalysisDatabaseReaderFactoryV3.composeCamView(streamPair.getVmuid(), overrideId, definitionsStream);
            if (camView == null) continue;
            final Integer utid = camView.originUtid;
            camStreams.add(new IAnalysisReaderFactoryV2.IAnalysisCAMDataStream(){

                @Override
                public @NonNull IAnalysisCAMReader createReader() throws IOException {
                    L1IndexIterator l1OfJobs = L1IndexIterator.createFromL0Index(dataView, streamPair.getJobL0Entries());
                    StreamValueIterator<CamStreamParser.IStreamValue> jobsStream = new StreamValueIterator<CamStreamParser.IStreamValue>(dataView, l1OfJobs, new CamStreamParser());
                    return new DatabaseCamStreamReader(streamPair.getVmuid(), camView.viewUID, utid, jobsStream);
                }

                @Override
                public @NonNull CAMView getCAMView() {
                    return camView;
                }
            });
        }
        return camStreams;
    }

    public static <T, E extends Throwable> @NonNull List<T> mapStreamChannels(@NonNull TLongObjectMap<IndexId> vmToStream, @NonNull ProcessingElementReference @NonNull [] channels, @NonNull IStreamChannelMapper<T, E> mapper) throws E {
        if (vmToStream.isEmpty()) {
            return Collections.emptyList();
        }
        if (channels.length == 0) {
            throw new AssertionError((Object)"Invalid channel vs streams map");
        }
        TLongIntHashMap vmToCount = new TLongIntHashMap(10, 0.5f, 0L, 0);
        TLongIntHashMap vmToBase = new TLongIntHashMap(10, 0.5f, 0L, -1);
        ProcessingElementReference lastPe = null;
        int i = 0;
        while (i < channels.length) {
            ProcessingElementReference channel = channels[i];
            if (lastPe != null && lastPe.compareTo(channel) >= 0) {
                throw new AssertionError((Object)"Expected ordered channels");
            }
            vmToBase.putIfAbsent(channel.vmUID, i);
            int count = vmToCount.adjustOrPutValue(channel.vmUID, 1, 1);
            if (count != channel.deviceNumber + 1) {
                throw new AssertionError((Object)"Cannot support sparse channel list");
            }
            lastPe = channel;
            ++i;
        }
        ArrayList<T> result = new ArrayList<T>(vmToStream.size());
        TLongObjectIterator it = vmToStream.iterator();
        while (it.hasNext()) {
            it.advance();
            long vm = it.key();
            IndexId index = (IndexId)it.value();
            assert (index != null);
            int base = vmToBase.get(vm);
            int count = vmToCount.get(vm);
            if (base < 0 || count < 1) {
                throw new AssertionError((Object)"Invalid channel vs streams map");
            }
            result.add(mapper.apply(vm, base, count, index));
        }
        return result;
    }

    public static @NonNull Map<@NonNull DBRootTypeKey, @NonNull Map<@NonNull CounterRecord, @NonNull TLongObjectMap<IndexId>>> resolveAllActivityStreams(@NonNull IMetadata metadata, @NonNull IDbCountersMap counters) throws IOException {
        HashMap<DBRootTypeKey, Map<CounterRecord, TLongObjectMap<IndexId>>> allActivities = new HashMap<DBRootTypeKey, Map<CounterRecord, TLongObjectMap<IndexId>>>();
        Map<CounterRecord, TLongObjectMap<IndexId>> userspaceSeries = AnalysisDatabaseReaderFactoryV3.findActivityOrCounterStreams(metadata, DBRootTypeKey.activity_annotation_series_key, (LongIntBiFunction<CounterRecord>)((LongIntBiFunction)counters::mapUserspaceAnnotationCounterSeriesKey));
        Map<CounterRecord, TLongObjectMap<IndexId>> atraceSeries = AnalysisDatabaseReaderFactoryV3.findActivityOrCounterStreams(metadata, DBRootTypeKey.activity_atrace_series_key, (LongIntBiFunction<CounterRecord>)((LongIntBiFunction)counters::mapAtraceCounterSeriesKey));
        Map<CounterRecord, TLongObjectMap<IndexId>> staticSeries = AnalysisDatabaseReaderFactoryV3.findActivityOrCounterStreams(metadata, DBRootTypeKey.activity_gator_key, (LongIntBiFunction<CounterRecord>)((LongIntBiFunction)counters::mapStaticCounterSeriesKey));
        Map<CounterRecord, TLongObjectMap<IndexId>> kernelSeries = AnalysisDatabaseReaderFactoryV3.findActivityOrCounterStreams(metadata, DBRootTypeKey.activity_kernel_annotation_series_key, (LongIntBiFunction<CounterRecord>)((LongIntBiFunction)counters::mapKernelAnnotationCounterSeriesKey));
        if (!userspaceSeries.isEmpty()) {
            allActivities.put(DBRootTypeKey.activity_annotation_series_key, userspaceSeries);
        }
        if (!atraceSeries.isEmpty()) {
            allActivities.put(DBRootTypeKey.activity_atrace_series_key, atraceSeries);
        }
        if (!staticSeries.isEmpty()) {
            allActivities.put(DBRootTypeKey.activity_gator_key, staticSeries);
        }
        if (!kernelSeries.isEmpty()) {
            allActivities.put(DBRootTypeKey.activity_kernel_annotation_series_key, kernelSeries);
        }
        return allActivities;
    }

    public static @NonNull Map<@NonNull DBRootTypeKey, @NonNull Map<@NonNull CounterRecord, @NonNull TLongObjectMap<IndexId>>> resolveAllCounterStreams(@NonNull IMetadata metadata, @NonNull IDbCountersMap counters) throws IOException {
        HashMap<DBRootTypeKey, Map<CounterRecord, TLongObjectMap<IndexId>>> allCounters = new HashMap<DBRootTypeKey, Map<CounterRecord, TLongObjectMap<IndexId>>>();
        Map<CounterRecord, TLongObjectMap<IndexId>> userspaceSeries = AnalysisDatabaseReaderFactoryV3.findActivityOrCounterStreams(metadata, DBRootTypeKey.counter_annotation_series_key, (LongIntBiFunction<CounterRecord>)((LongIntBiFunction)counters::mapUserspaceAnnotationCounterSeriesKey));
        Map<CounterRecord, TLongObjectMap<IndexId>> atraceSeries = AnalysisDatabaseReaderFactoryV3.findActivityOrCounterStreams(metadata, DBRootTypeKey.counter_atrace_series_key, (LongIntBiFunction<CounterRecord>)((LongIntBiFunction)counters::mapAtraceCounterSeriesKey));
        Map<CounterRecord, TLongObjectMap<IndexId>> staticSeries = AnalysisDatabaseReaderFactoryV3.findActivityOrCounterStreams(metadata, DBRootTypeKey.counter_gator_key, (LongIntBiFunction<CounterRecord>)((LongIntBiFunction)counters::mapStaticCounterSeriesKey));
        Map<CounterRecord, TLongObjectMap<IndexId>> kernelSeries = AnalysisDatabaseReaderFactoryV3.findActivityOrCounterStreams(metadata, DBRootTypeKey.counter_kernel_annotation_series_key, (LongIntBiFunction<CounterRecord>)((LongIntBiFunction)counters::mapKernelAnnotationCounterSeriesKey));
        if (!userspaceSeries.isEmpty()) {
            allCounters.put(DBRootTypeKey.counter_annotation_series_key, userspaceSeries);
        }
        if (!atraceSeries.isEmpty()) {
            allCounters.put(DBRootTypeKey.counter_atrace_series_key, atraceSeries);
        }
        if (!staticSeries.isEmpty()) {
            allCounters.put(DBRootTypeKey.counter_gator_key, staticSeries);
        }
        if (!kernelSeries.isEmpty()) {
            allCounters.put(DBRootTypeKey.counter_kernel_annotation_series_key, kernelSeries);
        }
        return allCounters;
    }

    private static @NonNull EventsChart createSchedulerEventsChart(@NonNull ProcessingElementReference @NonNull [] peArray) {
        return new EventsChart(peArray.length, true, true, DEFAULT_EVENT_CHART_TITLE, DeviceType.CPU, peArray, DEFAULT_EVENT_CHART_SERIES_NAMES, DEFAULT_EVENT_CHART_SERIES_DESCRIPTIONS, DEFAULT_EVENT_CHART_COLORS, true);
    }

    private static @Nullable DatabaseSpeCounterReader createSpeCounterReader(@NonNull TLongObjectHashMap<TIntObjectHashMap<SpeTargetDescription>> speDescriptorMap, @NonNull IClustersInfo clustersInfo, @NonNull ProcessingElementReferenceSet processingElementsReferenceSet, @NonNull IExecutablePathsMap executablePaths, @NonNull IMetadata metadata, @NonNull IFileDataView dataFileView) throws IOException {
        Map<Long, List<L0IndexEntry>> vmuidsToL0 = AnalysisDatabaseReaderFactoryV3.findL0EntriesForRootKey(metadata, DBRootTypeKey.spe);
        if (vmuidsToL0.isEmpty()) {
            return null;
        }
        DatabaseSpeCounterReader.DescriptorTransformer transformer = new DatabaseSpeCounterReader.DescriptorTransformer(speDescriptorMap, clustersInfo, processingElementsReferenceSet);
        ArrayList<DatabaseSpeCounterReader.VmStream> vmStreams = new ArrayList<DatabaseSpeCounterReader.VmStream>();
        for (Map.Entry<Long, List<L0IndexEntry>> entry : vmuidsToL0.entrySet()) {
            long vm = entry.getKey();
            List<L0IndexEntry> l0Index = entry.getValue();
            IThrowingFunction<SpeStreamParser.StreamValue, DatabaseSpeCounterReader.Value, IOException> mapper = transformer.createTransformer(vm);
            if (mapper == null) continue;
            vmStreams.add(new DatabaseSpeCounterReader.VmStream(mapper, executablePaths, vm, l0Index, dataFileView));
        }
        return new DatabaseSpeCounterReader(transformer.getCounterRecords(), vmStreams);
    }

    private static @NonNull Map<@NonNull CounterRecord, @NonNull TLongObjectMap<IndexId>> findActivityOrCounterStreams(@NonNull IMetadata metadata, @NonNull DBRootTypeKey type, @NonNull LongIntBiFunction<@Nullable CounterRecord> keyMapper) throws IOException {
        assert (type == DBRootTypeKey.activity_annotation_series_key || type == DBRootTypeKey.activity_atrace_series_key || type == DBRootTypeKey.activity_gator_key || type == DBRootTypeKey.activity_kernel_annotation_series_key || type == DBRootTypeKey.counter_annotation_series_key || type == DBRootTypeKey.counter_atrace_series_key || type == DBRootTypeKey.counter_gator_key || type == DBRootTypeKey.counter_kernel_annotation_series_key);
        HashMap<CounterRecord, TLongObjectMap<IndexId>> result = new HashMap<CounterRecord, TLongObjectMap<IndexId>>(0);
        IndexId idOfTypeDirectory = metadata.getIndexIdOfDirectory(IndexId.ROOT, type.toLong());
        if (idOfTypeDirectory == null) {
            return result;
        }
        Map<Long, IndexId> keyDirectory = metadata.getDirectoryFrom(idOfTypeDirectory);
        assert (keyDirectory != null);
        for (Map.Entry<Long, IndexId> entry : keyDirectory.entrySet()) {
            int key = Math.toIntExact(entry.getKey());
            Map<Long, IndexId> vmDirectory = metadata.getStreamIndicesFromDirectory(entry.getValue());
            if (vmDirectory == null) continue;
            for (Map.Entry<Long, IndexId> childEntry : vmDirectory.entrySet()) {
                long vm = childEntry.getKey();
                CounterRecord counterRecord = (CounterRecord)keyMapper.apply(vm, key);
                if (counterRecord == null) {
                    throw new IOException("Invalid db, missing counter key");
                }
                TLongObjectMap vmToStream = result.computeIfAbsent(counterRecord, r -> new TLongObjectHashMap(keyDirectory.size(), 0.5f, 0L));
                vmToStream.put(vm, (Object)childEntry.getValue());
            }
        }
        return result;
    }

    private static @NonNull List<@NonNull DatabaseCamStreamL0Entries> findL0EntriesForCamData(@NonNull IMetadata metadata) {
        IndexId indexIdOfCamDirectory = metadata.getIndexIdOfDirectory(IndexId.ROOT, DBRootTypeKey.cam.toLong());
        if (indexIdOfCamDirectory == null) {
            return Collections.emptyList();
        }
        Map rootCamDirectory = (Map)NullChecking.neverNull(metadata.getDirectoryFrom(indexIdOfCamDirectory));
        ArrayList<DatabaseCamStreamL0Entries> result = new ArrayList<DatabaseCamStreamL0Entries>();
        for (Map.Entry vmToInstanceId : rootCamDirectory.entrySet()) {
            long vmUID = (Long)vmToInstanceId.getKey();
            IndexId instanceIndexId = (IndexId)vmToInstanceId.getValue();
            Map<Long, IndexId> instanceDirectory = metadata.getDirectoryFrom(instanceIndexId);
            if (instanceDirectory == null) continue;
            for (Map.Entry<Long, IndexId> instanceToKindId : instanceDirectory.entrySet()) {
                long instanceId = instanceToKindId.getKey();
                IndexId kindsIndexId = instanceToKindId.getValue();
                Map<Long, IndexId> kindsDirectory = metadata.getStreamIndicesFromDirectory(kindsIndexId);
                if (kindsDirectory == null) continue;
                IndexId definitionsIndexId = kindsDirectory.get(0L);
                IndexId jobsIndexId = kindsDirectory.get(1L);
                if (definitionsIndexId == null || jobsIndexId == null) continue;
                List<L0IndexEntry> l0ForDefinitionsStream = metadata.getL0Index(definitionsIndexId);
                List<L0IndexEntry> l0ForJobsStream = metadata.getL0Index(jobsIndexId);
                result.add(new DatabaseCamStreamL0Entries(vmUID, instanceId, l0ForDefinitionsStream, l0ForJobsStream));
            }
        }
        return result;
    }

    private static @NonNull Map<@NonNull Long, @NonNull List<@NonNull L0IndexEntry>> findL0EntriesForRootKey(IMetadata metadata, @NonNull DBRootTypeKey rootKey) {
        @NonNull Map<@NonNull Long, @NonNull IndexId> streamsByKey = AnalysisDatabaseReaderFactoryV3.findStreamsForRootKey(metadata, rootKey);
        HashMap<@NonNull Long, @NonNull List<@NonNull L0IndexEntry>> vmuidsToL0 = new HashMap<Long, List<L0IndexEntry>>();
        for (Map.Entry<Long, IndexId> streamEntry : streamsByKey.entrySet()) {
            List<@NonNull L0IndexEntry> list = metadata.getL0Index(streamEntry.getValue());
            vmuidsToL0.put(streamEntry.getKey(), list);
        }
        return vmuidsToL0;
    }

    private static @NonNull Map<@NonNull Long, @NonNull IndexId> findStreamsForRootKey(IMetadata metadata, @NonNull DBRootTypeKey rootKey) {
        IndexId indexIdOfRequestedDirectory = metadata.getIndexIdOfDirectory(IndexId.ROOT, rootKey.toLong());
        if (indexIdOfRequestedDirectory == null) {
            return new HashMap<Long, IndexId>();
        }
        Map<@NonNull Long, @NonNull IndexId> streamsByKey = metadata.getStreamIndicesFromDirectory(indexIdOfRequestedDirectory);
        if (streamsByKey == null) {
            throw new IllegalStateException("expected some streams for " + String.valueOf((Object)rootKey) + " root directory " + String.valueOf(indexIdOfRequestedDirectory));
        }
        return streamsByKey;
    }

    AnalysisDatabaseReaderFactoryV3(@NonNull File dbDirectory, @NonNull DeviceTypeCalculator deviceTypeCalculator) throws IOException, BadXmlException {
        this.dbDirectory = dbDirectory;
        this.indexFile = new File(dbDirectory, "index.db");
        this.dataFile = new File(dbDirectory, "data.db");
        this.metadata = Metadata.readFrom(this.indexFile);
        this.applications = ApplicationsReader.read(new File(dbDirectory, APPLICATIONS_FILE));
        this.counters = new CountersXmlReader(new File(dbDirectory, COUNTERS_FILE), this.processingElementsReferenceSet, deviceTypeCalculator);
        this.dbProperties = DBPropertiesReaderWriter.create(new File(dbDirectory, STATE_FILE));
        this.devicesXml = new DevicesXmlReader(new File(dbDirectory, DEVICES_FILE), this.processingElementsReferenceSet);
        this.executablePaths = new ExecutablePathsXmlReader(new File(dbDirectory, EXECUTABLE_PATHS_FILE));
        this.kernelSymbols = KernelSymbolsReaderWriter.read(new File(dbDirectory, KALLSYMS_FILE));
        this.vmStateMap = VirtualMachinePropertiesReaderWriter.read(new File(dbDirectory, VM_STATE_FILE));
        this.dataFileView = new MMappedFileDataView(this.dataFile);
        this.allActivities = AnalysisDatabaseReaderFactoryV3.resolveAllActivityStreams(this.metadata, this.counters);
        this.allCounters = AnalysisDatabaseReaderFactoryV3.resolveAllCounterStreams(this.metadata, this.counters);
    }

    @Override
    public void close() throws IOException {
        this.dataFileView.close();
    }

    @Override
    public @NonNull IAnalysisAnnotationsReader createAnnotationsReader() throws IOException {
        @NonNull Map<@NonNull Long, @NonNull List<@NonNull L0IndexEntry>> vmuidsToL0 = AnalysisDatabaseReaderFactoryV3.findL0EntriesForRootKey(this.metadata, DBRootTypeKey.annotation);
        return new DatabaseAnnotationEventReader(vmuidsToL0, this.dataFileView);
    }

    @Override
    public @NonNull Set<? extends @NonNull IAnalysisReaderFactoryV2.IAnalysisReaderActivityStream> enumerateActivityStreams() throws IOException {
        HashSet<IAnalysisReaderFactoryV2.IAnalysisReaderActivityStream> result = new HashSet<IAnalysisReaderFactoryV2.IAnalysisReaderActivityStream>();
        for (Map<CounterRecord, TLongObjectMap<IndexId>> map : this.allActivities.values()) {
            for (Map.Entry<CounterRecord, TLongObjectMap<IndexId>> entry : map.entrySet()) {
                result.add(this.makeActivityStream(entry.getKey(), entry.getValue()));
            }
        }
        result.add(this.getSchedulerTraceReaderStream());
        return result;
    }

    @Override
    public @NonNull Set<? extends @NonNull IAnalysisReaderFactoryV2.IAnalysisCAMDataStream> enumerateCAMDataStreams() throws IOException {
        return AnalysisDatabaseReaderFactoryV3.enumerateAllCamStreams(this.metadata, this.dataFileView);
    }

    @Override
    public @NonNull Set<? extends @NonNull IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream> enumerateCounterStreams() throws IOException {
        HashSet<IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream> result = new HashSet<IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream>();
        for (Map<CounterRecord, TLongObjectMap<IndexId>> map : this.allCounters.values()) {
            for (Map.Entry<CounterRecord, TLongObjectMap<IndexId>> entry : map.entrySet()) {
                result.add(this.makeCounterStream(entry.getKey(), entry.getValue()));
            }
        }
        return result;
    }

    @Override
    public @NonNull Stream<@NonNull IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream> enumerateThreadCounterChannelStreams() throws IOException {
        return Stream.empty();
    }

    @Override
    public @NonNull CounterMap getAllCounters() {
        return this.counters.getCounterMap();
    }

    @Override
    public @NonNull IUniqueIds getApplications() {
        return this.applications;
    }

    @Override
    public @NonNull IClustersInfo getClustersInfo() {
        return this.devicesXml.clustersInfo;
    }

    @Override
    public @NonNull ICores getCores() {
        return this.devicesXml.coresFile;
    }

    @Override
    public @NonNull DBProperties getDbProperties() {
        return this.dbProperties;
    }

    @Override
    public @NonNull TLongObjectMap<List<@NonNull KernelSymbol>> getKernelSymbols() {
        return this.kernelSymbols;
    }

    @Override
    public @NonNull ProcessingElementReferenceSet getProcessingElementsReferenceSet() {
        return this.processingElementsReferenceSet;
    }

    @Override
    public @NonNull IAnalysisReaderFactoryV2.IAnalysisReaderActivityStream getSchedulerTraceReaderStream() throws IOException {
        return AnalysisDatabaseReaderFactoryV3.createSchedulerTraceReaderStream(this.metadata, this.dataFileView, this.processingElementsReferenceSet, this.applications);
    }

    @Override
    public @Nullable IAnalysisSpeMultiCounterReader getSpeCounterReader() throws IOException {
        return AnalysisDatabaseReaderFactoryV3.createSpeCounterReader(this.counters.getSpeDescriptionMap(), (IClustersInfo)this.devicesXml.clustersInfo, this.processingElementsReferenceSet, this.executablePaths, this.metadata, this.dataFileView);
    }

    @Override
    public @NonNull TLongObjectMap<VirtualMachineProperties> getVmStateMap() {
        return this.vmStateMap;
    }

    @Override
    public void writeApplicationsToReport(@NonNull File outputFile) throws IOException, InterruptedException {
        CommonFileUtils.copyFile((File)new File(this.dbDirectory, APPLICATIONS_FILE), (File)new File(outputFile, APPLICATIONS_FILE));
    }

    @Override
    public void writeCoresToReport(@NonNull File outputFile) throws IOException, InterruptedException {
        CoresReaderWriter.write(new File(outputFile, "cores.xml"), this.devicesXml.coresFile, (IClustersInfo)this.devicesXml.clustersInfo);
    }

    @Override
    public void writePeReferencesToReport(@NonNull File outputFile) throws IOException, InterruptedException {
        ProcessingElementReferenceSetReaderWriter.write(new File(outputFile, "pe-references.xml"), this.processingElementsReferenceSet);
    }

    @Override
    public void writeVmsToReport(@NonNull File outputFile) throws IOException, InterruptedException {
        CommonFileUtils.copyFile((File)new File(this.dbDirectory, VM_STATE_FILE), (File)new File(outputFile, VM_STATE_FILE));
    }

    private @NonNull IAnalysisReaderFactoryV2.IAnalysisReaderActivityStream makeActivityStream(@NonNull CounterRecord counterRecord, @NonNull TLongObjectMap<IndexId> vmToStream) throws IOException {
        Object[] channels = counterRecord.getChannelDescriptions();
        assert (channels != null);
        EventsChart chart = new EventsChart(counterRecord);
        assert (Arrays.equals(channels, chart.getChannelDescriptors()));
        List<DatabaseActivityReader.VmStream> vmStreams = AnalysisDatabaseReaderFactoryV3.mapStreamChannels(vmToStream, (ProcessingElementReference[])channels, (vm, channelBase, deviceNoCount, index) -> {
            List<L0IndexEntry> l0Index = this.metadata.getL0Index(index);
            return new DatabaseActivityReader.VmStream(channelBase, deviceNoCount, l0Index, this.dataFileView);
        });
        return new IAnalysisReaderFactoryV2.IAnalysisReaderActivityStream((ProcessingElementReference[])channels, vmStreams, chart, counterRecord){
            private final /* synthetic */ ProcessingElementReference[] val$channels;
            private final /* synthetic */ List val$vmStreams;
            private final /* synthetic */ EventsChart val$chart;
            private final /* synthetic */ CounterRecord val$counterRecord;
            {
                this.val$channels = processingElementReferenceArray;
                this.val$vmStreams = list;
                this.val$chart = eventsChart;
                this.val$counterRecord = counterRecord;
            }

            @Override
            public @NonNull IAnalysisActivityReader<ProcessingElementReference> createReader() throws IOException {
                return new DatabaseActivityReader(this.val$channels, this.val$vmStreams);
            }

            @Override
            public @NonNull EventsChart getEventsChart() {
                return this.val$chart;
            }

            @Override
            public @NonNull String getStreamName() {
                return this.val$counterRecord.getAlias();
            }

            @Override
            public boolean isSchedulerTrace() {
                return false;
            }
        };
    }

    private @NonNull IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream makeCounterStream(final @NonNull CounterRecord counterRecord, @NonNull TLongObjectMap<IndexId> vmToStream) throws IOException {
        final ProcessingElementReference[] channels = (ProcessingElementReference[])NullChecking.neverNull((Object[])counterRecord.getChannelDescriptions());
        final List<DatabaseCounterReader.VmStream> vmStreams = AnalysisDatabaseReaderFactoryV3.mapStreamChannels(vmToStream, channels, (vm, channelBase, deviceNoCount, index) -> {
            List<L0IndexEntry> l0Index = this.metadata.getL0Index(index);
            return new DatabaseCounterReader.VmStream(channelBase, deviceNoCount, l0Index, this.dataFileView);
        });
        return new IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream(){

            @Override
            public @NonNull IAnalysisHardwareCounterReader createReader() throws IOException {
                return new DatabaseCounterReader(channels, vmStreams);
            }

            @Override
            public int getChannelCount() {
                return channels.length;
            }

            @Override
            public @NonNull CounterRecord getCounterRecord() {
                return counterRecord;
            }

            @Override
            public @NonNull String getStreamName() {
                return counterRecord.getAlias();
            }
        };
    }

    private static final class CamDefinitionsVisitor
    implements CamStreamParser.IStreamValueVisitor {
        public @Nullable String name;
        public @Nullable Integer viewUID;
        public @Nullable Integer utid;
        public final @NonNull TIntObjectMap<CAMTrack> tracks = new TIntObjectHashMap(10, 0.5f, -1);

        private CamDefinitionsVisitor() {
        }

        @Override
        public void camJob(long timestamp, long sequenceNo, int trackUid, int jobUid, long duration, int colour, int primaryDependencyJobUid, int[] dependencyJobUids, @NonNull String jobName, @NonNull String detailText) {
        }

        @Override
        public void camJobDependencies(long timestamp, long sequenceNo, int jobUid, int primaryDependencyJobUid, int[] dependencyJobUids) {
        }

        @Override
        public void camJobStart(long timestamp, long sequenceNo, int trackUid, int jobUid, int colour, @NonNull String jobName, @NonNull String detailText) {
        }

        @Override
        public void camJobStop(long timestamp, long sequenceNo, int jobUid) {
        }

        @Override
        public void camTrackDefinition(long timestamp, long sequenceNo, int parentTrackUid, int trackUid, @NonNull String name) {
            this.tracks.put(trackUid, (Object)new CAMTrack(parentTrackUid, trackUid, name));
        }

        @Override
        public void camViewDefinition(long timestamp, long sequenceNo, int viewUID, @Nullable Integer utid, @NonNull String name) {
            Integer oldViewUID = this.viewUID;
            assert (oldViewUID == null || oldViewUID == viewUID);
            this.name = name;
            this.viewUID = viewUID;
            this.utid = utid;
        }
    }

    @FunctionalInterface
    public static interface IStreamChannelMapper<R, E extends Throwable> {
        public R apply(long var1, int var3, int var4, @NonNull IndexId var5) throws E;
    }
}

