/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.chunkwriter;

import com.arm.streamline.common.utility.io.Compression;
import com.arm.utils.io.AccessibleByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractBaseChunkWriter
implements Compression.IBytesWriter,
Closeable {
    private static final int DEFAULT_CHUNK_SIZE = 4096;
    private final @NonNull IChunkConsumer chunkConsumer;
    private final int chunkSize;
    protected final long key;
    private final @NonNull AccessibleByteArrayOutputStream outputStream;

    public AbstractBaseChunkWriter(long key, @NonNull IChunkConsumer chunkConsumer) {
        this(key, 4096, chunkConsumer);
    }

    public AbstractBaseChunkWriter(long key, int chunkSize, @NonNull IChunkConsumer chunkConsumer) {
        if (chunkSize < 1) {
            throw new IllegalArgumentException();
        }
        this.key = key;
        this.chunkSize = chunkSize;
        this.chunkConsumer = chunkConsumer;
        this.outputStream = new AccessibleByteArrayOutputStream(chunkSize);
    }

    @Override
    public final void close() throws IOException {
        this.flush();
        int size = this.outputStream.size();
        if (size > 0) {
            this.chunkConsumer.consume(this.key, this.outputStream.buffer(), 0, size);
            this.outputStream.reset();
        }
    }

    public final void write(byte[] b, int off, int len) {
        this.outputStream.write(b, off, len);
    }

    protected final void completeRecord() throws IOException {
        int size = this.outputStream.size();
        if (size >= this.chunkSize) {
            this.chunkConsumer.consume(this.key, this.outputStream.buffer(), 0, size);
            this.outputStream.reset();
        }
    }

    protected void flush() throws IOException {
    }

    @FunctionalInterface
    public static interface IChunkConsumer {
        public void consume(long var1, byte @NonNull [] var3, int var4, int var5) throws IOException;
    }
}

