/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream;

import com.arm.streamline.analysis.database.api.IEventReader;
import com.arm.streamline.analysis.database.api.IEventReaderValue;
import com.arm.utils.function.Throwing;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractEventReader<T extends IEventReaderValue, V extends IEventReaderValue, R extends IEventReader<V>>
implements IEventReader<T> {
    private final @NonNull R @NonNull [] channelReaders;
    private final @Nullable T @NonNull [] currentValues;

    public AbstractEventReader(@NonNull R @NonNull [] channelReaders) {
        this.channelReaders = channelReaders;
        this.currentValues = new IEventReaderValue[channelReaders.length];
    }

    @Override
    public final void close() throws IOException {
        Throwing.closeAll(this.channelReaders);
    }

    @Override
    public final @Nullable T read() throws IOException {
        int resultIndex = 0;
        @Nullable IEventReaderValue result = null;
        int i = 0;
        while (i < this.currentValues.length) {
            @Nullable T value = this.getValue(i);
            if (value != null && (result == null || result.getTimestamp() > value.getTimestamp())) {
                result = value;
                resultIndex = i;
            }
            ++i;
        }
        if (result != null) {
            this.currentValues[resultIndex] = null;
        }
        return (T)result;
    }

    protected abstract @NonNull T adaptPerChannelValue(int var1, @NonNull V var2) throws IOException;

    private @Nullable T getValue(int index) throws IOException {
        @Nullable T currentValue = this.currentValues[index];
        if (currentValue != null) {
            return currentValue;
        }
        @Nullable T readValue = this.channelReaders[index].read();
        if (readValue == null) {
            return null;
        }
        @NonNull T adaptedValue = this.adaptPerChannelValue(index, readValue);
        this.currentValues[index] = adaptedValue;
        return adaptedValue;
    }
}

