/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database;

import com.arm.streamline.analysis.model.KernelSymbol;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class KernelSymbolsReaderWriter {
    public static final @NonNull String ATTR_ADDRESS = "address";
    public static final @NonNull String ATTR_MODULE = "module";
    public static final @NonNull String ATTR_SYMBOL = "name";
    public static final @NonNull String ATTR_TYPE = "type";
    public static final @NonNull String ATTR_VERSION = "version";
    public static final @NonNull String ATTR_VMUID = "id";
    public static final @NonNull String TAG_KALLSYMS = "kallsyms";
    public static final @NonNull String TAG_SYMBOL = "symbol";
    public static final @NonNull String TAG_VM = "vm";

    public static @NonNull TLongObjectMap<List<@NonNull KernelSymbol>> read(@NonNull File input) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (XMLParser in = XMLParser.create((File)input);){
                return KernelSymbolsReaderWriter.read(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            return new TLongObjectHashMap();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull TLongObjectMap<List<@NonNull KernelSymbol>> read(XMLParser in) throws IOException {
        String tag;
        @NonNull @NonNull TLongObjectHashMap kernelSymbolsByVm = new TLongObjectHashMap();
        String marker = in.getMarker();
        while ((tag = in.nextTag(marker)) != null) {
            if (TAG_KALLSYMS.equals(tag)) {
                int fileVersion = in.getIntegerAttribute(ATTR_VERSION, 0);
                if (fileVersion != 1) {
                    throw new IOException("Invalid version in kernel-symbols.xml, corrupt capture");
                }
                String rootMarker = in.getMarker();
                while ((tag = in.nextTag(rootMarker)) != null) {
                    if (!TAG_VM.contentEquals(tag)) continue;
                    long vmUID = in.getLongAttribute(ATTR_VMUID);
                    @NonNull ArrayList<@NonNull KernelSymbol> symbols = new ArrayList<KernelSymbol>();
                    String vmMarker = in.getMarker();
                    while ((tag = in.nextTag(vmMarker)) != null) {
                        if (!TAG_SYMBOL.contentEquals(tag)) continue;
                        @NonNull String module = in.getAttribute(ATTR_MODULE, "");
                        @NonNull String symbol = in.getAttribute(ATTR_SYMBOL, "");
                        long address = in.getLongAttribute(ATTR_ADDRESS);
                        @NonNull String type = in.getAttribute(ATTR_TYPE, "");
                        if (symbol.isEmpty() || type.length() != 1) {
                            throw new IOException("Invalid kernel symbol in kernel-symbols.xml, corrupt capture");
                        }
                        symbols.add(new KernelSymbol(module, symbol, type.charAt(0), address));
                    }
                    if (symbols.isEmpty()) continue;
                    kernelSymbolsByVm.put(vmUID, symbols);
                }
                continue;
            }
            in.skip();
        }
        return kernelSymbolsByVm;
    }

    public static void write(@NonNull File file, @NonNull TLongObjectMap<List<@NonNull KernelSymbol>> kernelSymbolsByVm) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLGenerator xml = XMLGenerator.create((File)file);){
            KernelSymbolsReaderWriter.write(xml, kernelSymbolsByVm);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void write(@NonNull XMLGenerator xml, @NonNull TLongObjectMap<List<@NonNull KernelSymbol>> kernelSymbolsByVm) throws IOException {
        xml.startDocument();
        xml.startTag(TAG_KALLSYMS);
        xml.addAttribute(ATTR_VERSION, 1);
        @NonNull TLongObjectIterator it = kernelSymbolsByVm.iterator();
        while (it.hasNext()) {
            it.advance();
            long vmUID = it.key();
            @NonNull List symbols = (List)it.value();
            if (symbols.isEmpty()) continue;
            xml.startTag(TAG_VM);
            xml.addAttribute(ATTR_VMUID, vmUID);
            for (KernelSymbol symbol : symbols) {
                xml.startEmptyTag(TAG_SYMBOL);
                xml.addAttributeNot(ATTR_MODULE, symbol.module, "");
                xml.addAttribute(ATTR_SYMBOL, symbol.symbol);
                xml.addAttribute(ATTR_ADDRESS, String.format("0x%x", symbol.address));
                xml.addAttribute(ATTR_TYPE, Character.toString(symbol.type));
            }
            xml.endTag();
        }
        xml.endTag();
        xml.endDocument();
    }
}

