/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database;

import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.utils.NullChecking;
import gnu.trove.set.hash.TLongHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public interface IProcessingElementReferenceWriterMapper {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public static final /* synthetic */ int[] $SWITCH_TABLE$com$arm$streamline$common$model$topology$DeviceType$BasicDeviceType;

    static {
        $SWITCH_TABLE$com$arm$streamline$common$model$topology$DeviceType$BasicDeviceType = IProcessingElementReferenceWriterMapper.$SWITCH_TABLE$com$arm$streamline$common$model$topology$DeviceType$BasicDeviceType();
    }

    public static @NonNull IProcessingElementReferenceWriterMapper create(@NonNull ProcessingElementReferenceSet processingElementsReferenceSet, @NonNull DeviceType deviceType, @NonNull List<@NonNull ProcessingElementReference> processingElementReferences, boolean isPerCPU, int expectedCoreCount) {
        switch (deviceType.getBasicDeviceType()) {
            case CPU: {
                assert (isPerCPU);
                assert (expectedCoreCount < 0 || expectedCoreCount >= processingElementReferences.size());
                return new PerProcessingElementReferenceWriterMapper(processingElementReferences);
            }
            case DISPLAY: 
            case GPU: 
            case VIDEO: {
                if (expectedCoreCount > 0) {
                    return new PerProcessingElementReferenceWriterMapper(processingElementsReferenceSet, deviceType, processingElementReferences, expectedCoreCount);
                }
                return new PerVmReferenceWriterMapper(processingElementsReferenceSet, deviceType, processingElementReferences);
            }
            case SYSTEM_WIDE: {
                return new PerVmReferenceWriterMapper(processingElementsReferenceSet, deviceType, processingElementReferences);
            }
        }
        throw new AssertionError(deviceType.getBasicDeviceType());
    }

    public int getChannelCount();

    public @NonNull ProcessingElementReference @NonNull [] getChannelDescriptions();

    public int getChannelNumber(@NonNull ProcessingElementReference var1);

    public boolean matchesAnyInSet(int var1, @NonNull Set<@NonNull ProcessingElementReference> var2);

    public static final class PerProcessingElementReferenceWriterMapper
    implements IProcessingElementReferenceWriterMapper {
        private final @NonNull ProcessingElementReference @NonNull [] sortedProcessingElementReferences;

        public PerProcessingElementReferenceWriterMapper(@NonNull List<@NonNull ProcessingElementReference> processingElementReferences) {
            this.sortedProcessingElementReferences = processingElementReferences.toArray(new ProcessingElementReference[processingElementReferences.size()]);
            Arrays.sort(this.sortedProcessingElementReferences);
        }

        public PerProcessingElementReferenceWriterMapper(@NonNull ProcessingElementReferenceSet processingElementsReferenceSet, @NonNull DeviceType deviceType, @NonNull List<@NonNull ProcessingElementReference> processingElementReferences, int expectedCoreCountPerVm) {
            TLongHashSet vmUIDs = new TLongHashSet();
            for (ProcessingElementReference peReference : processingElementReferences) {
                assert (peReference.deviceType.equals((Object)deviceType));
                vmUIDs.add(peReference.vmUID);
                if (peReference.deviceNumber < 0 || peReference.deviceNumber >= expectedCoreCountPerVm) {
                    throw new AssertionError();
                }
            }
            long[] sortedVmUIDs = vmUIDs.toArray();
            Arrays.sort(sortedVmUIDs);
            this.sortedProcessingElementReferences = new ProcessingElementReference[sortedVmUIDs.length * expectedCoreCountPerVm];
            int i = 0;
            while (i < sortedVmUIDs.length) {
                long vmUID = sortedVmUIDs[i];
                int j = 0;
                while (j < expectedCoreCountPerVm) {
                    int deviceNumber = j;
                    this.sortedProcessingElementReferences[i * expectedCoreCountPerVm + j] = processingElementsReferenceSet.get(deviceType, vmUID, deviceNumber);
                    ++j;
                }
                ++i;
            }
            Arrays.sort(this.sortedProcessingElementReferences);
        }

        @Override
        public int getChannelCount() {
            return this.sortedProcessingElementReferences.length;
        }

        @Override
        public @NonNull ProcessingElementReference @NonNull [] getChannelDescriptions() {
            return this.sortedProcessingElementReferences;
        }

        @Override
        public int getChannelNumber(@NonNull ProcessingElementReference peReference) {
            int index = Arrays.binarySearch(this.sortedProcessingElementReferences, peReference);
            if (index < 0) {
                throw new AssertionError();
            }
            return index;
        }

        @Override
        public boolean matchesAnyInSet(int channelNumber, @NonNull Set<@NonNull ProcessingElementReference> set) {
            return set.contains(this.sortedProcessingElementReferences[channelNumber]);
        }
    }

    public static final class PerVmReferenceWriterMapper
    implements IProcessingElementReferenceWriterMapper {
        private final @NonNull ProcessingElementReference @NonNull [] channelDescriptions;
        private final long @NonNull [] sortedVmUIDs;

        public PerVmReferenceWriterMapper(@NonNull ProcessingElementReferenceSet processingElementsReferenceSet, @NonNull DeviceType deviceType, @NonNull List<@NonNull ProcessingElementReference> processingElementReferences) {
            assert (!deviceType.isCPU());
            TLongHashSet vmUIDs = new TLongHashSet();
            for (ProcessingElementReference peReference : processingElementReferences) {
                vmUIDs.add(peReference.vmUID);
            }
            this.sortedVmUIDs = (long[])NullChecking.neverNull((Object)vmUIDs.toArray());
            Arrays.sort(this.sortedVmUIDs);
            this.channelDescriptions = new ProcessingElementReference[this.sortedVmUIDs.length];
            int i = 0;
            while (i < this.sortedVmUIDs.length) {
                this.channelDescriptions[i] = processingElementsReferenceSet.get(deviceType, this.sortedVmUIDs[i], 0);
                ++i;
            }
        }

        @Override
        public int getChannelCount() {
            return this.sortedVmUIDs.length;
        }

        @Override
        public @NonNull ProcessingElementReference @NonNull [] getChannelDescriptions() {
            return this.channelDescriptions;
        }

        @Override
        public int getChannelNumber(@NonNull ProcessingElementReference peReference) {
            int channelNumber = Arrays.binarySearch(this.sortedVmUIDs, peReference.vmUID);
            if (channelNumber < 0) {
                throw new AssertionError();
            }
            return channelNumber;
        }

        @Override
        public boolean matchesAnyInSet(int channelNumber, @NonNull Set<@NonNull ProcessingElementReference> set) {
            long vmUID = this.sortedVmUIDs[channelNumber];
            for (ProcessingElementReference peReference : set) {
                if (peReference.vmUID != vmUID) continue;
                return true;
            }
            return false;
        }
    }
}

