/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database;

import com.arm.streamline.analysis.model.DBProperties;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class DBPropertiesReaderWriter {
    public static final int CURRENT_VERSION = 20240819;
    private static final String ATTR_APPLICATION_TRACING_MODE = "application_mode";
    private static final String ATTR_CREATED = "created";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_STOP_TIME = "stop_time";
    private static final String ATTR_VERSION = "version";
    private static final String TAG_STATE = "state";

    public static @NonNull DBProperties create(@NonNull File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XMLParser in = XMLParser.create((File)file);){
            String tag;
            while ((tag = in.nextTag()) != null) {
                if (TAG_STATE.equals(tag)) {
                    long stopTimestamp = in.getLongAttribute(ATTR_STOP_TIME, 0L);
                    String name = in.getAttribute(ATTR_NAME);
                    int version = in.getIntegerAttribute(ATTR_VERSION, 0);
                    boolean applicationTracingMode = in.isAttributeSet(ATTR_APPLICATION_TRACING_MODE, false);
                    return new DBProperties(stopTimestamp, name, version, applicationTracingMode);
                }
                in.skip();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throw new IOException("Invalid state file: " + String.valueOf(file));
    }

    public static boolean isValid(@NonNull File file) {
        try {
            DBProperties stateFile = DBPropertiesReaderWriter.create(file);
            return DBPropertiesReaderWriter.isValid(stateFile);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected static boolean isValid(@NonNull DBProperties stateFile) {
        return stateFile.getVersion() == 20240819;
    }

    public static void write(@NonNull File file, long currentTime, long duration, String name, boolean applicationTracingMode) throws IOException {
        Throwable throwable = null;
        Object var8_7 = null;
        try (XMLGenerator xml = XMLGenerator.create((File)file);){
            xml.startDocument();
            xml.startEmptyTag(TAG_STATE);
            xml.addAttribute(ATTR_VERSION, 20240819);
            xml.addAttribute(ATTR_CREATED, currentTime);
            xml.addAttribute(ATTR_STOP_TIME, duration);
            xml.addAttribute(ATTR_NAME, name);
            xml.addAttributeNot(ATTR_APPLICATION_TRACING_MODE, applicationTracingMode, false);
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

