/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.elfdwarf;

import com.arm.streamline.jni.StreamlineLib;
import com.arm.streamline.jni.common.NativeHandle;
import com.arm.streamline.jni.elfdwarf.BasicArchitecture;
import com.arm.streamline.jni.elfdwarf.ImageMetadataReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ImageMetadataWriter
implements Closeable {
    private final @NonNull NativeHandle nativeHandle;

    private static native long createNativeImageMetadataWriterHashed(String var0, String var1, int var2, long var3, long var5, String var7, String var8, String var9, long var10, long var12, boolean var14, boolean var15) throws IOException;

    private static native long createNativeImageMetadataWriter(String var0, String var1, int var2, String var3, String var4, String var5, String var6, String var7, long var8, long var10, boolean var12, boolean var13) throws IOException;

    private static native void destroyNativeImageMetadataWriter(long var0) throws IOException;

    private static native void addSymbol(long var0, long var2, long var4, long var6, long var8, String var10, String var11, String[] var12, String[] var13, long var14, int var16, byte[] var17) throws IOException;

    private static native void addRegion(long var0, long var2, int var4) throws IOException;

    private static native void addOpcode(long var0, boolean var2, long var3, long var5, long var7, int var9, long var10, int var12, long var13) throws IOException;

    private static void uncheckedDestroyNativeImageMetadataWriter(long l) {
        try {
            ImageMetadataWriter.destroyNativeImageMetadataWriter(l);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public ImageMetadataWriter(@NonNull File file, @NonNull File file2, @NonNull BasicArchitecture basicArchitecture, long l, long l2, @NonNull String string, @NonNull String string2, @NonNull String string3, long l3, long l4, boolean bl, boolean bl2) throws IOException {
        if (!string3.matches("^[0-9A-Fa-f]+$") || string3.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid buildId argument");
        }
        this.nativeHandle = new NativeHandle(ImageMetadataWriter.createNativeImageMetadataWriterHashed(file.getAbsolutePath(), file2.getAbsolutePath(), basicArchitecture.nativeValue, l, l2, string, string2, string3, l3, l4, bl, bl2), ImageMetadataWriter::uncheckedDestroyNativeImageMetadataWriter);
    }

    public ImageMetadataWriter(@NonNull File file, @NonNull File file2, @NonNull BasicArchitecture basicArchitecture, @NonNull File file3, @Nullable File file4, @NonNull String string, @NonNull String string2, @NonNull String string3, boolean bl, boolean bl2) throws IOException {
        if (!string3.matches("^[0-9A-Fa-f]+$") || string3.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid buildId argument");
        }
        this.nativeHandle = new NativeHandle(ImageMetadataWriter.createNativeImageMetadataWriter(file.getAbsolutePath(), file2.getAbsolutePath(), basicArchitecture.nativeValue, file3.getAbsolutePath(), file4 != null ? file4.getAbsolutePath() : null, string, string2, string3, 0L, file3.length(), bl, bl2), ImageMetadataWriter::uncheckedDestroyNativeImageMetadataWriter);
    }

    @Override
    public void close() throws IOException {
        this.nativeHandle.close();
    }

    public void addSymbol(@NonNull ImageMetadataReader.SymbolRecord symbolRecord, byte @NonNull [] byArray) throws IOException {
        this.nativeHandle.doWith(l -> ImageMetadataWriter.addSymbol(l, symbolRecord.fileOffset, symbolRecord.address, symbolRecord.size, symbolRecord.stackFrameSize, symbolRecord.name, symbolRecord.unmangledName, symbolRecord.aliasNames, symbolRecord.unmangledAliasNames, symbolRecord.sourceFileUID, symbolRecord.souceLineNo, byArray));
    }

    public void addRegion(long l,  @NonNull MappingClassificationRange.MappingSymbolClassification mappingSymbolClassification) throws IOException {
        this.nativeHandle.doWith(l2 -> ImageMetadataWriter.addRegion(l2, l, mappingSymbolClassification.ordinal()));
    }

    public void addOpcode(boolean bl, long l, long l2, long l3, int n, long l4, int n2, long l5) throws IOException {
        this.nativeHandle.doWith(l6 -> ImageMetadataWriter.addOpcode(l6, bl, l, l2, l3, n, l4, n2, l5));
    }

    static {
        if (!StreamlineLib.isLoaded) {
            throw new AssertionError((Object)"Failed to load Streamline JNI lib");
        }
    }
}

