/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.common;

import com.arm.streamline.jni.common.ListUtils;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class TimeRangeFilter {
    public static <T extends IHasStartStopTime> @NonNull List<@NonNull T> filterTimeRangeWindow(long l, long l2, @Nullable List<@NonNull T> list) {
        if (l >= l2) {
            throw new IllegalArgumentException();
        }
        if (list == null) {
            return Collections.emptyList();
        }
        int n = ListUtils.binarySearch(list, iHasStartStopTime -> {
            if (iHasStartStopTime.getStartTime() >= l) {
                return -1;
            }
            if (iHasStartStopTime.getStopTime() <= l) {
                return 1;
            }
            return -1;
        });
        if (n < 0) {
            n = -(n + 1);
        }
        if (n >= list.size()) {
            return Collections.emptyList();
        }
        assert (n == 0 || ((IHasStartStopTime)list.get(n - 1)).getStopTime() <= l);
        IHasStartStopTime iHasStartStopTime2 = (IHasStartStopTime)list.get(n);
        if (iHasStartStopTime2.getStartTime() >= l2) {
            return Collections.emptyList();
        }
        assert (iHasStartStopTime2.getStartTime() < l2 && iHasStartStopTime2.getStopTime() > l || iHasStartStopTime2.getStartTime() == iHasStartStopTime2.getStopTime() && iHasStartStopTime2.getStartTime() >= l && iHasStartStopTime2.getStopTime() < l2);
        int n2 = ListUtils.binarySearch(list, n, list.size() - n, iHasStartStopTime -> {
            if (iHasStartStopTime.getStartTime() >= l2) {
                return -1;
            }
            return 1;
        });
        if (n2 < 0) {
            n2 = -(n2 + 1);
        }
        if (n2 >= list.size()) {
            return Collections.unmodifiableList(list.subList(n, n2));
        }
        assert (n2 >= n);
        assert (n2 >= list.size() || ((IHasStartStopTime)list.get(n2)).getStartTime() >= l2 && ((IHasStartStopTime)list.get(n2)).getStopTime() >= l2);
        return Collections.unmodifiableList(list.subList(n, n2));
    }

    public static interface IHasStartStopTime {
        public long getStartTime();

        public long getStopTime();
    }
}

