/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.common;

import com.arm.streamline.jni.StreamlineLib;
import com.arm.streamline.jni.common.NativeException;
import com.arm.streamline.jni.common.NativeHandle;
import java.util.function.BooleanSupplier;
import org.eclipse.jdt.annotation.NonNull;

public final class CancellationPredicate
implements AutoCloseable,
BooleanSupplier {
    private final @NonNull NativeHandle nativeHandle = new NativeHandle(CancellationPredicate.create(), CancellationPredicate::destroy);

    private static native long create();

    private static native void destroy(long var0);

    private static native void performCancel(long var0);

    private static native boolean performIsCancelled(long var0);

    public void cancel() {
        this.nativeHandle.doIf(CancellationPredicate::performCancel);
    }

    @Override
    public void close() {
        try {
            this.cancel();
        }
        finally {
            this.nativeHandle.close();
        }
    }

    public <R, T1 extends Throwable, T2 extends Throwable> R doWithResult(@NonNull NativeHandle.Action<R, T1, T2> action) throws T1, T2 {
        return this.nativeHandle.doWithResult(action);
    }

    public <T extends Throwable> void doWith(@NonNull NativeHandle.VoidAction<T> voidAction) throws T {
        this.nativeHandle.doWith(voidAction);
    }

    @Override
    public boolean getAsBoolean() {
        return this.isCancelled();
    }

    public boolean isCancelled() throws NativeException {
        return this.nativeHandle.doWithResult(l -> CancellationPredicate.performIsCancelled(l));
    }

    static {
        if (!StreamlineLib.isLoaded) {
            throw new AssertionError((Object)"Failed to load common JNI lib");
        }
    }
}

