/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.proto;

import com.arm.streamline.jni.apcdbgen.proto.ILabelVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public abstract class TimelineWorkload {
    private static final @NonNull String FRAME = "Frame";
    private final @NonNull List<@NonNull String> debugLabels;
    private final long id;
    private final long frame;
    private final long queue;
    private final @NonNull Map<@NonNull String, @NonNull String> properties;
    private final @NonNull String name;

    public TimelineWorkload(@NonNull String string, @NonNull String @NonNull [] stringArray, long l, long l2, long l3) {
        this.name = string;
        this.debugLabels = Arrays.asList(stringArray);
        this.frame = l2;
        this.queue = l3;
        this.id = l;
        this.properties = new LinkedHashMap<String, String>();
        this.addProperty(FRAME, String.valueOf(l2));
    }

    public abstract void accept(@NonNull ILabelVisitor var1);

    public @NonNull String getName() {
        return this.name;
    }

    public long getQueue() {
        return this.queue;
    }

    public long getFrame() {
        return this.frame;
    }

    public long getId() {
        return this.id;
    }

    public @NonNull List<@NonNull String> getDebugLabels() {
        return Collections.unmodifiableList(this.debugLabels);
    }

    public @NonNull Map<@NonNull String, @NonNull String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    protected void addProperty(@NonNull String string, @NonNull String string2) {
        this.properties.put(string, string2);
    }

    public String toString() {
        return "TimelineWorkload[debugLabels=" + String.valueOf(this.debugLabels) + ", frame=" + this.frame + ", queue=" + this.queue + ", id=" + this.id + ", properties=" + String.valueOf(this.properties) + "]";
    }
}

