/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.proto;

import com.arm.streamline.jni.apcdbgen.proto.IExtractable;
import com.arm.streamline.jni.apcdbgen.proto.ISourceLineReference;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

public final class SimpleSourceReference
implements ISourceLineReference,
IExtractable {
    private final @NonNull SourceFile mFile;
    private final @NonNull ReferencedSymbol mFunction;
    private final int mLine;

    public SimpleSourceReference(@NonNull ReferencedSymbol referencedSymbol, @NonNull SourceFile sourceFile, int n) {
        this.mFunction = referencedSymbol;
        this.mFile = sourceFile;
        this.mLine = n;
    }

    @Override
    public <R, E extends Throwable> R accept(@NonNull IExtractable.IExtractableVisitor<R, E> iExtractableVisitor) throws E {
        return iExtractableVisitor.visit(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SimpleSourceReference) {
            SimpleSourceReference simpleSourceReference = (SimpleSourceReference)object;
            return this.mLine == simpleSourceReference.mLine && this.mFile.equals(simpleSourceReference.mFile) && this.mFunction.equals(simpleSourceReference.mFunction);
        }
        return false;
    }

    @Override
    public @NonNull ReferencedSymbol getAssociatedFunction() {
        return this.mFunction;
    }

    @Override
    public @NonNull SourceFile getSourceFile() {
        return this.mFile;
    }

    @Override
    public int getStartLine() {
        return this.mLine;
    }

    public int hashCode() {
        return Objects.hash(this.mFile, this.mFunction, this.mLine);
    }
}

