/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.proto;

import com.arm.streamline.jni.apcdbgen.proto.Attachment;
import com.arm.streamline.jni.apcdbgen.proto.AttachmentStringBuilder;
import com.arm.streamline.jni.apcdbgen.proto.ILabelVisitor;
import com.arm.streamline.jni.apcdbgen.proto.TimelineWorkload;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class Renderpass
extends TimelineWorkload {
    private static final @NonNull String WORKLOAD_NAME = "Render Pass";
    private final int width;
    private final int height;
    private final int drawCallCount;
    private final int subpassCount;
    private final @NonNull List<@NonNull Attachment> attachmentsList;
    private final @NonNull String attachments;
    private final @NonNull String attachmentsLoaded;
    private final @NonNull String attachmentsStored;
    private final @NonNull String attachmentsResolved;

    public Renderpass(@NonNull String @NonNull [] stringArray, long l, long l2, long l3, int n, int n2, int n3, int n4, @NonNull Attachment @NonNull [] attachmentArray) {
        super(WORKLOAD_NAME, stringArray, l, l2, l3);
        this.width = n;
        this.height = n2;
        this.drawCallCount = n3;
        this.subpassCount = n4;
        this.attachmentsList = Arrays.asList(attachmentArray);
        AttachmentsStrings attachmentsStrings = AttachmentsStrings.fromAttachments(this.attachmentsList);
        this.attachments = attachmentsStrings.attachments();
        this.attachmentsLoaded = attachmentsStrings.loaded();
        this.attachmentsStored = attachmentsStrings.stored();
        this.attachmentsResolved = attachmentsStrings.resolved();
        this.addProperties();
    }

    @Override
    public void accept(@NonNull ILabelVisitor iLabelVisitor) {
        iLabelVisitor.visit(this);
    }

    private void addProperties() {
        this.addProperty("Resolution", String.format("%dx%d", this.width, this.height));
        this.addProperty("Draw count", Integer.valueOf(this.drawCallCount).toString());
        if (this.subpassCount > 1) {
            this.addProperty("Subpass count", Integer.valueOf(this.subpassCount).toString());
        }
        if (!this.attachments.isEmpty()) {
            this.addProperty("Attachments", this.attachments);
        }
        if (!this.attachmentsLoaded.isEmpty()) {
            this.addProperty("Attachments loaded", this.attachmentsLoaded);
        }
        if (!this.attachmentsStored.isEmpty()) {
            this.addProperty("Attachments stored", this.attachmentsStored);
        }
        if (!this.attachmentsResolved.isEmpty()) {
            this.addProperty("Attachments resolved", this.attachmentsResolved);
        }
    }

    public long getWidth() {
        return this.width;
    }

    public long getHeight() {
        return this.height;
    }

    public long getDrawCallCount() {
        return this.drawCallCount;
    }

    public long getSubpassCount() {
        return this.subpassCount;
    }

    public @NonNull List<@NonNull Attachment> getAttachmentsList() {
        return this.attachmentsList;
    }

    public @NonNull String getAttachments() {
        return this.attachments;
    }

    public @NonNull String getAttachmentsLoaded() {
        return this.attachmentsLoaded;
    }

    public @NonNull String getAttachmentsStored() {
        return this.attachmentsStored;
    }

    public @NonNull String getAttachmentsResolved() {
        return this.attachmentsResolved;
    }

    @Override
    public String toString() {
        return "Renderpass[width=" + this.width + ", height=" + this.height + ", drawCallCount=" + this.drawCallCount + ", subpassCount=" + this.subpassCount + ", attachmentsList=" + String.valueOf(this.attachmentsList) + ", attachments=" + this.attachments + ", attachmentsLoaded=" + this.attachmentsLoaded + ", attachmentsStored=" + this.attachmentsStored + ", attachmentsResolved=" + this.attachmentsResolved + ", super=" + super.toString() + "]";
    }

    private record AttachmentsStrings(@NonNull String attachments, @NonNull String loaded, @NonNull String stored, @NonNull String resolved) {
        public static @NonNull AttachmentsStrings fromAttachments(@NonNull List<@NonNull Attachment> list) {
            AttachmentStringBuilder attachmentStringBuilder = new AttachmentStringBuilder();
            AttachmentStringBuilder attachmentStringBuilder2 = new AttachmentStringBuilder();
            AttachmentStringBuilder attachmentStringBuilder3 = new AttachmentStringBuilder();
            AttachmentStringBuilder attachmentStringBuilder4 = new AttachmentStringBuilder();
            for (Attachment attachment : list) {
                attachmentStringBuilder.append(attachment.type());
                if (attachment.loaded()) {
                    attachmentStringBuilder2.append(attachment.type());
                }
                if (attachment.stored()) {
                    attachmentStringBuilder3.append(attachment.type());
                }
                if (!attachment.resolved()) continue;
                attachmentStringBuilder4.append(attachment.type());
            }
            return new AttachmentsStrings(attachmentStringBuilder.toString(), attachmentStringBuilder2.toString(), attachmentStringBuilder3.toString(), attachmentStringBuilder4.toString());
        }
    }
}

