/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.proto;

import com.arm.streamline.jni.apcdbgen.proto.ILabelVisitor;
import com.arm.streamline.jni.apcdbgen.proto.ImageTransferType;
import com.arm.streamline.jni.apcdbgen.proto.TimelineWorkload;
import org.eclipse.jdt.annotation.NonNull;

public final class ImageTransfer
extends TimelineWorkload {
    private static final @NonNull String WORKLOAD_NAME = "Image Transfer";
    private final int pixelCount;
    private final @NonNull ImageTransferType type;

    public ImageTransfer(@NonNull String @NonNull [] stringArray, long l, long l2, long l3, int n, @NonNull ImageTransferType imageTransferType) {
        super(WORKLOAD_NAME, stringArray, l, l2, l3);
        this.pixelCount = n;
        this.type = imageTransferType;
        this.addProperties();
    }

    @Override
    public void accept(@NonNull ILabelVisitor iLabelVisitor) {
        iLabelVisitor.visit(this);
    }

    private void addProperties() {
        if (this.pixelCount < 0) {
            this.addProperty("Transfer size", "Unknown");
        } else {
            String string = this.pixelCount != 1 ? "s" : "";
            this.addProperty("Transfer size", String.format("%d pixel%s", this.pixelCount, string));
        }
    }

    public long getPixelCount() {
        return this.pixelCount;
    }

    public @NonNull ImageTransferType getTransferType() {
        return this.type;
    }

    @Override
    public String toString() {
        return "ImageTransfer[pixelCount=" + this.pixelCount + ", type=" + String.valueOf((Object)this.type) + ", super=" + super.toString() + "]";
    }
}

