/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.proto;

import org.eclipse.jdt.annotation.NonNull;

public final class HistogramDataPoint {
    public final int skip;
    public final int width;

    public static final long @NonNull [] calculateAbsoluteBaseValues(@NonNull HistogramDataPoint @NonNull [] histogramDataPointArray) {
        long @NonNull [] lArray = new long[histogramDataPointArray.length];
        long l = 0L;
        for (int i = 0; i < histogramDataPointArray.length; ++i) {
            lArray[i] = l += (long)histogramDataPointArray[i].skip;
            l += (long)histogramDataPointArray[i].width;
        }
        return lArray;
    }

    public static final @NonNull HistogramDataPoint @NonNull [] calculateHistogramDataPoints(int @NonNull [] nArray, int n) {
        @NonNull HistogramDataPoint @NonNull [] histogramDataPointArray = new HistogramDataPoint[nArray.length];
        long l = 0L;
        for (int i = 0; i < nArray.length; ++i) {
            long l2 = (long)nArray[i] - l;
            if (l2 < 0L || l2 > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            histogramDataPointArray[i] = new HistogramDataPoint(Math.toIntExact(l2), n);
            l = nArray[i] + n;
        }
        return histogramDataPointArray;
    }

    public static @NonNull HistogramDataPoint @NonNull [] calculateHistogramDataPointsOnLog2Nplus1Scale(int n) {
        @NonNull HistogramDataPoint @NonNull [] histogramDataPointArray = new HistogramDataPoint[n];
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            long l2 = i > 0 ? 1L << i - 1 : 0L;
            long l3 = 1L << i;
            long l4 = l3 - l2;
            long l5 = l2 - l;
            l = l3;
            if (l5 < 0L || l5 > Integer.MAX_VALUE || l4 < 0L || l4 > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            histogramDataPointArray[i] = new HistogramDataPoint(Math.toIntExact(l5), Math.toIntExact(l4));
        }
        return histogramDataPointArray;
    }

    public HistogramDataPoint(int n, int n2) {
        if (n < 0 || n2 < 1) {
            throw new IllegalArgumentException();
        }
        this.skip = n;
        this.width = n2;
    }
}

