/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.proto;

import com.arm.streamline.jni.apcdbgen.proto.AccelerationStructureBuildType;
import com.arm.streamline.jni.apcdbgen.proto.ILabelVisitor;
import com.arm.streamline.jni.apcdbgen.proto.TimelineWorkload;
import org.eclipse.jdt.annotation.NonNull;

public final class AccelerationStructureBuild
extends TimelineWorkload {
    private static final @NonNull String WORKLOAD_NAME = "Acceleration Structure Build";
    private final int primitiveCount;
    private final @NonNull AccelerationStructureBuildType type;

    public AccelerationStructureBuild(@NonNull String @NonNull [] stringArray, long l, long l2, long l3, int n, @NonNull AccelerationStructureBuildType accelerationStructureBuildType) {
        super(WORKLOAD_NAME, stringArray, l, l2, l3);
        this.primitiveCount = n;
        this.type = accelerationStructureBuildType;
        this.addProperties();
    }

    @Override
    public void accept(@NonNull ILabelVisitor iLabelVisitor) {
        iLabelVisitor.visit(this);
    }

    private void addProperties() {
        if (this.primitiveCount < 0) {
            this.addProperty("Build size", "Unknown");
        } else {
            String string = this.primitiveCount != 1 ? "s" : "";
            this.addProperty("Build size", String.format("%d primitive%s", this.primitiveCount, string));
        }
    }

    public @NonNull AccelerationStructureBuildType getBuildType() {
        return this.type;
    }

    public long getPrimitiveCount() {
        return this.primitiveCount;
    }

    @Override
    public String toString() {
        return "AccelerationStructureBuild[primitiveCount=" + this.primitiveCount + ", type=" + String.valueOf((Object)this.type) + ", super=" + super.toString() + "]";
    }
}

