/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.impl;

import com.arm.streamline.jni.apcdbgen.impl.ICloseableSamplesReportDataForDisasmAndSourceAnnotations;
import com.arm.streamline.jni.apcdbgen.impl.INativeColumn;
import com.arm.streamline.jni.apcdbgen.impl.ListOfUIDObjects;
import com.arm.streamline.jni.apcdbgen.impl.SamplesReport;
import com.arm.streamline.jni.apcdbgen.proto.CallPathFunctions;
import com.arm.streamline.jni.apcdbgen.proto.CallPathNode;
import com.arm.streamline.jni.apcdbgen.proto.ICallPathFunctions;
import com.arm.streamline.jni.apcdbgen.proto.IColumnDescriptor;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterColumnAccessorFactory;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReportData;
import com.arm.streamline.jni.apcdbgen.proto.ImageFile;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.common.CancellationPredicate;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.jni.common.IProgressMonitorFactory;
import com.arm.streamline.jni.common.NativeHandle;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SamplesReportData
implements ISamplesReportData {
    protected final @NonNull SamplesReport samplesReport;
    private final @NonNull List<@NonNull ImageFile> imagesWithAnySamples;
    private final boolean invertCallStacks;
    private final @NonNull NativeHandle nativeHandle;
    private final @NonNull List<@NonNull NodeToRootNode> nodeToRootNode = new ArrayList<NodeToRootNode>();
    private final @NonNull List<@NonNull CallPathNode> rooCallPathNodes;
    private final @NonNull Set<@NonNull CallPathNode> rootNodes = new HashSet<CallPathNode>();

    protected static @Nullable SamplesReportData tryFromHandle(@NonNull SamplesReport samplesReport, long l, @NonNull CallPathNode @NonNull [] callPathNodeArray, long @NonNull [] lArray, boolean bl) {
        if (l == 0L) {
            return null;
        }
        return new SamplesReportData(samplesReport, l, Arrays.asList(callPathNodeArray), lArray, bl);
    }

    private static native @Nullable ICloseableSamplesReportDataForDisasmAndSourceAnnotations computeDisasmAndSourceData(@NonNull SamplesReportData var0, long var1, long var3, long var5, boolean var7, @NonNull IProgressMonitorFactory var8) throws CodecException, IOException;

    private static native void destroyHandle(long var0);

    private static native long getCallPathCumulativeForColumn(long var0, long var2, long var4);

    private static native @Nullable ISampleCounterColumnAccessorFactory.HistogramValue getCallPathFunctionValueForHistogramColumn(long var0, long var2, long var4, long @NonNull [] var6);

    private static native @Nullable Number getCallPathFunctionValueForNumberColumn(long var0, long var2, long var4, long @NonNull [] var6);

    private static native @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong getCallPathFunctionValueForPercentAndLongColumn(long var0, long var2, long var4, long @NonNull [] var6);

    private static native long getCallPathSelfForColumn(long var0, long var2, long var4);

    private static native @Nullable ISampleCounterColumnAccessorFactory.HistogramValue getCallPathValueForHistogramColumn(long var0, long var2, long var4, boolean var6);

    private static native @Nullable Number getCallPathValueForNumberColumn(long var0, long var2, long var4, boolean var6);

    private static native @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong getCallPathValueForPercentAndLongColumn(long var0, long var2, long var4, boolean var6);

    private static native long getFunctionCumulativeForColumn(long var0, long var2, long var4);

    private static native long getFunctionGlobalTotalForColumn(long var0, long var2);

    private static native double getFunctionGlobalTotalForNumberColumn(long var0, long var2);

    private static native long getFunctionGlobalTotalForPercentAndLongColumn(long var0, long var2);

    private static native long getFunctionLargestSelfForColumn(long var0, long var2);

    private static native long getFunctionSelfForColumn(long var0, long var2, long var4);

    private static native @Nullable ISampleCounterColumnAccessorFactory.HistogramValue getFunctionSelfForHistogramColumn(long var0, long var2, long var4);

    private static native @Nullable Number getFunctionSelfForNumberColumn(long var0, long var2, long var4);

    private static native @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong getFunctionSelfForPercentAndLongColumn(long var0, long var2, long var4);

    private static void recursivelyPopulate(@NonNull List<@NonNull NodeToRootNode> list, @NonNull Set<@NonNull CallPathNode> set, @NonNull List<@NonNull CallPathNode> list2, @Nullable CallPathNode callPathNode) {
        for (CallPathNode callPathNode2 : list2) {
            CallPathNode callPathNode3;
            switch (callPathNode2.type) {
                case VMUID: {
                    if (callPathNode != null) {
                        throw new AssertionError((Object)"Unexpected CP tree structure");
                    }
                    callPathNode3 = callPathNode;
                    break;
                }
                case PROCESS: {
                    if (callPathNode != null) {
                        throw new AssertionError((Object)"Unexpected CP tree structure");
                    }
                    callPathNode3 = callPathNode2;
                    set.add(callPathNode2);
                    break;
                }
                case THREAD: 
                case SYMBOL: {
                    if (callPathNode != null) {
                        callPathNode3 = callPathNode;
                        break;
                    }
                    callPathNode3 = callPathNode2;
                    set.add(callPathNode2);
                    break;
                }
                default: {
                    throw new AssertionError((Object)callPathNode2.type);
                }
            }
            if (callPathNode3 != null) {
                list.add(new NodeToRootNode(callPathNode2, callPathNode3));
            }
            SamplesReportData.recursivelyPopulate(list, set, Arrays.asList(callPathNode2.children), callPathNode3);
        }
    }

    private SamplesReportData(@NonNull SamplesReport samplesReport, long l2, @NonNull List<@NonNull CallPathNode> list, long @NonNull [] lArray, boolean bl) {
        assert (l2 != 0L);
        this.nativeHandle = new NativeHandle(l2, SamplesReportData::destroyHandle);
        this.samplesReport = samplesReport;
        this.rooCallPathNodes = list;
        this.invertCallStacks = bl;
        SamplesReportData.recursivelyPopulate(this.nodeToRootNode, this.rootNodes, list, null);
        this.nodeToRootNode.sort((nodeToRootNode, nodeToRootNode2) -> Long.compareUnsigned(nodeToRootNode.node.uid, nodeToRootNode2.node.uid));
        ArrayList arrayList = Arrays.stream(lArray).mapToObj(l -> Objects.requireNonNull(ListOfUIDObjects.findObjectByUID(samplesReport.images, l, imageFile -> imageFile.uid))).collect(Collectors.toCollection(ArrayList::new));
        arrayList.sort((imageFile, imageFile2) -> Long.compareUnsigned(imageFile.uid, imageFile2.uid));
        this.imagesWithAnySamples = Collections.unmodifiableList(arrayList);
    }

    @Override
    public void close() throws Exception {
        this.nativeHandle.close();
    }

    @Override
    public @NonNull ICallPathFunctions computeCallPathFunctions(@NonNull CallPathNode callPathNode) {
        return new CallPathFunctions(this, callPathNode, this::getCallPathFunctionsDataAccessorFor, this::getTopCallpathsFunctionsMetricSupplier);
    }

    @Override
    public @Nullable ICloseableSamplesReportDataForDisasmAndSourceAnnotations computeDisasmAndSourceData(long l, boolean bl, @NonNull CancellationPredicate cancellationPredicate, @NonNull IProgressMonitorFactory iProgressMonitorFactory) throws CodecException, IOException {
        return this.nativeHandle.doWithResult(l2 -> cancellationPredicate.doWithResult(l3 -> SamplesReportData.computeDisasmAndSourceData(this, l2, l3, l, bl, iProgressMonitorFactory)));
    }

    @Override
    public @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong computePercentOfTotalOfCallPathSamplesCount(@NonNull LongStream longStream) {
        for (INativeColumn iNativeColumn : this.samplesReport.nativeColumns) {
            if (!iNativeColumn.isPeriodicSamples()) continue;
            return iNativeColumn.computePercentOfTotalOfCallPathSamplesCount(this, longStream);
        }
        return null;
    }

    @Override
    public @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong computePercentOfTotalOfReferencedSymbolSamplesCount(@NonNull LongStream longStream) {
        for (INativeColumn iNativeColumn : this.samplesReport.nativeColumns) {
            if (!iNativeColumn.isPeriodicSamples()) continue;
            return iNativeColumn.computePercentOfTotalOfReferencedSymbolSamplesCount(this, longStream);
        }
        return null;
    }

    @Override
    public @NonNull List<@NonNull CallPathNode> getCallPathRoots() {
        return Collections.unmodifiableList(this.rooCallPathNodes);
    }

    @Override
    public <D, R, E extends Throwable> R getCallPathsDataAccessorFor(@NonNull IColumnDescriptor iColumnDescriptor, boolean bl, @NonNull ISampleCounterColumnAccessorFactory<D, R, E> iSampleCounterColumnAccessorFactory, D d) throws E {
        for (INativeColumn iNativeColumn : this.samplesReport.nativeColumns) {
            INativeColumn.IAccessorFor iAccessorFor = iNativeColumn.getCallPathsDataAccessorFor(this, iColumnDescriptor, bl);
            if (iAccessorFor == null) continue;
            return iAccessorFor.apply(iSampleCounterColumnAccessorFactory, d);
        }
        throw new IllegalArgumentException("Invalid column " + iColumnDescriptor.getTitle());
    }

    @Override
    public <D, R, E extends Throwable> R getFunctionDataAccessorFor(@NonNull IColumnDescriptor iColumnDescriptor, @NonNull ISampleCounterColumnAccessorFactory<D, R, E> iSampleCounterColumnAccessorFactory, D d) throws E {
        for (INativeColumn iNativeColumn : this.samplesReport.nativeColumns) {
            INativeColumn.IAccessorFor iAccessorFor = iNativeColumn.getFunctionDataAccessorFor(this, iColumnDescriptor);
            if (iAccessorFor == null) continue;
            return iAccessorFor.apply(iSampleCounterColumnAccessorFactory, d);
        }
        throw new IllegalArgumentException("Invalid column " + iColumnDescriptor.getTitle());
    }

    @Override
    public @NonNull List<@NonNull ImageFile> getImagesWithAnySamples() {
        return this.imagesWithAnySamples;
    }

    @Override
    public @NonNull SamplesReport getParentReport() {
        return this.samplesReport;
    }

    @Override
    public @Nullable LongFunction<@Nullable ISampleCounterColumnAccessorFactory.PercentAndLong> getTopCallpathsMetricSupplier(boolean bl) {
        for (INativeColumn iNativeColumn : this.samplesReport.nativeColumns) {
            LongFunction<ISampleCounterColumnAccessorFactory.PercentAndLong> longFunction = iNativeColumn.getTopCallpathsMetricSupplier(this, bl);
            if (longFunction == null) continue;
            return longFunction;
        }
        return null;
    }

    @Override
    public @Nullable LongFunction<@Nullable ISampleCounterColumnAccessorFactory.PercentAndLong> getTopFunctionsMetricSupplier(boolean bl) {
        for (INativeColumn iNativeColumn : this.samplesReport.nativeColumns) {
            LongFunction<ISampleCounterColumnAccessorFactory.PercentAndLong> longFunction = iNativeColumn.getTopFunctionsMetricSupplier(this, bl);
            if (longFunction == null) continue;
            return longFunction;
        }
        return null;
    }

    protected long getCallPathCumulativeForColumn(long l, long l2) {
        return this.nativeHandle.doWithResult(l3 -> SamplesReportData.getCallPathCumulativeForColumn(l3, l, l2));
    }

    protected @Nullable ISampleCounterColumnAccessorFactory.HistogramValue getCallPathFunctionValueForHistogramColumn(long l, long l2, long @NonNull [] lArray) {
        return this.nativeHandle.doWithResult(l3 -> SamplesReportData.getCallPathFunctionValueForHistogramColumn(l3, l, l2, lArray));
    }

    protected @Nullable Number getCallPathFunctionValueForNumberColumn(long l, long l2, long @NonNull [] lArray) {
        return this.nativeHandle.doWithResult(l3 -> SamplesReportData.getCallPathFunctionValueForNumberColumn(l3, l, l2, lArray));
    }

    protected @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong getCallPathFunctionValueForPercentAndLongColumn(long l, long l2, long @NonNull [] lArray) {
        return this.nativeHandle.doWithResult(l3 -> SamplesReportData.getCallPathFunctionValueForPercentAndLongColumn(l3, l, l2, lArray));
    }

    protected long getCallPathProcessTotalForColumn(long l, long l3) {
        NodeToRootNode nodeToRootNode = this.findNodeAndRootNode(l3);
        if (nodeToRootNode == null) {
            return -1L;
        }
        return this.nativeHandle.doWithResult(l2 -> SamplesReportData.getCallPathCumulativeForColumn(l2, l, nodeToRootNode.rootNode.uid));
    }

    protected long getCallPathSelfForColumn(long l, long l2) {
        return this.nativeHandle.doWithResult(l3 -> SamplesReportData.getCallPathSelfForColumn(l3, l, l2));
    }

    protected @Nullable ISampleCounterColumnAccessorFactory.HistogramValue getCallPathValueForHistogramColumn(long l, long l2, boolean bl) {
        return this.nativeHandle.doWithResult(l3 -> SamplesReportData.getCallPathValueForHistogramColumn(l3, l, l2, bl));
    }

    protected @Nullable Number getCallPathValueForNumberColumn(long l, long l2, boolean bl) {
        return this.nativeHandle.doWithResult(l3 -> SamplesReportData.getCallPathValueForNumberColumn(l3, l, l2, bl));
    }

    protected @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong getCallPathValueForPercentAndLongColumn(long l, long l2, boolean bl) {
        return this.nativeHandle.doWithResult(l3 -> SamplesReportData.getCallPathValueForPercentAndLongColumn(l3, l, l2, bl));
    }

    protected long getFunctionCumulativeForColumn(long l, long l2) {
        return this.nativeHandle.doWithResult(l3 -> SamplesReportData.getFunctionCumulativeForColumn(l3, l, l2));
    }

    protected long getFunctionGlobalTotalForColumn(long l) {
        return this.nativeHandle.doWithResult(l2 -> SamplesReportData.getFunctionGlobalTotalForColumn(l2, l));
    }

    protected double getFunctionGlobalTotalForNumberColumn(long l) {
        return this.nativeHandle.doWithResult(l2 -> SamplesReportData.getFunctionGlobalTotalForNumberColumn(l2, l));
    }

    protected long getFunctionGlobalTotalForPercentAndLongColumn(long l) {
        return this.nativeHandle.doWithResult(l2 -> SamplesReportData.getFunctionGlobalTotalForPercentAndLongColumn(l2, l));
    }

    protected long getFunctionLargestSelfForColumn(long l) {
        return this.nativeHandle.doWithResult(l2 -> SamplesReportData.getFunctionLargestSelfForColumn(l2, l));
    }

    protected long getFunctionSelfForColumn(long l, long l2) {
        return this.nativeHandle.doWithResult(l3 -> SamplesReportData.getFunctionSelfForColumn(l3, l, l2));
    }

    protected @Nullable ISampleCounterColumnAccessorFactory.HistogramValue getFunctionSelfForHistogramColumn(long l, long l2) {
        return this.nativeHandle.doWithResult(l3 -> SamplesReportData.getFunctionSelfForHistogramColumn(l3, l, l2));
    }

    protected @Nullable Number getFunctionSelfForNumberColumn(long l, long l2) {
        return this.nativeHandle.doWithResult(l3 -> SamplesReportData.getFunctionSelfForNumberColumn(l3, l, l2));
    }

    protected @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong getFunctionSelfForPercentAndLongColumn(long l, long l2) {
        return this.nativeHandle.doWithResult(l3 -> SamplesReportData.getFunctionSelfForPercentAndLongColumn(l3, l, l2));
    }

    protected @Nullable ReferencedSymbol mapCallPathUIDToReferencedSymbol(long l) {
        NodeToRootNode nodeToRootNode = this.findNodeAndRootNode(l);
        if (nodeToRootNode == null) {
            return null;
        }
        return nodeToRootNode.node.symbol;
    }

    private @Nullable NodeToRootNode findNodeAndRootNode(long l) {
        return ListOfUIDObjects.findObjectByUID(this.nodeToRootNode, l, nodeToRootNode -> nodeToRootNode.node.uid);
    }

    private <D, R, E extends Throwable> R getCallPathFunctionsDataAccessorFor(@NonNull IColumnDescriptor iColumnDescriptor, @NonNull CallPathNode callPathNode, @NonNull Map<@NonNull ReferencedSymbol, @NonNull Set<@NonNull CallPathNode>> map, @NonNull ISampleCounterColumnAccessorFactory<D, R, E> iSampleCounterColumnAccessorFactory, D d) throws E {
        TLongObjectHashMap tLongObjectHashMap = new TLongObjectHashMap();
        for (Map.Entry<ReferencedSymbol, Set<CallPathNode>> object : map.entrySet()) {
            tLongObjectHashMap.put(object.getKey().uid, object.getValue());
        }
        for (INativeColumn iNativeColumn : this.samplesReport.nativeColumns) {
            INativeColumn.IAccessorFor iAccessorFor = iNativeColumn.getCallPathsFunctionDataAccessorFor(this, iColumnDescriptor, callPathNode, map, (TLongObjectMap<Set<CallPathNode>>)tLongObjectHashMap);
            if (iAccessorFor == null) continue;
            return iAccessorFor.apply(iSampleCounterColumnAccessorFactory, d);
        }
        throw new IllegalArgumentException("Invalid column request" + iColumnDescriptor.getTitle());
    }

    private @Nullable LongFunction<@Nullable ISampleCounterColumnAccessorFactory.PercentAndLong> getTopCallpathsFunctionsMetricSupplier(@NonNull CallPathNode callPathNode, @NonNull Map<@NonNull ReferencedSymbol, @NonNull Set<@NonNull CallPathNode>> map) {
        for (INativeColumn iNativeColumn : this.samplesReport.nativeColumns) {
            LongFunction<ISampleCounterColumnAccessorFactory.PercentAndLong> longFunction = iNativeColumn.getTopCallpathsFunctionsMetricSupplier(this, callPathNode, map);
            if (longFunction == null) continue;
            return longFunction;
        }
        return null;
    }

    private record NodeToRootNode(@NonNull CallPathNode node, @NonNull CallPathNode rootNode) {
    }
}

