/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.impl;

import com.arm.streamline.jni.apcdbgen.ProfilingFilterParams;
import com.arm.streamline.jni.apcdbgen.ProfilingLoadOptions;
import com.arm.streamline.jni.apcdbgen.impl.CallPathNodeBuilder;
import com.arm.streamline.jni.apcdbgen.impl.INativeColumn;
import com.arm.streamline.jni.apcdbgen.impl.IUniqueIDsHelper;
import com.arm.streamline.jni.apcdbgen.impl.ListOfUIDObjects;
import com.arm.streamline.jni.apcdbgen.impl.ProfilingReportGroup;
import com.arm.streamline.jni.apcdbgen.impl.SamplesReportData;
import com.arm.streamline.jni.apcdbgen.impl.SamplesReportPeriodicSamplesData;
import com.arm.streamline.jni.apcdbgen.proto.IColumnDescriptor;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReport;
import com.arm.streamline.jni.apcdbgen.proto.ImageFile;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.common.CancellationPredicate;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.jni.common.IProgressMonitorFactory;
import com.arm.streamline.jni.common.NativeHandle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SamplesReport
implements ISamplesReport,
AutoCloseable,
Comparable<SamplesReport> {
    protected final @NonNull List<@NonNull ImageFile> images;
    protected final @NonNull List<@NonNull INativeColumn> nativeColumns;
    private final @NonNull List<@NonNull IColumnDescriptor> callPathColumns;
    private final @NonNull List<@NonNull IColumnDescriptor> callPathFunctionColumns;
    private final @NonNull List<@NonNull IColumnDescriptor> functionColumns;
    private final @NonNull ProfilingReportGroup group;
    private final @NonNull List<@NonNull IColumnDescriptor> instructionAndSourceLineColumns;
    private final @NonNull String label;
    private final @NonNull NativeHandle nativeHandle;
    private final boolean nestedCallStacks;
    private final boolean periodicSamplesCount;
    private final @NonNull List<@NonNull ReferencedSymbol> referencedSymbols;
    private final @NonNull IUniqueIDsHelper uniqueIDsHelper;

    protected static @Nullable ReferencedSymbol findReferencedSymbolByUid(@NonNull List<@NonNull ReferencedSymbol> list, long l) {
        return ListOfUIDObjects.findObjectByUID(list, l, referencedSymbol -> referencedSymbol.uid);
    }

    protected static @NonNull CallPathNodeBuilder makeCallPathNodeBuilder(@NonNull SamplesReport samplesReport, long @NonNull [] lArray, boolean bl) {
        return new CallPathNodeBuilder(samplesReport.uniqueIDsHelper, samplesReport.referencedSymbols, lArray, bl);
    }

    protected static @Nullable SamplesReport tryFromHandle(long l, long l2, @NonNull String string, @NonNull IUniqueIDsHelper iUniqueIDsHelper, @NonNull ReferencedSymbol @NonNull [] referencedSymbolArray, @NonNull INativeColumn @NonNull [] iNativeColumnArray, boolean bl, boolean bl2) {
        if (l == 0L) {
            return null;
        }
        return new SamplesReport(l, ProfilingReportGroup.fromLong(l2), string, iUniqueIDsHelper, Arrays.asList(referencedSymbolArray), Arrays.asList(iNativeColumnArray), bl, bl2);
    }

    private static native @Nullable SamplesReportPeriodicSamplesData computeFilteredPeriodicSamplesCount(@NonNull SamplesReport var0, long var1, long var3, @NonNull IProgressMonitorFactory var5, @NonNull String @Nullable [] var6, @NonNull String @Nullable [] var7, int @Nullable [] var8, int @Nullable [] var9, int @Nullable [] var10, int @Nullable [] var11, long @Nullable [] var12, long @Nullable [] var13, long @Nullable [] var14, long @Nullable [] var15, long var16, long var18, boolean var20, boolean var21, long var22, boolean var24);

    private static native @Nullable SamplesReportData computeFilteredSampleData(@NonNull SamplesReport var0, long var1, long var3, @NonNull IProgressMonitorFactory var5, @NonNull String @Nullable [] var6, @NonNull String @Nullable [] var7, int @Nullable [] var8, int @Nullable [] var9, int @Nullable [] var10, int @Nullable [] var11, long @Nullable [] var12, long @Nullable [] var13, long @Nullable [] var14, long @Nullable [] var15, long var16, long var18, boolean var20, boolean var21, long var22, boolean var24, boolean var25, boolean var26, boolean var27);

    private static native void destroyHandle(long var0);

    private static boolean isExcludedColumn(@NonNull INativeColumn iNativeColumn) {
        if (iNativeColumn.getParent() != null) {
            assert (!iNativeColumn.isInternalColumn());
            return false;
        }
        boolean bl = "true".equalsIgnoreCase(System.getProperty("streamline.enable_internal_columns", "false"));
        return bl || !iNativeColumn.isInternalColumn();
    }

    private SamplesReport(long l, @NonNull ProfilingReportGroup profilingReportGroup, @NonNull String string, @NonNull IUniqueIDsHelper iUniqueIDsHelper, @NonNull List<@NonNull ReferencedSymbol> list, @NonNull List<@NonNull INativeColumn> list2, boolean bl, boolean bl2) {
        assert (l != 0L);
        this.nativeHandle = new NativeHandle(l, SamplesReport::destroyHandle);
        list.sort((referencedSymbol, referencedSymbol2) -> {
            int n = Long.compareUnsigned(referencedSymbol.uid, referencedSymbol2.uid);
            if (n == 0) {
                n = referencedSymbol.symbol.compareTo(referencedSymbol2.symbol);
            }
            return n;
        });
        list2.sort((iNativeColumn, iNativeColumn2) -> {
            int n = -Boolean.compare(iNativeColumn.isPeriodicSamples(), iNativeColumn2.isPeriodicSamples());
            if (n == 0) {
                n = Long.compareUnsigned(iNativeColumn.getColumnUID(), iNativeColumn2.getColumnUID());
            }
            return n;
        });
        this.group = profilingReportGroup;
        this.label = string;
        this.uniqueIDsHelper = iUniqueIDsHelper;
        this.nativeColumns = list2;
        this.referencedSymbols = Collections.unmodifiableList(list);
        this.callPathColumns = list2.stream().filter(SamplesReport::isExcludedColumn).map(INativeColumn::getCallPathColumns).flatMap(Collection::stream).collect(Collectors.toList());
        this.callPathFunctionColumns = list2.stream().filter(SamplesReport::isExcludedColumn).map(INativeColumn::getCallPathFunctionColumns).flatMap(Collection::stream).collect(Collectors.toList());
        this.functionColumns = list2.stream().filter(SamplesReport::isExcludedColumn).map(INativeColumn::getFunctionColumns).flatMap(Collection::stream).collect(Collectors.toList());
        this.instructionAndSourceLineColumns = list2.stream().filter(SamplesReport::isExcludedColumn).map(INativeColumn::getInstructionAndSourceLineColumns).flatMap(Collection::stream).collect(Collectors.toList());
        this.periodicSamplesCount = bl;
        this.nestedCallStacks = bl2;
        ArrayList arrayList = list.stream().map(referencedSymbol -> referencedSymbol.symbol.image).distinct().collect(Collectors.toCollection(ArrayList::new));
        arrayList.sort((imageFile, imageFile2) -> Long.compareUnsigned(imageFile.uid, imageFile2.uid));
        this.images = Collections.unmodifiableList(arrayList);
    }

    @Override
    public boolean canFilterStacksDynamically() {
        return this.hasNestedCallStacks();
    }

    @Override
    public void close() throws Exception {
        this.nativeHandle.close();
    }

    @Override
    public int compareTo(@NonNull SamplesReport samplesReport) {
        int n = -Boolean.compare(this.periodicSamplesCount, samplesReport.periodicSamplesCount);
        if (n == 0) {
            n = this.group.compareTo(samplesReport.group);
        }
        if (n == 0) {
            n = this.label.compareToIgnoreCase(samplesReport.label);
        }
        return n;
    }

    @Override
    public @Nullable SamplesReportPeriodicSamplesData computeFilteredPeriodicSamplesCount(@NonNull ProfilingFilterParams profilingFilterParams, @NonNull ProfilingLoadOptions profilingLoadOptions, @NonNull CancellationPredicate cancellationPredicate, @NonNull IProgressMonitorFactory iProgressMonitorFactory) throws CodecException, IOException {
        return this.nativeHandle.doWithResult(l -> cancellationPredicate.doWithResult(l2 -> SamplesReport.computeFilteredPeriodicSamplesCount(this, l, l2, iProgressMonitorFactory, ProfilingFilterParams.toStringList(profilingFilterParams.filterProcessNames()), ProfilingFilterParams.toStringList(profilingFilterParams.filterThreadNames()), profilingFilterParams.filterPidsIncluded(), profilingFilterParams.filterPidsExcluded(), profilingFilterParams.filterTidsIncluded(), profilingFilterParams.filterTidsExcluded(), profilingFilterParams.filterUPidsIncluded(), profilingFilterParams.filterUPidsExcluded(), profilingFilterParams.filterUTidsIncluded(), profilingFilterParams.filterUTidsExcluded(), ProfilingFilterParams.toRangeFrom(profilingFilterParams.timeRangeFrom()), ProfilingFilterParams.toRangeTo(profilingFilterParams.timeRangeTo()), profilingFilterParams.filterCallStack(), profilingFilterParams.filterKernelAddresses(), profilingLoadOptions.nestedMetricFilter(), profilingLoadOptions.useInlinedSymbols())));
    }

    @Override
    public @Nullable SamplesReportData computeFilteredSampleData(@NonNull ProfilingFilterParams profilingFilterParams, @NonNull ProfilingLoadOptions profilingLoadOptions, @NonNull CancellationPredicate cancellationPredicate, @NonNull IProgressMonitorFactory iProgressMonitorFactory) throws CodecException, IOException {
        return this.nativeHandle.doWithResult(l -> cancellationPredicate.doWithResult(l2 -> SamplesReport.computeFilteredSampleData(this, l, l2, iProgressMonitorFactory, ProfilingFilterParams.toStringList(profilingFilterParams.filterProcessNames()), ProfilingFilterParams.toStringList(profilingFilterParams.filterThreadNames()), profilingFilterParams.filterPidsIncluded(), profilingFilterParams.filterPidsExcluded(), profilingFilterParams.filterTidsIncluded(), profilingFilterParams.filterTidsExcluded(), profilingFilterParams.filterUPidsIncluded(), profilingFilterParams.filterUPidsExcluded(), profilingFilterParams.filterUTidsIncluded(), profilingFilterParams.filterUTidsExcluded(), ProfilingFilterParams.toRangeFrom(profilingFilterParams.timeRangeFrom()), ProfilingFilterParams.toRangeTo(profilingFilterParams.timeRangeTo()), profilingFilterParams.filterCallStack(), profilingFilterParams.filterKernelAddresses(), profilingLoadOptions.nestedMetricFilter(), profilingLoadOptions.useInlinedSymbols(), profilingLoadOptions.loadInstructionSlotData(), profilingLoadOptions.loadSourceData(), profilingLoadOptions.invertCallStacks())));
    }

    @Override
    public @NonNull List<@NonNull IColumnDescriptor> getCallPathColumns() {
        return Collections.unmodifiableList(this.callPathColumns);
    }

    @Override
    public @NonNull List<@NonNull IColumnDescriptor> getCallPathFunctionColumns() {
        return Collections.unmodifiableList(this.callPathFunctionColumns);
    }

    @Override
    public @NonNull List<@NonNull IColumnDescriptor> getFunctionColumns() {
        return Collections.unmodifiableList(this.functionColumns);
    }

    @Override
    public @NonNull List<@NonNull IColumnDescriptor> getInstructionAndSourceLineColumns() {
        return Collections.unmodifiableList(this.instructionAndSourceLineColumns);
    }

    @Override
    public @NonNull String getLabel() {
        return this.label;
    }

    @Override
    public @NonNull List<@NonNull ReferencedSymbol> getSymbols() {
        return Collections.unmodifiableList(this.referencedSymbols);
    }

    @Override
    public boolean hasNestedCallStacks() {
        return this.nestedCallStacks;
    }

    @Override
    public boolean hasPeriodicSamplesCount() {
        return this.periodicSamplesCount;
    }
}

