/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.impl;

import com.arm.streamline.jni.apcdbgen.impl.CAMTrack;
import com.arm.streamline.jni.apcdbgen.proto.ICAMJob;
import com.arm.streamline.jni.apcdbgen.proto.ICAMTrack;
import com.arm.streamline.jni.apcdbgen.proto.IGPUWorkloadJob;
import com.arm.streamline.jni.apcdbgen.proto.PerfettoWorkload;
import com.arm.streamline.jni.apcdbgen.proto.TimelineWorkload;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GPUWorkloadJob
implements IGPUWorkloadJob {
    private final int uid;
    private final @NonNull CAMTrack track;
    private final long start;
    private final long stop;
    private final @NonNull TimelineWorkload timelineWorkload;
    private final @NonNull PerfettoWorkload perfettoWorkload;
    private final @NonNull String detailText;

    public GPUWorkloadJob(int n, long l, long l2, @NonNull CAMTrack cAMTrack, @NonNull TimelineWorkload timelineWorkload, @NonNull PerfettoWorkload perfettoWorkload) {
        this.uid = n;
        this.start = l;
        this.stop = l2;
        this.track = cAMTrack;
        this.timelineWorkload = timelineWorkload;
        this.perfettoWorkload = perfettoWorkload;
        this.detailText = this.buildDetailText();
    }

    private @NonNull String buildDetailText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.timelineWorkload.getName()).append(':').append('\n');
        for (Map.Entry<String, String> object : this.timelineWorkload.getProperties().entrySet()) {
            stringBuilder.append(String.format("  %s: %s\n", object.getKey(), object.getValue()));
        }
        List<String> list = this.timelineWorkload.getDebugLabels();
        if (!list.isEmpty()) {
            stringBuilder.append('\n');
            stringBuilder.append("Debug Labels:\n");
            for (String string : this.timelineWorkload.getDebugLabels()) {
                string = string.replace("\r\n", "");
                string = string.replace("\n", "");
                string = string.replace("\t", "");
                for (int i = 0; i < string.length(); i += 50) {
                    stringBuilder.append("  ");
                    if (i > 0) {
                        stringBuilder.append("  ");
                    }
                    stringBuilder.append(string.substring(i, Math.min(i + 50, string.length()))).append('\n');
                }
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public int getId() {
        return this.uid;
    }

    @Override
    public int getColor() {
        return -4911559;
    }

    @Override
    public @NonNull List<@NonNull ICAMJob> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public @NonNull List<@NonNull ICAMJob> getDependents() {
        return Collections.emptyList();
    }

    @Override
    public @NonNull String getName() {
        return this.timelineWorkload.toString() + "\n" + this.perfettoWorkload.toString();
    }

    @Override
    public @NonNull String getDetailText() {
        return this.detailText;
    }

    @Override
    public @Nullable ICAMJob getPrimaryDependency() {
        return null;
    }

    @Override
    public @Nullable ICAMJob getPrimaryDependent() {
        return null;
    }

    @Override
    public long getStartTime() {
        return this.start;
    }

    @Override
    public long getStopTime() {
        return this.stop;
    }

    @Override
    public @NonNull ICAMTrack getTrack() {
        return this.track;
    }

    @Override
    public @NonNull TimelineWorkload getTimelineWorkload() {
        return this.timelineWorkload;
    }

    @Override
    public @NonNull PerfettoWorkload getPerfettoWorkload() {
        return this.perfettoWorkload;
    }
}

