/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.impl;

import com.arm.streamline.jni.apcdbgen.impl.IUniqueIDsHelper;
import com.arm.streamline.jni.apcdbgen.impl.SamplesReport;
import com.arm.streamline.jni.apcdbgen.proto.CallPathNode;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueProcessID;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueThreadID;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class CallPathNodeBuilder {
    protected final boolean invertCallStacks;
    protected @Nullable CallPathNode invertCallStacksRoot = null;
    protected final @NonNull Map<@NonNull IUniqueProcessID, @NonNull ProcessState> processStates = new HashMap<IUniqueProcessID, ProcessState>();
    protected final @NonNull List<@NonNull ReferencedSymbol> referencedSymbols;
    protected long uidCounter = 0L;
    protected final @NonNull IUniqueIDsHelper uniqueIDsHelper;

    public CallPathNodeBuilder(@NonNull IUniqueIDsHelper iUniqueIDsHelper, @NonNull List<@NonNull ReferencedSymbol> list, long @NonNull [] lArray, boolean bl) {
        this.uniqueIDsHelper = iUniqueIDsHelper;
        this.invertCallStacks = bl;
        this.referencedSymbols = list;
        if (bl) {
            if (lArray.length > 1) {
                throw new IllegalArgumentException("inverted call stacks should only have one root");
            }
        } else {
            CallPathNode[] callPathNodeArray;
            Object object;
            HashMap<IUniqueProcessID, Integer> hashMap = new HashMap<IUniqueProcessID, Integer>();
            HashSet<IUniqueProcessID> hashSet = new HashSet<IUniqueProcessID>();
            HashSet<IUniqueProcessID> hashSet2 = new HashSet<IUniqueProcessID>();
            for (long l : lArray) {
                object = iUniqueIDsHelper.getProcessForThreadUID(l);
                hashMap.compute((IUniqueProcessID)object, (iUniqueProcessID, n) -> n != null ? Integer.valueOf(n + 1) : Integer.valueOf(1));
                callPathNodeArray = iUniqueIDsHelper.getThreadByUID(l);
                if (callPathNodeArray.isIdle() || callPathNodeArray.isKernel()) {
                    hashSet.add((IUniqueProcessID)object);
                    continue;
                }
                hashSet2.add((IUniqueProcessID)object);
            }
            Object object2 = hashMap.entrySet().iterator();
            while (object2.hasNext()) {
                Map.Entry entry = (Map.Entry)object2.next();
                IUniqueProcessID iUniqueProcessID2 = (IUniqueProcessID)entry.getKey();
                Integer n2 = (Integer)entry.getValue();
                boolean bl2 = hashSet.contains(iUniqueProcessID2) && !hashSet2.contains(iUniqueProcessID2);
                object = bl2 ? iUniqueProcessID2.getName() : String.format("%s #%d", iUniqueProcessID2.getName(), iUniqueProcessID2.getOriginalID());
                callPathNodeArray = new CallPathNode[n2.intValue()];
                CallPathNode callPathNode = new CallPathNode(CallPathNode.Type.PROCESS, ++this.uidCounter, iUniqueProcessID2.getUID(), null, null, (String)object, callPathNodeArray, null);
                ProcessState processState = new ProcessState(callPathNode);
                this.processStates.put(iUniqueProcessID2, processState);
            }
        }
    }

    public @NonNull CallPathNode @NonNull [] getRealRoots() {
        if (this.invertCallStacks) {
            CallPathNode callPathNode = this.invertCallStacksRoot;
            if (callPathNode == null) {
                return new CallPathNode[0];
            }
            return callPathNode.children;
        }
        return (CallPathNode[])this.processStates.values().stream().map(processState -> processState.processNode).toArray(CallPathNode[]::new);
    }

    public @NonNull CallPathNode makeForReferencedSymbolUID(@NonNull CallPathNode callPathNode, long l, @NonNull CallPathNode @NonNull [] callPathNodeArray) {
        ReferencedSymbol referencedSymbol = SamplesReport.findReferencedSymbolByUid(this.referencedSymbols, l);
        if (referencedSymbol == null) {
            throw new AssertionError((Object)("Missing symbol " + l));
        }
        String string = referencedSymbol.symbol.getName();
        return new CallPathNode(CallPathNode.Type.SYMBOL, ++this.uidCounter, referencedSymbol.uid, null, referencedSymbol, string, callPathNodeArray, callPathNode != this.invertCallStacksRoot ? callPathNode : null);
    }

    public @NonNull CallPathNode makeForThreadUID(long l, @NonNull CallPathNode @NonNull [] callPathNodeArray) {
        if (this.invertCallStacks) {
            CallPathNode callPathNode;
            if (this.invertCallStacksRoot != null) {
                throw new AssertionError((Object)"inverted call stacks root called twice");
            }
            this.invertCallStacksRoot = callPathNode = new CallPathNode(CallPathNode.Type.VMUID, ++this.uidCounter, 0L, null, null, "All Items", callPathNodeArray, null);
            return callPathNode;
        }
        IUniqueThreadID iUniqueThreadID = this.uniqueIDsHelper.getThreadByUID(l);
        IUniqueProcessID iUniqueProcessID = this.uniqueIDsHelper.getProcessForThreadUID(l);
        ProcessState processState = this.processStates.get(iUniqueProcessID);
        if (processState == null) {
            throw new AssertionError((Object)"missing process node");
        }
        if (processState.childIndex >= processState.processNode.children.length) {
            throw new AssertionError((Object)"too many thread nodes");
        }
        String string = String.format("%s #%s", iUniqueThreadID.getName(), Integer.toUnsignedString(iUniqueThreadID.getOriginalID()));
        CallPathNode callPathNode = new CallPathNode(CallPathNode.Type.THREAD, ++this.uidCounter, iUniqueThreadID.getUID(), iUniqueThreadID, null, string, callPathNodeArray, processState.processNode);
        processState.processNode.children[processState.childIndex++] = callPathNode;
        return callPathNode;
    }

    protected static final class ProcessState {
        public int childIndex = 0;
        public final @NonNull CallPathNode processNode;

        public ProcessState(@NonNull CallPathNode callPathNode) {
            this.processNode = callPathNode;
        }
    }
}

