/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.impl;

import com.arm.streamline.jni.apcdbgen.impl.CAMTrack;
import com.arm.streamline.jni.apcdbgen.proto.ICAMJob;
import com.arm.streamline.jni.apcdbgen.proto.ICAMTrack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CAMJob
implements ICAMJob {
    private final int uid;
    private final int colour;
    private final @NonNull CAMTrack track;
    private final @NonNull String name;
    private final @NonNull String detailText;
    private final long start;
    private final long stop;
    private final int primaryDependencyId;
    private final int primaryDependentId;
    private final int @NonNull [] dependencyIds;
    private final int @NonNull [] dependentIds;
    private @Nullable ICAMJob primaryDependency;
    private @Nullable ICAMJob primaryDependent;
    private final @NonNull List<@NonNull ICAMJob> dependencies;
    private final @NonNull List<@NonNull ICAMJob> dependents;

    public CAMJob(int n, int n2, @NonNull String string, @NonNull String string2, long l, long l2, @NonNull CAMTrack cAMTrack, int n3, int n4, int @NonNull [] nArray, int @NonNull [] nArray2) {
        this.uid = n;
        this.colour = n2;
        this.name = string;
        this.detailText = string2;
        this.start = l;
        this.stop = l2;
        this.track = cAMTrack;
        this.primaryDependencyId = n3;
        this.primaryDependentId = n4;
        this.dependencyIds = nArray;
        this.dependentIds = nArray2;
        this.primaryDependency = null;
        this.primaryDependent = null;
        this.dependencies = new ArrayList<ICAMJob>();
        this.dependents = new ArrayList<ICAMJob>();
    }

    public void updateDependencies(@NonNull Map<@NonNull Integer, @NonNull CAMJob> map) {
        int n;
        CAMJob cAMJob = map.get(this.primaryDependencyId);
        if (cAMJob != null) {
            this.primaryDependency = cAMJob;
        }
        if ((cAMJob = map.get(this.primaryDependentId)) != null) {
            this.primaryDependent = cAMJob;
        }
        for (n = 0; n < this.dependencyIds.length; ++n) {
            cAMJob = map.get(this.dependencyIds[n]);
            if (cAMJob == null) continue;
            this.dependencies.add(cAMJob);
        }
        for (n = 0; n < this.dependentIds.length; ++n) {
            cAMJob = map.get(this.dependentIds[n]);
            if (cAMJob == null) continue;
            this.dependents.add(cAMJob);
        }
    }

    @Override
    public int getId() {
        return this.uid;
    }

    @Override
    public int getColor() {
        return this.colour;
    }

    @Override
    public @NonNull List<@NonNull ICAMJob> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public int @NonNull [] getDependencyIds() {
        return this.dependencyIds;
    }

    @Override
    public @NonNull List<@NonNull ICAMJob> getDependents() {
        return Collections.unmodifiableList(this.dependents);
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull String getDetailText() {
        if (!this.detailText.isBlank()) {
            return this.detailText;
        }
        return this.getName();
    }

    @Override
    public @Nullable ICAMJob getPrimaryDependency() {
        return this.primaryDependency;
    }

    @Override
    public @Nullable ICAMJob getPrimaryDependent() {
        return this.primaryDependent;
    }

    @Override
    public long getStartTime() {
        return this.start;
    }

    @Override
    public long getStopTime() {
        return this.stop;
    }

    @Override
    public @NonNull ICAMTrack getTrack() {
        return this.track;
    }
}

