/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen;

import com.arm.streamline.jni.StreamlineLib;
import com.arm.streamline.jni.apcdbgen.AnalysisOptions;
import com.arm.streamline.jni.apcdbgen.AnalysisResult;
import com.arm.streamline.jni.apcdbgen.AnalysisResultCode;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.jni.common.Executor;
import com.arm.streamline.jni.common.IProgressMonitorFactory;
import com.arm.streamline.jni.common.NativeHandle;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ApcDbGenerator {
    private final @NonNull AtomicReference<NativeDbGeneratorHandle> activeHandle = new AtomicReference<Object>(null);
    private final @NonNull File apcDirectory;
    private final @NonNull ExecutorService executorService;
    private final @NonNull IProgressMonitorFactory progressMonitorFactory;
    private final @NonNull AnalysisOptions analysisOptions;

    public ApcDbGenerator(@NonNull AnalysisOptions analysisOptions, @NonNull File file, @NonNull ExecutorService executorService, @NonNull IProgressMonitorFactory iProgressMonitorFactory) {
        this.apcDirectory = file;
        this.executorService = executorService;
        this.progressMonitorFactory = iProgressMonitorFactory;
        this.analysisOptions = analysisOptions;
    }

    public void cancel() {
        NativeDbGeneratorHandle nativeDbGeneratorHandle = this.activeHandle.get();
        if (nativeDbGeneratorHandle != null) {
            nativeDbGeneratorHandle.cancel();
        }
    }

    public @NonNull AnalysisResult generateDb() throws CodecException, IOException {
        try {
            NativeDbGeneratorHandle nativeDbGeneratorHandle = new NativeDbGeneratorHandle();
            try {
                this.activeHandle.set(nativeDbGeneratorHandle);
                int n = nativeDbGeneratorHandle.run(this.analysisOptions, this.apcDirectory.getCanonicalPath(), new Executor(this.executorService, this.progressMonitorFactory));
                int n2 = n & Integer.MAX_VALUE;
                boolean bl = (n & Integer.MIN_VALUE) != 0;
                AnalysisResult analysisResult = new AnalysisResult(AnalysisResultCode.fromInt(n2), bl);
                nativeDbGeneratorHandle.close();
                return analysisResult;
            }
            catch (Throwable throwable) {
                try {
                    nativeDbGeneratorHandle.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.activeHandle.set(null);
        }
    }

    static {
        if (!StreamlineLib.isLoaded) {
            throw new AssertionError((Object)"Failed to load streamline JNI lib");
        }
    }

    private static class NativeDbGeneratorHandle
    implements AutoCloseable {
        private final @NonNull NativeHandle nativeHandle = new NativeHandle(NativeDbGeneratorHandle.createNativeGenerator(), NativeDbGeneratorHandle::destroyNativeGenerator);

        private static native long createNativeGenerator();

        private static native void destroyNativeGenerator(long var0);

        private static native void performCancel(long var0);

        private static native int performDbGeneration(long var0, boolean var2, boolean var3, boolean var4, boolean var5, @NonNull String @Nullable [] var6, @NonNull String var7, @NonNull Executor var8) throws CodecException, IOException;

        public void cancel() {
            this.nativeHandle.doIf(NativeDbGeneratorHandle::performCancel);
        }

        @Override
        public void close() {
            try {
                this.cancel();
            }
            finally {
                this.nativeHandle.close();
            }
        }

        public int run(@NonNull AnalysisOptions analysisOptions, String string, Executor executor) throws CodecException, IOException {
            return this.nativeHandle.doWithResult(l -> NativeDbGeneratorHandle.performDbGeneration(l, analysisOptions.forceClean(), analysisOptions.wantsBacktraceData(), analysisOptions.wantsSPEData(), analysisOptions.processDebugInfo(), analysisOptions.convertSearchImagePaths(), string, executor));
        }
    }
}

