/*
 * Decompiled with CFR 0.152.
 */
package com.arm.debug.dtsl.decoders.stm.stpprotocol;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class STPNibbleQueue {
    private List<NibbleBlock> nibbleQueue = new LinkedList<NibbleBlock>();
    private long nextBufferLocation;

    public synchronized void appendData(byte[] nibbleData) {
        if (nibbleData != null && nibbleData.length > 0) {
            NibbleBlock block = new NibbleBlock(nibbleData, 2 * nibbleData.length);
            block.setBufferLocation(this.nextBufferLocation);
            this.nibbleQueue.add(block);
        }
    }

    public synchronized void appendData(byte[] nibbleData, int nibbleCount) {
        if (nibbleData != null && nibbleData.length > 0 && nibbleCount > 0) {
            NibbleBlock block = new NibbleBlock(nibbleData, nibbleCount);
            block.setBufferLocation(this.nextBufferLocation);
            this.nibbleQueue.add(block);
        }
    }

    public synchronized void prependData(byte[] nibbleData) {
        if (nibbleData != null && nibbleData.length > 0) {
            long location = this.getBufferLocation();
            NibbleBlock block = new NibbleBlock(nibbleData, 2 * nibbleData.length);
            block.setBufferLocation(location - (long)nibbleData.length);
            this.nibbleQueue.add(0, block);
        }
    }

    public synchronized void prependData(byte[] nibbleData, int nibbleCount) {
        if (nibbleData != null && nibbleData.length > 0 && nibbleCount > 0) {
            long location = this.getBufferLocation();
            NibbleBlock block = new NibbleBlock(nibbleData, nibbleCount);
            block.setBufferLocation(location - (long)((nibbleCount + 1) / 2));
            this.nibbleQueue.add(0, block);
        }
    }

    public synchronized void flush() {
        this.nibbleQueue.clear();
    }

    public synchronized boolean hasAtLeast(int nibbleCount) {
        for (NibbleBlock dataBlock : this.nibbleQueue) {
            if ((nibbleCount -= dataBlock.length()) > 0) continue;
            return true;
        }
        return false;
    }

    public synchronized int length() {
        int length = 0;
        for (NibbleBlock dataBlock : this.nibbleQueue) {
            length += dataBlock.length();
        }
        return length;
    }

    public synchronized byte getNibble() throws IndexOutOfBoundsException {
        if (this.nibbleQueue.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        NibbleBlock dataBlock = this.nibbleQueue.get(0);
        byte b = dataBlock.getNibble();
        if (dataBlock.isOutOfData()) {
            this.nibbleQueue.remove(0);
        }
        return b;
    }

    public synchronized long getBufferLocation() throws IndexOutOfBoundsException {
        if (this.nibbleQueue.isEmpty()) {
            return 0L;
        }
        NibbleBlock dataBlock = this.nibbleQueue.get(0);
        return dataBlock.getBufferLocation();
    }

    public synchronized void setBufferLocation(long bufferLocation) {
        this.nextBufferLocation = bufferLocation;
    }

    public synchronized void dump(PrintWriter s, int nibbleWidth) {
        for (NibbleBlock dataBlock : this.nibbleQueue) {
            dataBlock.dump(s, nibbleWidth);
        }
    }

    public synchronized void binaryDump(FileOutputStream output) throws IOException {
        int nData = 0;
        int nibble = 0;
        for (NibbleBlock dataBlock : this.nibbleQueue) {
            while (dataBlock.length() > 0) {
                byte n = dataBlock.getNibble();
                nData = nibble == 0 ? (int)n : (int)((byte)(nData & 0xF | n << 4));
                if ((nibble = 1 - nibble) != 0) continue;
                output.write(nData);
            }
        }
        if (nibble == 1) {
            output.write(nData);
        }
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder(128);
        for (NibbleBlock dataBlock : this.nibbleQueue) {
            int idx = 0;
            while (idx < dataBlock.length()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("%x");
                sb.append(Integer.toHexString(dataBlock.get(idx) >> 4 * (idx & 1) & 0xF).toUpperCase());
                ++idx;
            }
        }
        return sb.toString();
    }

    static class NibbleBlock {
        private byte[] nibbleData;
        private int nibbleIdx;
        private int nibbleCount;
        private long bufferLocation;

        public NibbleBlock(byte[] data, int nibbleCount) {
            this.nibbleData = data;
            this.nibbleIdx = 0;
            this.nibbleCount = Math.min(2 * data.length, nibbleCount);
        }

        public void setBufferLocation(long bufferLocation) {
            this.bufferLocation = bufferLocation;
        }

        public long getBufferLocation() {
            return this.bufferLocation + (long)(this.nibbleIdx / 2);
        }

        public boolean isOutOfData() {
            return this.nibbleCount <= 0;
        }

        private byte getNibble(int idx) {
            byte data = this.nibbleData[idx / 2];
            byte nibble = (idx & 1) != 0 ? (byte)(data >> 4 & 0xF) : (byte)(data & 0xF);
            return nibble;
        }

        public byte getNibble() {
            byte nibble = this.getNibble(this.nibbleIdx);
            --this.nibbleCount;
            ++this.nibbleIdx;
            return nibble;
        }

        public int length() {
            return this.nibbleCount;
        }

        public byte get(int idx) {
            return this.nibbleData[idx];
        }

        public void dump(PrintWriter s, int nibbleWidth) {
            int idx = 0;
            while (idx < this.length()) {
                char[] text = new char[nibbleWidth];
                Arrays.fill(text, ' ');
                int pos = 0;
                while (pos < nibbleWidth && idx < this.length()) {
                    text[nibbleWidth - pos - 1] = Integer.toHexString(this.getNibble(idx)).toUpperCase().charAt(0);
                    ++pos;
                    ++idx;
                }
                s.println(text);
            }
        }
    }
}

