/*
 * Decompiled with CFR 0.152.
 */
package com.arm.coresight.ds5_trace_dump;

import com.arm.coresight.ds5_trace_dump.ITraceDumpDirectory;
import com.arm.coresight.ds5_trace_dump.ITraceDumpTraceStream;
import com.arm.coresight.ds5_trace_dump.ITraceSourceStreamWrapper;
import com.arm.utils.NullChecking;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ITMTraceSourceStreamWrapper
implements ITraceSourceStreamWrapper {
    public static final @NonNull String SOURCE_FORMAT = "ITM";
    private final @NonNull ITraceDumpTraceStream traceStream;

    public static @NonNull List<@NonNull ITMTraceSourceStreamWrapper> getAllITMTraceStreams(@NonNull ITraceDumpDirectory traceDumpDir) {
        ArrayList<@NonNull ITMTraceSourceStreamWrapper> result = new ArrayList<ITMTraceSourceStreamWrapper>();
        for (ITraceDumpTraceStream iTraceDumpTraceStream : traceDumpDir.getTraceStreams().values()) {
            ITMTraceSourceStreamWrapper itmTraceDumpStream = ITMTraceSourceStreamWrapper.tryCreateITMTraceStream((ITraceDumpTraceStream)NullChecking.neverNull((Object)iTraceDumpTraceStream));
            if (itmTraceDumpStream == null) continue;
            result.add(itmTraceDumpStream);
        }
        return result;
    }

    public static @Nullable ITMTraceSourceStreamWrapper tryCreateITMTraceStream(@NonNull ITraceDumpTraceStream traceStream) {
        if (!NullChecking.equalsNullable((Object)SOURCE_FORMAT, (Object)traceStream.getSourceFormat())) {
            return null;
        }
        List<@NonNull File> primaryFiles = traceStream.getPrimaryStreamFiles();
        List<@NonNull File> secondaryFiles = traceStream.getSecondaryStreamFiles();
        if (!secondaryFiles.isEmpty()) {
            throw new AssertionError((Object)"Unexpected secondary files for ITM");
        }
        if (primaryFiles.isEmpty()) {
            return null;
        }
        return new ITMTraceSourceStreamWrapper(traceStream);
    }

    private ITMTraceSourceStreamWrapper(@NonNull ITraceDumpTraceStream traceStream) {
        this.traceStream = traceStream;
    }

    @Override
    public <T, R, E extends Throwable> R accept(@NonNull ITraceSourceStreamWrapper.ITraceSourceStreamWrapperVisitor<T, R, E> visitor, T data) throws E {
        return visitor.visit(this, data);
    }

    public @NonNull List<@NonNull File> getFiles() {
        return this.traceStream.getPrimaryStreamFiles();
    }

    @Override
    public @NonNull ITraceDumpTraceStream getTraceStream() {
        return this.traceStream;
    }

    public String toString() {
        return String.format("ITMTraceSourceStreamWrapper [traceStream=%s]", this.traceStream.getStreamName());
    }
}

