#!/bin/sh
function probe_mali() {
    ls /dev/mali0 > /dev/null 2>&1
    if [ $? == 0 ]; then
        echo 'true'
    else
        echo 'false'
    fi
}


function get_manufacturer() {
    echo `getprop ro.product.manufacturer`
}


function get_model() {
    echo `getprop ro.product.model`
}


function get_last_config_version() {
    if [[ -f /data/local/tmp/configuration.xml ]]; then
        result=$(grep -o 'streamline_version=\"[^\"]*\"' /data/local/tmp/configuration.xml)
        echo $result
    else
        echo
    fi
}


echo -n "has_mali: "; probe_mali
echo -n "manufacturer: "; get_manufacturer
echo -n "model: "; get_model
echo -n "config_version: "; get_last_config_version