<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0" xmlns="http://www.w3.org/1999/xhtml">
<xsl:output doctype-public="-//W3C//DTD XHTML 1.1//EN"
  doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"
 method="html" encoding="utf-8"/>

  <xsl:template match="/alphaindex">
    <html>
      <xsl:apply-templates />
    </html>
  </xsl:template>

  <xsl:template match="/alphaindex/toptitle">
    <head>
      <title><xsl:value-of select="@instructionset"/></title>
      <link rel="stylesheet" type="text/css" href="insn.css"/>
    </head>
  </xsl:template>

  <xsl:template match="/alphaindex/iforms">
    <body>
    <table style="margin: 0 auto;">
      <tr>
        <!-- autogenerator: header/footer start -->
        <!-- autogenerated -->
	<td><div class="topbar"><a href="index.xml">Base Instructions</a></div></td>
	<td><div class="topbar"><a href="fpsimdindex.xml">SIMD&amp;FP Instructions</a></div></td>
	<td><div class="topbar"><a href="a32_encindex.xml">A32 Instructions by Encoding</a></div></td>
	<td><div class="topbar"><a href="t32_encindex.xml">T32 Instructions by Encoding</a></div></td>
	<td><div class="topbar"><a href="shared_pseudocode.xml">Shared Pseudocode</a></div></td>
	<td><div class="topbar"><a href="notice.xml">Proprietary Notice</a></div></td>
        <!-- autogenerator: header/footer end -->
      </tr>
    </table>  
    <hr/>
      <h1 class="alphindextitle"><xsl:value-of select="@title"/></h1>
      <xsl:apply-templates />
      <hr/>
    <table style="margin: 0 auto;">
      <tr>
        <!-- autogenerator: header/footer start -->
        <!-- autogenerated -->
	<td><div class="topbar"><a href="index.xml">Base Instructions</a></div></td>
	<td><div class="topbar"><a href="fpsimdindex.xml">SIMD&amp;FP Instructions</a></div></td>
	<td><div class="topbar"><a href="a32_encindex.xml">A32 Instructions by Encoding</a></div></td>
	<td><div class="topbar"><a href="t32_encindex.xml">T32 Instructions by Encoding</a></div></td>
	<td><div class="topbar"><a href="shared_pseudocode.xml">Shared Pseudocode</a></div></td>
	<td><div class="topbar"><a href="notice.xml">Proprietary Notice</a></div></td>
        <!-- autogenerator: header/footer end -->
      </tr>
    </table>  
    <!-- version footer -->
    <p class="versions">
        Internal version only: isa v01_31, pseudocode v2024-06_rel      
        ; Build timestamp: 2024-07-04T15:14
    </p>
    <p class="copyconf">
      Copyright &#169; 2010-2024 Arm Limited or its affiliates. All rights reserved.
      This document is Non-Confidential.
    </p>
    </body>
  </xsl:template>

  <xsl:template match="/alphaindex/iforms/iform">
  <div class="iformindex">
    <p class="iformindex">
      <span class="insnheading">
        <a>
          <xsl:attribute name="href">
            <xsl:choose>
              <xsl:when test="@id = ''">
                <xsl:value-of select="@href"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="@iformfile"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
          <xsl:value-of select="@heading"/>
        </a>:
        <xsl:value-of select="."/>
      </span>
    </p>
  </div>
  </xsl:template>

</xsl:stylesheet>
