/* Copyright (C) 2024 by Arm Limited. All rights reserved. */

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// This file is generated and has a matching component in Streamline.
// Do not manually modify the metric definitions without doing the same in Streamline.
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

#include "metrics/definitions.hpp"

#include <cstdint>

// NOLINTBEGIN(cert-err58-cpp)

namespace metrics {
    namespace {
        [[maybe_unused]] const metric_events_set_t backend_bound_0 {
            {
                std::uint16_t(0x003d),
            },
            "backend_bound",
            "Backend Bound",
            "This metric is the percentage of total slots that were stalled due to resource constraints in the backend "
            "of the processor.",
            "percent",
            0,
            metric_priority_t::backend_bound,
            metric_arch_t::v8,
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
        };
        [[maybe_unused]] const metric_events_set_t backend_bound_1 {
            {
                std::uint16_t(0x003d),
                std::uint16_t(0x0010),
            },
            "backend_bound",
            "Backend Bound",
            "This metric is the percentage of total slots that were stalled due to resource constraints in the backend "
            "of the processor.",
            "percent",
            1,
            metric_priority_t::backend_bound,
            metric_arch_t::v8,
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
        };
        [[maybe_unused]] const metric_events_set_t backend_busy_bound_0 {
            {
                std::uint16_t(0x816b),
                std::uint16_t(0x0024),
            },
            "backend_busy_bound",
            "Backend Busy Bound",
            "This metric is the percentage of total cycles stalled in the backend due to issue queues being full to "
            "accept operations for execution.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_backend,
            },
        };
        [[maybe_unused]] const metric_events_set_t backend_cache_l1d_bound_0 {
            {
                std::uint16_t(0x4005),
                std::uint16_t(0x8165),
            },
            "backend_cache_l1d_bound",
            "Backend Cache L1D Bound",
            "This metric is the percentage of total cycles stalled in the backend due to memory access latency issues "
            "caused by level 1 data cache misses.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_backend,
            },
        };
        [[maybe_unused]] const metric_events_set_t backend_cache_l2d_bound_0 {
            {
                std::uint16_t(0x4005),
                std::uint16_t(0x8165),
            },
            "backend_cache_l2d_bound",
            "Backend Cache L2D Bound",
            "This metric is the percentage of total cycles stalled in the backend due to memory access latency issues "
            "caused by level 2 data cache misses.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_backend,
            },
        };
        [[maybe_unused]] const metric_events_set_t backend_core_bound_0 {
            {
                std::uint16_t(0x0024),
                std::uint16_t(0x816a),
            },
            "backend_core_bound",
            "Backend Core Bound",
            "This metric is the percentage of total cycles stalled in the backend due to backend core resource "
            "constraints not related to instruction fetch latency issues caused by memory access components.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_backend,
            },
        };
        [[maybe_unused]] const metric_events_set_t backend_core_rename_bound_0 {
            {
                std::uint16_t(0x816a),
                std::uint16_t(0x816d),
            },
            "backend_core_rename_bound",
            "Backend Core Rename Bound",
            "This metric is the percentage of total cycles stalled in the backend as the rename unit registers are "
            "unavailable.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_backend,
            },
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_bound_0 {
            {
                std::uint16_t(0x4005),
                std::uint16_t(0x0024),
            },
            "backend_mem_bound",
            "Backend Memory Bound",
            "This metric is the percentage of backend stalled cycles that were stalled due a miss in the last level of "
            "cache.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_backend,
            },
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_bound_1 {
            {
                std::uint16_t(0x0024),
                std::uint16_t(0x8164),
            },
            "backend_mem_bound",
            "Backend Memory Bound",
            "This metric is the percentage of total cycles stalled in the backend due to backend core resource "
            "constraints related to memory access latency issues caused by memory access components.",
            "percent",
            1,
            metric_priority_t::backend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_backend,
            },
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_cache_bound_0 {
            {
                std::uint16_t(0x4005),
                std::uint16_t(0x8165),
                std::uint16_t(0x8164),
            },
            "backend_mem_cache_bound",
            "Backend Mem Cache Bound",
            "This metric is the percentage of total cycles stalled in the backend due to memory latency issues caused "
            "by data cache misses.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_backend,
            },
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_cache_bound_1 {
            {
                std::uint16_t(0x4005),
                std::uint16_t(0x8165),
                std::uint16_t(0x8164),
            },
            "backend_mem_cache_bound",
            "Backend Memory Cache Bound",
            "This metric is the percentage of total cycles stalled in the backend due to memory latency issues caused "
            "by data cache misses.",
            "percent",
            1,
            metric_priority_t::backend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_backend,
            },
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_store_bound_0 {
            {
                std::uint16_t(0x8168),
                std::uint16_t(0x8164),
            },
            "backend_mem_store_bound",
            "Backend Mem Store Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to memory write pending caused "
            "by stores stalled in the pre-commit stage.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_backend,
            },
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_store_bound_1 {
            {
                std::uint16_t(0x8168),
                std::uint16_t(0x8164),
            },
            "backend_mem_store_bound",
            "Backend Memory Store Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to memory write pending caused "
            "by stores stalled in the pre-commit stage.",
            "percent",
            1,
            metric_priority_t::backend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_backend,
            },
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_tlb_bound_0 {
            {
                std::uint16_t(0x8164),
                std::uint16_t(0x8167),
            },
            "backend_mem_tlb_bound",
            "Backend Mem Tlb Bound",
            "This metric is the percentage of total cycles stalled in the backend due to memory access latency issues "
            "caused by data TLB misses.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_backend,
            },
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_tlb_bound_1 {
            {
                std::uint16_t(0x8164),
                std::uint16_t(0x8167),
            },
            "backend_mem_tlb_bound",
            "Backend Memory TLB Bound",
            "This metric is the percentage of total cycles stalled in the backend due to memory access latency issues "
            "caused by data TLB misses.",
            "percent",
            1,
            metric_priority_t::backend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_backend,
            },
        };
        [[maybe_unused]] const metric_events_set_t backend_stall_interlock_bound_0 {
            {
                std::uint16_t(0x00e4),
                std::uint16_t(0x0024),
            },
            "backend_stall_interlock_bound",
            "Backend Stall Interlock Rate",
            "This metric is the percentage of total cycles stalled in the backend due to instruction interlocks. A "
            "high rate of interlock stalls is likely an indication of sub-optimal instruction scheduling for an "
            "in-order core.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_backend,
            },
        };
        [[maybe_unused]] const metric_events_set_t backend_stall_interlock_bound_1 {
            {
                std::uint16_t(0x816c),
                std::uint16_t(0x0024),
            },
            "backend_stall_interlock_bound",
            "Backend Stall Interlock Rate",
            "This metric is the percentage of total cycles stalled in the backend due to instruction interlocks. A "
            "high rate of interlock stalls is likely an indication of sub-optimal instruction scheduling for an "
            "in-order core.",
            "percent",
            1,
            metric_priority_t::backend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_backend,
            },
        };
        [[maybe_unused]] const metric_events_set_t backend_stalled_cycles_0 {
            {
                std::uint16_t(0x0024),
            },
            "backend_stalled_cycles",
            "Backend Stalled Cycles",
            "This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit "
            "of the processor.",
            "percent",
            0,
            metric_priority_t::backend_stalled_cycles,
            metric_arch_t::v8,
            {
                metric_group_id_t::basic,
                metric_group_id_t::cycle_accounting,
            },
        };
        [[maybe_unused]] const metric_events_set_t bad_speculation_0 {
            {
                std::uint16_t(0x003a),
                std::uint16_t(0x003f),
                std::uint16_t(0x003b),
                std::uint16_t(0x8162),
            },
            "bad_speculation",
            "Bad Speculation",
            "This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline "
            "flush.\nThis indicates cycles that were utilized but inefficiently.",
            "percent",
            0,
            metric_priority_t::bad_speculation,
            metric_arch_t::v8,
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
        };
        [[maybe_unused]] const metric_events_set_t bad_speculation_1 {
            {
                std::uint16_t(0x003a),
                std::uint16_t(0x003f),
                std::uint16_t(0x003b),
                std::uint16_t(0x0010),
            },
            "bad_speculation",
            "Bad Speculation",
            "This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline "
            "flush.\nThis indicates cycles that were utilized but inefficiently.",
            "percent",
            1,
            metric_priority_t::bad_speculation,
            metric_arch_t::v8,
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
        };
        [[maybe_unused]] const metric_events_set_t bad_speculation_2 {
            {
                std::uint16_t(0x003a),
                std::uint16_t(0x003f),
                std::uint16_t(0x003b),
                std::uint16_t(0x0010),
            },
            "bad_speculation",
            "Bad Speculation",
            "This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline "
            "flush.\nThis indicates cycles that were utilized but inefficiently.",
            "percent",
            2,
            metric_priority_t::bad_speculation,
            metric_arch_t::v8,
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
        };
        [[maybe_unused]] const metric_events_set_t barrier_percentage_0 {
            {
                std::uint16_t(0x007e),
                std::uint16_t(0x007d),
                std::uint16_t(0x001b),
                std::uint16_t(0x007c),
            },
            "barrier_percentage",
            "Barrier Operations Percentage",
            "This metric measures instruction and data barrier operations as a percentage of operations speculatively "
            "executed.",
            "percent",
            0,
            metric_priority_t::barrier,
            metric_arch_t::any,
            {
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t branch_direct_ratio_0 {
            {
                std::uint16_t(0x0021),
                std::uint16_t(0x000d),
            },
            "branch_direct_ratio",
            "Branch Direct Percentage",
            "This metric measures the ratio of direct branches retired to the total number of branches architecturally "
            "executed.",
            "percent",
            0,
            metric_priority_t::branch,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::branch_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t branch_indirect_ratio_0 {
            {
                std::uint16_t(0x0021),
                std::uint16_t(0x811d),
            },
            "branch_indirect_ratio",
            "Branch Indirect Percentage",
            "This metric measures the ratio of indirect branches retired, including function returns, to the total "
            "number of branches architecturally executed.",
            "percent",
            0,
            metric_priority_t::branch,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::branch_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t branch_misprediction_ratio_0 {
            {
                std::uint16_t(0x0021),
                std::uint16_t(0x0022),
            },
            "branch_misprediction_ratio",
            "Branch Misprediction Percentage",
            "This metric measures the ratio of branches mispredicted to the total number of branches architecturally "
            "executed. This gives an indication of the effectiveness of the branch prediction unit.",
            "percent",
            0,
            metric_priority_t::branch,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::branch_effectiveness,
                metric_group_id_t::miss_ratio,
            },
        };
        [[maybe_unused]] const metric_events_set_t branch_mpki_0 {
            {
                std::uint16_t(0x0008),
                std::uint16_t(0x0010),
            },
            "branch_mpki",
            "Branch MPKI",
            "This metric measures the number of branch mispredictions per thousand instructions executed",
            "misses",
            0,
            metric_priority_t::branch,
            metric_arch_t::any,
            {
                metric_group_id_t::branch_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t branch_mpki_1 {
            {
                std::uint16_t(0x0022),
                std::uint16_t(0x0008),
            },
            "branch_mpki",
            "Branch MPKI",
            "This metric measures the number of branch mispredictions per thousand instructions executed.",
            "misses",
            1,
            metric_priority_t::branch,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::branch_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t branch_percentage_0 {
            {
                std::uint16_t(0x0078),
                std::uint16_t(0x007a),
                std::uint16_t(0x001b),
            },
            "branch_percentage",
            "Branch Operations Percentage",
            "This metric measures branch operations as a percentage of operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::branch,
            metric_arch_t::any,
            {
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t branch_percentage_1 {
            {
                std::uint16_t(0x0076),
                std::uint16_t(0x001b),
            },
            "branch_percentage",
            "Branch Operations Percentage",
            "This metric measures branch operations as a percentage of operations speculatively executed.",
            "percent",
            1,
            metric_priority_t::branch,
            metric_arch_t::any,
            {
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t branch_return_ratio_0 {
            {
                std::uint16_t(0x0021),
                std::uint16_t(0x000e),
            },
            "branch_return_ratio",
            "Branch Return Percentage",
            "This metric measures the ratio of branches retired that are function returns to the total number of "
            "branches architecturally executed.",
            "percent",
            0,
            metric_priority_t::branch,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::branch_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t bus_read_requests_average_latency_0 {
            {
                std::uint16_t(0x8125),
                std::uint16_t(0x818d),
            },
            "bus_read_requests_average_latency",
            "Bus Read Request Average Latency",
            "This metric measures the average latency of read requests made by this processor on the system bus in CPU "
            "cycles",
            "cycles",
            0,
            metric_priority_t::latency,
            metric_arch_t::any,
            {
                metric_group_id_t::average_latency,
                metric_group_id_t::bus_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t cas_near_fail_ratio_0 {
            {
                std::uint16_t(0x8172),
                std::uint16_t(0x8171),
            },
            "cas_near_fail_ratio",
            "Compare and Swap Near Fail Percentage",
            "This metric measures the ratio of failed compare and swap instructions speculatively executed locally to "
            "the PE that do not update the location accessed to the total near compare and swap instructions.",
            "percent",
            0,
            metric_priority_t::cas,
            metric_arch_t::any,
            {
                metric_group_id_t::atomics_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t cas_near_pass_ratio_0 {
            {
                std::uint16_t(0x8172),
                std::uint16_t(0x8171),
            },
            "cas_near_pass_ratio",
            "Compare and Swap Near Pass Percentage",
            "This metric measures the ratio of passed compare and swap instructions speculatively executed locally to "
            "the PE that updated the location accessed to the total near compare and swap instructions.",
            "percent",
            0,
            metric_priority_t::cas,
            metric_arch_t::any,
            {
                metric_group_id_t::atomics_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t cpi_0 {
            {
                std::uint16_t(0x0008),
            },
            "cpi",
            "Cycles Per Instruction",
            "This metric measures the number of cycles per instructions retired",
            "cycles",
            0,
            metric_priority_t::cpi,
            metric_arch_t::v8,
            {
                metric_group_id_t::general,
            },
        };
        [[maybe_unused]] const metric_events_set_t crypto_percentage_0 {
            {
                std::uint16_t(0x001b),
                std::uint16_t(0x0077),
            },
            "crypto_percentage",
            "Crypto Operations Percentage",
            "This metric measures crypto operations as a percentage of operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            {
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t dtlb_mpki_0 {
            {
                std::uint16_t(0x0008),
                std::uint16_t(0x0034),
            },
            "dtlb_mpki",
            "DTLB MPKI",
            "This metric measures the number of data TLB Walks per thousand instructions executed.",
            "misses",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            {
                metric_group_id_t::dtlb_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t dtlb_walk_average_depth_0 {
            {
                std::uint16_t(0x8136),
                std::uint16_t(0x0034),
            },
            "dtlb_walk_average_depth",
            "DTLB Walk Average Depth of Accesses",
            "This metric measures the average depth of the Instruction TLB walks for a data TLB refill",
            "accesses",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            {
                metric_group_id_t::dtlb_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t dtlb_walk_average_depth_1 {
            {
                std::uint16_t(0x8136),
                std::uint16_t(0x0034),
            },
            "dtlb_walk_average_depth",
            "DTLB Walk Average Depth of Accesses",
            "This metric measures the average depth of the data TLB walks for a data TLB refill",
            "accesses",
            1,
            metric_priority_t::data,
            metric_arch_t::any,
            {
                metric_group_id_t::dtlb_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t dtlb_walk_average_latency_0 {
            {
                std::uint16_t(0x8128),
                std::uint16_t(0x0034),
            },
            "dtlb_walk_average_latency",
            "DTLB Walk Average Latency",
            "This metric measures the average latency of data TLB walks in CPU cycles",
            "cycles",
            0,
            metric_priority_t::latency,
            metric_arch_t::any,
            {
                metric_group_id_t::average_latency,
                metric_group_id_t::dtlb_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t dtlb_walk_large_ratio_0 {
            {
                std::uint16_t(0x8138),
                std::uint16_t(0x0025),
            },
            "dtlb_walk_large_ratio",
            "DTLB Walk Large Page Percentage",
            "This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB "
            "accesses.",
            "percent",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            {
                metric_group_id_t::dtlb_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t dtlb_walk_ratio_0 {
            {
                std::uint16_t(0x0025),
                std::uint16_t(0x0034),
            },
            "dtlb_walk_ratio",
            "DTLB Walk Percentage",
            "This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an "
            "indication of the effectiveness of the data TLB accesses.",
            "percent",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            {
                metric_group_id_t::dtlb_effectiveness,
                metric_group_id_t::miss_ratio,
            },
        };
        [[maybe_unused]] const metric_events_set_t dtlb_walk_small_ratio_0 {
            {
                std::uint16_t(0x813a),
                std::uint16_t(0x0025),
            },
            "dtlb_walk_small_ratio",
            "DTLB Walk Small Page Percentage",
            "This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB "
            "accesses.",
            "percent",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            {
                metric_group_id_t::dtlb_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t fp16_percentage_0 {
            {
                std::uint16_t(0x8014),
                std::uint16_t(0x001b),
            },
            "fp16_percentage",
            "Half Precision Floating Point Percentage",
            "This metric measures half-precision floating point operations as a percentage of operations speculatively "
            "executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            {
                metric_group_id_t::fp_precision_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t fp32_percentage_0 {
            {
                std::uint16_t(0x8018),
                std::uint16_t(0x001b),
            },
            "fp32_percentage",
            "Single Precision Floating Point Percentage",
            "This metric measures single-precision floating point operations as a percentage of operations "
            "speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            {
                metric_group_id_t::fp_precision_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t fp64_percentage_0 {
            {
                std::uint16_t(0x001b),
                std::uint16_t(0x801c),
            },
            "fp64_percentage",
            "Double Precision Floating Point Percentage",
            "This metric measures double-precision floating point operations as a percentage of operations "
            "speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            {
                metric_group_id_t::fp_precision_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t fp_ops_per_cycle_0 {
            {
                std::uint16_t(0x80c0),
                std::uint16_t(0x80c1),
            },
            "fp_ops_per_cycle",
            "Floating Point Operations per Cycle",
            "This metric measures floating point operations per cycle in any precision performed by any instruction. "
            "Operations are counted by computation and by vector lanes, fused computations such as multiply-add count "
            "as twice per vector lane for example.",
            "operations",
            0,
            metric_priority_t::numeric,
            metric_arch_t::v8,
            {
                metric_group_id_t::fp_arithmetic_intensity,
            },
        };
        [[maybe_unused]] const metric_events_set_t frontend_bound_0 {
            {
                std::uint16_t(0x003e),
                std::uint16_t(0x8162),
            },
            "frontend_bound",
            "Frontend Bound",
            "This metric is the percentage of total slots that were stalled due to resource constraints in the "
            "frontend of the processor.",
            "percent",
            0,
            metric_priority_t::frontend_bound,
            metric_arch_t::v8,
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
        };
        [[maybe_unused]] const metric_events_set_t frontend_bound_1 {
            {
                std::uint16_t(0x003e),
                std::uint16_t(0x0010),
            },
            "frontend_bound",
            "Frontend Bound",
            "This metric is the percentage of total slots that were stalled due to resource constraints in the "
            "frontend of the processor.",
            "percent",
            1,
            metric_priority_t::frontend_bound,
            metric_arch_t::v8,
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
        };
        [[maybe_unused]] const metric_events_set_t frontend_bound_2 {
            {
                std::uint16_t(0x003e),
                std::uint16_t(0x0010),
            },
            "frontend_bound",
            "Frontend Bound",
            "This metric is the percentage of total slots that were stalled due to resource constraints in the "
            "frontend of the processor.",
            "percent",
            2,
            metric_priority_t::frontend_bound,
            metric_arch_t::v8,
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
        };
        [[maybe_unused]] const metric_events_set_t frontend_cache_l1i_bound_0 {
            {
                std::uint16_t(0x8159),
                std::uint16_t(0x815b),
            },
            "frontend_cache_l1i_bound",
            "Frontend Cache L1I Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues "
            "caused by level 1 instruction cache misses.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_frontend,
            },
        };
        [[maybe_unused]] const metric_events_set_t frontend_cache_l2i_bound_0 {
            {
                std::uint16_t(0x8159),
                std::uint16_t(0x815b),
            },
            "frontend_cache_l2i_bound",
            "Frontend Cache L2I Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues "
            "caused by level 2 instruction cache misses.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_frontend,
            },
        };
        [[maybe_unused]] const metric_events_set_t frontend_core_bound_0 {
            {
                std::uint16_t(0x8160),
                std::uint16_t(0x0023),
            },
            "frontend_core_bound",
            "Frontend Core Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to frontend core resource "
            "constraints not related to instruction fetch latency issues caused by memory access components.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_frontend,
            },
        };
        [[maybe_unused]] const metric_events_set_t frontend_core_flow_bound_0 {
            {
                std::uint16_t(0x8161),
                std::uint16_t(0x8160),
            },
            "frontend_core_flow_bound",
            "Frontend Core Flow Bound",
            "This metric is the percentage of total cycles stalled in the frontend as the decode unit is awaiting "
            "input from the branch prediction unit.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_frontend,
            },
        };
        [[maybe_unused]] const metric_events_set_t frontend_core_flush_bound_0 {
            {
                std::uint16_t(0x8160),
                std::uint16_t(0x8162),
            },
            "frontend_core_flush_bound",
            "Frontend Core Flush Bound",
            "This metric is the percentage of total cycles stalled in the frontend as the processor is recovering from "
            "a pipeline flush caused by bad speculation or other machine resteers.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_frontend,
            },
        };
        [[maybe_unused]] const metric_events_set_t frontend_mem_bound_0 {
            {
                std::uint16_t(0x8158),
                std::uint16_t(0x0023),
            },
            "frontend_mem_bound",
            "Frontend Memory Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to frontend core resource "
            "constraints related to the instruction fetch latency issues caused by memory access components.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_frontend,
            },
        };
        [[maybe_unused]] const metric_events_set_t frontend_mem_cache_bound_0 {
            {
                std::uint16_t(0x8158),
                std::uint16_t(0x8159),
                std::uint16_t(0x815b),
            },
            "frontend_mem_cache_bound",
            "Frontend Mem Cache Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency "
            "issues caused by instruction cache misses.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_frontend,
            },
        };
        [[maybe_unused]] const metric_events_set_t frontend_mem_tlb_bound_0 {
            {
                std::uint16_t(0x815c),
                std::uint16_t(0x8158),
            },
            "frontend_mem_tlb_bound",
            "Frontend Mem TLB Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency "
            "issues caused by instruction TLB misses.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_frontend,
            },
        };
        [[maybe_unused]] const metric_events_set_t frontend_stalled_cycles_0 {
            {
                std::uint16_t(0x0023),
            },
            "frontend_stalled_cycles",
            "Frontend Stalled Cycles",
            "This metric is the percentage of cycles that were stalled due to resource constraints in the frontend "
            "unit of the processor.",
            "percent",
            0,
            metric_priority_t::frontend_stalled_cycles,
            metric_arch_t::v8,
            {
                metric_group_id_t::basic,
                metric_group_id_t::cycle_accounting,
            },
        };
        [[maybe_unused]] const metric_events_set_t instruction_fetch_average_latency_0 {
            {
                std::uint16_t(0x8120),
                std::uint16_t(0x8124),
            },
            "instruction_fetch_average_latency",
            "Instruction Fetch Average Latency",
            "This metric measures the average latency of instruction fetches in CPU cycles",
            "cycles",
            0,
            metric_priority_t::latency,
            metric_arch_t::any,
            {
                metric_group_id_t::average_latency,
            },
        };
        [[maybe_unused]] const metric_events_set_t integer_dp_percentage_0 {
            {
                std::uint16_t(0x007d),
                std::uint16_t(0x0073),
                std::uint16_t(0x001b),
            },
            "integer_dp_percentage",
            "Integer Operations Percentage",
            "This metric measures scalar integer operations as a percentage of operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t integer_dp_percentage_1 {
            {
                std::uint16_t(0x0073),
                std::uint16_t(0x001b),
            },
            "integer_dp_percentage",
            "Integer Operations Percentage",
            "This metric measures scalar integer operations as a percentage of operations speculatively executed.",
            "percent",
            1,
            metric_priority_t::numeric,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t ipc_0 {
            {
                std::uint16_t(0x0008),
            },
            "ipc",
            "Instructions Per Cycle",
            "This metric measures the number of instructions retired per cycle.",
            "instructions",
            0,
            metric_priority_t::ipc,
            metric_arch_t::v8,
            {
                metric_group_id_t::basic,
                metric_group_id_t::general,
            },
        };
        [[maybe_unused]] const metric_events_set_t iq_stall_lsu_percentage_0 {
            {
                std::uint16_t(0x015e),
                std::uint16_t(0x816b),
            },
            "iq_stall_lsu_percentage",
            "Load/Store IQ Stall Percentage",
            "This metric measures the percentage of backend stall cycles where the oldest operation was a load or "
            "store operation",
            "percent",
            0,
            metric_priority_t::iq,
            metric_arch_t::any,
            {
                metric_group_id_t::iq_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t iq_stall_mx_percentage_0 {
            {
                std::uint16_t(0x015d),
                std::uint16_t(0x816b),
            },
            "iq_stall_mx_percentage",
            "Integer MX IQ Stall Percentage",
            "This metric measures the percentage of backend stall cycles where the oldest operation was an integer "
            "operation",
            "percent",
            0,
            metric_priority_t::iq,
            metric_arch_t::any,
            {
                metric_group_id_t::iq_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t iq_stall_sx_percentage_0 {
            {
                std::uint16_t(0x816b),
                std::uint16_t(0x015c),
            },
            "iq_stall_sx_percentage",
            "Integer SX IQ Stall Percentage",
            "This metric measures the percentage of backend stall cycles where the oldest operation was an integer "
            "operation",
            "percent",
            0,
            metric_priority_t::iq,
            metric_arch_t::any,
            {
                metric_group_id_t::iq_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t iq_stall_vpu_percentage_0 {
            {
                std::uint16_t(0x816b),
                std::uint16_t(0x015f),
            },
            "iq_stall_vpu_percentage",
            "Vector IQ Stall Percentage",
            "This metric measures the percentage of backend stall cycles where the oldest operation was a vector "
            "operation",
            "percent",
            0,
            metric_priority_t::iq,
            metric_arch_t::any,
            {
                metric_group_id_t::iq_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t itlb_mpki_0 {
            {
                std::uint16_t(0x0035),
                std::uint16_t(0x0008),
            },
            "itlb_mpki",
            "ITLB MPKI",
            "This metric measures the number of instruction TLB Walks per thousand instructions executed.",
            "misses",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            {
                metric_group_id_t::itlb_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t itlb_walk_average_depth_0 {
            {
                std::uint16_t(0x0035),
                std::uint16_t(0x8137),
            },
            "itlb_walk_average_depth",
            "ITLB Walk Average Depth of Accesses",
            "This metric measures the average depth of the Instruction TLB walks for an instruction TLB refill",
            "accesses",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            {
                metric_group_id_t::itlb_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t itlb_walk_average_depth_1 {
            {
                std::uint16_t(0x0035),
                std::uint16_t(0x8137),
            },
            "itlb_walk_average_depth",
            "ITLB Walk Average Depth of Accesses",
            "This metric measures the average depth of the instruction TLB walks for an instruction TLB refill",
            "accesses",
            1,
            metric_priority_t::instruction,
            metric_arch_t::any,
            {
                metric_group_id_t::itlb_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t itlb_walk_average_latency_0 {
            {
                std::uint16_t(0x0035),
                std::uint16_t(0x8129),
            },
            "itlb_walk_average_latency",
            "ITLB Walk Average Latency",
            "This metric measures the average latency of instruction TLB walks in CPU cycles",
            "cycles",
            0,
            metric_priority_t::latency,
            metric_arch_t::any,
            {
                metric_group_id_t::average_latency,
                metric_group_id_t::itlb_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t itlb_walk_large_ratio_0 {
            {
                std::uint16_t(0x8139),
                std::uint16_t(0x0026),
            },
            "itlb_walk_large_ratio",
            "ITLB Walk Large Page Percentage",
            "This metric measures the ratio of instruction TLB Walks that returned large page to the total number of "
            "instruction TLB accesses.",
            "percent",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            {
                metric_group_id_t::itlb_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t itlb_walk_ratio_0 {
            {
                std::uint16_t(0x0035),
                std::uint16_t(0x0026),
            },
            "itlb_walk_ratio",
            "ITLB Walk Percentage",
            "This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. "
            "This gives an indication of the effectiveness of the instruction TLB accesses.",
            "percent",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            {
                metric_group_id_t::itlb_effectiveness,
                metric_group_id_t::miss_ratio,
            },
        };
        [[maybe_unused]] const metric_events_set_t itlb_walk_small_ratio_0 {
            {
                std::uint16_t(0x813b),
                std::uint16_t(0x0026),
            },
            "itlb_walk_small_ratio",
            "ITLB Walk Small Page Percentage",
            "This metric measures the ratio of instruction TLB Walks that returned large page to the total number of "
            "instruction TLB accesses.",
            "percent",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            {
                metric_group_id_t::itlb_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t l1d_cache_miss_ratio_0 {
            {
                std::uint16_t(0x0003),
                std::uint16_t(0x0004),
            },
            "l1d_cache_miss_ratio",
            "L1D Cache Miss Percentage",
            "This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data "
            "cache accesses. This gives an indication of the effectiveness of the level 1 data cache.",
            "percent",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::l1d_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
        };
        [[maybe_unused]] const metric_events_set_t l1d_cache_mpki_0 {
            {
                std::uint16_t(0x0042),
                std::uint16_t(0x0008),
                std::uint16_t(0x0043),
            },
            "l1d_cache_mpki",
            "L1D Cache MPKI",
            "This metric measures the number of level 1 data cache accesses missed per thousand instructions executed.",
            "misses",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::l1d_cache_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t l1d_cache_mpki_1 {
            {
                std::uint16_t(0x0008),
                std::uint16_t(0x0003),
            },
            "l1d_cache_mpki",
            "L1D Cache MPKI",
            "This metric measures the number of level 1 data cache accesses missed per thousand instructions executed.",
            "misses",
            1,
            metric_priority_t::data,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::l1d_cache_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t l1d_tlb_miss_ratio_0 {
            {
                std::uint16_t(0x0005),
                std::uint16_t(0x0025),
            },
            "l1d_tlb_miss_ratio",
            "L1 Data TLB Miss Percentage",
            "This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data "
            "TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB.",
            "percent",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            {
                metric_group_id_t::dtlb_effectiveness,
                metric_group_id_t::miss_ratio,
            },
        };
        [[maybe_unused]] const metric_events_set_t l1d_tlb_mpki_0 {
            {
                std::uint16_t(0x0005),
                std::uint16_t(0x0008),
            },
            "l1d_tlb_mpki",
            "L1 Data TLB MPKI",
            "This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed.",
            "misses",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            {
                metric_group_id_t::dtlb_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t l1i_cache_miss_ratio_0 {
            {
                std::uint16_t(0x0001),
                std::uint16_t(0x0014),
            },
            "l1i_cache_miss_ratio",
            "L1I Cache Miss Percentage",
            "This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level "
            "1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction "
            "cache.",
            "percent",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::l1i_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
        };
        [[maybe_unused]] const metric_events_set_t l1i_cache_mpki_0 {
            {
                std::uint16_t(0x0001),
                std::uint16_t(0x0008),
            },
            "l1i_cache_mpki",
            "L1I Cache MPKI",
            "This metric measures the number of level 1 instruction cache accesses missed per thousand instructions "
            "executed.",
            "misses",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::l1i_cache_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t l1i_tlb_miss_ratio_0 {
            {
                std::uint16_t(0x0002),
                std::uint16_t(0x0026),
            },
            "l1i_tlb_miss_ratio",
            "L1 Instruction TLB Miss Percentage",
            "This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 "
            "instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB.",
            "percent",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            {
                metric_group_id_t::itlb_effectiveness,
                metric_group_id_t::miss_ratio,
            },
        };
        [[maybe_unused]] const metric_events_set_t l1i_tlb_mpki_0 {
            {
                std::uint16_t(0x0002),
                std::uint16_t(0x0008),
            },
            "l1i_tlb_mpki",
            "L1 Instruction TLB MPKI",
            "This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions "
            "executed.",
            "misses",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            {
                metric_group_id_t::itlb_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t l2_cache_miss_ratio_0 {
            {
                std::uint16_t(0x0017),
                std::uint16_t(0x0016),
            },
            "l2_cache_miss_ratio",
            "L2 Cache Miss Percentage",
            "This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache "
            "accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache "
            "that stores both data and instruction. Note that cache accesses in this cache are either data memory "
            "access or instruction fetch as this is a unified cache.",
            "percent",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
        };
        [[maybe_unused]] const metric_events_set_t l2_cache_mpki_0 {
            {
                std::uint16_t(0x0052),
                std::uint16_t(0x0008),
                std::uint16_t(0x0053),
            },
            "l2_cache_mpki",
            "L2 Cache MPKI",
            "This metric measures the number of level 2 unified cache accesses missed per thousand instructions "
            "executed. Note that cache accesses in this cache are either data memory access or instruction fetch as "
            "this is a unified cache.",
            "misses",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2_cache_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t l2_cache_mpki_1 {
            {
                std::uint16_t(0x0017),
                std::uint16_t(0x0008),
            },
            "l2_cache_mpki",
            "L2 Cache MPKI",
            "This metric measures the number of level 2 unified cache accesses missed per thousand instructions "
            "executed. Note that cache accesses in this cache are either data memory access or instruction fetch as "
            "this is a unified cache.",
            "misses",
            1,
            metric_priority_t::l2,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2_cache_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t l2_tlb_miss_ratio_0 {
            {
                std::uint16_t(0x002d),
                std::uint16_t(0x002f),
            },
            "l2_tlb_miss_ratio",
            "L2 Unified TLB Miss Percentage",
            "This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 "
            "unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB.",
            "percent",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            {
                metric_group_id_t::dtlb_effectiveness,
                metric_group_id_t::itlb_effectiveness,
                metric_group_id_t::miss_ratio,
            },
        };
        [[maybe_unused]] const metric_events_set_t l2_tlb_mpki_0 {
            {
                std::uint16_t(0x002d),
                std::uint16_t(0x0008),
            },
            "l2_tlb_mpki",
            "L2 Unified TLB MPKI",
            "This metric measures the number of level 2 unified TLB accesses missed per thousand instructions "
            "executed.",
            "misses",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            {
                metric_group_id_t::dtlb_effectiveness,
                metric_group_id_t::itlb_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t l2d_cache_miss_ratio_0 {
            {
                std::uint16_t(0x0017),
                std::uint16_t(0x0016),
            },
            "l2d_cache_miss_ratio",
            "L2D Cache Miss Percentage",
            "This metric measures the ratio of level 2 cache data accesses missed to the total number of level 2 data "
            "cache accesses. This gives an indication of the effectiveness of data accesses in the level 2 cache, "
            "which is a unified cache that stores both data and instruction. Note that cache accesses in this cache "
            "are either data memory access or instruction fetch as this is a unified cache.",
            "percent",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2d_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
        };
        [[maybe_unused]] const metric_events_set_t l2d_cache_mpki_0 {
            {
                std::uint16_t(0x0052),
                std::uint16_t(0x0008),
                std::uint16_t(0x0053),
            },
            "l2d_cache_mpki",
            "L2D Cache MPKI",
            "This metric measures the number of level 2 unified cache data accesses missed per thousand instructions "
            "executed. Note that cache accesses in this cache are either data memory access or instruction fetch as "
            "this is a unified cache.",
            "misses",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2d_cache_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t l2d_cache_mpki_1 {
            {
                std::uint16_t(0x0017),
                std::uint16_t(0x0008),
            },
            "l2d_cache_mpki",
            "L2D Cache MPKI",
            "This metric measures the number of level 2 unified cache data accesses missed per thousand instructions "
            "executed. Note that cache accesses in this cache are either data memory access or instruction fetch as "
            "this is a unified cache.",
            "misses",
            1,
            metric_priority_t::l2,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2d_cache_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t l2i_cache_miss_ratio_0 {
            {
                std::uint16_t(0x0028),
                std::uint16_t(0x0027),
            },
            "l2i_cache_miss_ratio",
            "L2I Cache Miss Percentage",
            "This metric measures the ratio of level 2 cache instruction accesses missed to the total number of level "
            "2 cache instruction accesses. This gives an indication of the effectiveness of instruction accesses in "
            "the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache "
            "accesses in this cache are either data memory access or instruction fetch as this is a unified cache.",
            "percent",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2i_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
        };
        [[maybe_unused]] const metric_events_set_t l2i_cache_mpki_0 {
            {
                std::uint16_t(0x0028),
                std::uint16_t(0x0008),
            },
            "l2i_cache_mpki",
            "L2I Cache MPKI",
            "This metric measures the number of level 2 unified cache instruction accesses missed per thousand "
            "instructions executed. Note that cache accesses in this cache are either data memory access or "
            "instruction fetch as this is a unified cache.",
            "misses",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2i_cache_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t l3_cache_miss_ratio_0 {
            {
                std::uint16_t(0x002a),
                std::uint16_t(0x002b),
            },
            "l3_cache_miss_ratio",
            "L3 Cache Miss Percentage",
            "This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache "
            "accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache "
            "that stores both data and instruction. Note that cache accesses in this cache are either data memory "
            "access or instruction fetch as this is a unified cache.",
            "percent",
            0,
            metric_priority_t::l3,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::l3_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
        };
        [[maybe_unused]] const metric_events_set_t l3_cache_miss_ratio_1 {
            {
                std::uint16_t(0x00a2),
                std::uint16_t(0x00a0),
            },
            "l3_cache_miss_ratio",
            "L3 Cache Miss Percentage",
            "This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache "
            "accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache "
            "that stores both data and instruction. Note that cache accesses in this cache are either data memory "
            "access or instruction fetch as this is a unified cache.",
            "percent",
            1,
            metric_priority_t::l3,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::l3_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
        };
        [[maybe_unused]] const metric_events_set_t l3_cache_mpki_0 {
            {
                std::uint16_t(0x002a),
                std::uint16_t(0x0008),
            },
            "l3_cache_mpki",
            "L3 Cache MPKI",
            "This metric measures the number of level 3 unified cache accesses missed per thousand instructions "
            "executed. Note that cache accesses in this cache are either data memory access or instruction fetch as "
            "this is a unified cache.",
            "misses",
            0,
            metric_priority_t::l3,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::l3_cache_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t l3_cache_mpki_1 {
            {
                std::uint16_t(0x00a2),
                std::uint16_t(0x0008),
            },
            "l3_cache_mpki",
            "L3 Cache MPKI",
            "This metric measures the number of level 3 unified cache accesses missed per thousand instructions "
            "executed. Note that cache accesses in this cache are either data memory access or instruction fetch as "
            "this is a unified cache.",
            "misses",
            1,
            metric_priority_t::l3,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::l3_cache_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t ldrex_percentage_0 {
            {
                std::uint16_t(0x006c),
                std::uint16_t(0x001b),
            },
            "ldrex_percentage",
            "Load-Exclusive Instructions Percentage",
            "This metric measures load-exclusive instructions as a percentage of instructions speculatively executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            {
                metric_group_id_t::atomics_effectiveness,
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t ll_cache_read_hit_ratio_0 {
            {
                std::uint16_t(0x0036),
                std::uint16_t(0x0037),
            },
            "ll_cache_read_hit_ratio",
            "LL Cache Read Hit Percentage",
            "This metric measures the ratio of last level cache read accesses hit in the cache to the total number of "
            "last level cache accesses. This gives an indication of the effectiveness of the last level cache for read "
            "traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as "
            "this is a system level cache.",
            "percent",
            0,
            metric_priority_t::ll,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::ll_cache_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t ll_cache_read_miss_ratio_0 {
            {
                std::uint16_t(0x0036),
                std::uint16_t(0x0037),
            },
            "ll_cache_read_miss_ratio",
            "LL Cache Read Miss Percentage",
            "This metric measures the ratio of last level cache read accesses missed to the total number of last level "
            "cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. "
            "Note that cache accesses in this cache are either data memory access or instruction fetch as this is a "
            "system level cache.",
            "percent",
            0,
            metric_priority_t::ll,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::ll_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
        };
        [[maybe_unused]] const metric_events_set_t ll_cache_read_mpki_0 {
            {
                std::uint16_t(0x0008),
                std::uint16_t(0x0037),
            },
            "ll_cache_read_mpki",
            "LL Cache Read MPKI",
            "This metric measures the number of last level cache read accesses missed per thousand instructions "
            "executed.",
            "misses",
            0,
            metric_priority_t::ll,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::ll_cache_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t load_average_latency_0 {
            {
                std::uint16_t(0x0013),
                std::uint16_t(0x8121),
            },
            "load_average_latency",
            "Load Operation Average Latency",
            "This metric measures the average latency of load operations in CPU cycles",
            "cycles",
            0,
            metric_priority_t::latency,
            metric_arch_t::any,
            {
                metric_group_id_t::average_latency,
            },
        };
        [[maybe_unused]] const metric_events_set_t load_ls_percentage_0 {
            {
                std::uint16_t(0x0070),
                std::uint16_t(0x0072),
            },
            "load_ls_percentage",
            "Load as Load/Store Operations Percentage",
            "This metric measures load operations as a percentage of load and store operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            {
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t load_percentage_0 {
            {
                std::uint16_t(0x0070),
                std::uint16_t(0x001b),
            },
            "load_percentage",
            "Load Operations Percentage",
            "This metric measures load operations as a percentage of operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t load_store_percentage_0 {
            {
                std::uint16_t(0x001b),
                std::uint16_t(0x0072),
            },
            "load_store_percentage",
            "Load/Store Operations Percentage",
            "This metric measures load and store operations as a percentage of operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            {
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t mcq_stall_percentage_0 {
            {
                std::uint16_t(0x0160),
                std::uint16_t(0x816a),
            },
            "mcq_stall_percentage",
            "Commit Queue Stall Percentage",
            "This metric measures the percentage of backend stall cycles where no commit queue resource was available",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            {
                metric_group_id_t::mcq_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t nonsve_fp_ops_per_cycle_0 {
            {
                std::uint16_t(0x80c1),
            },
            "nonsve_fp_ops_per_cycle",
            "Non-SVE Floating Point Operations per Cycle",
            "This metric measures floating point operations per cycle in any precision performed by an instruction "
            "that is not an SVE instruction. Operations are counted by computation and by vector lanes, fused "
            "computations such as multiply-add count as twice per vector lane for example.",
            "operations",
            0,
            metric_priority_t::numeric,
            metric_arch_t::v8,
            {
                metric_group_id_t::fp_arithmetic_intensity,
            },
        };
        [[maybe_unused]] const metric_events_set_t rc_ld_percentage_0 {
            {
                std::uint16_t(0x0090),
                std::uint16_t(0x001b),
            },
            "rc_ld_percentage",
            "Load-Acquire Instructions Percentage",
            "This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of "
            "instructions speculatively executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            {
                metric_group_id_t::atomics_effectiveness,
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t rc_st_percentage_0 {
            {
                std::uint16_t(0x0091),
                std::uint16_t(0x001b),
            },
            "rc_st_percentage",
            "Store-Release Instructions Percentage",
            "This metric measures memory-write instructions with release semantics as a percentage of instructions "
            "speculatively executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            {
                metric_group_id_t::atomics_effectiveness,
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t retired_insns_percent_0 {
            {
                std::uint16_t(0x0008),
                std::uint16_t(0x001b),
            },
            "retired_insns_percent",
            "Retired Instructions Percentage",
            "This metric measures the percentage of instructions speculatively executed that are subsequently retired",
            "percent",
            0,
            metric_priority_t::retiring,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_l1,
            },
        };
        [[maybe_unused]] const metric_events_set_t retired_ops_percent_0 {
            {
                std::uint16_t(0x003a),
                std::uint16_t(0x003b),
            },
            "retired_ops_percent",
            "Retired Operations Percentage",
            "This metric measures the percentage of operations speculatively executed that are subsequently retired",
            "percent",
            0,
            metric_priority_t::retiring,
            metric_arch_t::any,
            {
                metric_group_id_t::topdown_l1,
            },
        };
        [[maybe_unused]] const metric_events_set_t retiring_0 {
            {
                std::uint16_t(0x003a),
                std::uint16_t(0x003f),
                std::uint16_t(0x003b),
            },
            "retiring",
            "Retiring",
            "This metric is the percentage of total slots that retired operations, which indicates cycles that were "
            "utilized efficiently.",
            "percent",
            0,
            metric_priority_t::retiring,
            metric_arch_t::v8,
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
        };
        [[maybe_unused]] const metric_events_set_t retiring_1 {
            {
                std::uint16_t(0x003a),
                std::uint16_t(0x003f),
                std::uint16_t(0x003b),
            },
            "retiring",
            "Retiring",
            "This metric is the percentage of total slots that retired operations, which indicates cycles that were "
            "utilized efficiently.",
            "percent",
            1,
            metric_priority_t::retiring,
            metric_arch_t::v8,
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
        };
        [[maybe_unused]] const metric_events_set_t retiring_2 {
            {
                std::uint16_t(0x003a),
                std::uint16_t(0x003f),
                std::uint16_t(0x003b),
            },
            "retiring",
            "Retiring",
            "This metric is the percentage of total slots that retired operations, which indicates cycles that were "
            "utilized efficiently.",
            "percent",
            2,
            metric_priority_t::retiring,
            metric_arch_t::v8,
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
        };
        [[maybe_unused]] const metric_events_set_t scalar_fp_percentage_0 {
            {
                std::uint16_t(0x0075),
                std::uint16_t(0x001b),
            },
            "scalar_fp_percentage",
            "Floating Point Operations Percentage",
            "This metric measures scalar floating point operations as a percentage of operations speculatively "
            "executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t simd_percentage_0 {
            {
                std::uint16_t(0x0074),
                std::uint16_t(0x001b),
            },
            "simd_percentage",
            "Advanced SIMD Operations Percentage",
            "This metric measures advanced SIMD operations as a percentage of total operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t store_ls_percentage_0 {
            {
                std::uint16_t(0x0071),
                std::uint16_t(0x0072),
            },
            "store_ls_percentage",
            "Store as Load/Store Operations Percentage",
            "This metric measures store operations as a percentage of load and store operations speculatively "
            "executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            {
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t store_percentage_0 {
            {
                std::uint16_t(0x0071),
                std::uint16_t(0x001b),
            },
            "store_percentage",
            "Store Operations Percentage",
            "This metric measures store operations as a percentage of operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t strex_fail_mpki_0 {
            {
                std::uint16_t(0x001b),
                std::uint16_t(0x006e),
            },
            "strex_fail_mpki",
            "Store-Exclusive Failures PKI",
            "This metric measures the number of store-exclusive instructions that failed per thousand instructions "
            "speculatively executed",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            {
                metric_group_id_t::atomics_effectiveness,
                metric_group_id_t::mpki,
            },
        };
        [[maybe_unused]] const metric_events_set_t strex_fail_percent_0 {
            {
                std::uint16_t(0x006f),
                std::uint16_t(0x006e),
            },
            "strex_fail_percent",
            "Store-Exclusive Failures Percentage",
            "This metric measures the number of store-exclusive instructions that failed as a percentage of "
            "store-exclusive instructions speculatively executed",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            {
                metric_group_id_t::atomics_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t strex_percentage_0 {
            {
                std::uint16_t(0x006f),
                std::uint16_t(0x001b),
            },
            "strex_percentage",
            "Store-Exclusive Instructions Percentage",
            "This metric measures store-exclusive instructions as a percentage of instructions speculatively executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            {
                metric_group_id_t::atomics_effectiveness,
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t sve_all_percentage_0 {
            {
                std::uint16_t(0x001b),
                std::uint16_t(0x8006),
            },
            "sve_all_percentage",
            "SVE Operations (Load/Store Inclusive) Percentage",
            "This metric measures scalable vector operations, including loads and stores, as a percentage of "
            "operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            {
                metric_group_id_t::basic,
                metric_group_id_t::operation_mix,
            },
        };
        [[maybe_unused]] const metric_events_set_t sve_fp_ops_per_cycle_0 {
            {
                std::uint16_t(0x80c0),
            },
            "sve_fp_ops_per_cycle",
            "SVE Floating Point Operations per Cycle",
            "This metric measures floating point operations per cycle in any precision performed by SVE instructions. "
            "Operations are counted by computation and by vector lanes, fused computations such as multiply-add count "
            "as twice per vector lane for example.",
            "operations",
            0,
            metric_priority_t::numeric,
            metric_arch_t::v8,
            {
                metric_group_id_t::fp_arithmetic_intensity,
            },
        };
        [[maybe_unused]] const metric_events_set_t sve_predicate_empty_percentage_0 {
            {
                std::uint16_t(0x8075),
                std::uint16_t(0x8074),
            },
            "sve_predicate_empty_percentage",
            "SVE Empty Predicate Percentage",
            "This metric measures scalable vector operations with no active predicates as a percentage of sve "
            "predicated operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            {
                metric_group_id_t::sve_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t sve_predicate_full_percentage_0 {
            {
                std::uint16_t(0x8076),
                std::uint16_t(0x8074),
            },
            "sve_predicate_full_percentage",
            "SVE Full Predicate Percentage",
            "This metric measures scalable vector operations with all active predicates as a percentage of sve "
            "predicated operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            {
                metric_group_id_t::sve_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t sve_predicate_partial_percentage_0 {
            {
                std::uint16_t(0x8077),
                std::uint16_t(0x8074),
            },
            "sve_predicate_partial_percentage",
            "SVE Partial Predicate Percentage",
            "This metric measures scalable vector operations with at least one active predicates as a percentage of "
            "sve predicated operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            {
                metric_group_id_t::sve_effectiveness,
            },
        };
        [[maybe_unused]] const metric_events_set_t sve_predicate_percentage_0 {
            {
                std::uint16_t(0x8074),
                std::uint16_t(0x001b),
            },
            "sve_predicate_percentage",
            "SVE Predicate Percentage",
            "This metric measures scalable vector operations with predicates as a percentage of operations "
            "speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            {
                metric_group_id_t::sve_effectiveness,
            },
        };
        const metric_cpu_events_t cortex_a32_metrics {
            branch_mpki_0,
            cpi_0,
            ipc_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_mpki_0,
        };
        const metric_cpu_events_t cortex_a34_metrics {
            branch_mpki_0,
            cpi_0,
            ipc_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_mpki_0,
        };
        const metric_cpu_events_t cortex_a35_metrics {
            branch_mpki_0,
            cpi_0,
            crypto_percentage_0,
            integer_dp_percentage_1,
            ipc_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_mpki_0,
            retired_insns_percent_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
        };
        const metric_cpu_events_t cortex_a53_metrics {
            branch_mpki_0,
            cpi_0,
            ipc_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_mpki_0,
        };
        const metric_cpu_events_t cortex_a55_metrics {
            backend_stall_interlock_bound_0,
            backend_stalled_cycles_0,
            branch_direct_ratio_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            branch_return_ratio_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            frontend_stalled_cycles_0,
            integer_dp_percentage_1,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_0,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_mpki_0,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_mpki_0,
            l3_cache_miss_ratio_1,
            l3_cache_mpki_1,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            retired_insns_percent_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
        };
        const metric_cpu_events_t cortex_a57_metrics {
            barrier_percentage_0,
            branch_mpki_0,
            branch_percentage_0,
            cpi_0,
            crypto_percentage_0,
            integer_dp_percentage_0,
            ipc_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            ldrex_percentage_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_insns_percent_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
        };
        const metric_cpu_events_t cortex_a65ae_metrics {
            backend_stalled_cycles_0,
            branch_direct_ratio_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            branch_return_ratio_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            frontend_stalled_cycles_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            retired_insns_percent_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
        };
        const metric_cpu_events_t neoverse_e1_metrics {
            backend_stalled_cycles_0,
            branch_direct_ratio_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            branch_return_ratio_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            frontend_stalled_cycles_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            retired_insns_percent_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
        };
        const metric_cpu_events_t cortex_a72_metrics {
            barrier_percentage_0,
            branch_mpki_0,
            branch_percentage_0,
            cpi_0,
            crypto_percentage_0,
            integer_dp_percentage_0,
            ipc_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            ldrex_percentage_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_insns_percent_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
        };
        const metric_cpu_events_t cortex_a73_metrics {
            barrier_percentage_0,   branch_mpki_0,           cpi_0,
            crypto_percentage_0,    integer_dp_percentage_0, ipc_0,
            l1d_cache_miss_ratio_0, l1d_cache_mpki_1,        l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0, l1i_cache_mpki_0,        l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,  l2_cache_mpki_1,         l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,       ldrex_percentage_0,      load_ls_percentage_0,
            load_percentage_0,      load_store_percentage_0, retired_insns_percent_0,
            scalar_fp_percentage_0, simd_percentage_0,       store_ls_percentage_0,
            store_percentage_0,     strex_fail_mpki_0,
        };
        const metric_cpu_events_t cortex_a75_metrics {
            backend_stalled_cycles_0,
            barrier_percentage_0,
            branch_direct_ratio_0,
            branch_mpki_0,
            branch_return_ratio_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            frontend_stalled_cycles_0,
            integer_dp_percentage_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            retired_insns_percent_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
        };
        const metric_cpu_events_t cortex_a76_metrics {
            backend_stalled_cycles_0,
            barrier_percentage_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            frontend_stalled_cycles_0,
            integer_dp_percentage_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_insns_percent_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
        };
        const metric_cpu_events_t cortex_a77_metrics {
            backend_stalled_cycles_0,
            barrier_percentage_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            frontend_stalled_cycles_0,
            integer_dp_percentage_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_insns_percent_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
        };
        const metric_cpu_events_t cortex_a78_metrics {
            backend_bound_0,
            backend_mem_bound_0,
            backend_stalled_cycles_0,
            barrier_percentage_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            frontend_stalled_cycles_0,
            integer_dp_percentage_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_percentage_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
        };
        const metric_cpu_events_t cortex_a78ae_metrics {
            backend_bound_0,
            backend_mem_bound_0,
            backend_stalled_cycles_0,
            barrier_percentage_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            frontend_stalled_cycles_0,
            integer_dp_percentage_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_percentage_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
        };
        const metric_cpu_events_t cortex_a78c_metrics {
            backend_bound_0,
            backend_mem_bound_0,
            backend_stalled_cycles_0,
            barrier_percentage_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            frontend_stalled_cycles_0,
            integer_dp_percentage_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_percentage_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
        };
        const metric_cpu_events_t cortex_a510_metrics {
            backend_bound_0,
            backend_mem_bound_0,
            backend_stall_interlock_bound_0,
            backend_stalled_cycles_0,
            branch_direct_ratio_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            branch_return_ratio_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            fp16_percentage_0,
            fp32_percentage_0,
            fp64_percentage_0,
            frontend_stalled_cycles_0,
            integer_dp_percentage_1,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_0,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_mpki_0,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_mpki_0,
            l3_cache_miss_ratio_1,
            l3_cache_mpki_1,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
        };
        const metric_cpu_events_t cortex_a520_metrics {
            backend_bound_0,
            backend_busy_bound_0,
            backend_cache_l1d_bound_0,
            backend_cache_l2d_bound_0,
            backend_mem_bound_1,
            backend_mem_cache_bound_0,
            backend_mem_store_bound_0,
            backend_mem_tlb_bound_0,
            backend_stall_interlock_bound_1,
            backend_stalled_cycles_0,
            bad_speculation_0,
            branch_direct_ratio_0,
            branch_indirect_ratio_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            branch_return_ratio_0,
            bus_read_requests_average_latency_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_average_depth_0,
            dtlb_walk_average_latency_0,
            dtlb_walk_large_ratio_0,
            dtlb_walk_ratio_0,
            dtlb_walk_small_ratio_0,
            fp16_percentage_0,
            fp32_percentage_0,
            fp64_percentage_0,
            frontend_bound_0,
            frontend_cache_l1i_bound_0,
            frontend_cache_l2i_bound_0,
            frontend_core_bound_0,
            frontend_core_flow_bound_0,
            frontend_core_flush_bound_0,
            frontend_mem_bound_0,
            frontend_mem_cache_bound_0,
            frontend_mem_tlb_bound_0,
            frontend_stalled_cycles_0,
            instruction_fetch_average_latency_0,
            integer_dp_percentage_1,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_average_depth_0,
            itlb_walk_average_latency_0,
            itlb_walk_large_ratio_0,
            itlb_walk_ratio_0,
            itlb_walk_small_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_0,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_mpki_0,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_mpki_0,
            l3_cache_miss_ratio_1,
            l3_cache_mpki_1,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_average_latency_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
        };
        const metric_cpu_events_t cortex_a520ae_metrics {
            backend_bound_0,
            backend_busy_bound_0,
            backend_cache_l1d_bound_0,
            backend_cache_l2d_bound_0,
            backend_mem_bound_1,
            backend_mem_cache_bound_0,
            backend_mem_store_bound_0,
            backend_mem_tlb_bound_0,
            backend_stall_interlock_bound_1,
            backend_stalled_cycles_0,
            bad_speculation_0,
            branch_direct_ratio_0,
            branch_indirect_ratio_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            branch_return_ratio_0,
            bus_read_requests_average_latency_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_average_depth_0,
            dtlb_walk_average_latency_0,
            dtlb_walk_large_ratio_0,
            dtlb_walk_ratio_0,
            dtlb_walk_small_ratio_0,
            fp16_percentage_0,
            fp32_percentage_0,
            fp64_percentage_0,
            frontend_bound_0,
            frontend_cache_l1i_bound_0,
            frontend_cache_l2i_bound_0,
            frontend_core_bound_0,
            frontend_core_flow_bound_0,
            frontend_core_flush_bound_0,
            frontend_mem_bound_0,
            frontend_mem_cache_bound_0,
            frontend_mem_tlb_bound_0,
            frontend_stalled_cycles_0,
            instruction_fetch_average_latency_0,
            integer_dp_percentage_1,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_average_depth_0,
            itlb_walk_average_latency_0,
            itlb_walk_large_ratio_0,
            itlb_walk_ratio_0,
            itlb_walk_small_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_0,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_mpki_0,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_mpki_0,
            l3_cache_miss_ratio_1,
            l3_cache_mpki_1,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_average_latency_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
        };
        const metric_cpu_events_t cortex_a710_metrics {
            backend_bound_0,
            backend_mem_bound_0,
            backend_stalled_cycles_0,
            barrier_percentage_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            fp16_percentage_0,
            fp32_percentage_0,
            fp64_percentage_0,
            fp_ops_per_cycle_0,
            frontend_stalled_cycles_0,
            integer_dp_percentage_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_percentage_0,
            nonsve_fp_ops_per_cycle_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
            sve_all_percentage_0,
            sve_fp_ops_per_cycle_0,
            sve_predicate_empty_percentage_0,
            sve_predicate_full_percentage_0,
            sve_predicate_partial_percentage_0,
            sve_predicate_percentage_0,
        };
        const metric_cpu_events_t cortex_x2_metrics {
            backend_bound_0,
            backend_mem_bound_0,
            backend_stalled_cycles_0,
            barrier_percentage_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            fp16_percentage_0,
            fp32_percentage_0,
            fp64_percentage_0,
            fp_ops_per_cycle_0,
            frontend_stalled_cycles_0,
            integer_dp_percentage_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_percentage_0,
            nonsve_fp_ops_per_cycle_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
            sve_all_percentage_0,
            sve_fp_ops_per_cycle_0,
            sve_predicate_empty_percentage_0,
            sve_predicate_full_percentage_0,
            sve_predicate_partial_percentage_0,
            sve_predicate_percentage_0,
        };
        const metric_cpu_events_t cortex_x3_metrics {
            backend_bound_0,
            backend_mem_bound_0,
            backend_stalled_cycles_0,
            barrier_percentage_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            fp16_percentage_0,
            fp32_percentage_0,
            fp64_percentage_0,
            fp_ops_per_cycle_0,
            frontend_stalled_cycles_0,
            integer_dp_percentage_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_percentage_0,
            nonsve_fp_ops_per_cycle_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
            sve_all_percentage_0,
            sve_fp_ops_per_cycle_0,
            sve_predicate_empty_percentage_0,
            sve_predicate_full_percentage_0,
            sve_predicate_partial_percentage_0,
            sve_predicate_percentage_0,
        };
        const metric_cpu_events_t cortex_a715_metrics {
            backend_bound_0,
            backend_mem_bound_0,
            backend_stalled_cycles_0,
            barrier_percentage_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            fp16_percentage_0,
            fp32_percentage_0,
            fp64_percentage_0,
            fp_ops_per_cycle_0,
            frontend_stalled_cycles_0,
            integer_dp_percentage_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_percentage_0,
            nonsve_fp_ops_per_cycle_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
            sve_all_percentage_0,
            sve_fp_ops_per_cycle_0,
            sve_predicate_empty_percentage_0,
            sve_predicate_full_percentage_0,
            sve_predicate_partial_percentage_0,
            sve_predicate_percentage_0,
        };
        const metric_cpu_events_t cortex_a720_metrics {
            backend_bound_0,
            backend_busy_bound_0,
            backend_cache_l1d_bound_0,
            backend_cache_l2d_bound_0,
            backend_core_bound_0,
            backend_core_rename_bound_0,
            backend_mem_bound_1,
            backend_mem_cache_bound_1,
            backend_mem_store_bound_1,
            backend_mem_tlb_bound_1,
            backend_stalled_cycles_0,
            bad_speculation_0,
            barrier_percentage_0,
            branch_direct_ratio_0,
            branch_indirect_ratio_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_return_ratio_0,
            cas_near_fail_ratio_0,
            cas_near_pass_ratio_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_average_depth_1,
            dtlb_walk_average_latency_0,
            dtlb_walk_large_ratio_0,
            dtlb_walk_ratio_0,
            dtlb_walk_small_ratio_0,
            fp16_percentage_0,
            fp32_percentage_0,
            fp64_percentage_0,
            fp_ops_per_cycle_0,
            frontend_bound_0,
            frontend_cache_l1i_bound_0,
            frontend_cache_l2i_bound_0,
            frontend_core_bound_0,
            frontend_core_flush_bound_0,
            frontend_mem_bound_0,
            frontend_mem_cache_bound_0,
            frontend_mem_tlb_bound_0,
            frontend_stalled_cycles_0,
            instruction_fetch_average_latency_0,
            integer_dp_percentage_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_average_depth_1,
            itlb_walk_average_latency_0,
            itlb_walk_large_ratio_0,
            itlb_walk_ratio_0,
            itlb_walk_small_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_average_latency_0,
            load_percentage_0,
            nonsve_fp_ops_per_cycle_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
            sve_all_percentage_0,
            sve_fp_ops_per_cycle_0,
            sve_predicate_empty_percentage_0,
            sve_predicate_full_percentage_0,
            sve_predicate_partial_percentage_0,
            sve_predicate_percentage_0,
        };
        const metric_cpu_events_t cortex_a720ae_metrics {
            backend_bound_0,
            backend_busy_bound_0,
            backend_cache_l1d_bound_0,
            backend_cache_l2d_bound_0,
            backend_core_bound_0,
            backend_core_rename_bound_0,
            backend_mem_bound_1,
            backend_mem_cache_bound_1,
            backend_mem_store_bound_1,
            backend_mem_tlb_bound_1,
            backend_stalled_cycles_0,
            bad_speculation_0,
            barrier_percentage_0,
            branch_direct_ratio_0,
            branch_indirect_ratio_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_return_ratio_0,
            cas_near_fail_ratio_0,
            cas_near_pass_ratio_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_average_depth_1,
            dtlb_walk_average_latency_0,
            dtlb_walk_large_ratio_0,
            dtlb_walk_ratio_0,
            dtlb_walk_small_ratio_0,
            fp16_percentage_0,
            fp32_percentage_0,
            fp64_percentage_0,
            fp_ops_per_cycle_0,
            frontend_bound_0,
            frontend_cache_l1i_bound_0,
            frontend_cache_l2i_bound_0,
            frontend_core_bound_0,
            frontend_core_flush_bound_0,
            frontend_mem_bound_0,
            frontend_mem_cache_bound_0,
            frontend_mem_tlb_bound_0,
            frontend_stalled_cycles_0,
            instruction_fetch_average_latency_0,
            integer_dp_percentage_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_average_depth_1,
            itlb_walk_average_latency_0,
            itlb_walk_large_ratio_0,
            itlb_walk_ratio_0,
            itlb_walk_small_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_average_latency_0,
            load_percentage_0,
            nonsve_fp_ops_per_cycle_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
            sve_all_percentage_0,
            sve_fp_ops_per_cycle_0,
            sve_predicate_empty_percentage_0,
            sve_predicate_full_percentage_0,
            sve_predicate_partial_percentage_0,
            sve_predicate_percentage_0,
        };
        const metric_cpu_events_t cortex_a725_metrics {
            backend_bound_0,
            backend_busy_bound_0,
            backend_cache_l1d_bound_0,
            backend_cache_l2d_bound_0,
            backend_core_bound_0,
            backend_core_rename_bound_0,
            backend_mem_bound_1,
            backend_mem_cache_bound_1,
            backend_mem_store_bound_1,
            backend_mem_tlb_bound_1,
            backend_stalled_cycles_0,
            bad_speculation_0,
            barrier_percentage_0,
            branch_direct_ratio_0,
            branch_indirect_ratio_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_return_ratio_0,
            cas_near_fail_ratio_0,
            cas_near_pass_ratio_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_average_depth_1,
            dtlb_walk_average_latency_0,
            dtlb_walk_large_ratio_0,
            dtlb_walk_ratio_0,
            dtlb_walk_small_ratio_0,
            fp16_percentage_0,
            fp32_percentage_0,
            fp64_percentage_0,
            fp_ops_per_cycle_0,
            frontend_bound_0,
            frontend_cache_l1i_bound_0,
            frontend_cache_l2i_bound_0,
            frontend_core_bound_0,
            frontend_core_flush_bound_0,
            frontend_mem_bound_0,
            frontend_mem_cache_bound_0,
            frontend_mem_tlb_bound_0,
            frontend_stalled_cycles_0,
            instruction_fetch_average_latency_0,
            integer_dp_percentage_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_average_depth_1,
            itlb_walk_average_latency_0,
            itlb_walk_large_ratio_0,
            itlb_walk_ratio_0,
            itlb_walk_small_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l2i_cache_miss_ratio_0,
            l2i_cache_mpki_0,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_average_latency_0,
            load_percentage_0,
            nonsve_fp_ops_per_cycle_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
            sve_all_percentage_0,
            sve_fp_ops_per_cycle_0,
            sve_predicate_empty_percentage_0,
            sve_predicate_full_percentage_0,
            sve_predicate_partial_percentage_0,
            sve_predicate_percentage_0,
        };
        const metric_cpu_events_t cortex_x1_metrics {
            backend_bound_0,
            backend_mem_bound_0,
            backend_stalled_cycles_0,
            barrier_percentage_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            frontend_stalled_cycles_0,
            integer_dp_percentage_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_percentage_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
        };
        const metric_cpu_events_t cortex_x1c_metrics {
            backend_bound_0,
            backend_mem_bound_0,
            backend_stalled_cycles_0,
            barrier_percentage_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            frontend_stalled_cycles_0,
            integer_dp_percentage_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_percentage_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
        };
        const metric_cpu_events_t cortex_x4_metrics {
            backend_bound_0,
            backend_busy_bound_0,
            backend_cache_l1d_bound_0,
            backend_cache_l2d_bound_0,
            backend_core_bound_0,
            backend_core_rename_bound_0,
            backend_mem_bound_1,
            backend_mem_cache_bound_1,
            backend_mem_store_bound_1,
            backend_mem_tlb_bound_1,
            backend_stalled_cycles_0,
            bad_speculation_0,
            barrier_percentage_0,
            branch_direct_ratio_0,
            branch_indirect_ratio_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            branch_return_ratio_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_average_depth_1,
            dtlb_walk_average_latency_0,
            dtlb_walk_large_ratio_0,
            dtlb_walk_ratio_0,
            dtlb_walk_small_ratio_0,
            fp16_percentage_0,
            fp32_percentage_0,
            fp64_percentage_0,
            fp_ops_per_cycle_0,
            frontend_bound_0,
            frontend_cache_l1i_bound_0,
            frontend_cache_l2i_bound_0,
            frontend_core_bound_0,
            frontend_core_flow_bound_0,
            frontend_core_flush_bound_0,
            frontend_mem_bound_0,
            frontend_mem_cache_bound_0,
            frontend_mem_tlb_bound_0,
            frontend_stalled_cycles_0,
            instruction_fetch_average_latency_0,
            integer_dp_percentage_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_average_depth_1,
            itlb_walk_average_latency_0,
            itlb_walk_large_ratio_0,
            itlb_walk_ratio_0,
            itlb_walk_small_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_average_latency_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            nonsve_fp_ops_per_cycle_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
            sve_all_percentage_0,
            sve_fp_ops_per_cycle_0,
            sve_predicate_empty_percentage_0,
            sve_predicate_full_percentage_0,
            sve_predicate_partial_percentage_0,
            sve_predicate_percentage_0,
        };
        const metric_cpu_events_t cortex_x925_metrics {
            backend_bound_0,
            backend_busy_bound_0,
            backend_cache_l1d_bound_0,
            backend_cache_l2d_bound_0,
            backend_core_bound_0,
            backend_core_rename_bound_0,
            backend_mem_bound_1,
            backend_mem_cache_bound_1,
            backend_mem_store_bound_1,
            backend_mem_tlb_bound_1,
            backend_stalled_cycles_0,
            bad_speculation_0,
            barrier_percentage_0,
            branch_direct_ratio_0,
            branch_indirect_ratio_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            branch_return_ratio_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_average_depth_1,
            dtlb_walk_average_latency_0,
            dtlb_walk_large_ratio_0,
            dtlb_walk_ratio_0,
            dtlb_walk_small_ratio_0,
            fp16_percentage_0,
            fp32_percentage_0,
            fp64_percentage_0,
            fp_ops_per_cycle_0,
            frontend_bound_0,
            frontend_cache_l1i_bound_0,
            frontend_cache_l2i_bound_0,
            frontend_core_bound_0,
            frontend_core_flow_bound_0,
            frontend_core_flush_bound_0,
            frontend_mem_bound_0,
            frontend_mem_cache_bound_0,
            frontend_mem_tlb_bound_0,
            frontend_stalled_cycles_0,
            instruction_fetch_average_latency_0,
            integer_dp_percentage_0,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_average_depth_1,
            itlb_walk_average_latency_0,
            itlb_walk_large_ratio_0,
            itlb_walk_ratio_0,
            itlb_walk_small_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_average_latency_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            nonsve_fp_ops_per_cycle_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
            sve_all_percentage_0,
            sve_fp_ops_per_cycle_0,
            sve_predicate_empty_percentage_0,
            sve_predicate_full_percentage_0,
            sve_predicate_partial_percentage_0,
            sve_predicate_percentage_0,
        };
        const metric_cpu_events_t cortex_r52__metrics {
            backend_stalled_cycles_0,
            branch_direct_ratio_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_return_ratio_0,
            cpi_0,
            frontend_stalled_cycles_0,
            ipc_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            retired_insns_percent_0,
        };
        const metric_cpu_events_t cortex_r82_metrics {
            backend_stalled_cycles_0,
            branch_direct_ratio_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            branch_return_ratio_0,
            cpi_0,
            frontend_stalled_cycles_0,
            ipc_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            retired_ops_percent_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
        };
        const metric_cpu_events_t cortex_r82ae_metrics {
            backend_stalled_cycles_0,
            branch_direct_ratio_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            branch_return_ratio_0,
            cpi_0,
            frontend_stalled_cycles_0,
            ipc_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            retired_ops_percent_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
        };
        const metric_cpu_events_t neoverse_n1_metrics {
            backend_stalled_cycles_0,
            barrier_percentage_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            frontend_stalled_cycles_0,
            integer_dp_percentage_1,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_insns_percent_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
        };
        const metric_cpu_events_t neoverse_v1_metrics {
            backend_bound_0,
            backend_mem_bound_0,
            backend_stalled_cycles_0,
            bad_speculation_2,
            barrier_percentage_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            fp_ops_per_cycle_0,
            frontend_bound_2,
            frontend_stalled_cycles_0,
            integer_dp_percentage_1,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_percentage_0,
            nonsve_fp_ops_per_cycle_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
            sve_all_percentage_0,
            sve_fp_ops_per_cycle_0,
            sve_predicate_empty_percentage_0,
            sve_predicate_full_percentage_0,
            sve_predicate_partial_percentage_0,
            sve_predicate_percentage_0,
        };
        const metric_cpu_events_t neoverse_n2_common_metrics {
            backend_bound_1,
            backend_mem_bound_0,
            backend_stalled_cycles_0,
            barrier_percentage_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            fp16_percentage_0,
            fp32_percentage_0,
            fp64_percentage_0,
            fp_ops_per_cycle_0,
            frontend_stalled_cycles_0,
            integer_dp_percentage_1,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_percentage_0,
            nonsve_fp_ops_per_cycle_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
            sve_all_percentage_0,
            sve_fp_ops_per_cycle_0,
            sve_predicate_empty_percentage_0,
            sve_predicate_full_percentage_0,
            sve_predicate_partial_percentage_0,
            sve_predicate_percentage_0,
        };
        const metric_cpu_events_t neoverse_n2_tel_v0_metrics {
            bad_speculation_1,
            frontend_bound_1,
            retiring_1,
        };
        const metric_cpu_events_t neoverse_n2_tel_v1_metrics {
            bad_speculation_2,
            frontend_bound_2,
        };
        const metric_cpu_events_t neoverse_v2_metrics {
            backend_bound_1,
            backend_mem_bound_0,
            backend_stalled_cycles_0,
            bad_speculation_2,
            barrier_percentage_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_ratio_0,
            fp16_percentage_0,
            fp32_percentage_0,
            fp64_percentage_0,
            fp_ops_per_cycle_0,
            frontend_bound_2,
            frontend_stalled_cycles_0,
            integer_dp_percentage_1,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_percentage_0,
            nonsve_fp_ops_per_cycle_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_2,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
            sve_all_percentage_0,
            sve_fp_ops_per_cycle_0,
            sve_predicate_empty_percentage_0,
            sve_predicate_full_percentage_0,
            sve_predicate_partial_percentage_0,
            sve_predicate_percentage_0,
        };
        const metric_cpu_events_t neoverse_n3_metrics {
            backend_bound_0,
            backend_busy_bound_0,
            backend_cache_l1d_bound_0,
            backend_cache_l2d_bound_0,
            backend_core_bound_0,
            backend_core_rename_bound_0,
            backend_mem_bound_1,
            backend_mem_cache_bound_1,
            backend_mem_store_bound_1,
            backend_mem_tlb_bound_1,
            backend_stalled_cycles_0,
            bad_speculation_0,
            barrier_percentage_0,
            branch_direct_ratio_0,
            branch_indirect_ratio_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_1,
            branch_return_ratio_0,
            cas_near_fail_ratio_0,
            cas_near_pass_ratio_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_average_depth_1,
            dtlb_walk_average_latency_0,
            dtlb_walk_large_ratio_0,
            dtlb_walk_ratio_0,
            dtlb_walk_small_ratio_0,
            fp16_percentage_0,
            fp32_percentage_0,
            fp64_percentage_0,
            fp_ops_per_cycle_0,
            frontend_bound_0,
            frontend_cache_l1i_bound_0,
            frontend_cache_l2i_bound_0,
            frontend_core_bound_0,
            frontend_core_flow_bound_0,
            frontend_core_flush_bound_0,
            frontend_mem_bound_0,
            frontend_mem_cache_bound_0,
            frontend_mem_tlb_bound_0,
            frontend_stalled_cycles_0,
            instruction_fetch_average_latency_0,
            integer_dp_percentage_0,
            ipc_0,
            iq_stall_lsu_percentage_0,
            iq_stall_mx_percentage_0,
            iq_stall_sx_percentage_0,
            iq_stall_vpu_percentage_0,
            itlb_mpki_0,
            itlb_walk_average_depth_1,
            itlb_walk_average_latency_0,
            itlb_walk_large_ratio_0,
            itlb_walk_ratio_0,
            itlb_walk_small_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            l2i_cache_miss_ratio_0,
            l2i_cache_mpki_0,
            l3_cache_miss_ratio_0,
            l3_cache_mpki_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_average_latency_0,
            load_percentage_0,
            mcq_stall_percentage_0,
            nonsve_fp_ops_per_cycle_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
            sve_all_percentage_0,
            sve_fp_ops_per_cycle_0,
            sve_predicate_empty_percentage_0,
            sve_predicate_full_percentage_0,
            sve_predicate_partial_percentage_0,
            sve_predicate_percentage_0,
        };
        const metric_cpu_events_t neoverse_v3_metrics {
            backend_bound_0,
            backend_busy_bound_0,
            backend_cache_l1d_bound_0,
            backend_cache_l2d_bound_0,
            backend_core_bound_0,
            backend_core_rename_bound_0,
            backend_mem_bound_1,
            backend_mem_cache_bound_1,
            backend_mem_store_bound_1,
            backend_mem_tlb_bound_1,
            backend_stalled_cycles_0,
            bad_speculation_0,
            barrier_percentage_0,
            branch_direct_ratio_0,
            branch_indirect_ratio_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            branch_return_ratio_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_average_depth_1,
            dtlb_walk_average_latency_0,
            dtlb_walk_large_ratio_0,
            dtlb_walk_ratio_0,
            dtlb_walk_small_ratio_0,
            fp16_percentage_0,
            fp32_percentage_0,
            fp64_percentage_0,
            fp_ops_per_cycle_0,
            frontend_bound_0,
            frontend_cache_l1i_bound_0,
            frontend_cache_l2i_bound_0,
            frontend_core_bound_0,
            frontend_core_flow_bound_0,
            frontend_core_flush_bound_0,
            frontend_mem_bound_0,
            frontend_mem_cache_bound_0,
            frontend_mem_tlb_bound_0,
            frontend_stalled_cycles_0,
            instruction_fetch_average_latency_0,
            integer_dp_percentage_1,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_average_depth_1,
            itlb_walk_average_latency_0,
            itlb_walk_large_ratio_0,
            itlb_walk_ratio_0,
            itlb_walk_small_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_average_latency_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            nonsve_fp_ops_per_cycle_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
            sve_all_percentage_0,
            sve_fp_ops_per_cycle_0,
            sve_predicate_empty_percentage_0,
            sve_predicate_full_percentage_0,
            sve_predicate_partial_percentage_0,
            sve_predicate_percentage_0,
        };
        const metric_cpu_events_t neoverse_v3ae_metrics {
            backend_bound_0,
            backend_busy_bound_0,
            backend_cache_l1d_bound_0,
            backend_cache_l2d_bound_0,
            backend_core_bound_0,
            backend_core_rename_bound_0,
            backend_mem_bound_1,
            backend_mem_cache_bound_1,
            backend_mem_store_bound_1,
            backend_mem_tlb_bound_1,
            backend_stalled_cycles_0,
            bad_speculation_0,
            barrier_percentage_0,
            branch_direct_ratio_0,
            branch_indirect_ratio_0,
            branch_misprediction_ratio_0,
            branch_mpki_1,
            branch_percentage_0,
            branch_return_ratio_0,
            cpi_0,
            crypto_percentage_0,
            dtlb_mpki_0,
            dtlb_walk_average_depth_1,
            dtlb_walk_average_latency_0,
            dtlb_walk_large_ratio_0,
            dtlb_walk_ratio_0,
            dtlb_walk_small_ratio_0,
            fp16_percentage_0,
            fp32_percentage_0,
            fp64_percentage_0,
            fp_ops_per_cycle_0,
            frontend_bound_0,
            frontend_cache_l1i_bound_0,
            frontend_cache_l2i_bound_0,
            frontend_core_bound_0,
            frontend_core_flow_bound_0,
            frontend_core_flush_bound_0,
            frontend_mem_bound_0,
            frontend_mem_cache_bound_0,
            frontend_mem_tlb_bound_0,
            frontend_stalled_cycles_0,
            instruction_fetch_average_latency_0,
            integer_dp_percentage_1,
            ipc_0,
            itlb_mpki_0,
            itlb_walk_average_depth_1,
            itlb_walk_average_latency_0,
            itlb_walk_large_ratio_0,
            itlb_walk_ratio_0,
            itlb_walk_small_ratio_0,
            l1d_cache_miss_ratio_0,
            l1d_cache_mpki_1,
            l1d_tlb_miss_ratio_0,
            l1d_tlb_mpki_0,
            l1i_cache_miss_ratio_0,
            l1i_cache_mpki_0,
            l1i_tlb_miss_ratio_0,
            l1i_tlb_mpki_0,
            l2_cache_miss_ratio_0,
            l2_cache_mpki_1,
            l2_tlb_miss_ratio_0,
            l2_tlb_mpki_0,
            l2d_cache_miss_ratio_0,
            l2d_cache_mpki_1,
            ldrex_percentage_0,
            ll_cache_read_hit_ratio_0,
            ll_cache_read_miss_ratio_0,
            ll_cache_read_mpki_0,
            load_average_latency_0,
            load_ls_percentage_0,
            load_percentage_0,
            load_store_percentage_0,
            nonsve_fp_ops_per_cycle_0,
            rc_ld_percentage_0,
            rc_st_percentage_0,
            retired_ops_percent_0,
            retiring_0,
            scalar_fp_percentage_0,
            simd_percentage_0,
            store_ls_percentage_0,
            store_percentage_0,
            strex_fail_mpki_0,
            strex_fail_percent_0,
            strex_percentage_0,
            sve_all_percentage_0,
            sve_fp_ops_per_cycle_0,
            sve_predicate_empty_percentage_0,
            sve_predicate_full_percentage_0,
            sve_predicate_partial_percentage_0,
            sve_predicate_percentage_0,
        };
    }
    metric_cpu_events_map_t const cpu_metrics_table {
        {
            "ARMv8_Cortex_A32",
            {
                0x000e,
                {
                    {{}, {cortex_a32_metrics, 2}},
                },
            },
        },
        {
            "ARMv8_Cortex_A34",
            {
                0x000e,
                {
                    {{}, {cortex_a34_metrics, 2}},
                },
            },
        },
        {
            "ARMv8_Cortex_A35",
            {
                0x000e,
                {
                    {{}, {cortex_a35_metrics, 2}},
                },
            },
        },
        {
            "ARMv8_Cortex_A53",
            {
                0x000e,
                {
                    {{}, {cortex_a53_metrics, 2}},
                },
            },
        },
        {
            "ARMv8_Cortex_A55",
            {
                0x000e,
                {
                    {{}, {cortex_a55_metrics, 3}},
                },
            },
        },
        {
            "ARMv8_Cortex_A57",
            {
                0x0079,
                {
                    {{}, {cortex_a57_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_A65AE",
            {
                0x000e,
                {
                    {{}, {cortex_a65ae_metrics, 3}},
                },
            },
        },
        {
            "ARMv8_Neoverse_E1",
            {
                0x000e,
                {
                    {{}, {neoverse_e1_metrics, 3}},
                },
            },
        },
        {
            "ARMv8_Cortex_A72",
            {
                0x0079,
                {
                    {{}, {cortex_a72_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_A73",
            {
                0x000e,
                {
                    {{}, {cortex_a73_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_A75",
            {
                0x000e,
                {
                    {{}, {cortex_a75_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_A76",
            {
                0x0079,
                {
                    {{}, {cortex_a76_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_A77",
            {
                0x0079,
                {
                    {{}, {cortex_a77_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_A78",
            {
                0x0079,
                {
                    {{}, {cortex_a78_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_A78AE",
            {
                0x0079,
                {
                    {{}, {cortex_a78ae_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_A78C",
            {
                0x0079,
                {
                    {{}, {cortex_a78c_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_A510",
            {
                0x000e,
                {
                    {{}, {cortex_a510_metrics, 4}},
                },
            },
        },
        {
            "ARMv9_Cortex_A520",
            {
                0x000e,
                {
                    {{}, {cortex_a520_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_Cortex_A520AE",
            {
                0x000e,
                {
                    {{}, {cortex_a520ae_metrics, 5}},
                },
            },
        },
        {
            "ARMv8_Cortex_A710",
            {
                0x0079,
                {
                    {{}, {cortex_a710_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_X2",
            {
                0x0079,
                {
                    {{}, {cortex_x2_metrics, 4}},
                },
            },
        },
        {
            "ARMv9_Cortex_X3",
            {
                0x0079,
                {
                    {{}, {cortex_x3_metrics, 4}},
                },
            },
        },
        {
            "ARMv9_Cortex_A715",
            {
                0x0079,
                {
                    {{}, {cortex_a715_metrics, 4}},
                },
            },
        },
        {
            "ARMv9_Cortex_A720",
            {
                0x000e,
                {
                    {{}, {cortex_a720_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_Cortex_A720AE",
            {
                0x000e,
                {
                    {{}, {cortex_a720ae_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_Cortex_A725",
            {
                0x000e,
                {
                    {{}, {cortex_a725_metrics, 5}},
                },
            },
        },
        {
            "ARMv8_Cortex_X1",
            {
                0x0079,
                {
                    {{}, {cortex_x1_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_X1C",
            {
                0x0079,
                {
                    {{}, {cortex_x1c_metrics, 4}},
                },
            },
        },
        {
            "ARMv9_Cortex_X4",
            {
                0x000e,
                {
                    {{}, {cortex_x4_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_Cortex_X925",
            {
                0x000e,
                {
                    {{}, {cortex_x925_metrics, 5}},
                },
            },
        },
        {
            "ARMv8R_Cortex_R52X",
            {
                0x000e,
                {
                    {{}, {cortex_r52__metrics, 2}},
                },
            },
        },
        {
            "ARMv8R_Cortex_R82",
            {
                0x000e,
                {
                    {{}, {cortex_r82_metrics, 3}},
                },
            },
        },
        {
            "ARMv8R_Cortex_R82AE",
            {
                0x000e,
                {
                    {{}, {cortex_r82ae_metrics, 3}},
                },
            },
        },
        {
            "ARMv8_Neoverse_N1",
            {
                0x0079,
                {
                    {{}, {neoverse_n1_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Neoverse_V1",
            {
                0x0079,
                {
                    {{}, {neoverse_v1_metrics, 5}},
                },
            },
        },
        {
            "ARMv8_Neoverse_N2",
            {
                0x0079,
                {
                    {{}, {neoverse_n2_common_metrics, 4}},
                    {{0, 0}, {neoverse_n2_tel_v0_metrics, 5}},
                    {{0, 3}, {neoverse_n2_tel_v1_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_Neoverse_V2",
            {
                0x0079,
                {
                    {{}, {neoverse_v2_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_Neoverse_N3",
            {
                0x000e,
                {
                    {{}, {neoverse_n3_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_Neoverse_V3",
            {
                0x000e,
                {
                    {{}, {neoverse_v3_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_Neoverse_V3AE",
            {
                0x000e,
                {
                    {{}, {neoverse_v3ae_metrics, 5}},
                },
            },
        },
    };
}

// NOLINTEND(cert-err58-cpp)
