/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.vm;

import com.arm.streamline.ui.utils.ObservableUtils;
import com.arm.streamline.ui.vm.IAndroidTargetDevice;
import com.arm.streamline.ui.vm.ILandingPageActionHandler;
import com.arm.streamline.ui.vm.ILandingPageAdbPathPreferenceModel;
import com.arm.streamline.ui.vm.ILandingPageTcpSubViewViewModel;
import com.arm.streamline.ui.vm.ITcpTargetDevice;
import com.arm.streamline.ui.vm.ITcpTargetLauncher;
import com.arm.streamline.ui.vm.LandingPageSceneViewModel;
import java.io.File;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.services.IDisposable;

public final class LandingPageTcpSubViewViewModel
implements ILandingPageTcpSubViewViewModel {
    private final @NonNull ILandingPageActionHandler actionsHandler;
    private final @NonNull SimpleObjectProperty<@NonNull ILandingPageTcpSubViewViewModel.ActiveAddressSource> activeAddressSource = new SimpleObjectProperty((Object)ILandingPageTcpSubViewViewModel.ActiveAddressSource.ADDRESS_INPUT);
    private final @NonNull ObjectBinding<@Nullable ITcpTargetLauncher> activeTargetLauncher;
    private final @NonNull ILandingPageAdbPathPreferenceModel adbPathModel;
    private final @NonNull SimpleObjectProperty<@NonNull String> addressInputText = new SimpleObjectProperty((Object)"");
    private final @NonNull IDisposable addressInputTextChangeListener;
    private final @NonNull SimpleObjectProperty<@NonNull String> commandPathText = new SimpleObjectProperty((Object)"");
    private final @NonNull SimpleBooleanProperty commandStopOnExit = new SimpleBooleanProperty(true);
    private final @NonNull SimpleObjectProperty<@NonNull String> commandUserNameText = new SimpleObjectProperty((Object)"");
    private final @NonNull SimpleObjectProperty<@NonNull String> commandWorkingDirText = new SimpleObjectProperty((Object)"");
    private final @NonNull ObservableList<@NonNull ITcpTargetDevice> detectedDevices = FXCollections.observableArrayList();
    private final @NonNull BooleanBinding disableDeviceTableSelection;
    private final @NonNull LandingPageSceneViewModel.ITcpTargetLauncherFactory launcherFactory;
    private final @NonNull SimpleObjectProperty<@Nullable ITcpTargetDevice> selectedDetectedDevice = new SimpleObjectProperty();
    private final @NonNull IDisposable selectedDetectedDeviceChangeListener;

    public LandingPageTcpSubViewViewModel(@NonNull ILandingPageActionHandler actionsHandler, @NonNull LandingPageSceneViewModel.ITcpTargetLauncherFactory launcherFactory, @NonNull ILandingPageAdbPathPreferenceModel adbPathModel) {
        this.actionsHandler = actionsHandler;
        this.launcherFactory = launcherFactory;
        this.adbPathModel = adbPathModel;
        this.disableDeviceTableSelection = Bindings.isEmpty(this.detectedDevices);
        this.selectedDetectedDeviceChangeListener = ObservableUtils.onChange(this.selectedDetectedDevice, s -> {
            assert (s == null || this.detectedDevices.contains(s));
            if (s != null) {
                this.activeAddressSource.set((Object)ILandingPageTcpSubViewViewModel.ActiveAddressSource.TARGET_TABLE);
            }
        });
        this.addressInputTextChangeListener = ObservableUtils.onChange(this.addressInputText, t -> {
            if (!t.isBlank()) {
                this.activeAddressSource.set((Object)ILandingPageTcpSubViewViewModel.ActiveAddressSource.ADDRESS_INPUT);
            }
        });
        this.detectedDevices.addListener((ListChangeListener)new ListChangeListener<ITcpTargetDevice>(){

            public void onChanged(// Could not load outer class - annotation placement on inner may be incorrect
            ListChangeListener.Change<? extends @NonNull ITcpTargetDevice> change) {
                if (LandingPageTcpSubViewViewModel.this.detectedDevices.isEmpty()) {
                    LandingPageTcpSubViewViewModel.this.activeAddressSource.set((Object)ILandingPageTcpSubViewViewModel.ActiveAddressSource.ADDRESS_INPUT);
                    LandingPageTcpSubViewViewModel.this.selectedDetectedDevice.set(null);
                } else {
                    ITcpTargetDevice currentSelection = (ITcpTargetDevice)LandingPageTcpSubViewViewModel.this.selectedDetectedDevice.get();
                    ITcpTargetDevice newSelection = currentSelection != null && LandingPageTcpSubViewViewModel.this.detectedDevices.contains((Object)currentSelection) ? currentSelection : (ITcpTargetDevice)LandingPageTcpSubViewViewModel.this.detectedDevices.get(0);
                    ILandingPageTcpSubViewViewModel.ActiveAddressSource currentSource = (ILandingPageTcpSubViewViewModel.ActiveAddressSource)((Object)LandingPageTcpSubViewViewModel.this.activeAddressSource.get());
                    String currentAddress = (String)LandingPageTcpSubViewViewModel.this.addressInputText.get();
                    if (currentSource.equals((Object)ILandingPageTcpSubViewViewModel.ActiveAddressSource.TARGET_TABLE) || currentAddress.isBlank()) {
                        LandingPageTcpSubViewViewModel.this.selectedDetectedDevice.set((Object)newSelection);
                    } else {
                        LandingPageTcpSubViewViewModel.this.selectedDetectedDevice.set(null);
                    }
                }
            }
        });
        this.activeTargetLauncher = Bindings.createObjectBinding(this::calculateActiveTargetLauncher, (Observable[])new Observable[]{this.activeAddressSource, this.selectedDetectedDevice, this.addressInputText, this.commandPathText, this.commandWorkingDirText, this.commandUserNameText, this.commandStopOnExit});
    }

    @Override
    public @NonNull ObjectProperty<@NonNull ILandingPageTcpSubViewViewModel.ActiveAddressSource> activeAddressSourceProperty() {
        return this.activeAddressSource;
    }

    @Override
    public @NonNull ObservableObjectValue<@Nullable ITcpTargetLauncher> activeTargetLauncherProperty() {
        return this.activeTargetLauncher;
    }

    @Override
    public @NonNull ObservableObjectValue<@Nullable File> adbToolPathProperty() {
        return this.adbPathModel.adbToolPathProperty();
    }

    @Override
    public @NonNull ObjectProperty<@NonNull String> addressInputTextProperty() {
        return this.addressInputText;
    }

    @Override
    public boolean canFocusOnDeviceTableEntry(@Nullable ITcpTargetDevice currentTableSelection) {
        if (currentTableSelection == null) {
            return false;
        }
        if (this.activeAddressSource.get() != ILandingPageTcpSubViewViewModel.ActiveAddressSource.TARGET_TABLE) {
            return false;
        }
        return this.detectedDevices.contains((Object)currentTableSelection);
    }

    @Override
    public @NonNull ObjectProperty<@NonNull String> commandPathTextProperty() {
        return this.commandPathText;
    }

    @Override
    public @NonNull BooleanProperty commandStopOnExitProperty() {
        return this.commandStopOnExit;
    }

    @Override
    public @NonNull ObjectProperty<@NonNull String> commandUserNameTextProperty() {
        return this.commandUserNameText;
    }

    @Override
    public @NonNull ObjectProperty<@NonNull String> commandWorkingDirTextProperty() {
        return this.commandWorkingDirText;
    }

    @Override
    public @NonNull ObservableList<@NonNull ITcpTargetDevice> detectedDevicesProperty() {
        return this.detectedDevices;
    }

    @Override
    public @NonNull ObservableBooleanValue disableDeviceTableSelectionProperty() {
        return this.disableDeviceTableSelection;
    }

    @Override
    public void doShowAdbPathConfigurationPreference() {
        this.adbPathModel.doShowAdbPathConfigurationPreference();
    }

    @Override
    public void resetAdbPathToDefault() {
        this.adbPathModel.resetAdbPathToDefault();
    }

    @Override
    public void doShowAndroidTargetHelp() {
        this.actionsHandler.showAndroidTargetHelp();
    }

    @Override
    public void doShowStreamlineMeTargetHelp() {
        this.actionsHandler.showStreamlineMeTargetHelp();
    }

    @Override
    public void doShowLinuxTargetHelp() {
        this.actionsHandler.showLinuxTargetHelp();
    }

    @Override
    public @NonNull ObservableBooleanValue hasValidAdbToolPathSetProperty() {
        return this.adbPathModel.hasValidAdbToolPathSetProperty();
    }

    @Override
    public @NonNull ObjectProperty<@Nullable ITcpTargetDevice> selectedDetectedDeviceProperty() {
        return this.selectedDetectedDevice;
    }

    private @Nullable ITcpTargetLauncher calculateActiveTargetLauncher() {
        ILandingPageTcpSubViewViewModel.ActiveAddressSource activeAddressSource = (ILandingPageTcpSubViewViewModel.ActiveAddressSource)((Object)this.activeAddressSource.get());
        ITcpTargetDevice selectedDetectedDevice = (ITcpTargetDevice)this.selectedDetectedDevice.get();
        String addressInputText = (String)this.addressInputText.get();
        switch (activeAddressSource) {
            case ADDRESS_INPUT: {
                if (!addressInputText.isBlank()) {
                    return this.launcherFactory.create(addressInputText, (String)this.commandPathText.get(), (String)this.commandWorkingDirText.get(), (String)this.commandUserNameText.get(), this.commandStopOnExit.get());
                }
                return null;
            }
            case TARGET_TABLE: {
                if (selectedDetectedDevice != null && selectedDetectedDevice.getStatus() == ITcpTargetDevice.Status.AVAILABLE) {
                    return this.launcherFactory.create(selectedDetectedDevice.getTargetAddress(), (String)this.commandPathText.get(), (String)this.commandWorkingDirText.get(), (String)this.commandUserNameText.get(), this.commandStopOnExit.get());
                }
                return null;
            }
        }
        throw new AssertionError((Object)activeAddressSource);
    }

    @Override
    public void setSelectedDeviceIfPresent(@NonNull IAndroidTargetDevice targetDevice) {
        Optional<@NonNull ITcpTargetDevice> findSameDeviceInTcpView = this.detectedDevicesProperty().stream().filter(tcpViewDevice -> tcpViewDevice.getTargetAddress().equals(targetDevice.getTargetAddress())).findFirst();
        if (findSameDeviceInTcpView.isPresent()) {
            this.selectedDetectedDeviceProperty().set((Object)findSameDeviceInTcpView.get());
        }
    }
}

