/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.spe.decoders;

import com.arm.streamline.common.xml.spe.SpeOperationTypeClass;
import com.arm.streamline.spe.decoders.ISpePacketConsumer;
import com.arm.streamline.spe.decoders.ISpeRawPacketConsumer;
import com.arm.streamline.spe.decoders.SpeDecodeException;
import com.arm.utils.ArrayUtils;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;

public class SpePacketDecoder<T extends Throwable>
implements ISpeRawPacketConsumer<T> {
    private final @NonNull ISpePacketConsumer<T> packetConsumer;

    private static boolean isAddressPacket(int header) {
        return (header | 7) == 183;
    }

    private static boolean isAddressPacket(int header0, int header1) {
        return (header0 | 3) == 35 && (header1 | 7) == 183;
    }

    private static boolean isContextPacket(int header) {
        return (header | 3) == 103;
    }

    private static boolean isCounterPacket(int header) {
        return (header | 7) == 159;
    }

    private static boolean isCounterPacket(int header0, int header1) {
        return (header0 | 3) == 35 && (header1 | 7) == 159;
    }

    private static boolean isDataSourcePacketByte(int header) {
        return header == 67;
    }

    private static boolean isDataSourcePacketShort(int header) {
        return header == 83;
    }

    private static boolean isEndPacket(int header) {
        return header == 1;
    }

    private static boolean isEventsPacketByte(int header) {
        return header == 66;
    }

    private static boolean isEventsPacketInt(int header) {
        return header == 98;
    }

    private static boolean isEventsPacketLong(int header) {
        return header == 114;
    }

    private static boolean isEventsPacketShort(int header) {
        return header == 82;
    }

    private static boolean isKnown(int header) {
        return SpePacketDecoder.isAddressPacket(header) || SpePacketDecoder.isContextPacket(header) || SpePacketDecoder.isCounterPacket(header) || SpePacketDecoder.isDataSourcePacketByte(header) || SpePacketDecoder.isDataSourcePacketShort(header) || SpePacketDecoder.isEndPacket(header) || SpePacketDecoder.isEventsPacketByte(header) || SpePacketDecoder.isEventsPacketShort(header) || SpePacketDecoder.isEventsPacketInt(header) || SpePacketDecoder.isEventsPacketLong(header) || SpePacketDecoder.isOperationTypePacket(header) || SpePacketDecoder.isPadding(header) || SpePacketDecoder.isTimestampPacket(header);
    }

    private static boolean isKnown(int header0, int header1) {
        return SpePacketDecoder.isAddressPacket(header0, header1) || SpePacketDecoder.isCounterPacket(header0, header1);
    }

    private static boolean isOperationTypePacket(int header) {
        return (header | 3) == 75;
    }

    private static boolean isPadding(int header) {
        return header == 0;
    }

    private static boolean isTimestampPacket(int header) {
        return header == 113;
    }

    private static SpeDecodeException exception(@NonNull SpeDecodeException.Reason reason, @NonNull Supplier<byte @NonNull []> packet) {
        return new SpeDecodeException(reason, reason.toString() + " 0x" + ArrayUtils.toString((byte[])packet.get(), Integer::toHexString));
    }

    private static SpeDecodeException reserved(@NonNull Supplier<byte @NonNull []> packet) {
        return SpePacketDecoder.exception(SpeDecodeException.Reason.RESERVED_BITS, packet);
    }

    private static SpeDecodeException wrongSize(@NonNull Supplier<byte @NonNull []> packet) {
        return SpePacketDecoder.exception(SpeDecodeException.Reason.WRONG_PAYLOAD_SIZE, packet);
    }

    public SpePacketDecoder(@NonNull ISpePacketConsumer<T> packetConsumer) {
        this.packetConsumer = packetConsumer;
    }

    @Override
    public void rawPacket(byte headerByte) throws T, SpeDecodeException {
        Supplier<byte @NonNull []> packet = () -> new byte[]{headerByte};
        int header = Byte.toUnsignedInt(headerByte);
        if (SpePacketDecoder.isEndPacket(header)) {
            this.endPacket();
        } else if (!SpePacketDecoder.isPadding(header)) {
            if (SpePacketDecoder.isKnown(header)) {
                throw SpePacketDecoder.wrongSize(packet);
            }
            this.unknownPacket();
        }
    }

    @Override
    public void rawPacket(byte headerByte, byte payload) throws T, SpeDecodeException {
        Supplier<byte @NonNull []> packet = () -> new byte[]{headerByte, payload};
        int header = Byte.toUnsignedInt(headerByte);
        if (SpePacketDecoder.isDataSourcePacketByte(header)) {
            this.dataSourcePacket((short)Byte.toUnsignedInt(payload));
        } else if (SpePacketDecoder.isEventsPacketByte(header)) {
            this.eventsPacket(Byte.toUnsignedLong(payload), packet);
        } else if (SpePacketDecoder.isOperationTypePacket(header)) {
            this.operationPacket(header & 3, payload, packet);
        } else {
            if (SpePacketDecoder.isKnown(header)) {
                throw SpePacketDecoder.wrongSize(packet);
            }
            this.unknownPacket();
        }
    }

    @Override
    public void rawPacket(byte headerByte, int payload) throws T, SpeDecodeException {
        Supplier<byte @NonNull []> packet = () -> new byte[]{headerByte, (byte)payload, (byte)(payload >> 8), (byte)(payload >> 16), (byte)(payload >> 24)};
        int header = Byte.toUnsignedInt(headerByte);
        if (SpePacketDecoder.isContextPacket(header)) {
            this.contextPacket(header & 3, payload, packet);
        } else if (SpePacketDecoder.isEventsPacketInt(header)) {
            this.eventsPacket(Integer.toUnsignedLong(payload), packet);
        } else {
            if (SpePacketDecoder.isKnown(header)) {
                throw SpePacketDecoder.wrongSize(packet);
            }
            this.unknownPacket();
        }
    }

    @Override
    public void rawPacket(byte headerByte, long payload) throws T, SpeDecodeException {
        Supplier<byte @NonNull []> packet = () -> new byte[]{headerByte, (byte)payload, (byte)(payload >> 8), (byte)(payload >> 16), (byte)(payload >> 24), (byte)(payload >> 32), (byte)(payload >> 40), (byte)(payload >> 48), (byte)(payload >> 56)};
        int header = Byte.toUnsignedInt(headerByte);
        if (SpePacketDecoder.isAddressPacket(header)) {
            this.addressPacket(header & 7, payload, packet);
        } else if (SpePacketDecoder.isEventsPacketLong(header)) {
            this.eventsPacket(payload, packet);
        } else if (SpePacketDecoder.isTimestampPacket(header)) {
            this.timestampPacket(payload);
        } else {
            if (SpePacketDecoder.isKnown(header)) {
                throw SpePacketDecoder.wrongSize(packet);
            }
            this.unknownPacket();
        }
    }

    @Override
    public void rawPacket(byte headerByte, short payload) throws T, SpeDecodeException {
        Supplier<byte @NonNull []> packet = () -> new byte[]{headerByte, (byte)payload, (byte)(payload >> 8)};
        int header = Byte.toUnsignedInt(headerByte);
        if (SpePacketDecoder.isCounterPacket(header)) {
            this.counterPacket(header & 7, payload, packet);
        } else if (SpePacketDecoder.isDataSourcePacketShort(header)) {
            this.dataSourcePacket(payload);
        } else if (SpePacketDecoder.isEventsPacketShort(header)) {
            this.eventsPacket(Short.toUnsignedLong(payload), packet);
        } else {
            if (SpePacketDecoder.isKnown(header)) {
                throw SpePacketDecoder.wrongSize(packet);
            }
            this.unknownPacket();
        }
    }

    @Override
    public void rawPacketExtended(byte header0Byte, byte header1Byte) throws T, SpeDecodeException {
        int header1;
        Supplier<byte @NonNull []> packet = () -> new byte[]{header0Byte, header1Byte};
        int header0 = Byte.toUnsignedInt(header0Byte);
        if (SpePacketDecoder.isKnown(header0, header1 = Byte.toUnsignedInt(header1Byte))) {
            throw SpePacketDecoder.wrongSize(packet);
        }
        this.unknownPacket();
    }

    @Override
    public void rawPacketExtended(byte header0Byte, byte header1Byte, byte payload) throws T, SpeDecodeException {
        int header1;
        Supplier<byte @NonNull []> packet = () -> new byte[]{header0Byte, header1Byte, payload};
        int header0 = Byte.toUnsignedInt(header0Byte);
        if (SpePacketDecoder.isKnown(header0, header1 = Byte.toUnsignedInt(header1Byte))) {
            throw SpePacketDecoder.wrongSize(packet);
        }
        this.unknownPacket();
    }

    @Override
    public void rawPacketExtended(byte header0Byte, byte header1Byte, int payload) throws T, SpeDecodeException {
        int header1;
        Supplier<byte @NonNull []> packet = () -> new byte[]{header0Byte, header1Byte, (byte)payload, (byte)(payload >> 8), (byte)(payload >> 16), (byte)(payload >> 24)};
        int header0 = Byte.toUnsignedInt(header0Byte);
        if (SpePacketDecoder.isKnown(header0, header1 = Byte.toUnsignedInt(header1Byte))) {
            throw SpePacketDecoder.wrongSize(packet);
        }
        this.unknownPacket();
    }

    @Override
    public void rawPacketExtended(byte header0Byte, byte header1Byte, long payload) throws T, SpeDecodeException {
        int header1;
        Supplier<byte @NonNull []> packet = () -> new byte[]{header0Byte, header1Byte, (byte)payload, (byte)(payload >> 8), (byte)(payload >> 16), (byte)(payload >> 24), (byte)(payload >> 32), (byte)(payload >> 40), (byte)(payload >> 48), (byte)(payload >> 56)};
        int header0 = Byte.toUnsignedInt(header0Byte);
        if (SpePacketDecoder.isAddressPacket(header0, header1 = Byte.toUnsignedInt(header1Byte))) {
            this.addressPacket((header0 & 3) << 3 | header1 & 7, payload, packet);
        } else {
            if (SpePacketDecoder.isKnown(header0, header1)) {
                throw SpePacketDecoder.wrongSize(packet);
            }
            this.unknownPacket();
        }
    }

    @Override
    public void rawPacketExtended(byte header0Byte, byte header1Byte, short payload) throws T, SpeDecodeException {
        int header1;
        Supplier<byte @NonNull []> packet = () -> new byte[]{header0Byte, header1Byte, (byte)payload, (byte)(payload >> 8), (byte)(payload >> 16), (byte)(payload >> 24)};
        int header0 = Byte.toUnsignedInt(header0Byte);
        if (SpePacketDecoder.isCounterPacket(header0, header1 = Byte.toUnsignedInt(header1Byte))) {
            this.counterPacket((header0 & 3) << 3 | header1 & 7, payload, packet);
        } else {
            if (SpePacketDecoder.isKnown(header0, header1)) {
                throw SpePacketDecoder.wrongSize(packet);
            }
            this.unknownPacket();
        }
    }

    private void addressPacket(int index, long payload, @NonNull Supplier<byte @NonNull []> packet) throws T, SpeDecodeException {
        if ((index | 1) == 7 || (index | 0xF) == 31) {
            this.packetConsumer.addressPacket((byte)index, payload);
        } else if (index == 2) {
            this.packetConsumer.addressPacket((byte)index, payload);
        } else if (index == 3) {
            if ((payload & 0x7F00000000000000L) != 0L) {
                throw SpePacketDecoder.reserved(packet);
            }
            this.packetConsumer.addressPacket((byte)index, payload);
        } else if (index == 0 || index == 1) {
            if ((payload & 0x1F00000000000000L) != 0L) {
                throw SpePacketDecoder.reserved(packet);
            }
            this.packetConsumer.addressPacket((byte)index, payload);
        } else {
            throw SpePacketDecoder.reserved(packet);
        }
    }

    private void contextPacket(int index, int payload, @NonNull Supplier<byte @NonNull []> packet) throws T, SpeDecodeException {
        this.packetConsumer.contextPacket(switch (index) {
            case 0 -> ISpePacketConsumer.ContextId.CONTEXTIDR_EL1;
            case 1 -> ISpePacketConsumer.ContextId.CONTEXTIDR_EL2;
            case 2, 3 -> throw SpePacketDecoder.reserved(packet);
            default -> throw new AssertionError((Object)"context id masking wrong");
        }, payload);
    }

    private void counterPacket(int index, short payload, @NonNull Supplier<byte @NonNull []> packet) throws T, SpeDecodeException {
        if (index > 31) {
            throw new AssertionError((Object)"bad counter index mask");
        }
        if (index != 0 && index != 1 && index != 2 && (index | 1) != 7 && (index | 0xF) != 31) {
            throw SpePacketDecoder.reserved(packet);
        }
        if ((payload & 0xFFFFF000) != 0) {
            throw SpePacketDecoder.reserved(packet);
        }
        this.packetConsumer.counterPacket((byte)index, payload);
    }

    private void dataSourcePacket(short payload) throws T, SpeDecodeException {
        this.packetConsumer.dataSourcePacket(payload);
    }

    private void endPacket() throws T, SpeDecodeException {
        this.packetConsumer.endPacket();
    }

    private void eventsPacket(long payload, @NonNull Supplier<byte @NonNull []> packet) throws T, SpeDecodeException {
        if ((payload & 0xFFFF00FF0800L) != 0L) {
            throw SpePacketDecoder.reserved(packet);
        }
        this.packetConsumer.eventsPacket(payload);
    }

    private void operationPacket(int klass, byte payload, @NonNull Supplier<byte @NonNull []> packet) throws T, SpeDecodeException {
        switch (klass) {
            case 0: {
                if ((payload & 0xFE) == 0) {
                    this.packetConsumer.operationTypePacket(SpeOperationTypeClass.OTHER, payload);
                    break;
                }
                throw SpePacketDecoder.reserved(packet);
            }
            case 1: {
                if ((payload | 1) == 1) {
                    this.packetConsumer.operationTypePacket(SpeOperationTypeClass.LOAD_STORE, payload);
                    break;
                }
                if ((payload | 0x1D) == 31) {
                    this.packetConsumer.operationTypePacket(SpeOperationTypeClass.LOAD_STORE, payload);
                    break;
                }
                if ((payload | 1) == 5) {
                    this.packetConsumer.operationTypePacket(SpeOperationTypeClass.LOAD_STORE, payload);
                    break;
                }
                throw SpePacketDecoder.reserved(packet);
            }
            case 2: {
                if ((payload & 0xFC) == 0) {
                    this.packetConsumer.operationTypePacket(SpeOperationTypeClass.BRANCH, payload);
                    break;
                }
                throw SpePacketDecoder.reserved(packet);
            }
            case 3: {
                throw SpePacketDecoder.reserved(packet);
            }
            default: {
                throw new AssertionError((Object)"bad klass mask");
            }
        }
    }

    private void timestampPacket(long payload) throws T, SpeDecodeException {
        this.packetConsumer.timestampPacket(payload);
    }

    private void unknownPacket() throws T, SpeDecodeException {
        this.packetConsumer.unknownPacket();
    }
}

