/*
 * Decompiled with CFR 0.152.
 */
package com.arm.eclipse.cdt.asmlib.model;

import com.arm.eclipse.cdt.asmlib.AsmlibPlugin;
import com.arm.eclipse.cdt.asmlib.model.Messages;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class WirelessMMX {
    private static Pattern wmmxPattern;
    private static final String NEON_TABLE_NAME = "wmmxexpr.sjava";

    static {
        try {
            URL url;
            Bundle bundle;
            Path neonTablePath = new Path(NEON_TABLE_NAME);
            InputStream fis = null;
            AsmlibPlugin plugin = AsmlibPlugin.getDefault();
            if (plugin != null && (bundle = plugin.getBundle()) != null && (url = FileLocator.find((Bundle)bundle, (IPath)neonTablePath, null)) != null) {
                File f = new File(FileLocator.toFileURL((URL)url).getPath());
                fis = Files.newInputStream(f.toPath(), new OpenOption[0]);
            }
            if (fis == null) {
                fis = WirelessMMX.class.getResourceAsStream("/wmmxexpr.sjava");
            }
            if (fis == null) {
                throw new RuntimeException(Messages.FAILED_FIND.getLocalisedValue(NEON_TABLE_NAME));
            }
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try (ObjectInputStream ois = new ObjectInputStream(fis);){
                    wmmxPattern = (Pattern)ois.readObject();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                fis.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(Messages.FAILED_READ.getLocalisedValue(NEON_TABLE_NAME), e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(Messages.FAILED_DESERIALISE.getLocalisedValue(NEON_TABLE_NAME), e);
        }
    }

    public static boolean isValidWirelessMMXInstruction(String s) {
        return wmmxPattern == null ? false : wmmxPattern.matcher(s.toUpperCase()).matches();
    }
}

