/*
 * Decompiled with CFR 0.152.
 */
package com.arm.eclipse.cdt.asmlib.model;

import com.arm.eclipse.cdt.asmlib.model.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class V8MInstructions {
    private static final String V8M_INSTR_FILE_NAME = "v8m_instructions.txt";
    private static final String COMMENT_START = "#";
    private static final String[] a32Conds = new String[]{"EQ", "NE", "CS", "HS", "CC", "LO", "MI", "PL", "VS", "VC", "HI", "LS", "GE", "LT", "GT", "LE", "AL", "NV"};
    private static V8MInstructions instance;
    private Set<String> instructions;

    private V8MInstructions(Class<?> resourceLocation) {
        this.loadInstructions(resourceLocation);
    }

    private void loadInstructions(Class<?> resourceLocation) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream stream = resourceLocation.getResourceAsStream(V8M_INSTR_FILE_NAME);){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                    this.instructions = new LinkedHashSet<String>();
                    reader.lines().map(String::toLowerCase).map(this::stripCommentsFromInputLine).filter(s -> !s.isBlank()).map(this::expandMnemonics).forEach(this.instructions::addAll);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(Messages.FAILED_READ.getLocalisedValue(V8M_INSTR_FILE_NAME), e);
        }
    }

    private String stripCommentsFromInputLine(String line) {
        if (line.contains(COMMENT_START)) {
            line = line.substring(0, line.indexOf(COMMENT_START));
        }
        return line.trim();
    }

    private List<String> expandMnemonics(String mnemonic) {
        List<String> result;
        if (mnemonic.contains("{<c>}")) {
            result = new ArrayList<String>();
            result.add(mnemonic.replace("{<c>}", ""));
            String[] stringArray = a32Conds;
            int n = a32Conds.length;
            int n2 = 0;
            while (n2 < n) {
                String cond = stringArray[n2];
                result.add(mnemonic.replace("{<c>}", cond.toLowerCase()));
                ++n2;
            }
        } else {
            result = Collections.singletonList(mnemonic);
        }
        return result;
    }

    public static V8MInstructions getInstance() {
        return V8MInstructions.getInstance(V8MInstructions.class);
    }

    static V8MInstructions getInstance(Class<?> resourceLocation) {
        if (instance == null) {
            instance = new V8MInstructions(resourceLocation);
        }
        return instance;
    }

    public Set<String> getInstructions() {
        return Collections.unmodifiableSet(this.instructions);
    }

    public boolean isValidV8MInstruction(String token) {
        return this.instructions.contains(token.toLowerCase());
    }
}

