/*
 * Decompiled with CFR 0.152.
 */
package com.arm.eclipse.cdt.asmlib.model;

import java.util.Arrays;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SysReg {
    private static final Set<String> AARCH64_SYSREGS = Set.of("BTYPE", "CURRENTEL", "DAIF", "DIT", "FPCR", "FPSR", "NZCV", "PAN", "PM", "PPEND", "RNDR", "RNDRRS", "SPSR_ABT", "SPSR_FIQ", "SPSR_IRQ", "SPSR_UND", "SPSEL", "SSBS", "SVCR", "TCO", "UAO", "TRCITEEDCR", "TRCCONFIGR", "TRCIDR0", "TRCEVENTCTL1R", "TRCIDR5", "TRCDEVARCH");
    private static final Set<String> AARCH32_SYSREGS = Arrays.stream(new String[]{"ACTLR", "ACTLR2", "ADFSR", "AIDR", "AIFSR", "AMAIR0", "AMAIR1", "APSR", "CCSIDR", "CLIDR", "CNTFRQ", "CNTHCTL", "CNTHP_CTL", "CNTHP_CVAL", "CNTHP_TVAL", "CNTHV_CTL", "CNTHV_CVAL", "CNTHV_TVAL", "CNTKCTL", "CNTPCT", "CNTPCTSS", "CNTP_CTL", "CNTP_CVAL", "CNTP_TVAL", "CNTVCT", "CNTVCTSS", "CNTVOFF", "CNTV_CTL", "CNTV_CVAL", "CNTV_TVAL", "CONTEXTIDR", "CPACR", "CPSR", "CSSELR", "CTR", "DACR", "DBGAUTHSTATUS", "DBGBCR0", "DBGBCR1", "DBGBCR2", "DBGBCR3", "DBGBCR4", "DBGBCR5", "DBGBCR6", "DBGBCR7", "DBGBCR8", "DBGBCR9", "DBGBCR10", "DBGBCR11", "DBGBCR12", "DBGBCR13", "DBGBCR14", "DBGBCR15", "DBGBVR0", "DBGBVR1", "DBGBVR2", "DBGBVR3", "DBGBVR4", "DBGBVR5", "DBGBVR6", "DBGBVR7", "DBGBVR8", "DBGBVR9", "DBGBVR10", "DBGBVR11", "DBGBVR12", "DBGBVR13", "DBGBVR14", "DBGBVR15", "DBGCLAIMCLR", "DBGCLAIMSET", "DBGDCCINT", "DBGDEVID", "DBGDEVID1", "DBGDEVID2", "DBGDIDR", "DBGDRAR", "DBGDSAR", "DBGDSCRext", "DBGDSCRint", "DBGDTRRXext", "DBGDTRRXint", "DBGDTRTXext", "DBGDTRTXint", "DBGOSDLR", "DBGOSECCR", "DBGOSLAR", "DBGOSLSR", "DBGPRCR", "DBGVCR", "DBGWCR0", "DBGWCR1", "DBGWCR2", "DBGWCR3", "DBGWCR4", "DBGWCR5", "DBGWCR6", "DBGWCR7", "DBGWCR8", "DBGWCR9", "DBGWCR10", "DBGWCR11", "DBGWCR12", "DBGWCR13", "DBGWCR14", "DBGWCR15", "DBGWFAR", "DBGWVR0", "DBGWVR1", "DBGWVR2", "DBGWVR3", "DBGWVR4", "DBGWVR5", "DBGWVR6", "DBGWVR7", "DBGWVR8", "DBGWVR9", "DBGWVR10", "DBGWVR11", "DBGWVR12", "DBGWVR13", "DBGWVR14", "DBGBCR15", "DFAR", "DFSR", "DLR", "DSPSR", "ELR_hyp", "FCSEIDR", "FPEXC", "FPSCR", "FPSID", "HACR", "HACTLR", "HACTLR2", "HADFSR", "HAIFSR", "HAMAIR0", "HAMAIR1", "HCPTR", "HCR", "HCR2", "HDCR", "HDFAR", "HIFAR", "HMAIR0", "HMAIR1", "HPFAR", "HRMR", "HSCTLR", "HSR", "HSTR", "HTCR", "HTPIDR", "HTTBR", "HVBAR", "ICC_AP0R0", "ICC_AP0R1", "ICC_AP0R2", "ICC_AP0R3", "ICC_AP1R0", "ICC_AP1R1", "ICC_AP1R2", "ICC_AP1R3", "ICC_ASGI1R", "ICC_BPR0", "ICC_BPR1", "ICC_CTLR", "ICC_DIR", "ICC_EOIR0", "ICC_EOIR1", "ICC_HPPIR0", "ICC_HPPIR1", "ICC_HSRE", "ICC_IAR0", "ICC_IAR1", "ICC_IGRPEN0", "ICC_IGRPEN1", "ICC_MCTLR", "ICC_MGRPEN1", "ICC_MSRE", "ICC_PMR", "ICC_RPR", "ICC_SGI0R", "ICC_SGI1R", "ICC_SRE", "ICH_AP0R0", "ICH_AP0R1", "ICH_AP0R2", "ICH_AP0R3", "ICH_AP1R0", "ICH_AP1R1", "ICH_AP1R2", "ICH_AP1R3", "ICH_EISR", "ICH_ELRSR", "ICH_HCR", "ICH_HCR", "ICH_LR0", "ICH_LR1", "ICH_LR2", "ICH_LR3", "ICH_LR4", "ICH_LR5", "ICH_LR6", "ICH_LR7", "ICH_LR8", "ICH_LR9", "ICH_LR10", "ICH_LR11", "ICH_LR12", "ICH_LR13", "ICH_LR14", "ICH_LR15", "ICH_LRC0", "ICH_LRC1", "ICH_LRC2", "ICH_LRC3", "ICH_LRC4", "ICH_LRC5", "ICH_LRC6", "ICH_LRC7", "ICH_LRC8", "ICH_LRC9", "ICH_LRC10", "ICH_LRC11", "ICH_LRC12", "ICH_LRC13", "ICH_LRC14", "ICH_LRC15", "ICH_MISR", "ICH_VMCR", "ICH_VTR", "ICV_AP0R0", "ICV_AP0R1", "ICV_AP0R2", "ICV_AP0R3", "ICV_AP1R0", "ICV_AP1R1", "ICV_AP1R2", "ICV_AP1R3", "ICV_BPR0", "ICV_BPR1", "ICV_CTLR", "ICV_DIR", "ICV_EOIR0", "ICV_EOIR1", "ICV_HPPIR0", "ICV_HPPIR1", "ICV_IAR0", "ICV_IAR1", "ICV_IGRPEN0", "ICV_IGRPEN1", "ICV_PMR", "ICV_RPR", "ID_AFR0", "ID_DFR0", "ID_ISAR0", "ID_ISAR1", "ID_ISAR2", "ID_ISAR3", "ID_ISAR4", "ID_ISAR5", "ID_ISAR6", "ID_MMFR0", "ID_MMFR1", "ID_MMFR2", "ID_MMFR3", "ID_MMFR4", "ID_PFR0", "ID_PFR1", "ID_PFR2", "IFAR", "IFSR", "ISR", "JIDR", "JMCR", "JOSCR", "MAIR0", "MAIR1", "MIDR", "MPIDR", "MVBAR", "MVFR0", "MVFR1", "MVFR2", "NMRR", "NSACR", "PAR", "PMCCFILTR", "PMCCNTR", "PMCEID0", "PMCEID1", "PMCEID2", "PMCEID3", "PMCNTENCLR", "PMCNTENSET", "PMCR", "PMEVCNTR0", "PMEVCNTR1", "PMEVCNTR2", "PMEVCNTR3", "PMEVCNTR4", "PMEVCNTR5", "PMEVCNTR6", "PMEVCNTR7", "PMEVCNTR8", "PMEVCNTR9", "PMEVCNTR10", "PMEVCNTR11", "PMEVCNTR12", "PMEVCNTR13", "PMEVCNTR14", "PMEVCNTR15", "PMEVCNTR16", "PMEVCNTR17", "PMEVCNTR18", "PMEVCNTR19", "PMEVCNTR20", "PMEVCNTR21", "PMEVCNTR22", "PMEVCNTR23", "PMEVCNTR24", "PMEVCNTR25", "PMEVCNTR26", "PMEVCNTR27", "PMEVCNTR28", "PMEVCNTR29", "PMEVCNTR30", "PMEVTYPER0", "PMEVTYPER1", "PMEVTYPER2", "PMEVTYPER3", "PMEVTYPER4", "PMEVTYPER5", "PMEVTYPER6", "PMEVTYPER7", "PMEVTYPER8", "PMEVTYPER9", "PMEVTYPER10", "PMEVTYPER11", "PMEVTYPER12", "PMEVTYPER13", "PMEVTYPER14", "PMEVTYPER15", "PMEVTYPER16", "PMEVTYPER17", "PMEVTYPER18", "PMEVTYPER19", "PMEVTYPER20", "PMEVTYPER21", "PMEVTYPER22", "PMEVTYPER23", "PMEVTYPER24", "PMEVTYPER25", "PMEVTYPER26", "PMEVTYPER27", "PMEVTYPER28", "PMEVTYPER29", "PMEVTYPER30", "PMINTENCLR", "PMINTENSET", "PMOVSR", "PMOVSSET", "PMSELR", "PMSWINC", "PMUSERENR", "PMXEVCNTR", "PMXEVTYPER", "PRRR", "REVIDR", "RMR", "RVBAR", "SCR", "SCTLR", "SDCR", "SDER", "SPSR", "SPSR_abt", "SPSR_fiq", "SPSR_hyp", "SPSR_irq", "SPSR_mon", "SPSR_svc", "SPSR_und", "TCMTR", "TLBTR", "TPIDRPRW", "TPIDRURO", "TPIDRURW", "TTBCR", "TTBCR2", "TTBR0", "TTBR1", "VBAR", "VMPIDR", "VSTCR", "VSTTBR", "VPIDR", "VTCR", "VTTBR"}).map(String::toUpperCase).collect(Collectors.toSet());
    private static final Pattern AArch64Reg = Pattern.compile("\\w+_[eE][lL]\\d+");

    private static final boolean isGenericAArch64SysReg(String candidate) {
        return AArch64Reg.matcher(candidate).matches();
    }

    public static final boolean isAArch64SysReg(String candidate) {
        return AARCH64_SYSREGS.contains(candidate.toUpperCase()) || SysReg.isGenericAArch64SysReg(candidate);
    }

    public static final boolean isAArch32SysReg(String candidate) {
        return AARCH32_SYSREGS.contains(candidate.toUpperCase());
    }
}

