/*
 * Decompiled with CFR 0.152.
 */
package com.arm.eclipse.cdt.asmlib.model;

import com.arm.eclipse.cdt.asmlib.model.AssemblerModel;
import com.arm.eclipse.cdt.asmlib.model.SysReg;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;

public class Registers {
    private static final Set<String> aarch32RegisterSet;
    private static final Set<String> aarch64RegisterSet;

    static {
        String s;
        String s2;
        aarch32RegisterSet = new HashSet<String>();
        aarch64RegisterSet = new HashSet<String>();
        IntStream.rangeClosed(0, 16).mapToObj(n -> "R" + n).forEachOrdered(aarch32RegisterSet::add);
        Arrays.stream(new String[]{"PC", "SP", "LR", "FP", "CPSR", "IP", "SB", "FPSCR", "FPEXC", "FPSID"}).forEachOrdered(aarch32RegisterSet::add);
        IntStream.rangeClosed(0, 31).mapToObj(n -> "Q" + n).forEachOrdered(aarch32RegisterSet::add);
        IntStream.rangeClosed(0, 31).mapToObj(n -> "D" + n).forEachOrdered(aarch32RegisterSet::add);
        IntStream.rangeClosed(0, 31).mapToObj(n -> "S" + n).forEachOrdered(aarch32RegisterSet::add);
        IntStream.rangeClosed(0, 7).mapToObj(n -> "F" + n).forEachOrdered(aarch32RegisterSet::add);
        IntStream.rangeClosed(0, 16).mapToObj(n -> "WR" + n).forEachOrdered(aarch32RegisterSet::add);
        IntStream.rangeClosed(0, 4).mapToObj(n -> "WCGR" + n).forEachOrdered(aarch32RegisterSet::add);
        Arrays.stream(new String[]{"WCID", "WCON", "WCSSF", "WCASF"}).forEachOrdered(aarch32RegisterSet::add);
        IntStream.rangeClosed(1, 4).mapToObj(n -> "A" + n).forEachOrdered(aarch32RegisterSet::add);
        IntStream.rangeClosed(1, 8).mapToObj(n -> "V" + n).forEachOrdered(aarch32RegisterSet::add);
        IntStream.rangeClosed(0, 16).mapToObj(n -> "C" + n).forEachOrdered(aarch32RegisterSet::add);
        IntStream.rangeClosed(0, 16).mapToObj(n -> "P" + n).forEachOrdered(aarch32RegisterSet::add);
        IntStream.rangeClosed(0, 30).mapToObj(n -> "W" + n).forEachOrdered(aarch64RegisterSet::add);
        IntStream.rangeClosed(0, 30).mapToObj(n -> "X" + n).forEachOrdered(aarch64RegisterSet::add);
        Arrays.stream(new String[]{"PC", "SP", "LR", "XZR", "WZR"}).forEachOrdered(aarch64RegisterSet::add);
        String[] stringArray = new String[]{"V", "D", "S", "H", "B", "Q"};
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            s2 = stringArray[n3];
            IntStream.rangeClosed(0, 31).boxed().map(n -> String.format("%s%d", s2, n)).forEachOrdered(aarch64RegisterSet::add);
            ++n3;
        }
        stringArray = new String[]{"8B", "16B", "2H", "4H", "8H", "2S", "4S", "1D", "2D", "1Q"};
        n2 = stringArray.length;
        n3 = 0;
        while (n3 < n2) {
            s2 = stringArray[n3];
            IntStream.rangeClosed(0, 31).boxed().map(n -> String.format("V%d.%s", n, s2)).forEachOrdered(aarch64RegisterSet::add);
            ++n3;
        }
        stringArray = new String[]{"B", "H", "S", "D"};
        n2 = stringArray.length;
        n3 = 0;
        while (n3 < n2) {
            s2 = stringArray[n3];
            IntStream.rangeClosed(0, 31).boxed().map(n -> String.format("V%d.%s", n, s2)).forEachOrdered(aarch64RegisterSet::add);
            ++n3;
        }
        IntStream.rangeClosed(0, 31).mapToObj(n -> "Z" + n).forEachOrdered(aarch64RegisterSet::add);
        IntStream.rangeClosed(0, 15).mapToObj(n -> "P" + n).forEachOrdered(aarch64RegisterSet::add);
        IntStream.rangeClosed(0, 15).mapToObj(n -> "PN" + n).forEachOrdered(aarch64RegisterSet::add);
        String[] stringArray2 = new String[]{"B", "H", "S", "D"};
        int n4 = stringArray2.length;
        int n5 = 0;
        while (n5 < n4) {
            s = stringArray2[n5];
            IntStream.rangeClosed(0, 31).boxed().map(n -> String.format("Z%d.%s", n, s)).forEachOrdered(aarch64RegisterSet::add);
            ++n5;
        }
        stringArray2 = new String[]{"B", "H", "S", "D"};
        n4 = stringArray2.length;
        n5 = 0;
        while (n5 < n4) {
            s = stringArray2[n5];
            IntStream.rangeClosed(0, 15).boxed().map(n -> String.format("P%d.%s", n, s)).forEachOrdered(aarch64RegisterSet::add);
            IntStream.rangeClosed(0, 15).boxed().map(n -> String.format("PN%d.%s", n, s)).forEachOrdered(aarch64RegisterSet::add);
            ++n5;
        }
        stringArray2 = new String[]{"Z", "M"};
        n4 = stringArray2.length;
        n5 = 0;
        while (n5 < n4) {
            s = stringArray2[n5];
            IntStream.rangeClosed(0, 15).boxed().map(n -> String.format("P%d/%s", n, s)).forEachOrdered(aarch64RegisterSet::add);
            IntStream.rangeClosed(0, 15).boxed().map(n -> String.format("PN%d/%s", n, s)).forEachOrdered(aarch64RegisterSet::add);
            ++n5;
        }
        aarch64RegisterSet.add("ZA");
        aarch64RegisterSet.add("ZT0");
        int j = 1;
        String[] stringArray3 = new String[]{"B", "H", "S", "D", "Q"};
        int n6 = stringArray3.length;
        n4 = 0;
        while (n4 < n6) {
            String s3 = stringArray3[n4];
            aarch64RegisterSet.add("ZA." + s3);
            int i = 0;
            while (i < j) {
                aarch64RegisterSet.add(String.format("ZA%d.%s", i, s3));
                aarch64RegisterSet.add(String.format("ZA%dH.%s", i, s3));
                aarch64RegisterSet.add(String.format("ZA%dV.%s", i, s3));
                ++i;
            }
            j <<= 1;
            ++n4;
        }
    }

    public static boolean isValidRegister(String token, AssemblerModel.InstSet instSet) {
        token = token.toUpperCase();
        switch (instSet) {
            case AARCH32: {
                return aarch32RegisterSet.contains(token) || SysReg.isAArch32SysReg(token);
            }
            case AARCH64: {
                return aarch64RegisterSet.contains(token) || SysReg.isAArch64SysReg(token);
            }
        }
        return aarch32RegisterSet.contains(token) || SysReg.isAArch32SysReg(token) || aarch64RegisterSet.contains(token) || SysReg.isAArch64SysReg(token);
    }

    public static boolean isValidRegisterRange(String token, AssemblerModel.InstSet instSet) {
        String[] regs = token.split("-");
        return regs.length == 2 && Registers.isValidRegister(regs[0], instSet) && Registers.isValidRegister(regs[1], instSet);
    }
}

