/*
 * Decompiled with CFR 0.152.
 */
package com.arm.eclipse.cdt.asmlib.model;

import com.arm.eclipse.cdt.asmlib.AsmlibPlugin;
import com.arm.eclipse.cdt.asmlib.model.AsmArea;
import com.arm.eclipse.cdt.asmlib.model.AsmLabel;
import com.arm.eclipse.cdt.asmlib.model.AsmMacro;
import com.arm.eclipse.cdt.asmlib.model.AsmModelComponent;
import com.arm.eclipse.cdt.asmlib.model.AsmSection;
import com.arm.eclipse.cdt.asmlib.model.AssemblerModel;
import com.arm.eclipse.cdt.asmlib.model.Directives;
import com.arm.eclipse.cdt.asmlib.rules.AsmToken;
import com.arm.eclipse.cdt.asmlib.rules.LineTokenizer;
import com.arm.eclipse.cdt.asmlib.rules.TokenType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;

public class IncrementalParser {
    private static final String MULTILINE_COMMENT_START = "/*";
    private static final String MULTILINE_COMMENT_END = "*/";
    private static final String PARTITIONING = "AsmParitioning";
    @Nullable
    private final AssemblerModel model;
    @Nonnull
    private final DefaultLineTracker tracker;
    private StringBuffer documentCopy;
    Comparator<AsmModelComponent> OFFSET_COMPARATOR = Comparator.comparing(AsmModelComponent::getOffset);

    public IncrementalParser(@Nullable AssemblerModel model) {
        this.tracker = new DefaultLineTracker();
        this.model = model;
    }

    @Nullable
    public AssemblerModel getModel() {
        return this.model;
    }

    public void initialReconcile(IDocument realDocument) {
        this.documentCopy = new StringBuffer(realDocument.get());
        this.tracker.set(realDocument.get());
        Region r = new Region(0, this.documentCopy.length());
        try {
            IDocumentExtension3 extension = (IDocumentExtension3)realDocument;
            IDocumentPartitioner partitioner = extension.getDocumentPartitioner(PARTITIONING);
            boolean modeUpdated = this.parseRegion((IRegion)r, true, null, "");
            if (modeUpdated) {
                this.parseRegion((IRegion)r, false, null, "");
                if (partitioner != null) {
                    partitioner.documentChanged(new DocumentEvent(realDocument, 0, realDocument.getLength(), " "));
                }
            }
        }
        catch (BadLocationException e) {
            AsmlibPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.arm.eclipse.cdt.asmlib", e.getLocalizedMessage(), (Throwable)e));
            return;
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) throws BadLocationException {
        if (this.model == null) {
            return;
        }
        CharSequence textBeforeModification = "";
        if (dirtyRegion.getOffset() + dirtyRegion.getLength() <= this.documentCopy.length()) {
            textBeforeModification = this.documentCopy.subSequence(dirtyRegion.getOffset(), dirtyRegion.getOffset() + dirtyRegion.getLength());
        }
        this.applyUpdate(dirtyRegion);
        if (dirtyRegion.getType().equals("__remove")) {
            IRegion r = this.getAffectedRegionDeletion(dirtyRegion);
            this.propogateRemoval(dirtyRegion, r);
            this.parseRegion(r, false, dirtyRegion, textBeforeModification.toString());
        } else {
            IRegion r = this.getAffectedRegionInsertion(dirtyRegion);
            int offsetReparseEnd = dirtyRegion.getOffset() + dirtyRegion.getLength();
            try {
                char c = this.documentCopy.charAt(offsetReparseEnd);
                while (offsetReparseEnd < this.documentCopy.length() && c != '\r' && c != '\n') {
                    c = this.documentCopy.charAt(++offsetReparseEnd);
                }
                if (offsetReparseEnd < this.documentCopy.length() && (c == '\n' || c == '\r')) {
                    --offsetReparseEnd;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            this.propogateAddition(r, dirtyRegion, (offsetReparseEnd -= dirtyRegion.getLength()) + 1);
            this.parseRegion(r, true, dirtyRegion, textBeforeModification.toString());
        }
    }

    private void propogateAddition(IRegion reparseRegion, DirtyRegion dirtyRegion, int offsetReparseEnd) {
        List<AsmModelComponent> components = this.model.getComponents();
        int i = this.findPrecedingComponent(components, reparseRegion.getOffset());
        while (i < components.size()) {
            AsmModelComponent comp = components.get(i);
            if (comp.getOffset() > offsetReparseEnd) {
                this.model.removeComponent(comp.getOffset());
                comp.setOffset(comp.getOffset() + dirtyRegion.getLength());
                this.addComponent(comp);
            } else if (comp.getOffset() + comp.getSourceTriggerToken().length() >= reparseRegion.getOffset() && comp.getOffset() + comp.getSourceTriggerToken().length() <= offsetReparseEnd) {
                this.model.removeComponent(comp.getOffset());
            }
            ++i;
        }
    }

    private void propogateRemoval(DirtyRegion dirtyRegion, IRegion r) {
        List<AsmModelComponent> components = this.model.getComponents();
        int i = this.findPrecedingComponent(components, r.getOffset());
        while (i < components.size()) {
            AsmModelComponent comp = components.get(i);
            int componentStart = comp.getOffset();
            int componentEnd = comp.getOffset() + comp.getSourceTriggerToken().length();
            int regionStart = r.getOffset();
            int regionEnd = regionStart + r.getLength() + dirtyRegion.getLength();
            if (comp.getOffset() > regionEnd) {
                this.model.removeComponent(comp.getOffset());
                comp.setOffset(comp.getOffset() - dirtyRegion.getLength());
                this.addComponent(comp);
            } else if (componentStart >= regionStart && componentStart <= componentEnd || componentEnd >= regionStart && componentEnd <= regionEnd) {
                this.model.removeComponent(comp.getOffset());
            }
            ++i;
        }
    }

    private void addComponent(AsmModelComponent component) {
        if (component instanceof AsmArea) {
            AsmArea area = (AsmArea)component;
            this.model.addArea(area);
        } else if (component instanceof AsmLabel) {
            AsmLabel label = (AsmLabel)component;
            this.model.addLabel(label);
        } else if (component instanceof AsmMacro) {
            AsmMacro macro = (AsmMacro)component;
            this.model.addMacro(macro);
        }
    }

    private int findPrecedingComponent(List<AsmModelComponent> labels, int offset) {
        Collections.sort(labels, this.OFFSET_COMPARATOR);
        AsmLabel key = new AsmLabel("", offset);
        int result = Collections.binarySearch(labels, key, this.OFFSET_COMPARATOR);
        int n = result = result >= 0 ? result : -result - 1;
        if (result > 0) {
            --result;
        }
        return result;
    }

    private synchronized void applyUpdate(DirtyRegion dirtyRegion) {
        int offset = dirtyRegion.getOffset();
        int length = dirtyRegion.getLength();
        String newText = dirtyRegion.getText();
        if (newText == null) {
            newText = "";
        }
        if (dirtyRegion.getType().equals("__remove")) {
            this.documentCopy.delete(offset, offset + length);
        } else if (dirtyRegion.getType().equals("__insert")) {
            this.documentCopy.insert(offset, newText);
        }
        this.tracker.set(this.documentCopy.toString());
    }

    private IRegion getAffectedRegionInsertion(DirtyRegion dirtyRegion) throws BadLocationException {
        int changeEnd;
        int changeStart;
        int start = changeStart = dirtyRegion.getOffset();
        if (changeStart > 0) {
            char c = this.documentCopy.charAt(--start);
            while (start > 0 && c != '\r' && c != '\n') {
                c = this.documentCopy.charAt(--start);
            }
            if (start < changeStart && c == '\r' || c == '\n') {
                ++start;
            }
        }
        int end = changeEnd = changeStart + dirtyRegion.getLength();
        int docLength = this.documentCopy.length();
        if (changeEnd < docLength) {
            char c = this.documentCopy.charAt(end);
            while (end < docLength && c != '\r' && c != '\n') {
                c = this.documentCopy.charAt(end);
                ++end;
            }
            --end;
        }
        return new Region(start, end - start);
    }

    private IRegion getAffectedRegionDeletion(DirtyRegion dirtyRegion) throws BadLocationException {
        int docLength;
        int end;
        int changeStart;
        int start = changeStart = dirtyRegion.getOffset();
        if (changeStart > 0) {
            char c = this.documentCopy.charAt(--start);
            while (start > 0 && c != '\r' && c != '\n') {
                c = this.documentCopy.charAt(--start);
            }
            if (start < changeStart && c == '\r' || c == '\n') {
                ++start;
            }
        }
        if ((end = changeStart) < (docLength = this.documentCopy.length())) {
            char c = this.documentCopy.charAt(end);
            while (end < docLength && c != '\r' && c != '\n') {
                c = this.documentCopy.charAt(end);
                ++end;
            }
            if (end > changeStart && c == '\r' || c == '\n') {
                --end;
            }
        }
        return new Region(start, end - start);
    }

    /*
     * Unable to fully structure code
     */
    private boolean parseRegion(IRegion r, boolean updateMode, DirtyRegion dirtyRegion, String textBeforeModification) throws BadLocationException {
        block58: {
            block59: {
                block60: {
                    block61: {
                        block57: {
                            modeUpdated = false;
                            rescanRegionStart = r.getOffset();
                            rescanRegionEnd = rescanRegionStart + r.getLength();
                            lastStartComment = -1;
                            lastEndComment = -1;
                            firstForwardEndComment = -1;
                            if (dirtyRegion != null) break block57;
                            rescanRegionStart = r.getOffset();
                            rescanRegionEnd = rescanRegionStart + r.getLength();
                            break block58;
                        }
                        textInserted = dirtyRegion.getType() == "__insert";
                        lastStartComment = this.documentCopy.lastIndexOf("/*", rescanRegionStart + r.getLength());
                        lastEndComment = this.documentCopy.lastIndexOf("*/", rescanRegionStart + r.getLength());
                        firstForwardEndComment = this.documentCopy.indexOf("*/", r.getOffset() + r.getLength());
                        if (!textInserted || rescanRegionStart == 0 && rescanRegionEnd == this.documentCopy.length()) break block59;
                        if (lastStartComment == -1) break block60;
                        if (lastStartComment <= lastEndComment) break block61;
                        if (firstForwardEndComment == -1) ** GOTO lbl29
                        if (dirtyRegion.getText().contains("*") || dirtyRegion.getText().contains("/")) {
                            rescanRegionStart = lastStartComment;
                            rescanRegionEnd = firstForwardEndComment;
                        } else if (lastStartComment > r.getOffset()) {
                            rescanRegionStart = r.getOffset();
                            rescanRegionEnd = lastStartComment;
                        } else {
                            return modeUpdated;
lbl29:
                            // 1 sources

                            rescanRegionStart = lastStartComment;
                            rescanRegionEnd = this.documentCopy.length();
                        }
                        break block59;
                    }
                    rescanRegionStart = r.getOffset();
                    text = dirtyRegion.getText();
                    rescanRegionEnd = text.contains("*") || text.contains("/") ? (firstForwardEndComment != -1 ? firstForwardEndComment : this.documentCopy.length()) : rescanRegionStart + r.getLength();
                    break block59;
                }
                rescanRegionStart = r.getOffset();
                rescanRegionEnd = rescanRegionStart + r.getLength();
            }
            if (!textInserted) {
                if (textBeforeModification.contains("*") || textBeforeModification.contains("/")) {
                    rescanRegionStart = lastStartComment != -1 && lastStartComment > lastEndComment ? lastStartComment : r.getOffset();
                    rescanRegionEnd = firstForwardEndComment != -1 ? firstForwardEndComment : this.documentCopy.length();
                } else {
                    if (lastStartComment != -1 && r.getOffset() >= lastStartComment && (r.getOffset() + r.getLength() <= lastEndComment || r.getOffset() + r.getLength() <= firstForwardEndComment)) {
                        return modeUpdated;
                    }
                    rescanRegionStart = r.getOffset();
                    rescanRegionEnd = r.getOffset() + r.getLength();
                }
            }
        }
        if (rescanRegionStart > r.getOffset()) {
            rescanRegionStart = r.getOffset();
        }
        if (rescanRegionEnd < r.getOffset() + r.getLength()) {
            rescanRegionEnd = r.getOffset() + r.getLength();
        }
        moreLines = true;
        offset = rescanRegionStart;
        while (moreLines) {
            block56: {
                block62: {
                    offsetBefore = offset;
                    line = this.getLine(offset);
                    if (line.isEmpty()) break;
                    if (offset < rescanRegionStart || offset >= rescanRegionEnd) break block62;
                    if (this.model == null) {
                        offset += line.length();
                        continue;
                    }
                    commentRecogniser = LineTokenizer.getCommentRecogniser(this.model.getAsmMode());
                    tokens = LineTokenizer.tokeniseLine(line, this.model.getInstSet(), this.model.getAsmMode(), false);
                    if (!tokens.isEmpty() && commentRecogniser.isMultilineCommentStart(tokens.get(tokens.size() - 1).getText(), 0) && !commentRecogniser.isMultilineComment(tokens.get(tokens.size() - 1).getText(), 0)) {
                        tokenText = "";
                        firstForwardEndComment = this.documentCopy.indexOf("*/", offset);
                        if (firstForwardEndComment < lastStartComment) {
                            firstForwardEndComment = lastEndComment;
                        }
                        if (lastStartComment != -1) {
                            if (firstForwardEndComment != -1 && firstForwardEndComment > lastStartComment) {
                                tokenText = this.documentCopy.substring(lastStartComment, firstForwardEndComment);
                                tokens.remove(tokens.size() - 1);
                                tokens.add(new AsmToken(tokenText, TokenType.COMMENT));
                                offset = firstForwardEndComment;
                            } else {
                                tokenText = this.documentCopy.substring(lastStartComment, rescanRegionEnd);
                                tokens.remove(tokens.size() - 1);
                                tokens.add(new AsmToken(tokenText, TokenType.COMMENT_ERROR));
                                offset = rescanRegionEnd;
                            }
                            this.model.removeRegion(lastStartComment, offset - lastStartComment);
                        } else {
                            startingOffset = offset;
                            foundEndComment = false;
                            this.model.removeRegion(offset, line.length());
                            lastToken = tokens.get(tokens.size() - 1);
                            while (!foundEndComment && !line.isEmpty() && offset + line.length() <= rescanRegionEnd) {
                                if ((line = this.getLine(offset += line.length())).indexOf("*/") != -1) {
                                    offset += line.length();
                                    lastToken = new AsmToken(String.valueOf(lastToken.getText()) + line.substring(0, line.indexOf("*/") + 2), TokenType.COMMENT);
                                    line = line.substring(line.indexOf("*/") + 2);
                                    foundEndComment = true;
                                    break;
                                }
                                lastToken = new AsmToken(String.valueOf(lastToken.getText()) + line, lastToken.getType());
                            }
                            this.model.removeRegion(startingOffset, rescanRegionEnd - startingOffset);
                            tokens.remove(tokens.size() - 1);
                            if (foundEndComment) {
                                tokens.add(lastToken);
                                tokens.addAll(LineTokenizer.tokeniseLine(line, this.model.getInstSet(), this.model.getAsmMode(), false));
                            } else {
                                tokens.add(new AsmToken(lastToken.getText(), TokenType.COMMENT_ERROR));
                            }
                        }
                    }
                    curOffset = 0;
                    i = 0;
                    while (i < tokens.size()) {
                        token = tokens.get(i);
                        curOffset = line.indexOf(token.getText(), curOffset) != -1 ? line.indexOf(token.getText(), curOffset) : curOffset;
                        switch (IncrementalParser.$SWITCH_TABLE$com$arm$eclipse$cdt$asmlib$rules$TokenType()[token.getType().ordinal()]) {
                            case 10: {
                                this.model.addLabel(new AsmLabel(token.getText(), offsetBefore + curOffset));
                                ** GOTO lbl191
                            }
                            case 7: {
                                if (updateMode && this.model.getAsmMode() == AssemblerModel.AsmMode.UNKNOWN) {
                                    if (Directives.isValidArmDirective(token.getText())) {
                                        this.model.setAsmMode(AssemblerModel.AsmMode.ARMASM, true);
                                    } else {
                                        this.model.setAsmMode(AssemblerModel.AsmMode.GAS, true);
                                    }
                                    modeUpdated = true;
                                }
                                var20_23 = token.getText().toUpperCase();
                                tmp = -1;
                                switch (var20_23.hashCode()) {
                                    case 2017421: {
                                        if (var20_23.equals("AREA")) {
                                            tmp = 1;
                                        }
                                        break;
                                    }
                                    case 73114540: {
                                        if (var20_23.equals("MACRO")) {
                                            tmp = 2;
                                        }
                                        break;
                                    }
                                    case 1253120727: {
                                        if (var20_23.equals(".SECTION")) {
                                            tmp = 3;
                                        }
                                        break;
                                    }
                                    case 1390055486: {
                                        if (var20_23.equals(".MACRO")) {
                                            tmp = 4;
                                        }
                                        break;
                                    }
                                }
                                switch (tmp) {
                                    case 1: {
                                        sectionName = this.getComponentName(tokens, i);
                                        if (sectionName == null) {
                                            sectionName = ".section";
                                        }
                                        this.model.addArea(new AsmArea(offsetBefore + curOffset, sectionName));
                                        break;
                                    }
                                    case 3: {
                                        areaName = this.getComponentName(tokens, i);
                                        if (areaName == null) {
                                            areaName = "AREA";
                                        }
                                        this.model.addArea(new AsmSection(offsetBefore + curOffset, areaName));
                                        break;
                                    }
                                    case 2: {
                                        armMacro = this.getARMMacroModelComponent(offsetBefore + curOffset);
                                        if (armMacro == null) {
                                            armMacro = new AsmMacro(offsetBefore + curOffset, "");
                                        }
                                        this.model.addMacro(armMacro);
                                        if (!updateMode || this.model.getAsmMode() != AssemblerModel.AsmMode.UNKNOWN) break;
                                        this.model.setAsmMode(AssemblerModel.AsmMode.ARMASM, true);
                                        modeUpdated = true;
                                        break;
                                    }
                                    case 4: {
                                        gnuMacroName = this.getComponentName(tokens, i);
                                        if (gnuMacroName == null) {
                                            gnuMacroName = token.getText();
                                        }
                                        this.model.addMacro(new AsmMacro(offsetBefore + curOffset, gnuMacroName));
                                    }
                                }
                                if (this.model.getAsmMode() != AssemblerModel.AsmMode.GAS || this.model.getInstSet() != AssemblerModel.InstSet.AARCH64) break block56;
                                ** GOTO lbl191
                            }
                            case 5: {
                                if (updateMode && this.model.getInstSet() == AssemblerModel.InstSet.UNKNOWN) {
                                    regName = token.getText();
                                    if (regName.toUpperCase().startsWith("R")) {
                                        this.model.setInstSet(AssemblerModel.InstSet.AARCH32, true);
                                    } else if (regName.toUpperCase().startsWith("X")) {
                                        this.model.setInstSet(AssemblerModel.InstSet.AARCH64, true);
                                    }
                                    modeUpdated = true;
                                }
                            }
lbl191:
                            // 6 sources

                            default: {
                                ++i;
                            }
                        }
                    }
                    break block56;
                }
                if (offset >= rescanRegionEnd) {
                    moreLines = false;
                }
            }
            if (offset != offsetBefore) continue;
            offset += line.length();
        }
        return modeUpdated;
    }

    private String getComponentName(List<AsmToken> tokens, int startIndex) {
        if (startIndex + 2 < tokens.size()) {
            return tokens.get(startIndex + 2).getText();
        }
        return null;
    }

    private AsmMacro getARMMacroModelComponent(int offset) {
        int nameOffset = offset + this.getLine(offset).length();
        String nextLine = this.getLine(nameOffset);
        if (nextLine == null || nextLine.isEmpty() || nextLine.matches("\\s+")) {
            return null;
        }
        List<AsmToken> tokens = LineTokenizer.tokeniseLine(nextLine, this.model.getInstSet(), this.model.getAsmMode(), false);
        int i = 0;
        while (i < tokens.size()) {
            AsmToken token = tokens.get(i);
            switch (token.getType()) {
                case WHITESPACE: 
                case COMMENT: 
                case LABEL: {
                    break;
                }
                case UNDEFINED: 
                case INSTRUCTION: 
                case DIRECTIVE: 
                case DEPRECATED_INSTRUCTION: {
                    String text = token.getText();
                    if (!text.isEmpty()) {
                        return new AsmMacro(offset, text);
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    private String getLine(int offset) {
        int length = 0;
        while (offset + length < this.documentCopy.length() && this.documentCopy.charAt(offset + length) != '\n') {
            ++length;
        }
        String line = offset + length >= this.documentCopy.length() ? this.documentCopy.substring(offset, offset + length) : this.documentCopy.substring(offset, offset + length + 1);
        return line;
    }
}

