/*
 * Decompiled with CFR 0.152.
 */
package com.arm.eclipse.cdt.asmlib.model;

import com.arm.eclipse.cdt.asmlib.model.AssemblerModel;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Directives {
    private static final String[] ARM_DIRECTIVES = new String[]{"ALIGN", "ATTR", "EXPORT", "GLOBAL", "LTORG", "ARM", "CODE32", "EXPORTAS", "MACRO", "MEND", "AREA", "EXTERN", "MAP", "ASSERT", "FIELD", "MEND", "MACRO", "CN", "FRAME ADDRESS", "MEXIT", "CODE16", "FRAME POP", "NOFP", "COMMON", "FRAME PUSH", "OPT", "CP", "FRAME REGISTER", "PRESERVE8", "REQUIRE8", "DATA", "FRAME RESTORE", "PROC", "FUNCTION", "DCB", "FRAME SAVE", "QN", "DCD", "DCDU", "FRAME STATE REMEMBER", "RELOC", "DCDO", "FRAME STATE RESTORE", "REQUIRE", "DCFD", "DCFDU", "FRAME UNWIND ON", "FRAME UNWIND OFF", "REQUIRE8", "PRESERVE8", "DCFS", "DCFSU", "FUNCTION", "PROC", "RLIST", "DCI(\\.W)?", "GBLA", "GBLL", "GBLS", "RN", "DCQ", "DCQU", "GET", "INCLUDE", "ROUT", "DCW", "DCWU", "GLOBAL", "EXPORT", "SETA", "SETL", "SETS", "DN", "SN", "IF", "ELSE", "ENDIF", "ELIF", "DN", "ELIF", "ELSE", "IF", "IMPORT", "SPACE", "END", "INCBIN", "SUBT", "ENDFUNC", "ENDP", "INCLUDE", "GET", "THUMB", "ENDIF", "IF", "INFO", "THUMBX", "ENTRY", "KEEP", "TTL", "EQU", "LCLA", "LCLL", "LCLS", "WHILE", "WEND"};
    private static final String[] GAS_DIRECTIVES = new String[]{".abort", ".align", ".altmacro", ".ascii", ".asciz", ".balign", ".balign", ".bundle_lock", ".bundle_unlock", ".byte", ".cfi_sections", ".cfi_startproc", ".cfi_endproc", ".cfi_personality", ".cfi_lsda", ".cfi_def_cfa", ".cfi_def_cfa_register", ".cfi_def_cfa_offset", ".cfi_adjust_cfa_offset", ".cfi_offset", ".cfi_rel_offset", ".cfi_register", ".cfi_restore", ".cfi_undefined", ".cfi_same_value", ".cfi_remember_state,", ".cfi_return_column", ".cfi_signal_frame", ".cfi_window_save", ".cfi_escape", ".cfi_val_encoded_addr", ".comm", ".data", ".def", ".desc", ".dim", ".double", ".eject", ".else", ".elseif", ".end", ".endef", ".endfunc", ".endif", ".endm", ".equ", ".equiv", ".eqv", ".err", ".error", ".exitm", ".extern", ".fail", ".file", ".fill", ".float", ".func", ".global", ".globl", ".gnu_attribute", ".hidden", ".hword", ".ident", ".if", ".incbin", ".include", ".int", ".internal", ".irp", ".irpc", ".lcomm", ".lflags", ".line", ".linkonce", ".list", ".ln", ".loc", ".loc_mark_labels", ".local", ".long", ".macro", ".mri", ".noaltmacro", ".nolist", ".octa", ".offset", ".org", ".p2align", ".popsection", ".previous", ".print", ".protected", ".psize", ".purgem", ".pushsection", ".quad", ".reloc", ".rept", ".endr", ".sbttl", ".scl", ".section", ".set", ".short", ".single", ".size", ".skip", ".sleb128", ".space", ".stabd", ".stabn", ".stabs", ".string", ".string8", ".string16", ".string32", ".string64", ".struct", ".subsection", ".symver", ".tag", ".text", ".title", ".type", ".uleb128", ".val", ".version", ".vtable_entry", ".vtable_inherit", ".warning", ".weak", ".weakref", ".word", "2byte", "4byte", "8byte", ".arch", ".arm", ".bss", ".cantunwind", ".code", ".cpu", ".dn", ".qn", ".eabi_attribute", ".even", ".extend", ".ldouble", ".fnend", ".fnstart", ".force_thumb", ".fpu", ".handlerdata", ".inst", ".inst.n", ".inst.w", ".ltorg", ".movsp", ".object_arch", ".packed", ".pad", ".personality", ".personalityindex", ".pool", ".req", ".save", ".setfp", ".secrel32", ".syntax", ".thumb", ".thumb_func", ".thumb_set", ".tlsdescseq", ".unreq", ".unwind_raw", ".vsave"};
    private static final Pattern ARM_DIRECTIVE_PATTERN;
    private static final Pattern GAS_DIRECTIVE_PATTERN;

    static {
        String armStr = Arrays.stream(ARM_DIRECTIVES).map(s -> "(" + s.replace(" ", "\\s+") + ")").collect(Collectors.joining("|", "(?:", ")"));
        ARM_DIRECTIVE_PATTERN = Pattern.compile(armStr, 2);
        String gasStr = Arrays.stream(GAS_DIRECTIVES).map(s -> s.replace(".", "\\.")).collect(Collectors.joining("|", "(?:", ")"));
        GAS_DIRECTIVE_PATTERN = Pattern.compile(gasStr, 2);
    }

    public static boolean isValidArmDirective(String token) {
        return ARM_DIRECTIVE_PATTERN.matcher(token).matches();
    }

    public static boolean isValidGasDirective(String token) {
        return GAS_DIRECTIVE_PATTERN.matcher(token).matches();
    }

    public static int isValidArmDirective(List<String> tokens, int index) {
        String candidate = "";
        if (tokens.size() > index && Directives.isValidArmDirective(candidate = String.valueOf(candidate) + tokens.get(index))) {
            return 1;
        }
        if (tokens.size() > index + 2 && Directives.isValidArmDirective(candidate = String.valueOf(candidate) + tokens.get(index + 1) + tokens.get(index + 2))) {
            return 3;
        }
        if (tokens.size() > index + 4 && Directives.isValidArmDirective(candidate = String.valueOf(candidate) + tokens.get(index + 3) + tokens.get(index + 4))) {
            return 5;
        }
        return -1;
    }

    public static int isValidGasDirective(List<String> tokens, int index) {
        if (tokens.size() > index && Directives.isValidGasDirective(tokens.get(index))) {
            return 1;
        }
        return -1;
    }

    public static int isValidDirective(List<String> tokens, int index, AssemblerModel.AsmMode format) {
        switch (format) {
            case ARMASM: {
                return Directives.isValidArmDirective(tokens, index);
            }
            case GAS: {
                return Directives.isValidGasDirective(tokens, index);
            }
        }
        int r = Directives.isValidArmDirective(tokens, index);
        if (r < 0) {
            r = Directives.isValidGasDirective(tokens, index);
        }
        return r;
    }
}

