/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.util.ResourceBundle;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class ResizableDialog
extends Dialog {
    private static final String DIALOG_BOUNDS_KEY = "ResizableDialogBounds";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    protected ResourceBundle fBundle;
    private Rectangle fNewBounds;
    private final IDialogSettings fSettings;
    private String fContextId;

    public ResizableDialog(Shell parent, ResourceBundle bundle) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fBundle = bundle;
        this.fSettings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(ResizableDialog.class)).getDialogSettings();
    }

    public void setHelpContextId(String contextId) {
        this.fContextId = contextId;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.fContextId != null && PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, this.fContextId);
        }
    }

    protected Point getInitialSize() {
        IDialogSettings bounds;
        int width = 0;
        int height = 0;
        final Shell s = this.getShell();
        if (s != null) {
            s.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent arg0) {
                    ResizableDialog.this.fNewBounds = s.getBounds();
                }

                public void controlResized(ControlEvent arg0) {
                    ResizableDialog.this.fNewBounds = s.getBounds();
                }
            });
        }
        if ((bounds = this.fSettings.getSection(DIALOG_BOUNDS_KEY)) == null) {
            if (this.fBundle != null) {
                width = Utilities.getInteger(this.fBundle, WIDTH, 0);
                height = Utilities.getInteger(this.fBundle, HEIGHT, 0);
                Shell shell = this.getParentShell();
                if (shell != null) {
                    Point parentSize = shell.getSize();
                    if (width <= 0) {
                        width = parentSize.x - 300;
                    }
                    if (height <= 0) {
                        height = parentSize.y - 200;
                    }
                }
            } else {
                Shell shell = this.getParentShell();
                if (shell != null) {
                    Point parentSize = shell.getSize();
                    width = parentSize.x - 100;
                    height = parentSize.y - 100;
                }
            }
            if (width < 700) {
                width = 700;
            }
            if (height < 500) {
                height = 500;
            }
        } else {
            try {
                width = bounds.getInt(WIDTH);
            }
            catch (NumberFormatException numberFormatException) {
                width = 700;
            }
            try {
                height = bounds.getInt(HEIGHT);
            }
            catch (NumberFormatException numberFormatException) {
                height = 500;
            }
        }
        return new Point(width, height);
    }

    protected Point getInitialLocation(Point initialSize) {
        Point loc = super.getInitialLocation(initialSize);
        IDialogSettings bounds = this.fSettings.getSection(DIALOG_BOUNDS_KEY);
        if (bounds != null) {
            try {
                loc.x = bounds.getInt(X);
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                loc.y = bounds.getInt(Y);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return loc;
    }

    public boolean close() {
        boolean closed = super.close();
        if (closed && this.fNewBounds != null) {
            this.saveBounds(this.fNewBounds);
        }
        return closed;
    }

    private void saveBounds(Rectangle bounds) {
        IDialogSettings dialogBounds = this.fSettings.getSection(DIALOG_BOUNDS_KEY);
        if (dialogBounds == null) {
            dialogBounds = new DialogSettings(DIALOG_BOUNDS_KEY);
            this.fSettings.addSection(dialogBounds);
        }
        dialogBounds.put(X, bounds.x);
        dialogBounds.put(Y, bounds.y);
        dialogBounds.put(WIDTH, bounds.width);
        dialogBounds.put(HEIGHT, bounds.height);
    }
}

